      PROGRAM LAUN_SSO 

      use netcdf
      use flott_gwd_rando_m, only: flott_gwd_rando
      use acama_gwd_rando_m, only: acama_gwd_rando
      IMPLICIT none
!NETCDF STUFF
      integer ncid,status,varid,dimid
      integer start(4),count(4),stride(4),ilmdz
      !NETCDF STUFF FOR OUTPUT FILE:
      integer ncio
      integer londimid,latdimid,levdimid,timdimid
      integer lonvarid,latvarid,levvarid,timvarid
      integer uvarid,vvarid,tvarid,rvarid
!FORMATTED I/O STUFF
      character*1 entete
      character*5 charprec
      real amoins,aplus,bmoins,bplus
!LOOPS ON TIMES
      integer it,nit,iter,nvar,itdeb,itfin,itjum,istri
      integer iday,ihr,nday,ndaytot
      integer iav !  For cost function (24 four 1 days, 72 for 3 days...)
!     integer, parameter :: iav=72 !  For cost function (here 3 days)

!======================================================================
!
! Author(s) F. LOTT            date: 19990624
!
! AN OFFLINE CALL OF THE SSO DRAG SCHEME by LOTT&MILLER(1997),
! THAT SHOULD MAKE EASY TO IMPLEMENT THE SCHEME IN ANY GCM:
! IT IS A SIMPLE INTERFACE TOWARD ROUTINES THAT ARE CALLED
! AS THEY ARE PROVIDED HERE: IN THE LMD-GCM.
! PARTS THAT ARE TYPICAL OFF THE OFFLINE CALL ARE SURROUNDED
! BY COFF-BEG -- COFF-END
!
! IN MOST GCMS YOU CAN FIGURE THAT AT THE STAGE THIS SEQUENCES
! OF ROUTINES ARE CALLED, YOU ARE IN THE ROUTINE THAT CALL
! ALL THE PHYSICAL PARAMETRIZATION ONE AFTER THE OTHER.
!======================================================================
!
!  Variables (INPUT OF THE PHYSICS   IN ON LINE CALLS)
!            (READ ON EXTERNAL FILES IN OFF-LINE CALL)
!
! klon----input-I-Total number of horizontal points that get into physics
! klev----input-I-Number of vertical levels
! paprs---input-R-Pressure in semi-layers   (Pa)
! pplay---input-R-Pressure inside layers    (Pa)
! pphis---input-R-geopotential at the ground
! u-------input-R-Zonal velocity
! v-------input-R-Meridional velocity
! t-------input-R-Temperature (K)
! dtime---input-R-Time step of the physics
! zmea----input-R-Mean Orography (m)
! zstd----input-R-SSO standard deviation (m)
! zsig----input-R-SSO slope
! zgam----input-R-SSO Anisotropy
! zthe----input-R-SSO Angle
! zpic----input-R-SSO Peacks elevation (m)
! zval----input-R-SSO Valleys elevation (m)
! prec----input-R-Total precipitation kg/s/m^2
! zgpcp---input-R-GPCP Precipitations in mm/day, missing value -99999
!
!------------Modified quantities---------------------------
!
! d_u_oro-output-R-"u" increment due to SSO DRAG     (m/s)
! d_v_oro-output-R-"v" increment due to SSO DRAG     (m/s)
! d_t_oro-output-R-"t" increment due to SSO DRAG     (K)
! d_u_lif-output-R-"u" increment due to MOUNTAIN LIFT(m/s)
! d_v_lif-output-R-"v" increment due to MOUNTAIN LIFT(m/s)
! d_t_lif-output-R-"t" increment due to MOUNTAIN LIFT(K)
! zulow,zvlow -output-R: Low-level wind
! zustrdr,zvstrdr      : Surface stress due to SSO drag      (Pa)
! zustrli,zvstrli      : Surface stress due to MOUNTAIN LIFT (Pa)
!
! igwd--local-I: Total nb of points where the orography schemes are active
! itest-local-I: Flags to indicate active points
! idx---local-I: Locate the physical location of an active point.
!
!------------Issued from commons---------------------------
!
! iim--common-I: Number of longitude intervals
! jjm--common-I: Number of latitude intervals
! ideb-common-I: First longitude
! jdeb-common-I: First latitude
! klon-common-I: Number of points seen by the physics
!                (iim+1)*(jjm+1) for instance
! klev-common-I: Number of vertical layers
!======================================================================

include "dimensions.h" 
include "dimphy.h"    
include "YOEGWD.h"
      
! Those thinks are on the dynamical grid?

       integer ii,jj,ij,ideb,jdeb
       real xlon(iim),ylat(jjm),zpre(llm)
       real xx(iim),yy(jjm)
       real ap(llm),bp(llm),zlev(llm)
       real, allocatable :: var1d(:),var2d(:,:),var3d(:,:,:),var4d(:,:,:,:)

      integer i,j,l,ll,index

!  This is for precips data retrieval

! TYPICALLY USED FOR THE OFFLINE VERSION ONLY
      integer iplay(llm),zplay(llm)
      character*12 input,output
      character*25 filename

!  IMPUT DYNAMICAL FIELDS THAT SHOULD BE PROVIDED OBVIOUSLY
!  PLACED ON THE PHYSICAL GRID:

      integer level(klev)
      REAL paprs(klon,klev+1),pplay(klon,klev),psol(klon)    
      REAL u(klon,klev),v(klon,klev),t(klon,klev),rot(klon,klev)
      REAL east_acama(klon,klev),west_acama(klon,klev)
      REAL east_flott(klon,klev),west_flott(klon,klev)
      REAL rlat(klon)
   
!  OUTPUT TENDENCIES (NOT USED IN THE OFF-LINE CALL)

      REAL d_u(klon,klev),d_v(klon,klev),d_t(klon,klev)
!
! TIME STEP OF THE PHYSICS, time of the data
!
      REAL dtime
      INTEGER itime
!
! SUBGRID-SCALE OROGRAPHY PARAMETERS
!
      real zstd(klon),zsig(klon),zmea(klon)
      real zgam(klon),zthe(klon)
      real zpic(klon),zval(klon)
      
! TMP files used to upload fast:
      real, allocatable :: xlontmp(:),ylattmp(:)
      real, allocatable :: zmeatmp(:),zstdtmp(:),zsigtmp(:)
      real, allocatable :: zgamtmp(:),zthetmp(:),zpictmp(:),zvaltmp(:)
      real, allocatable :: eastbal(:),westbal(:),prestmp(:)
      real, allocatable :: prectmp(:),lnsptmp(:)
      real, allocatable :: vitutmp(:,:),vitvtmp(:,:),temptmp(:,:)
      real, allocatable :: eastpre(:),westpre(:)
      real :: eastpretmp,westpretmp,eastbaltmp,westbaltmp,cost,sec
      real :: costbal,costtot,costall,vobs
      real :: correast,corrwest,vareastpre,varwestpre,vareastbal,varwestbal 
      real :: meaeastpre,meawestpre,meaeastbal,meawestbal 

!
!  OUTPUT DIAGNOSTICS:
!     zulow(:),zvlow(:):       LOW-LEVEL WIND
!     zustrdr(:), zvstrdr(:):  LOW LEVEL STRESS DUE TO THE DRAG (Pa)
!     zustrli(:), zvstrli(:):  LOW LEVEL STRESS DUE TO THE LIFT (Pa)

      REAL zulow(klon),zvlow(klon),zustrdr(klon), zvstrdr(klon)
      REAL zustrli(klon), zvstrli(klon)
      INTEGER igwd,igwdim
      INTEGER idx(klon),itest(klon)

! U,V,T TENDENCIES DUE TO SSO DRAG and LIFT

      real d_u_oro(klon,klev),d_v_oro(klon,klev)
      real d_t_oro(klon,klev)
      real d_u_lif(klon,klev), d_v_lif(klon,klev)
      real d_t_lif(klon,klev)
      real d_u_hin(klon,klev), d_v_hin(klon,klev)
      real d_t_hin(klon,klev)
      real d_u_lot(klon,klev), d_v_lot(klon,klev)
      real d_t_lot(klon,klev)
!  Surface stress due to hines!
      real zustrhi(klon),zvstrhi(klon)
!  Surface stress due to Lott!
      real zustrlo(klon),zvstrlo(klon)
      real bvlow(klon)
! Precip 2D fields needed to compute GWs amplitudes
      real prec(klon)

!  Logical controlling storage and prints:
      logical, parameter :: ltalk=.true.
      logical :: lstore,llog10
      integer :: istore,ilog10
! Balloon flight characteristic
      integer, parameter :: nballoon=24
      integer :: ibbeg(nballoon),ibend(nballoon),iballoon,iballev
      integer :: ibalbeg,ibalend,nballeff
      real    :: zball(nballoon)
!  Files used to compute statistics:
     real :: eastprem(nballoon),westprem(nballoon),eastbalm(nballoon),westbalm(nballoon)
     real :: eastprev(nballoon),westprev(nballoon),eastbalv(nballoon),westbalv(nballoon)
     real :: eastcorr(nballoon),westcorr(nballoon)
     real :: eastpremall       ,westpremall       ,eastbalmall       ,westbalmall       
     real :: eastprevall       ,westprevall       ,eastbalvall       ,westbalvall       
     real :: cumupremall       ,cumuprevall       ,cumubalmall       ,cumubalvall       
     real :: eastcorrall       ,westcorrall       ,cumucorrall       
     real :: corbaleast,corbalwest,corbalcumu

      ibbeg=(/1,2566,5037,7465,9057,10975,12357,14352,16198,16228,16526,&
             17274,17985,19085,20225,21285,22576,24192,25103,25983,27207,&
             28908,30260,30893/)
      ibend=(/2565,5036,7464,9056,10974,12356,14351,16197,16227,16525,17273,&
              17984,19084,20224,21284,22575,24191,25102,25982,27206,28907,&
              30259,30892,31383/)
      zball=(/20.7,20.3,19.0,18.8,18.9,20.5,20.2,20.2,18.5,20.2,18.5,20.2,&
              18.5,18.5,18.5,20.3,20.3,18.6,18.6,20.5,20.4,18.6,18.5,18.58/)
     eastprem=0.0;      westprem=0.0;      eastbalm=0.0;      westbalm=0.0      
     eastprev=0.0;      westprev=0.0;      eastbalv=0.0;      westbalv=0.0      
     eastcorr=0.0;      westcorr=0.0;      cost=0.     ;      costbal=0.
     vobs=0.
    eastpremall=0.;eastbalmall=0.;westpremall=0.;westbalmall=0.
    cumupremall=0.;cumubalmall=0.;cumuprevall=0.;cumubalvall=0.
    eastprevall=0.;eastbalvall=0.;westprevall=0.;westbalvall=0.
    eastcorrall=0.;westcorrall=0.;cumucorrall=0.
    ndaytot=0
      correast=0.;corrwest=0.;vareastpre=0.
varwestpre=0.;vareastbal=0.;varwestbal=0. 
      meaeastpre=0.;meawestpre=0.;meaeastbal=0.;meawestbal=0. 

      lstore=.false.;llog10=.false.
      read(*,*)istore;if(istore.eq.1)lstore=.true.
      read(*,*)iav
      read(*,*)ilog10;if(ilog10.eq.1)llog10=.true.
      read(*,*)charprec
      if(charprec.eq.'imerg')print *,'imerg',charprec
      if(charprec.eq.'era5')print *,'era5',charprec
!     print *,'charprec=',trim(charprec)
      
!  OFF-DEB
!  THIS IS THE TIME-STEP THE PHYSICS SEE, IT IS
!  PUT TO 30 MINUTES HERE RATHER ABITRARILY

      if(ltalk)print *,'Cost begins'
      DTIME=30.*60.
      DTIME=6.*3600.

!  Load the number of dates you want to proceed:

      ideb=1 ; jdeb=1; ibalbeg=1; ibalend=24

!   Handle the vertical dimension of ERA5    
!   Read the ap and bp needed to calculate pressure from psol

       status = NF90_OPEN('VITU.nc',NF90_NOWRITE,ncid)

       status = NF90_INQ_VARID(ncid,'level',varid)
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
      status = NF90_INQ_DIMID(ncid,'level',dimid)
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
      status = NF90_INQUIRE_DIMENSION(ncid,dimid,len=ll)
      if(ll.ne.klev) then;print *,'pb z-dimension ERA5';stop;endif
      allocate(var3d(iim,jjm,llm))
       allocate(var1d(klev))
       status = &
              NF90_GET_VAR(ncid, varid, var1d, &
              start=(/1/),count=(/klev/))
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
      if(ltalk)print *,'klev=',klev
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
      level(:)=int(var1d(:));if(ltalk)print *,'level=',level
       open(30,file='data/era5_levels.txt')
       read(30,*)entete !; print *,entete
       do ll=1,klev;read(30,*)ii,amoins,bmoins;read(30,*)ii,aplus,bplus
       ap(klev+1-ll)=(amoins+aplus)/2.;bp(klev+1-ll)=(bmoins+bplus)/2.
       enddo
       do ll=1,klev;if(ltalk)print *,'pf(',ll,')=',(ap(ll)+bp(ll)*101325)/100.
       enddo
       do ll=1,klev;zlev(ll)=-7.*log(bp(ll)+ap(ll)/101325.);print*,ll,zlev(ll);enddo
       close(30) 
       deallocate(var1d)
!  Temporal dimension of input:
       status = NF90_INQ_VARID(ncid,'time',varid)
       status = NF90_INQ_DIMID(ncid,'time',dimid)
       status = NF90_INQUIRE_DIMENSION(ncid,dimid,len=ll)
       allocate(var1d(ll))
       status = NF90_CLOSE(ncid)
       if(ltalk)print *,'ll=',ll

!  Prepare outputs at grads and netcdf format:

! This prepare the storage at netdf and grads format:

if(lstore) then
!      open(20,file='gwd_era5_temp.ctl',form='formatted')
!      nvar=0

!       status = nf90_create("gwd_era5_temp.nc", &
!                            nf90_clobber,ncio)
!                    if(ltalk)print *,'Erreur create?',status

!       include "store_init.h"
open(20,file='East_and_West_daily.dat',form='formatted')
endif

      allocate(var2d(iim,jjm)) 
      
  !  Loop over balloons

  do iballoon=ibalbeg,ibalend ; if(ltalk)print *,' Balloon:',iballoon
      itdeb=ibbeg(iballoon)
      itfin=ibend(iballoon)
      itjum=1;istri=1

!  Detection of the model level near balloon level:
        do ll=2,klev-1;if(zball(iballoon).ge.zlev(ll-1).and.zball(iballoon).lt.zlev(ll))iballev=ll;enddo
        if(iballev.le.2.or.iballev.ge.klev-1)stop
        if(ltalk)print *,'iballev=',iballev

! This program handles on month of data only
if(ltalk)print *,'Let us check klon:',klon,iim,jjm,ideb,jdeb
      if(klon.eq.1)then
              nit=0;do it=itdeb,itfin,itjum;nit=nit+1;enddo;if(ltalk)print *,nit
      allocate(xlontmp(nit),ylattmp(nit))
      allocate(zmeatmp(nit),zstdtmp(nit),zsigtmp(nit))
      allocate(zgamtmp(nit),zthetmp(nit),zpictmp(nit),zvaltmp(nit))
!  Balloon data and prediction
      allocate(eastbal(nit),westbal(nit),prestmp(nit))
      allocate(eastpre(nit),westpre(nit))
      allocate(prectmp(nit),lnsptmp(nit))
      allocate(vitutmp(klev,nit),vitvtmp(klev,nit),temptmp(klev,nit))
      endif

!  LOAD THE SSO-PARAMETERS
         
      status = NF90_OPEN( &
      'sso_data.nc',NF90_NOWRITE,ncid)
      status = NF90_INQ_VARID(ncid,'longitude',varid)
      status = NF90_INQ_DIMID(ncid,'longitude',dimid)
      status = NF90_INQUIRE_DIMENSION(ncid,dimid,len=ii)
      if(iim.eq.1)ideb=(ii+1)/2
      if(ii.ne.iim.and.iim.ne.1) then;print *,'x-Dim SSOs wrong?';
      print *,ii,iim;endif
      status = &
        NF90_GET_VAR(ncid, varid, xlontmp,start=(/ideb,itdeb/),count=(/1,nit/), &
                     stride=(/istri,1/))
             if(ltalk)print *,'xlontmp(',nit/2,'):',xlontmp(1),xlontmp(nit/2),xlontmp(nit),xlontmp(nit-2)

      status = NF90_INQ_VARID(ncid,'latitude',varid)
      status = NF90_INQ_DIMID(ncid,'latitude',dimid)
      status = NF90_INQUIRE_DIMENSION(ncid,dimid,len=jj)
      if(iim.eq.1)jdeb=(jj+1)/2
      if(jj.ne.jjm.and.jjm.ne.1) then;print *,'y-Dim SSOs wrong?'
       print *,jj,jjm;endif
      status = &
        NF90_GET_VAR(ncid, varid, ylattmp,start=(/jdeb,itdeb/),count=(/jjm,nit/), &
                     stride=(/istri,1/))
             if(ltalk)print *,'ylattmp:',ylattmp(1),ylattmp(nit/2),ylattmp(nit)

      status = NF90_INQ_VARID(ncid,'zmea',varid)
      status = &
        NF90_GET_VAR(ncid, varid, zmeatmp,start=(/ideb,jdeb,itdeb/),count=(/iim,jjm,nit/), &
                     stride=(/istri,istri,1/))

       status = NF90_INQ_VARID(ncid,'zstd',varid)
      status = &
        NF90_GET_VAR(ncid, varid, zstdtmp,start=(/ideb,jdeb,itdeb/),count=(/iim,jjm,nit/), &
                     stride=(/istri,istri,1/))

       status = NF90_INQ_VARID(ncid,'zsig',varid)
      status = &
        NF90_GET_VAR(ncid, varid, zsigtmp,start=(/ideb,jdeb,itdeb/),count=(/iim,jjm,nit/), &
                     stride=(/istri,istri,1/))

       status = NF90_INQ_VARID(ncid,'zgam',varid)
      status = &
        NF90_GET_VAR(ncid, varid, zgamtmp,start=(/ideb,jdeb,itdeb/),count=(/iim,jjm,nit/), &
                     stride=(/istri,istri,1/))
       status = NF90_INQ_VARID(ncid,'zthe',varid)
      status = &
        NF90_GET_VAR(ncid, varid, zthetmp,start=(/ideb,jdeb,itdeb/),count=(/iim,jjm,nit/), &
                     stride=(/istri,istri,1/))

       status = NF90_INQ_VARID(ncid,'zpic',varid)
      status = &
        NF90_GET_VAR(ncid, varid, zpictmp,start=(/ideb,jdeb,itdeb/),count=(/iim,jjm,nit/), &
                     stride=(/istri,istri,1/))
       status = NF90_INQ_VARID(ncid,'zval',varid)
      status = &
        NF90_GET_VAR(ncid, varid, zvaltmp,start=(/ideb,jdeb,itdeb/),count=(/iim,jjm,nit/), &
                     stride=(/istri,istri,1/))
         status = NF90_CLOSE(ncid)

         if(ltalk)print *,'zmea:',minval(zmeatmp),maxval(zmeatmp) 
         if(ltalk)print *,'zstd:',minval(zstdtmp),maxval(zstdtmp) 
         if(ltalk)print *,'zsig',minval(zsigtmp),maxval(zsigtmp) 
         if(ltalk)print *,'zgam',minval(zgamtmp),maxval(zgamtmp) 
         if(ltalk)print *,'zthe',minval(zthetmp),maxval(zthetmp) 
         if(ltalk)print *,'zval',minval(zvaltmp),maxval(zvaltmp) 
         if(ltalk)print *,'zpic',minval(zpictmp),maxval(zpictmp) 

! READ THE BAlloon data

        status = NF90_OPEN('Balloon.nc',NF90_NOWRITE,ncid)
      status = NF90_INQ_VARID(ncid,'qdm_u_east',varid)
      status = &
              NF90_GET_VAR(ncid, varid, eastbal, &
              start=(/itdeb/),count=(/nit/), &
               stride=(/1/))
       status = NF90_INQ_VARID(ncid,'qdm_u_west',varid)
      status = &
              NF90_GET_VAR(ncid, varid, westbal, &
              start=(/itdeb/),count=(/nit/), &
               stride=(/1/))
       status = NF90_INQ_VARID(ncid,'pressure',varid)
      status = &
              NF90_GET_VAR(ncid, varid, prestmp, &
              start=(/itdeb/),count=(/nit/), &
               stride=(/1/))
      status = NF90_CLOSE(ncid)
      if(ltalk)print *,'eastbal',minval(eastbal),maxval(eastbal) 
        if(ltalk)print *,'westbal',minval(westbal),maxval(westbal) 
        if(ltalk)print *,'prestmp',minval(prestmp),maxval(prestmp) 
     if(ltalk) then;do it=1,nit;write(90,*)prestmp(it);enddo;write(90,*)' ';endif
     if(ltalk) then;do it=1,nit;write(91,*)eastbal(it);enddo;write(91,*)' ';endif

! READ THE ERA5 PRECIPS DATAS:
     
      status = NF90_OPEN('PREC.nc',NF90_NOWRITE,ncid)

      if(status.ne.0)then;print *,'Error open data';stop;endif
! Precips:
      status = NF90_INQ_VARID(ncid,'tp',varid)
      status = &
              NF90_GET_VAR(ncid, varid, prectmp, &
              start=(/ideb,jdeb,itdeb/),count=(/iim,jjm,nit/), &
                     stride=(/istri,istri,1/))
!  In ERA5, precips are in meter accumulated over one hour:
       if(charprec.eq.'era5')prectmp(:)=prectmp(:)*1000./3600.
!  In imerg, precips are in mm accumulated over one hour:
       if(charprec.eq.'imerg')prectmp(:)=prectmp(:)/3600.
       if(ltalk)print *,'Error read data:',status
       if(ltalk)print *,'prec',minval(prectmp),maxval(prectmp) 
      if(ltalk) then; do it=1,nit;write(92,*)prectmp(it);enddo;write(92,*);endif
      status = NF90_CLOSE(ncid)

!  READ the ERA5 lnsp field

      status = NF90_OPEN('LNSP.nc',NF90_NOWRITE,ncid)
       status = NF90_INQ_VARID(ncid,'lnsp',varid)
        status = &
              NF90_GET_VAR(ncid, varid, lnsptmp, &
              start=(/ideb,jdeb,itdeb/),count=(/iim,jjm,nit/), &
              stride=(/istri,istri,1/))
      if(ltalk)print *,'Min and Max de lnsp:',minval(lnsptmp),maxval(lnsptmp)

      status = NF90_CLOSE(ncid)

      status = NF90_OPEN('VITU.nc',NF90_NOWRITE,ncid)
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
       status = NF90_INQ_VARID(ncid,'vitu',varid)
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
        status = &
              NF90_GET_VAR(ncid, varid, vitutmp, &
              start=(/ideb,jdeb,1,itdeb/),count=(/iim,jjm,klev,nit/), &
              stride=(/istri,istri,1,1/))
      if(ltalk)print *,'Min and Max de vitutmp:',minval(vitutmp),maxval(vitutmp)
      status = NF90_CLOSE(ncid)

      status = NF90_OPEN('VITV.nc',NF90_NOWRITE,ncid)
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
       status = NF90_INQ_VARID(ncid,'vitv',varid)
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
        status = &
              NF90_GET_VAR(ncid, varid, vitvtmp, &
              start=(/ideb,jdeb,1,itdeb/),count=(/iim,jjm,klev,nit/), &
              stride=(/istri,istri,1,1/))
      if(ltalk)print *,'Min and Max de vitvtmp:',minval(vitvtmp),maxval(vitvtmp)
      status = NF90_CLOSE(ncid)

      status = NF90_OPEN('TEMP.nc',NF90_NOWRITE,ncid)
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
       status = NF90_INQ_VARID(ncid,'temp',varid)
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
        status = &
              NF90_GET_VAR(ncid, varid, temptmp, &
              start=(/ideb,jdeb,1,itdeb/),count=(/iim,jjm,klev,nit/), &
              stride=(/istri,istri,1,1/))
      if(ltalk)print *,'Min and Max de temptmp:',minval(temptmp),maxval(temptmp)
      status = NF90_CLOSE(ncid)

!LOOP ON THE DAYS

      iter=0
      do it=itdeb,itfin,itjum
      iter=iter+1

! Use the already read datas:

      xlon(:)=xlontmp(iter)
      xx(:)=xlon(:)*acos(-1.)/180.

      ylat(:)=ylattmp(iter)
      yy(:)=ylat(:)*acos(-1.)/180.

!  Used in subroutines:
      rlat(1)=ylattmp(iter)
! SSO parameters:
      zmea(1)=zmeatmp(iter)
      zstd(1)=zstdtmp(iter)
      zsig(1)=zsigtmp(iter)
      zgam(1)=zgamtmp(iter)
      zthe(1)=zthetmp(iter)
      zval(1)=zvaltmp(iter)
      zpic(1)=zpictmp(iter)
!ERA5 Values:
      prec(1)=prectmp(iter)
      psol(1)=exp(lnsptmp(iter))
      do ll=1,klev;u(1,ll)=vitutmp(klev+1-ll,iter);enddo
      do ll=1,klev;v(1,ll)=vitvtmp(klev+1-ll,iter);enddo
      do ll=1,klev;t(1,ll)=temptmp(klev+1-ll,iter);enddo
      
!))  Build the pressures

       do ll=1,klev;pplay(:,ll)=ap(ll)+bp(ll)*psol(:);enddo
        
       if(iter.eq.1.and.ltalk)print *,' pplay:',pplay((klon+1)/2,1),&
                         pplay((klon+1)/2,klev/2), &
                         pplay((klon+1)/2,klev)
!  Pressure at 1/2 Levels:

       paprs(:,klev+1)=0.
       do l=2,klev; paprs(:,l)=0.5*(pplay(:,l)+pplay(:,l-1)); enddo
       paprs(:,1)=pplay(:,1)+0.5*(pplay(:,1)-pplay(:,2))
       
       if(iter.eq.1.and.ltalk)print *,' paprs:',paprs((klon+1)/2,2),paprs((klon+1)/2,klev/2)

!  Rotationnal

      if(iim.ge.3.or.jjm.ge.3)then
      do jj=2,jjm-1
         do ii=2,iim-1; ij=(jj-1)*iim+ii
        rot(ij,:)=( &
                   (v(ij+1,:)-v(ij-1,:))/(xx(ii+1)-xx(ii-1)) &
                  -(u(ij+iim,:)*cos(yy(jj+1))-u(ij-iim,:)*cos(yy(jj-1))) &
                   /cos(yy(jj))/(yy(jj+1)-yy(jj-1)) &
                   )/6400000.;enddo 
         ii=1; ij=(jj-1)*iim+ii
        rot(ij,:)=( &
                   (v(ij+1,:)-v(ij-1+iim,:))/(xx(ii+2)-xx(ii)) &
                  -(u(ij+iim,:)*cos(yy(jj+1))-u(ij-iim,:)*cos(yy(jj-1))) &
                   /cos(yy(jj))/(yy(jj+1)-yy(jj-1)) &
                  )/6400000.
         ii=iim; ij=(jj-1)*iim+ii
         rot(ij,:)=( &
                   (v(ij+1-iim,:)-v(ij-1,:))/(xx(ii)-xx(ii-2)) &
                  -(u(ij+iim,:)*cos(yy(jj+1))-u(ij-iim,:)*cos(yy(jj-1))) &
                   /cos(yy(jj))/(yy(jj+1)-yy(jj-1)) &
                  )/6400000.
       enddo
       do ii=1,iim;rot(ii,:)=rot(ii+iim,:)
       rot((jjm-1)*iim+ii,:)=rot((jjm-2)*iim+ii,:);enddo

       if(iter.eq.1.and.ltalk)print *,'Min and Max de rot:',minval(rot),maxval(rot)
       if(iter.eq.1.and.ltalk)print *,'Une  de rot:',rot((klon+1)/2,klev/2)
       if(iter.eq.1.and.ltalk)print *,' index:',index,index+iim,klon !; stop
       else
       rot(:,:)=0.
       endif
  
!OFF-END

!  INITIALIZE CONSTANT FOR THE GWD SCHEME
!  ON-LINE SHOULD ONLY BE CALLED AT THE MODEL START UP.

        IF(iter.EQ.1) CALL SUGWD_strato(klon,klev,paprs,pplay)
        
       d_u_lif=0; d_v_lif=0; d_t_lif=0; zustrli=0; zvstrli=0
       d_u_oro=0; d_v_oro=0; d_t_oro=0; zustrdr=0; zvstrdr=0
       d_u_hin=0; d_v_hin=0; d_t_hin=0; zustrhi=0; zvstrhi=0
       d_u_lot=0; d_v_lot=0; d_t_lot=0; zustrlo=0; zvstrlo=0
       east_flott=0.;  west_flott=0.;  east_acama=0.;  west_acama=0.


!  SSO Parameterization from Lott and Miller (1997)

!  SELECTION  POINTS WHERE THE SCHEME IS ACTIVE
      
        goto 212

        igwd=0
        DO i=1,klon
        itest(i)=0
        IF (((zpic(i)-zmea(i)).GT.100.).AND.(zstd(i).GT.10.0)) THEN
          itest(i)=1
          igwd=igwd+1
          idx(igwd)=i
        ENDIF
        ENDDO
        igwdim=MAX(1,igwd)
 
        if(iter.eq.1.and.ltalk)print *,'Entree drag'


        CALL drag_noro_strato(1,klon,klev,dtime,paprs,pplay, &
                         zmea,zstd, zsig, zgam, zthe,zpic,zval, &
!                        igwd,igwdim,idx,itest, &
                         igwd,idx,itest, &
                         t, u, v, &
                         zulow, zvlow, zustrdr, zvstrdr, &
                         d_t_oro, d_u_oro, d_v_oro)
!
!  LIFT parameterization from Lott (1999):
!
        igwd=0
        DO i=1,klon
        itest(i)=0
        IF ((zpic(i)-zmea(i)).GT.100.) THEN
          itest(i)=1
          igwd=igwd+1
          idx(igwd)=i
        ENDIF
        ENDDO
        igwdim=MAX(1,igwd)
!
if(iter.eq.1.and.ltalk)print *,'Entree Lift'

        CALL lift_noro_strato(klon,klev,dtime,paprs,pplay, &
                         rlat,zmea,zstd, zsig, zgam, zthe,zpic,zval, &
!                        igwd,igwdim,idx,itest, &
                         igwd,idx,itest, &
                         t, u, v, &
                         zulow, zvlow, zustrli, zvstrli, &
                         d_t_lif, d_u_lif, d_v_lif)
!

!
158    Continue

!  Non-orographic GWS due to fronts:

       if(iter.eq.1.and.ltalk)print *,'Entree Acama'

       call acama_gwd_rando(dtime,pplay, rlat, &
                      t, u, v, rot, &
                     zustrhi,zvstrhi, &
                     d_u_hin,d_v_hin,east_acama,west_acama)

212      continue

!  Non-orographic GWS due to rain:
!
if(iter.eq.1.and.ltalk)print *,'Entree Lott'

             call flott_gwd_rando(dtime,pplay, &
                    t, u, v,prec, &
                    zustrlo,zvstrlo, &
                    d_u_lot,d_v_lot,east_flott,west_flott)
!         print *,'d_u_lot===', d_u_lot
!         print *,'east_flott', prec(1),east_flott(1,klev/2)
!         if(iballoon.eq.1)write(98,*)pplay(1,45)

!  TENDENCIES IN M/S/DAY

       do i=1,klon
       do l=1,klev
          d_u_oro(i,l)=d_u_oro(i,l)*24.*3600./dtime
          d_v_oro(i,l)=d_v_oro(i,l)*24.*3600./dtime
          d_u_lif(i,l)=d_u_lif(i,l)*24.*3600./dtime
          d_v_lif(i,l)=d_v_lif(i,l)*24.*3600./dtime
          d_u_hin(i,l)=d_u_hin(i,l)*24.*3600./dtime
          d_v_hin(i,l)=d_v_hin(i,l)*24.*3600./dtime
          d_u_lot(i,l)=d_u_lot(i,l)*24.*3600./dtime
          d_v_lot(i,l)=d_v_lot(i,l)*24.*3600./dtime
          v(i,l)=d_v_hin(i,l)
       enddo
       enddo

!  Interpolation at balloon altitude:

      eastpre(iter)=east_flott(1,iballev-1)+(east_flott(1,iballev)-east_flott(1,iballev-1)) &
                   *(zball(iballoon)-zlev(iballev-1))/(zlev(iballev)-zlev(iballev-1))
      westpre(iter)=west_flott(1,iballev-1)+(west_flott(1,iballev)-west_flott(1,iballev-1)) &
                   *(zball(iballoon)-zlev(iballev-1))/(zlev(iballev)-zlev(iballev-1))

!  NETCDF STORAGE:      
!     Here storage
      
!Old stuff:
!if(lstore)
!status = nf90_open('gwd_era5_temp.nc',NF90_WRITE,ncio)
!f(status.ne.0)then;print *,'Erreur open?',status;stop;endif
!     if(lstore)then
!     if(mod(iter,100).eq.1)print *,'storage begins at',it,':',eastpre(iter),westpre(iter)     
!include  "store_cost.h" 
!     status = nf90_close(ncio)
!     else
!     if(mod(iter,1000).eq.1.and.ltalk)print*,'No storage iballoon=',iballoon,' at',&
!             it,eastpre(iter),westpre(iter)       
!    endif

!  END OF LOOP ON DAYS

        ENDDO

!Mpa:
!      eastpre=1000.*eastpre ; westpre=1000.*westpre

        if(ltalk)print *,'eastpre',minval(eastpre),maxval(eastpre) 
        if(ltalk)print *,'westpre',minval(westpre),maxval(westpre) 

!day in balloon:

eastprem(iballoon)=0.0; westprem(iballoon)=0;eastbalm(iballoon)=0.0;westbalm(iballoon)=0.0      
eastprev(iballoon)=0.0;westprev(iballoon)=0.0;eastbalv(iballoon)=0.0;westbalv(iballoon)=0.0      
eastcorr(iballoon)=0.0;westcorr(iballoon)=0.0

iter=0.; nday=(itfin-itdeb+1)/iav !; print *,'nday=',nday
do iday=1,nday;eastbaltmp=0.;eastpretmp=0.;westbaltmp=0.;westpretmp=0.0;sec=1.e-8
 ndaytot=ndaytot+1   
!  Daily average
do ihr=1,iav
iter=iter+1
eastbaltmp=eastbaltmp+eastbal(iter)/float(iav); eastpretmp=eastpretmp+eastpre(iter)/float(iav)
westbaltmp=westbaltmp+westbal(iter)/float(iav); westpretmp=westpretmp+westpre(iter)/float(iav)
enddo
!mPa:
eastbaltmp=eastbaltmp*1000.;eastpretmp=eastpretmp*1000.
westbaltmp=westbaltmp*1000.;westpretmp=westpretmp*1000.
!  Daily storage:
if(lstore)write(20,*)ndaytot,westpretmp,eastpretmp,westbaltmp,eastbaltmp
! End of daily
        westprem(iballoon)=westprem(iballoon)+westpretmp/float(nday)  
        eastprem(iballoon)=eastprem(iballoon)+eastpretmp/float(nday)  
        westbalm(iballoon)=westbalm(iballoon)+westbaltmp/float(nday)  
        eastbalm(iballoon)=eastbalm(iballoon)+eastbaltmp/float(nday)  
        westprev(iballoon)=westprev(iballoon)+westpretmp**2/float(nday)  
        eastprev(iballoon)=eastprev(iballoon)+eastpretmp**2/float(nday)  
        westbalv(iballoon)=westbalv(iballoon)+westbaltmp**2/float(nday)  
        eastbalv(iballoon)=eastbalv(iballoon)+eastbaltmp**2/float(nday)  
        westcorr(iballoon)=westcorr(iballoon)+westpretmp*westbaltmp/float(nday)
        eastcorr(iballoon)=eastcorr(iballoon)+eastpretmp*eastbaltmp/float(nday)

!  Cost function:
!  Log COST...
        if(llog10)then
        cost=cost+(log10(abs(eastpretmp)+sec)-log10(abs(eastbaltmp)+sec))**2+&
                  (log10(abs(westpretmp)+sec)-log10(abs(westbaltmp)+sec))**2
        vobs=vobs+(log10(abs(eastbaltmp)+sec))**2+&
                  (log10(abs(westbaltmp)+sec))**2
        else
        cost=cost+(eastpretmp-eastbaltmp)**2+(westpretmp-westbaltmp)**2
        vobs=vobs+eastbaltmp**2+westbaltmp**2
        endif
!  End of cost function

        corrwest=corrwest+westpretmp*westbaltmp
        correast=correast+eastpretmp*eastbaltmp
        varwestpre=varwestpre+westpretmp*westpretmp
        vareastpre=vareastpre+eastpretmp*eastpretmp
        varwestbal=varwestbal+westbaltmp*westbaltmp
        vareastbal=vareastbal+eastbaltmp*eastbaltmp
        meawestpre=meawestpre+westpretmp
        meaeastpre=meaeastpre+eastpretmp
        meawestbal=meawestbal+westbaltmp
        meaeastbal=meaeastbal+eastbaltmp
enddo
        eastprev(iballoon)=eastprev(iballoon)-eastprem(iballoon)**2
        westprev(iballoon)=westprev(iballoon)-westprem(iballoon)**2
        eastbalv(iballoon)=eastbalv(iballoon)-eastbalm(iballoon)**2
        westbalv(iballoon)=westbalv(iballoon)-westbalm(iballoon)**2
        eastcorr(iballoon)=eastcorr(iballoon)-eastprem(iballoon)*eastbalm(iballoon)
        westcorr(iballoon)=westcorr(iballoon)-westprem(iballoon)*westbalm(iballoon)

        ! if(ltalk)print *,'daily Balloon(',iballoon,'):',eastcorr(iballoon)/sqrt(eastprev(iballoon)*eastbalv(iballoon))&
!       print *,'daily Balloon(',iballoon,'):',eastcorr(iballoon)/sqrt(eastprev(iballoon)*eastbalv(iballoon))&
!                                             ,westcorr(iballoon)/sqrt(westprev(iballoon)*westbalv(iballoon))
                     
!  End of statistics

      deallocate(xlontmp,ylattmp)
      deallocate(zmeatmp,zstdtmp,zsigtmp)
      deallocate(zgamtmp,zthetmp,zpictmp,zvaltmp)
      deallocate(eastbal,westbal,prestmp)
      deallocate(eastpre,westpre)
      deallocate(prectmp,lnsptmp)
      deallocate(vitutmp,vitvtmp,temptmp)

! End of loop on balloons
ENDDO

!  Archive des valeurs ballons
    if(lstore)then
    open(33,file='scat_balloon.dat')
    do iballoon=ibalbeg,ibalend; write(33,*)eastbalm(iballoon),eastprem(iballoon);enddo
    write(33,*)' '
    do iballoon=ibalbeg,ibalend; write(33,*)westbalm(iballoon)+eastbalm(iballoon),&
                                            westprem(iballoon)+eastprem(iballoon);enddo
    write(33,*)' '
    do iballoon=ibalbeg,ibalend; write(33,*)westbalm(iballoon),westprem(iballoon);enddo
    write(33,*)' '
    write(33,*)-3.,-3.;write(33,*)3.,3.
    close(33)
    endif

    eastpremall=0.;eastbalmall=0.;westpremall=0.;westbalmall=0.
    eastprevall=0.;eastbalvall=0.;westprevall=0.;westbalvall=0.
    eastcorrall=0.;westcorrall=0.
    do iballoon=ibalbeg,ibalend; nballeff=(ibalend-ibalbeg+1) 
    eastpremall=eastpremall+eastprem(iballoon)/float(nballeff);westpremall=westpremall+westprem(iballoon)/float(nballeff)
    eastbalmall=eastbalmall+eastbalm(iballoon)/float(nballeff);westbalmall=westbalmall+westbalm(iballoon)/float(nballeff)
    cumubalmall=cumubalmall+(eastbalm(iballoon)+westbalm(iballoon))/float(nballeff)
    cumupremall=cumupremall+(eastprem(iballoon)+westprem(iballoon))/float(nballeff)
    cumubalvall=cumubalvall+(eastbalm(iballoon)+westbalm(iballoon))**2/float(nballeff)
    cumuprevall=cumuprevall+(eastprem(iballoon)+westprem(iballoon))**2/float(nballeff)
    eastprevall=eastprevall+eastprem(iballoon)*eastprem(iballoon)/float(nballeff)
    westprevall=westprevall+westprem(iballoon)*westprem(iballoon)/float(nballeff)
    eastbalvall=eastbalvall+eastbalm(iballoon)*eastbalm(iballoon)/float(nballeff)
    westbalvall=westbalvall+westbalm(iballoon)*westbalm(iballoon)/float(nballeff)
    eastcorrall=eastcorrall+eastbalm(iballoon)*eastprem(iballoon)/float(nballeff)
    westcorrall=westcorrall+westbalm(iballoon)*westprem(iballoon)/float(nballeff)
    cumucorrall=cumucorrall+(eastbalm(iballoon)+westbalm(iballoon))*&
                            (eastprem(iballoon)+westprem(iballoon))/float(nballeff)
    enddo


if(ltalk) print *,' Between balloon:',(eastcorrall-eastpremall*eastbalmall)&
                             /sqrt(eastprevall-eastpremall**2)/sqrt(eastbalvall-eastbalmall**2)&
                             ,(westcorrall-westpremall*westbalmall)&
                             /sqrt(westprevall-westpremall**2)/sqrt(westbalvall-westbalmall**2)&
                             ,(cumucorrall-cumupremall*cumubalmall)&
                             /sqrt(cumuprevall-cumupremall**2)/sqrt(cumubalvall-cumubalmall**2)
corbaleast=(eastcorrall-eastpremall*eastbalmall)&
                             /sqrt(eastprevall-eastpremall**2)/sqrt(eastbalvall-eastbalmall**2)
corbalwest=(westcorrall-westpremall*westbalmall)&
                             /sqrt(westprevall-westpremall**2)/sqrt(westbalvall-westbalmall**2)
corbalcumu=(cumucorrall-cumupremall*cumubalmall)&
                             /sqrt(cumuprevall-cumupremall**2)/sqrt(cumubalvall-cumubalmall**2)


   costbal=0.;costtot=0.
   do iballoon=ibalbeg,ibalend
   nday=(ibend(iballoon)-ibbeg(iballoon)+1)/iav ! ; print *,'nday=',nday
!  print *,'iballoon',iballoon,nday,westprev(iballoon),westbalv(iballoon)
   costbal=costbal+float(nday)/float(ndaytot)*&
!         (westprem(iballoon)-westbalm(iballoon))**2+(eastprem(iballoon)-eastbalm(iballoon))**2   !  Wrong
          ((westprem(iballoon)-westbalm(iballoon))**2+(eastprem(iballoon)-eastbalm(iballoon))**2) !  Right
   costtot=costtot+float(nday)/float(ndaytot)*&
           (westprev(iballoon)+westbalv(iballoon)-2.*westcorr(iballoon)&
           +eastprev(iballoon)+eastbalv(iballoon)-2.*eastcorr(iballoon))
   enddo
  
!  print *,' Cost bal=',costbal/1.e-6,' Cost Tot:',(costtot+costbal)/1.e-6
   write(97,*)'LOOP',costbal
   write(98,*)'LOOP',costtot
   write(99,*)'LOOP',(costtot+costbal)

!  Final diagnostics:
        meaeastpre=meaeastpre/float(ndaytot)
        meawestpre=meawestpre/float(ndaytot)
        meaeastbal=meaeastbal/float(ndaytot)
        meawestbal=meawestbal/float(ndaytot)
        vareastpre=vareastpre/float(ndaytot)
        varwestpre=varwestpre/float(ndaytot)
        vareastbal=vareastbal/float(ndaytot)
        varwestbal=varwestbal/float(ndaytot)
        correast=correast/float(ndaytot)
        corrwest=corrwest/float(ndaytot)

        costtot=(vareastpre+vareastbal-2.*correast+varwestpre+varwestbal-2.*corrwest)

        vareastpre=vareastpre-meaeastpre**2
        varwestpre=varwestpre-meawestpre**2
        vareastbal=vareastbal-meaeastbal**2
        varwestbal=varwestbal-meawestbal**2
        correast=(correast-meaeastpre*meaeastbal)/sqrt(vareastpre*vareastbal)
        corrwest=(corrwest-meawestpre*meawestbal)/sqrt(varwestpre*varwestbal)
       

!write(*,232)'Corr E & W',correast,corrwest,';  Cost Bal & Tot:', costbal, costtot,'; cost:',cost/float(ndaytot)
   write(90,*)costtot
   write(91,*)correast
   write(92,*)corrwest
   write(93,*)cost/vobs

write(*,232)'Corr E & W',correast,corrwest,';  Ball E & W:', corbaleast, corbalwest,'; cost:',cost/vobs,'vobs=',vobs/float(ndaytot)

232 format(a11,2(1x,f7.3),a15,2(1x,f7.4),a11,(1x,f7.4),a11,(1x,f7.4))

if(lstore)then
write(20,*)' '
do iballoon=2,nballoon
write(20,*)float(ibbeg(iballoon))/float(iav),-10.
write(20,*)float(ibbeg(iballoon))/float(iav),+10.
write(20,*)float(ibbeg(iballoon))/float(iav),-10.
enddo
close(20)
endif
!OFF-END
        
!       STOP 
        END
