#!/bin/bash
#itfin=$(( itdeb + ( nit -1 ) * itjum ))
#itfin=20
istri=1   # Jumps in latitude and longitude (stride)
IIM=1
JJM=1
NOBS=2
IAV=24
#RDISS RUWMAX RUWBAC RSAT DZ XLAUNCH KMIN KMAX CMAX RUWSTSD : 1 to test, 0 not to test
IPAR=([1]=0 0 1 0 0 1 0 0 0 0)
NENS=100   # Number of runs in the ensemble
NENKF=4 # Number of ENKF Cycles
PROOF=0   # 1: Proof of concept mode
LOG10=1  # 1: log 10 of fluxes taken; 2: net and log10 of amplitude
SMOO=1    # 1: Kalman smoother active 
HOOD=1    # 1: Likelyhood estimates active
DETE=0    # 1: Deterministic (no added error in the analysis)
OMP=1     # 1: Compile in openmp
BALDEB=1  # Start at 1 Min
BALMID1=9 # Bad balloon is 9, BALMID1 and 2 at 9 to exclude
BALMID2=9 # =BALMID1-1 and less than BALEND-1 not to exclude one...
BALEND=24 # End at 24 Max
#nstart=([1]=1 2566 5037 7465 9057 10975 12970 14352)
#nstop=([1]=2565 5036 7464 9056 10974 12969 14351 16197)
prec=era5 #  imerg ou era5: origin of precipitation.
wavs=1hrs15min # 1hrs15min or 1day15min, frequency band of measured GWs MF
scenario=JGR25  # QBOi or COST3 or NORAI or DEBOR or TEST1? 2? 3???
version=FIX  

for ibal in `seq ${BALDEB} $((${BALMID1} - 1))` `seq $((${BALMID2} + 1)) $BALEND`
do
echo $ibal
done

ICODE=$((${IPAR[1]}*1+${IPAR[2]}*2+${IPAR[3]}*4+${IPAR[4]}*8+${IPAR[5]}*16+${IPAR[6]}*32+${IPAR[7]}*64+${IPAR[8]}*128+${IPAR[9]}*256+${IPAR[10]}*512))
NPAR=$((${IPAR[1]}+${IPAR[2]}+${IPAR[3]}+${IPAR[4]}+${IPAR[5]}+${IPAR[6]}+${IPAR[7]}+${IPAR[8]}+${IPAR[9]}+${IPAR[10]}))
echo $NPAR
printf -v ICO2D %04d $ICODE

echo $ICO2D

make clean
echo ${IPAR[2]}
Ninput=../hourly_1deg_ph1_ph2
Nprog=../prog_v4
Ndivr=../divr_v4
Noutput=../xmgr_v4/E${NENS}_K${NENKF}_$V${version}_A${IAV}_L${LOG10}_S${scenario}_C${ICODE}
echo $dirname

mkdir ../xmgr_v4
mkdir xmgr 
mkdir -p $Noutput

ijump=0

if [ "$ijump" -eq 0 ]; then

cat << EOF1 > dimensions.h
       INTEGER iim,jjm,llm
       PARAMETER (iim=${IIM},jjm=${JJM},llm=69)
EOF1
cat <<EOF2 > dimphy.h
      INTEGER KIDIA, KFDIA, KLON, KLEV
!  In the ENKF Version, longitude iterations used to sample time within intervals:
      PARAMETER (KIDIA=1,KFDIA=${IAV},KLON=KFDIA-KIDIA+1,KLEV=llm)
EOF2

cat <<EOF3 > laun_gwd_era5.h
  RDISS = 0.5
  RUWMAX= 0.15 
  RUWBAC= 0.935 
  RSAT= 0.3
  DZ =100.
  XLAUNCH=0.45
  KMIN = 2.E-5
  KMAX = 1.E-3
  CMAX = 40.0
  RUWSTD=0.01
EOF3

#Inputs: 
#Inputs: 
ln -s $Ninput data
ln -s $Ninput/sso_ph1_ph2.nc  sso_data.nc
ln -s $Ninput/ERA5_${prec}_Strateole_ph1_ph2.nc VITU.nc
ln -s $Ninput/ERA5_${prec}_Strateole_ph1_ph2.nc VITV.nc
ln -s $Ninput/ERA5_${prec}_Strateole_ph1_ph2.nc TEMP.nc
ln -s $Ninput/ERA5_${prec}_Strateole_ph1_ph2.nc LNSP.nc
ln -s $Ninput/ERA5_${prec}_Strateole_ph1_ph2.nc PREC.nc
ln -s $Ninput/STRATEOLE2_ph1_ph2_${wavs}.nc Balloon.nc

ln -s $Nprog/dimphy.h .
ln -s $Nprog/YOEGWD.h .
ln -s $Nprog/sugwd_strato_ENKF.f90 sugwd_strato.f90
ln -s $Nprog/laun_gwd_era5_ENKF.f90 laun_gwd_era5.f90
ln -s $Nprog/flott_gwd_rando_ENKF.f90 flott_gwd_rando.f90

\rm Makefile
if [ $OMP -gt 0 ]; then
   cp -f Makefile_OMP Makefile
else
   cp -f Makefile_OPT Makefile
fi

make 


for IBALL in `seq ${BALDEB} $((${BALMID1} - 1))` `seq $((${BALMID2} + 1)) $BALEND`
do
cat <<EOF3 > run_data
${NOBS}
${IAV}
${IPAR[1]},${IPAR[2]},${IPAR[3]},${IPAR[4]},${IPAR[5]},${IPAR[6]},${IPAR[7]},${IPAR[8]},${IPAR[9]},${IPAR[10]}
${NENS}
${NENKF}
${PROOF}
${LOG10}
${SMOO}
${HOOD}
${DETE}
${IBALL}
${IBALL}
${prec}
${scenario}
EOF3
./laun_gwd_era5 < run_data
done

cat <<EOF4 > header
#Balloons: $BALDEB $BALMID1 $BALMID2 $BALEND Nbr ENKF $NENKF
EOF4
for prod in x t y ;do
for typ in pre smo; do
for jpar in `seq 1 $NPAR`; do
cp header xmgr/$prod$typ$jpar.dat
#for ienk in `seq 0 ${NENKF}`; do
for ienk in `seq ${NENKF} ${NENKF}`; do
for ibal in `seq ${BALDEB} $((${BALMID1} - 1))` `seq $((${BALMID2} + 1)) $BALEND`
#echo for iball in `seq ${BALDEB} $((${BALMID} - 1))` `seq $((${BALMID} + 1)) $BALEND`
do
echo $ibal
cat xmgr/$prod$typ$jpar.dat xmgr/$prod$typ${jpar}_E${ienk}B${ibal}.dat > xmgr/temp.dat
\rm xmgr/$prod$typ$jpar.dat
mv xmgr/temp.dat xmgr/$prod$typ$jpar.dat
done
done
mv xmgr/$prod$typ$jpar.dat $Noutput
done
done
done

for jpar in 1 2; do
cp header xmgr/ysy_${jpar}.dat
#for ienk in `seq 0 ${NENKF}`; do
for ienk in `seq ${NENKF} ${NENKF}`; do
for ibal in `seq ${BALDEB} $((${BALMID1} - 1))` `seq $((${BALMID2} + 1)) $BALEND`
do
cat xmgr/ysy_${jpar}.dat xmgr/ysy_${jpar}_E${ienk}B${ibal}.dat > xmgr/temp.dat
\rm xmgr/ysy_${jpar}.dat
mv xmgr/temp.dat xmgr/ysy_${jpar}.dat
done
done
mv xmgr/ysy_${jpar}.dat $Noutput
done

cat header xmgr/ypr_*.dat > $Noutput/ypr_ens.dat
cat header xmgr/ysm_*.dat > $Noutput/ysm_ens.dat
cat header xmgr/tpr_*.dat > $Noutput/tpr_ens.dat
cat header xmgr/tsm_*.dat > $Noutput/tsm_ens.dat


cp header xmgr/profs.dat
for ibal in `seq ${BALDEB} $((${BALMID1} - 1))` `seq $((${BALMID2} + 1)) $BALEND`
do
cat xmgr/profs.dat xmgr/profs_E${NENKF}B${ibal}.dat  > xmgr/temp.dat
\rm xmgr/profs_E${NENKF}B${ibal}.dat
mv xmgr/temp.dat xmgr/profs.dat
done
mv xmgr/profs.dat $Noutput

cp ENKF_launch.sh $Noutput
cp laun_gwd_era5.f90 $Noutput
cp flott_gwd_rando.f90 $Noutput
cp laun_gwd_era5.h $Noutput

fi

cat <<EOF3 > run_data
${NENKF} ${NENKF}
EOF3
gfortran $Ndivr/axis_ENKF.f90
./a.out < run_data
\rm $Noutput/axis.dat
mv axis.dat $Noutput

xmgrace -nxy $Noutput/tsmo1.dat  $Noutput/axis.dat -par ../divr_v4/GB_Enkf.par &
xmgrace -nxy $Noutput/tsmo2.dat  $Noutput/axis.dat -par ../divr_v4/PL_Enkf.par &

xmgrace -nxy $Noutput/ysmo1.dat -nxy $Noutput/ysmo2.dat $Noutput/axis.dat -par ../divr_v4/MF_Enkf.par &

