      SUBROUTINE GASSES(IPRINT)
C THIS SUBROUTINE SETS UP THE MASS MIXING RATIOS OF THE
C OPTICALLY ACTIVE GASES: CH4, C2H2, AND C2H6
      USE TGMDAT_MOD, ONLY: RHCH4,FH2,FHAZE,FHVIS,FHIR,TAUFAC,
     &                      RCLOUD,FARGON
      USE TGMDAT_MOD, ONLY: RGAS,RHOP,PI,SIGMA
      include "dimensions.h"
      PARAMETER(NLAYER=llm,NLEVEL=NLAYER+1)
      COMMON /ATM/ Z(NLEVEL),PRESS(NLEVEL),DEN(NLEVEL),TEMP(NLEVEL)
      COMMON /GASS/ CH4(NLEVEL),XN2(NLEVEL),H2(NLEVEL),AR(NLEVEL)
     & ,XMU(NLEVEL),GAS1(NLAYER),COLDEN(NLAYER)
      COMMON /STRATO/ C2H2(NLAYER),C2H6(NLAYER)
C*
C NOW CALCULATE THE LAYER AVERAGE GAS MIXING RATIOS.
C OF THE ABSORBING GAS IN UNITS OF GRAMS PER GRAM
C AND THE TOTAL LAYER COLUMN MASS GRAMS CM-2.
      DO 159 J=1,NLAYER
      EMU=(XMU(J+1)+XMU(J))*0.5
c attention ici, Z en km doit etre passe en m
      COLDEN(J)=RHOP*(PRESS(J+1)-PRESS(J))/EFFG(Z(J)*1000.)
      GAS1(J)=(16./EMU)*AVERGE(CH4(J+1),CH4(J))
159   CONTINUE
C WE NOW ALSO CALCULTE THE MASS MIXING RATIOS OF THE
C STRATOSPHERIC GASES USED IN THE IR WITHIN EACH LAYER.
      J=1
      FC2H2=1.8E-6 ! NEW FROM ATHENA OLD= 2.E-6
      FC2H6=1.2E-5 ! NEW FORM ATHENA OLD= 2.E-5
      C2H2(J) = MIN(FC2H2,PC2H2(TEMP(J))/PRESS(J))
      C2H6(J) = MIN(FC2H6,PC2H6(TEMP(J))/PRESS(J))
      DO 101 J=2,NLAYER
      C2H2(J) = MIN(FC2H2,PC2H2(TEMP(J))/PRESS(J),C2H2(J-1))
      C2H6(J) = MIN(FC2H6,PC2H6(TEMP(J))/PRESS(J),C2H6(J-1))
101   CONTINUE
C NOW CONVERT TO MASS MIXING RATIO
      DO 102 J=1,NLAYER
      EMU=(XMU(J+1)+XMU(J))*0.5
      C2H2(J)=C2H2(J)*26.0/EMU
      C2H6(J)=C2H6(J)*30.0/EMU
102   CONTINUE
C
      IF (IPRINT .LT. 1) RETURN
      WRITE (6,9)
  9   FORMAT(///' ALT   CH4      C2H2        C2H6: MASS MIXING RATIOS')
      DO 103 J=1,NLAYER
      WRITE (6,*)Z(J),GAS1(J),C2H2(J),C2H6(J)
c     WRITE (6,10)Z(J),GAS1(J),C2H2(J),C2H6(J)
103   CONTINUE
 10   FORMAT(1X,F6.2,1P3E9.1)
      RETURN
      END
