      PROGRAM LAUN_SSO 
!$ use OMP_LIB

      use netcdf
      use flott_gwd_rando_m, only: flott_gwd_rando
      IMPLICIT none

!*********************************************************
!
!   1. DECLARATIONS
!
!*********************************************************


!   1.1) Physical parameters to be tuned plus vector and arrays needed in the ENKF+EM protocol
!************************************************************************************************  
!   
!function rgauss(xmea,xstd)
real :: rgauss,xgauss
real :: theta_func

!  Number of parameters too be tuned, Number of observations
     integer :: npar, nobs 
     integer :: ipar,jpar,kpar,iobs,jobs,kobs
!  Tuning parameters that will be changed randomly
      REAL :: RDISS , RUWMAX, RUWBAC,RSAT,DZ,XLAUNCH,KMIN,KMAX,CMAX,RUWSTD
!    common/flott_gwd/RDISS,RUWMAX,RUWBAC,RSAT,DZ,XLAUNCH,KMIN,KMAX,CMAX
!    NAMELIST /flott_gwd/RDISS,RUWMAX,RUWBAC,SAT,DZ,XLAUNCH,KMIN,KMAX,CMAX,RUWSTD

!  There are Nine possible parameters
     integer, parameter :: npartot=10
     integer :: iparyes(npartot),jparyes(npartot)
     character*4 :: charpar(npartot)
     character*10:: filepar
     character*3 :: ctype(3)
     real :: theta_proof(npartot),x_proof(npartot),theta_bound(npartot)



!  Now start the arrays needed for the ENKF+Estimation process
     
! Cholevsky stuff
      real, allocatable :: czz(:,:),cat(:,:),work(:),worky(:)
      integer, allocatable :: jpivxx(:),jpivyy(:)
      integer :: job,info
!  inversion stuff
      real :: rcond,fdet(2)
      integer, allocatable :: ipvt(:)
      real, allocatable :: zcond(:),workbis(:)
      integer, allocatable :: ipvtpar(:)
      real, allocatable :: zcondpar(:),workpar(:)
      real, allocatable :: cinvxx(:,:)
! Random parameters x 
      real, allocatable :: cbb(:,:) ! Covariance matrix for the initial values
      real, allocatable :: cqq(:,:) ! Covariance matrix for the random walk fo xana
      real, allocatable :: crt(:,:),crk(:,:)
      real trace,tracrr,tracyy,trackk,tracq,tracb,tracr
!  Time and ensemble size dependent stuff
      integer :: iens,ienkf
      integer :: nens,nenkf

      real, allocatable :: xblum(:),xbluv(:)   ! Parameter at t=1
      real, allocatable :: xblue(:,:)   ! Parameter at t=1
      real, allocatable :: xana(:,:,:)   ! (npar,ndaytot,nens) Analysis
      real, allocatable :: xfor(:,:,:)   ! (npar,ndaytot,nens) Forecast
      real, allocatable :: xsmo(:,:,:)   ! (npar,ndaytot,nens) Smoother
      real, allocatable :: xanam(:,:),xanav(:,:)   ! (npar,ndaytot)
      real, allocatable :: xform(:,:),xforv(:,:)   ! (npar,ndaytot)
      real, allocatable :: xsmom(:,:),xsmov(:,:)   ! (npar,ndaytot)
      real, allocatable :: theta(:,:,:)   ! Analysis of the physical parameter
      real, allocatable :: thetam(:,:),thetav(:,:)   ! (npar,ndaytot)
                                          
      real, allocatable ::  canaxx(:,:,:) !  Covariance matrix of the analysis 
      real, allocatable ::  cforxx(:,:,:) !  Covariance matrix of the Forecast 
      integer :: itemp
      real :: xtemp
! cxy cross-covariance matrix (npar,nobs,ndaytot)
      real, allocatable :: cxy(:,:,:)
! ckk kalman gain
      real, allocatable :: ckk(:,:,:)
! csmoxx kalman smoother
      real, allocatable :: csmoxx(:,:,:)
! cyy and crr error covariance matrix (nobs,nobs,ndaytot)
      real, allocatable :: cyy(:,:,:),crr(:,:,:)


!   1.2) NETCF load of ERA5+Balloon data, read once and placed in long vectors to 
!        speed-up multiple calculation done
!************************************************************************************************  
!NETCDF STUFF
      integer ncid,status,varid,dimid
       real, allocatable :: var1d(:),var2d(:,:),var3d(:,:,:)
      !NETCDF STUFF FOR OUTPUT FILE:
!     integer ncio
!FORMATTED I/O STUFF
      character*1 entete
      character*5 charprec
      character*4 scenario
      real amoins,aplus,bmoins,bplus
!LOOPS ON TIMES
      integer it,nit,iter,itdeb,itfin
      integer iday,jday,ihr,nday,ndaytot
      integer :: iav  !  Length of average (in number of hours)

! Balloon flight characteristic
      integer, parameter :: nballoon=24
      integer :: ibbeg(nballoon),ibend(nballoon),iballoon,iballev
      integer, allocatable :: nballev(:)
      integer :: ibalbeg,ibalend!,nballeff
      real    :: zball(nballoon)
      real, allocatable :: zbalt(:)     
! TMP files used to upload fast:
      real, allocatable :: xlontmp(:),ylattmp(:)
      real, allocatable :: zmeatmp(:),zstdtmp(:),zsigtmp(:)
      real, allocatable :: zgamtmp(:),zthetmp(:),zpictmp(:),zvaltmp(:)
      real, allocatable :: eastbal(:),westbal(:),prestmp(:)
      real, allocatable :: prectmp(:),lnsptmp(:)
      real, allocatable :: vitutmp(:,:),vitvtmp(:,:),temptmp(:,:)
      real, allocatable :: uav(:,:),vav(:,:),tav(:,:),pav(:,:)
      real, allocatable :: eastpre(:),westpre(:)
!  Esat & west (nobs=2) forecast, errors and observations (yobs is cosmetic)
      real, allocatable :: ypre(:,:,:),yprem(:,:),yprev(:,:)  ! Ensemble  Forecast, mean and var
      real, allocatable :: ysmo(:,:,:),ysmom(:,:),ysmov(:,:)  ! Ensemble Smoother, mean and var
      real, allocatable :: ypre_err(:,:,:),ypre_erm(:,:),ypre_erv(:,:) !  Ensemble Forecast error mean and var
      real, allocatable :: ysmo_err(:,:,:),ysmo_erm(:,:),ysmo_erv(:,:) !  Ensemble Forecast error mean and var
      real, allocatable :: ybal(:,:),ybalm(:),ysyn(:,:,:),yobs(:,:)
      real, parameter :: ysec=1.e-6  ! Security

!    1.3)   Variables associated with the parameterization scheme
!            (READ ON EXTERNAL FILES IN OFF-LINE CALL)
!**********************************************************

!=================================================================================
!
! klon----input-I-Total number of horizontal points that get into physics becomes number of time-steps average 
! klev----input-I-Number of vertical levels
! paprs---input-R-Pressure in semi-layers   (Pa)
! pplay---input-R-Pressure inside layers    (Pa)
! pphis---input-R-geopotential at the ground
! u-------input-R-Zonal velocity
! v-------input-R-Meridional velocity
! t-------input-R-Temperature (K)
! dtime---input-R-Time step of the physics
! zmea----input-R-Mean Orography (m)
! zstd----input-R-SSO standard deviation (m)
! zsig----input-R-SSO slope
! zgam----input-R-SSO Anisotropy
! zthe----input-R-SSO Angle
! zpic----input-R-SSO Peacks elevation (m)
! zval----input-R-SSO Valleys elevation (m)
! prec----input-R-Total precipitation kg/s/m^2
! zgpcp---input-R-GPCP Precipitations in mm/day, missing value -99999
!
!------------Modified quantities---------------------------
!
! zulow,zvlow -output-R: Low-level wind
! zustrdr,zvstrdr      : Surface stress due to SSO drag      (Pa)
! zustrli,zvstrli      : Surface stress due to MOUNTAIN LIFT (Pa)
!
! igwd--local-I: Total nb of points where the orography schemes are active
! itest-local-I: Flags to indicate active points
! idx---local-I: Locate the physical location of an active point.
!
!------------Issued from commons---------------------------
!
! iim--common-I: Number of longitude intervals
! jjm--common-I: Number of latitude intervals
! ideb-common-I: First longitude
! jdeb-common-I: First latitude
! klon-common-I: Number of points seen by the physics
!                (iim+1)*(jjm+1) for instance
! klev-common-I: Number of vertical layers
!======================================================================

include "dimensions.h" 
include "dimphy.h"    
include "YOEGWD.h"
      
! Those thinks are on the dynamical grid?

       integer ii,jj,ideb,jdeb
!      real xlon(iim),ylat(jjm)
!      real xx(iim),yy(jjm)
       real ap(llm),bp(llm),zlev(llm)


!     integer i,j,l,ll,index
      integer l,ll

!  This is for precips data retrieval

! TYPICALLY USED FOR THE OFFLINE VERSION ONLY
!     integer iplay(llm),zplay(llm)
!     character*12 input
!     character*25 filename

!  IMPUT DYNAMICAL FIELDS THAT SHOULD BE PROVIDED OBVIOUSLY
!  PLACED ON THE PHYSICAL GRID:

      integer level(klev)
      REAL paprs(klon,klev+1),pplay(klon,klev),psol(klon)    
      REAL u(klon,klev),v(klon,klev),t(klon,klev)
      REAL east_flott(klon,klev),west_flott(klon,klev)
      REAL rlat(klon)
! Precip 2D fields needed to compute GWs amplitudes
      real prec(klon)
! U,V,T TENDENCIES DUE TO convective GW DRAG and LIFT
      real d_u_lot(klon,klev), d_v_lot(klon,klev)
      real d_t_lot(klon,klev)
!  Surface stress due to Lott!
      real zustrlo(klon),zvstrlo(klon)
!     real bvlow(klon)

! TIME STEP OF THE PHYSICS, time of the data
!
      REAL dtime,tday
!     INTEGER itime
!
! SUBGRID-SCALE OROGRAPHY PARAMETERS
!
!     real zstd(klon),zsig(klon),zmea(klon)
!     real zgam(klon),zthe(klon)
!     real zpic(klon),zval(klon)

!
!    I.4)  Miscalleneous stuff
!**************************************************************

!  Logicals to control prints and nature of the analysis
!  (Proof of concept, log10, and with Max Likelihood estimates) 
      character*21 :: xmgfiles
      integer :: iproof,ilog10,ityp
      logical :: lproof, llog10
      logical, parameter :: ltalk=.false.
      integer :: ismoo,ilike,idete
      logical :: lsmoo,llike,ldete
      logical :: ltestsmo

      integer io,iu !  Input output files.

!  END OF DECLARATIONS
!************************************************************
!****************************************
!
!  2)  INITIALIZATIONS AND ALLOCATIONS
!
!****************************************

!  2.0) Loading the experiments characteristics
      read(*,*)nobs  !  Number of observations (East and West here)
      read(*,*)iav   !  Data averaged over iav hours
      print *,nobs,iav
      read(*,*)iparyes;print *,iparyes
      read(*,*)nens
      read(*,*)nenkf
      print *,'nens et nenkf:',nens,nenkf
      lproof=.false.;read(*,*)iproof;if(iproof.eq.1)lproof=.true.
      llog10=.false.;read(*,*)ilog10;if(ilog10.eq.1)llog10=.true.
      lsmoo=.false.;read(*,*)ismoo;if(ismoo.eq.1)lsmoo=.true.
      llike=.false.;read(*,*)ilike;if(ilike.eq.1)llike=.true.
      ldete=.false.;read(*,*)idete;if(idete.eq.1)ldete=.true.
      read(*,*)ibalbeg
      read(*,*)ibalend
      read(*,*)charprec
      read(*,*)scenario
      print*,'scenario=',scenario
      if(charprec.eq.'imerg')print *,'imerg',charprec
      if(charprec.eq.'era5')print *,'era5',charprec
      jparyes=0
      npar=0;do ipar=1,npartot;npar=npar+iparyes(ipar);if(iparyes(ipar).ne.0)jparyes(npar)=ipar;enddo
!     read(*,*)npar  !  Number of parameters to be tuned
      print *,npar
      print *,iparyes;print *,jparyes

!  2.1)  Basic arrays, independant of iteration
!  Parameter names for I/O and Proof of concepts (default?) values:

      ctype=(/'pre','ana','smo'/)
      charpar=(/'DISS','RUWM','RUWB','RSAT','DELZ','XLAU','KMIN','KMAX','CMAX','RUWS'/)
      theta_bound=(/5.,5.,10.,5.,10000.,1.,1.e-4,2.e-3,500.,10./)
      x_proof=(/-0.90,-1.175,-1.45,-0.83,-0.906,0.,-0.6,0.,-0.375,-0.594/)
!QBOi values
      print *,'scenario=',scenario
      if(scenario.eq.'QBOi')&
!  QBOi scenario wit Precips
!     x_proof=(/-0.90,-1.70,-1.45,-0.83,-0.906,0.,-0.6,0.,-0.375,-0.594/)
!  QBOi scenario without Precips
      x_proof=(/-0.90,-17.70,-1.45,-0.83,-0.906,0.,-0.6,0.,-0.375,-0.545/)
! Values yieldin minima in the cost function
      if(scenario.eq.'COST')&
       x_proof=(/-0.9,-1.296,-0.438,-1.076,-0.905,0.,-0.6,0.,0.088,-1.37/)
!  QBOi scenario with Precips only
!     x_proof=(/-0.90,-1.75,-1.45,-0.83,-0.906,0.,-0.6,0.,-0.375,-0.594/)
      if(scenario.eq.'RUWM')&
      x_proof=(/-0.90,-1.70,-10.5,-0.83,-0.906,0.,-0.6,0.,-0.375,-0.594/)
           RDISS  =theta_func(x_proof(1),theta_bound(1))
           RUWMAX =theta_func(x_proof(2),theta_bound(2))
           RUWBAC =theta_func(x_proof(3),theta_bound(3))
           RSAT   =theta_func(x_proof(4),theta_bound(4))
           DZ     =theta_func(x_proof(5),theta_bound(5))
           XLAUNCH=theta_func(x_proof(6),theta_bound(6))
           KMIN   =theta_func(x_proof(7),theta_bound(7))
           KMAX   =theta_func(x_proof(8),theta_bound(8))
           CMAX   =theta_func(x_proof(9),theta_bound(9))
           RUWSTD =theta_func(x_proof(10),theta_bound(10))

!  It is safer to load from the namelist:

!   OPEN(UNIT=33,FILE='laun_gwd_era5.nml',ACTION = 'READ',POSITION='REWIND')
!   READ(33,NML=flott_gwd)
!   CLOSE(33)

include "laun_gwd_era5.h" 

print 123,(charpar(ipar),ipar=1,npartot);123 format(3X,10(3x,a4,2x))    
print 124,RDISS,RUWMAX,RUWBAC,RSAT,DZ,XLAUNCH,KMIN,KMAX,CMAX,RUWSTD
124 format(3x,6(f8.3,1x),2(e8.2,1x),f8.3,1x,f8.3)
print 124,(theta_func(x_proof(ipar),theta_bound(ipar)),ipar=1,npartot)
open(53,file='tetha_func.dat')
write(53,225)'xx',(charpar(ipar),ipar=1,npartot);225 format(3X,11(3x,a4,2x))
do itemp=-999,999; xtemp=float(itemp)/500.
write(53,226)xtemp,(theta_func(xtemp,theta_bound(ipar)),ipar=1,npartot);enddo
226 format(1x,f8.4,3x,6(f8.3,1x),2(e8.2,1x),f8.3,1x,f8.3)

!  Balloons iteration start and  end,  and flight altitude      
      ibbeg=(/1,2566,5037,7465,9057,10975,12357,14352,16198,16228,16526,&
             17274,17985,19085,20225,21285,22576,24192,25103,25983,27207,&
             28908,30260,30893/)
      ibend=(/2565,5036,7464,9056,10974,12356,14351,16197,16227,16525,17273,&
              17984,19084,20224,21284,22575,24191,25102,25982,27206,28907,&
              30259,30892,31383/)
      zball=(/20.7,20.3,19.0,18.8,18.9,20.5,20.2,20.2,18.5,20.2,18.5,20.2,&
              18.5,18.5,18.5,20.3,20.3,18.6,18.6,20.5,20.4,18.6,18.5,18.58/)
!     ibalbeg=1; ibalend=2 !  First and last balloon that will be analysed

!  Allocate parameters and observation  arrays needed for the ENKF+Estimation process
     
     allocate(czz(npar,npar),cat(npar,npar),work(2*npar),jpivxx(npar))
     allocate(worky(2*nobs),jpivyy(nobs))
     allocate(ipvt(nobs),zcond(nobs),workbis(nobs),ipvtpar(npar),zcondpar(npar),workpar(npar))
     allocate(cinvxx(npar,npar),cbb(npar,npar),cqq(npar,npar),crt(nobs,nobs),crk(npar,nobs))

      if(iav.ne.klon)then; print *,'In DEVL to speed up iav=klon';
      print *,iav,klon;stop
      endif

!  THIS IS THE TIME-STEP THE PHYSICS SEE, NOT USED IN OFFLINE MODE
       DTIME=24.*3600.


!  2.2)  Loading the vertical levels, counting the number of iterations and days:
!
!****************************************************************************
!  Load the number of dates you want to proceed:
!  
      ideb=1 ; jdeb=1

!   Handle the vertical dimension of ERA5    
!   Read the ap and bp needed to calculate pressure from psol

       status = NF90_OPEN('VITU.nc',NF90_NOWRITE,ncid)
       status = NF90_INQ_VARID(ncid,'level',varid)
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
      status = NF90_INQ_DIMID(ncid,'level',dimid)
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
      status = NF90_INQUIRE_DIMENSION(ncid,dimid,len=ll)
      if(ll.ne.klev) then;print *,'pb z-dimension ERA5';stop;endif
      allocate(var3d(iim,jjm,llm))
      allocate(var1d(klev))
      status = &
              NF90_GET_VAR(ncid, varid, var1d, &
              start=(/1/),count=(/klev/))
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
      if(ltalk)print *,'klev=',klev
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
      level(:)=int(var1d(:));if(ltalk)print *,'level=',level
       open(30,file='data/era5_levels.txt')
       read(30,*)entete !; print *,entete
       do ll=1,klev;read(30,*)ii,amoins,bmoins;read(30,*)ii,aplus,bplus
       ap(klev+1-ll)=(amoins+aplus)/2.;bp(klev+1-ll)=(bmoins+bplus)/2.
       enddo
!      do ll=1,klev;if(ltalk)print *,'pf(',ll,')=',(ap(ll)+bp(ll)*101325)/100.;enddo
       do ll=1,klev;zlev(ll)=-7.*log(bp(ll)+ap(ll)/101325.);enddo
       close(30) 
       deallocate(var1d)
!  Temporal dimension of input:
       status = NF90_INQ_VARID(ncid,'time',varid)
       status = NF90_INQ_DIMID(ncid,'time',dimid)
       status = NF90_INQUIRE_DIMENSION(ncid,dimid,len=ll)
       allocate(var1d(ll))
       status = NF90_CLOSE(ncid)
!      if(ltalk)print *,'ll=',ll

!  Loop over balloons to detect balloon level:

do 222 iballoon=ibalbeg,ibalend  !! Begin loop on balloons..........

    Print *,'**************************'
    Print *,' Starting balloon:',iballoon
    Print *,'**************************'
    nit=ibend(iballoon)-ibbeg(iballoon)+1;ndaytot=0
    allocate(nballev(nit),zbalt(nit))
      iter=0
! do iballoon=ibalbeg,ibalend ; if(ltalk)print *,' Balloon:',iballoon
      itdeb=ibbeg(iballoon); itfin=ibend(iballoon)
        do ll=2,klev-1;if(zball(iballoon).ge.zlev(ll-1).and.zball(iballoon).lt.zlev(ll))iballev=ll;enddo
        if(iballev.le.2.or.iballev.ge.klev-1)stop
        if(ltalk)print *,'iballev=',iballev
      do it=itdeb,itfin
      iter=iter+1
      nballev(iter)=iballev;zbalt(iter)=zball(iballoon)
      enddo
      nday=(itfin-itdeb+1)/iav
      ndaytot=ndaytot+nday
! enddo
!     if(ltalk)print *,'Ndaytot:',ndaytot
!     if(ltalk)print *,'Nit:',nit,iter
!     print *,ibend(ibalend-1),ibbeg(ibalend)
!     if(ltalk)print *,'nballev:',nballev
!     stop
      

      allocate(theta(npar,ndaytot,nens))
      allocate(thetam(npar,ndaytot),thetav(npar,ndaytot))
      allocate(xfor(npar,ndaytot,nens))
      allocate(xform(npar,ndaytot),xforv(npar,ndaytot))
      allocate(xblue(npar,nens))
      allocate(xblum(npar),xbluv(npar))
      allocate(canaxx(npar,npar,ndaytot))
      allocate(cforxx(npar,npar,ndaytot))
      allocate(csmoxx(npar,npar,ndaytot))
      allocate(xana(npar,ndaytot,nens))
      allocate(xanam(npar,ndaytot),xanav(npar,ndaytot))
      allocate(xsmo(npar,ndaytot,nens))
      allocate(xsmom(npar,ndaytot),xsmov(npar,ndaytot))
      allocate(ypre(nobs,ndaytot,nens),ybal(nobs,ndaytot),yobs(nobs,ndaytot),ybalm(nobs))
      allocate(ysyn(nobs,ndaytot,nens))
      allocate(yprem(nobs,ndaytot),yprev(nobs,ndaytot))
      allocate(ysmo(nobs,ndaytot,nens),ysmom(nobs,ndaytot),ysmov(nobs,ndaytot))
      allocate(ypre_err(nobs,ndaytot,nens))
      allocate(ypre_erm(nobs,ndaytot),ypre_erv(nobs,ndaytot),crr(nobs,nobs,ndaytot))
      allocate(ysmo_err(nobs,ndaytot,nens))
      allocate(ysmo_erm(nobs,ndaytot),ysmo_erv(nobs,ndaytot))
      allocate(cxy(npar,nobs,ndaytot),cyy(nobs,nobs,ndaytot))
      allocate(ckk(npar,nobs,ndaytot))
      allocate(xlontmp(nit),ylattmp(nit))
      allocate(zmeatmp(nit),zstdtmp(nit),zsigtmp(nit))
      allocate(zgamtmp(nit),zthetmp(nit),zpictmp(nit),zvaltmp(nit))
!  Balloon data and prediction
      allocate(eastbal(nit),westbal(nit),prestmp(nit))
      allocate(eastpre(nit),westpre(nit))
      allocate(prectmp(nit),lnsptmp(nit))
      allocate(vitutmp(klev,nit),vitvtmp(klev,nit),temptmp(klev,nit))
      allocate(uav(klev,ndaytot),vav(klev,ndaytot),tav(klev,ndaytot),pav(klev,ndaytot))

!  2.3) Load the netcd data from all the balloon iterations
!
!*****************************************************************
      itdeb=ibbeg(iballoon);itfin=ibend(iballoon)

!  READ LOCATION AND SSO-PARAMETERS
         
      status = NF90_OPEN( &
      'sso_data.nc',NF90_NOWRITE,ncid)
      status = NF90_INQ_VARID(ncid,'longitude',varid)
      status = NF90_INQ_DIMID(ncid,'longitude',dimid)
      status = NF90_INQUIRE_DIMENSION(ncid,dimid,len=ii)
      if(iim.eq.1)ideb=(ii+1)/2
      if(ii.ne.iim.and.iim.ne.1) then;print *,'x-Dim SSOs wrong?';
      print *,ii,iim;endif
      status = &
        NF90_GET_VAR(ncid, varid, xlontmp,start=(/ideb,itdeb/),count=(/1,nit/), &
                     stride=(/1,1/))
             if(ltalk)print *,'xlontmp(',nit/2,'):',xlontmp(1),xlontmp(nit/2),xlontmp(nit),xlontmp(nit-2)

      status = NF90_INQ_VARID(ncid,'latitude',varid)
      status = NF90_INQ_DIMID(ncid,'latitude',dimid)
      status = NF90_INQUIRE_DIMENSION(ncid,dimid,len=jj)
      if(iim.eq.1)jdeb=(jj+1)/2
      if(jj.ne.jjm.and.jjm.ne.1) then;print *,'y-Dim SSOs wrong?'
       print *,jj,jjm;endif
      status = &
        NF90_GET_VAR(ncid, varid, ylattmp,start=(/jdeb,itdeb/),count=(/jjm,nit/), &
                     stride=(/1,1/))
             if(ltalk)print *,'ylattmp:',ylattmp(1),ylattmp(nit/2),ylattmp(nit)

      status = NF90_INQ_VARID(ncid,'zmea',varid)
      status = &
        NF90_GET_VAR(ncid, varid, zmeatmp,start=(/ideb,jdeb,itdeb/),count=(/iim,jjm,nit/), &
                     stride=(/1,1,1/))

       status = NF90_INQ_VARID(ncid,'zstd',varid)
      status = &
        NF90_GET_VAR(ncid, varid, zstdtmp,start=(/ideb,jdeb,itdeb/),count=(/iim,jjm,nit/), &
                     stride=(/1,1,1/))

       status = NF90_INQ_VARID(ncid,'zsig',varid)
      status = &
        NF90_GET_VAR(ncid, varid, zsigtmp,start=(/ideb,jdeb,itdeb/),count=(/iim,jjm,nit/), &
                     stride=(/1,1,1/))

       status = NF90_INQ_VARID(ncid,'zgam',varid)
      status = &
        NF90_GET_VAR(ncid, varid, zgamtmp,start=(/ideb,jdeb,itdeb/),count=(/iim,jjm,nit/), &
                     stride=(/1,1,1/))
       status = NF90_INQ_VARID(ncid,'zthe',varid)
      status = &
        NF90_GET_VAR(ncid, varid, zthetmp,start=(/ideb,jdeb,itdeb/),count=(/iim,jjm,nit/), &
                     stride=(/1,1,1/))

       status = NF90_INQ_VARID(ncid,'zpic',varid)
      status = &
        NF90_GET_VAR(ncid, varid, zpictmp,start=(/ideb,jdeb,itdeb/),count=(/iim,jjm,nit/), &
                     stride=(/1,1,1/))
       status = NF90_INQ_VARID(ncid,'zval',varid)
      status = &
        NF90_GET_VAR(ncid, varid, zvaltmp,start=(/ideb,jdeb,itdeb/),count=(/iim,jjm,nit/), &
                     stride=(/1,1,1/))
         status = NF90_CLOSE(ncid)

!        if(ltalk)print *,'zmea:',minval(zmeatmp),maxval(zmeatmp) 
!        if(ltalk)print *,'zstd:',minval(zstdtmp),maxval(zstdtmp) 
!        if(ltalk)print *,'zsig',minval(zsigtmp),maxval(zsigtmp) 
!        if(ltalk)print *,'zgam',minval(zgamtmp),maxval(zgamtmp) 
!        if(ltalk)print *,'zthe',minval(zthetmp),maxval(zthetmp) 
!        if(ltalk)print *,'zval',minval(zvaltmp),maxval(zvaltmp) 
!        if(ltalk)print *,'zpic',minval(zpictmp),maxval(zpictmp) 

! READ THE BAlloon data

        status = NF90_OPEN('Balloon.nc',NF90_NOWRITE,ncid)
      status = NF90_INQ_VARID(ncid,'qdm_u_east',varid)
      status = &
              NF90_GET_VAR(ncid, varid, eastbal, &
              start=(/itdeb/),count=(/nit/), &
               stride=(/1/))
       status = NF90_INQ_VARID(ncid,'qdm_u_west',varid)
      status = &
              NF90_GET_VAR(ncid, varid, westbal, &
              start=(/itdeb/),count=(/nit/), &
               stride=(/1/))
       status = NF90_INQ_VARID(ncid,'pressure',varid)
      status = &
              NF90_GET_VAR(ncid, varid, prestmp, &
              start=(/itdeb/),count=(/nit/), &
               stride=(/1/))
      status = NF90_CLOSE(ncid)
      if(ltalk)print *,'eastbal',minval(eastbal),maxval(eastbal) 
        if(ltalk)print *,'westbal',minval(westbal),maxval(westbal) 
        if(ltalk)print *,'prestmp',minval(prestmp),maxval(prestmp) 

! READ THE ERA5 PRECIPS DATAS:
     
      status = NF90_OPEN('PREC.nc',NF90_NOWRITE,ncid)

      if(status.ne.0)then;print *,'Error open data';stop;endif
! Precips:
      status = NF90_INQ_VARID(ncid,'tp',varid)
      status = &
              NF90_GET_VAR(ncid, varid, prectmp, &
              start=(/ideb,jdeb,itdeb/),count=(/iim,jjm,nit/), &
                     stride=(/1,1,1/))
!  In ERA5, precips are in meter accumulated over one hour:
       if(charprec.eq.'era5')prectmp(:)=prectmp(:)*1000./3600.
!  In imerg, precips are in mm accumulated over one hour:
       if(charprec.eq.'imerg')prectmp(:)=prectmp(:)/3600.
       if(ltalk)print *,'Error read data:',status
       if(ltalk)print *,'prec',minval(prectmp),maxval(prectmp) 
      status = NF90_CLOSE(ncid)

!  READ the ERA5 lnsp field

      status = NF90_OPEN('LNSP.nc',NF90_NOWRITE,ncid)
       status = NF90_INQ_VARID(ncid,'lnsp',varid)
        status = &
              NF90_GET_VAR(ncid, varid, lnsptmp, &
              start=(/ideb,jdeb,itdeb/),count=(/iim,jjm,nit/), &
              stride=(/1,1,1/))
      if(ltalk)print *,'Min and Max de lnsp:',minval(lnsptmp),maxval(lnsptmp)

      status = NF90_CLOSE(ncid)

!  READ the ERA5 VITU field

      status = NF90_OPEN('VITU.nc',NF90_NOWRITE,ncid)
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
       status = NF90_INQ_VARID(ncid,'vitu',varid)
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
        status = &
              NF90_GET_VAR(ncid, varid, vitutmp, &
              start=(/ideb,jdeb,1,itdeb/),count=(/iim,jjm,klev,nit/), &
              stride=(/1,1,1,1/))
      if(ltalk)print *,'Min and Max de vitutmp:',minval(vitutmp),maxval(vitutmp)
      status = NF90_CLOSE(ncid)

!  READ the ERA5 VITV field

      status = NF90_OPEN('VITV.nc',NF90_NOWRITE,ncid)
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
       status = NF90_INQ_VARID(ncid,'vitv',varid)
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
        status = &
              NF90_GET_VAR(ncid, varid, vitvtmp, &
              start=(/ideb,jdeb,1,itdeb/),count=(/iim,jjm,klev,nit/), &
              stride=(/1,1,1,1/))
      if(ltalk)print *,'Min and Max de vitvtmp:',minval(vitvtmp),maxval(vitvtmp)
      status = NF90_CLOSE(ncid)

!  READ the ERA5 TEMPERATURE field

      status = NF90_OPEN('TEMP.nc',NF90_NOWRITE,ncid)
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
       status = NF90_INQ_VARID(ncid,'temp',varid)
      if(status .ne. nf90_noerr) print *, trim(nf90_strerror(status))
        status = &
              NF90_GET_VAR(ncid, varid, temptmp, &
              start=(/ideb,jdeb,1,itdeb/),count=(/iim,jjm,klev,nit/), &
              stride=(/1,1,1,1/))
      if(ltalk)print *,'Min and Max de temptmp:',minval(temptmp),maxval(temptmp)
      status = NF90_CLOSE(ncid)

!   END of Loading data 
!  Reorganisation
      goto 673   !  No reorganisation (comment if you want reorganisation)
      iter=0
      do it=1,nit
         if(prectmp(it).gt.1.e-7)then
         iter=iter+1
         prectmp(iter)=prectmp(it);vitutmp(:,iter)=vitutmp(:,it)
         vitvtmp(:,iter)=vitvtmp(:,it);temptmp(:,iter)=temptmp(:,it)
         lnsptmp(iter)=lnsptmp(it);eastbal(iter)=eastbal(it)
         westbal(iter)=westbal(it);xlontmp(iter)=xlontmp(it)
         ylattmp(iter)=ylattmp(it); zmeatmp(iter)=zmeatmp(it)
         zstdtmp(iter)=zstdtmp(it);zsigtmp(iter)=zsigtmp(it)
        zgamtmp(iter)=zgamtmp(it);zthetmp(iter)=zthetmp(it)
        zpictmp(iter)=zpictmp(it);zvaltmp(iter)=zvaltmp(it)
         endif
      enddo
      nday=iter/iav;ndaytot=nday;goto 672
673   Continue
      if(ltalk)print *,'No Reorganisation'
      goto 671
672   Continue
      if(ltalk)print *,'No reorganisation'
671   Continue
!********************************************************
!cd ..
!   3)   ENKF WITH EM ESTIMATION STARTS
!
!********************************************************
!
!

      CALL SUGWD_strato(klon,klev,paprs,pplay)

!  Initialisation of x, random walk on x, and the error covariance matrix:

     ienkf=0;xblum(:)=0.

     if(lproof)then  
      cbb=0;do ipar=1,npar;cbb(ipar,ipar)=1.;enddo
      cqq=0;do ipar=1,npar;cqq(ipar,ipar)=.1;enddo
      crr=0.05;do iobs=1,nobs;crr(iobs,iobs,:)=0.1;enddo 
     else
      cbb=0;do ipar=1,npar;cbb(ipar,ipar)=.25;enddo
      cqq=0;do ipar=1,npar;cqq(ipar,ipar)=.005;enddo
      crr=0.1;do iobs=1,nobs;crr(iobs,iobs,:)=0.2;enddo    
     endif      

do while(ienkf.le.nenkf) !  Starts loop on ENKF+EM
      !print *,'Likelihood estimation at enkf  passage:',ienkf,'/',nenkf
      trace=0.;do ipar=1,npar;trace=trace+cbb(ipar,ipar);enddo
      !print *,'cbb:',trace
      tracb=trace
      if(trace.ge.100.) goto 953
      trace=0.;do ipar=1,npar;trace=trace+cqq(ipar,ipar);enddo
      !print *,'cqq:',trace
      tracq=trace
      if(trace.ge.100.) goto 953
      trace=0.;do iobs=1,nobs;do iday=1,ndaytot
      trace=trace+crr(iobs,iobs,iday)/float(ndaytot);enddo;enddo
      tracr=trace
      !print *,'crr:',trace
      if(trace.ge.100.) goto 953
      print *,'Passage:',ienkf,'/',nenkf,'Traces (B, Q, R)=',tracb,tracq,tracr

      if(ienkf.ge.1)then 
      crt=0.;do iday=1,ndaytot
      crt(:,:)=crt(:,:)+(crr(:,:,iday)+cyy(:,:,iday))/float(ndaytot);enddo
      call sgeco(crt,nobs,nobs,ipvt,rcond,zcond)
      call sgedi(crt,nobs,nobs,ipvt,fdet,workbis,11)
      trace=0.;do iobs=1,nobs;do jobs=1,nobs;do iday=1,ndaytot;do iens=1,nens
      trace=trace+crt(iobs,jobs)*(ypre(iobs,iday,iens)-ybal(iobs,iday)+ypre_err(iobs,iday,iens))&
                                *(ypre(jobs,iday,iens)-ybal(jobs,iday)+ypre_err(iobs,iday,iens))/float(nday)/float(nens)
      enddo;enddo;enddo;enddo
      trace=trace-0.5*log(fdet(1)*10**fdet(2))
      print *,'fdet and trace:',fdet(1)*10**fdet(2),exp(-trace)
      endif

      goto 952
953   continue
      print *,'************************'
      print *,'*     Divergence       *'
      print *,'************************'
      print *,'Passage:',ienkf,'/',nenkf,'Traces (B, Q, R)=',tracb,tracq,tracr
     stop
952   continue

!***********************
!  Begin loop on days  *
!***********************

      jday=0
      itdeb=ibbeg(iballoon);itfin=ibend(iballoon)
      nday=(itfin-itdeb+1)/iav

do iday=1,nday               ! Begin loop on days
           jday=jday+1

!        iens=1                    !  Starts Loop on ensemble

!  Load ERA datas every hour on a vector "iav" long before calling the subroutine
            uav(:,iday)=0. ; vav(:,iday)=0;tav(:,iday)=0.;pav(:,iday)=0.
            do ihr=1,iav ; iter=itdeb-ibbeg(iballoon)+(iday-1)*iav+ihr !  Loop on hours
            rlat(ihr)=ylattmp(iter)
            prec(ihr)=prectmp(iter)
            psol(ihr)=exp(lnsptmp(iter))
            do ll=1,klev;u(ihr,ll)=vitutmp(klev+1-ll,iter);enddo
            do ll=1,klev;v(ihr,ll)=vitvtmp(klev+1-ll,iter);enddo
            do ll=1,klev;t(ihr,ll)=temptmp(klev+1-ll,iter);enddo
            do ll=1,klev;uav(ll,iday)=uav(ll,iday)+vitutmp(klev+1-ll,iter)/float(iav);enddo
            do ll=1,klev;vav(ll,iday)=vav(ll,iday)+vitvtmp(klev+1-ll,iter)/float(iav);enddo
            do ll=1,klev;tav(ll,iday)=tav(ll,iday)+temptmp(klev+1-ll,iter)/float(iav);enddo
            enddo ! end loop on hours
! Pressure fields
            do ll=1,klev;pplay(:,ll)=ap(ll)+bp(ll)*psol(:);enddo
            do ihr=1,iav;do ll=1,klev
            pav(ll,iday)=pav(ll,iday)+pplay(ihr,ll)/float(iav);enddo;enddo
!  Pressure at 1/2 Levels:
            paprs(:,klev+1)=0.
            do ll=2,klev; paprs(:,ll)=0.5*(pplay(:,ll)+pplay(:,ll-1)); enddo
            paprs(:,1)=pplay(:,1)+0.5*(pplay(:,1)-pplay(:,2))
!  ERA5 data loaded

!  Non sequential ensemble loop
            if(jday.eq.1)then   !  !  First day, initialisation of x(1)
                 !  Cholesky decomposition of the Covariance matrix cbb
                 job=1;cat=0.
                 do ipar=1,npar;do jpar=ipar,npar
                 cat(ipar,jpar)=cbb(ipar,jpar);enddo;enddo
                 call schdc(cat,npar,npar,work,jpivxx,job,info)
  !  Producing ensemble of random parameters with cbb variance matrix
                 do iens=1,nens;xblue(:,iens)=xblum(:)
                 do ipar=1,npar;xgauss=rgauss(0.,1.);do jpar=1,npar
                 xblue(jpar,iens)=xblue(jpar,iens)+xgauss*cat(ipar,jpar)
                 enddo;enddo
                 xfor(:,1,iens)=xblue(:,iens);enddo
  !  Update physical parameters
            else  !  next days
                 job=1;cat=0.  !  Cholesky decomposition of the Covariance Matrix cqq
                 do ipar=1,npar;do jpar=ipar,npar
                 cat(ipar,jpar)=cqq(ipar,jpar);enddo;enddo
                 call schdc(cat,npar,npar,work,jpivxx,job,info)
                 do iens=1,nens
                 xfor(:,jday,iens)=xana(:,jday-1,iens)
                 do ipar=1,npar;xgauss=rgauss(0.,1.)
                 do jpar=1,npar
                 xfor(jpar,jday,iens)=xfor(jpar,jday,iens)&
                             +xgauss*cat(ipar,jpar)
                 enddo;enddo;enddo
            endif


!  Begin loop on the ensemble
!$OMP PARALLEL DO PRIVATE(KPAR,cat, &
!$OMP&       zustrlo,zvstrlo,d_u_lot,d_v_lot,d_t_lot,east_flott,west_flott, &
!$OMP&       iens,ipar,jpar,iter,ihr, &
!$OMP&       iballev,eastpre,westpre) &
!$OMP&       FIRSTPRIVATE(RDISS,RUWMAX, RUWBAC,RSAT,DZ,XLAUNCH,KMIN,KMAX,CMAX)
!$OMP&       SHARED(rlat,prec,psol,ll,l,u,v,t,pplay,paprs) 

  do iens=1,nens   

 
            d_u_lot=0; d_v_lot=0; d_t_lot=0; zustrlo=0; zvstrlo=0
            east_flott=0.;  west_flott=0.
  
!  Affecting values to the subroutine parameters: ARRET

           do ipar=1,npar; theta(ipar,jday,iens)=theta_func(xfor(ipar,jday,iens),theta_bound(jparyes(ipar)));enddo
           kpar=0 
           if(iparyes(1).eq.1)then;kpar=kpar+1;RDISS=theta(kpar,jday,iens);endif
           if(iparyes(2).eq.1)then;kpar=kpar+1;RUWMAX=theta(kpar,jday,iens);endif
           if(iparyes(3).eq.1)then;kpar=kpar+1;RUWBAC=theta(kpar,jday,iens);endif
           if(iparyes(4).eq.1)then;kpar=kpar+1;RSAT=theta(kpar,jday,iens);endif
           if(iparyes(5).eq.1)then;kpar=kpar+1;DZ=theta(kpar,jday,iens);endif
           if(iparyes(6).eq.1)then;kpar=kpar+1;XLAUNCH=theta(kpar,jday,iens);endif
           if(iparyes(7).eq.1)then;kpar=kpar+1;KMIN=theta(kpar,jday,iens);endif
           if(iparyes(8).eq.1)then;kpar=kpar+1;KMAX=theta(kpar,jday,iens);endif
           if(iparyes(9).eq.1)then;kpar=kpar+1;CMAX=theta(kpar,jday,iens);endif
!          print *,'thread=',omp_get_thread_num(),' for jday=',jday,iday,iballoon
!         print *,'thread=',omp_get_thread_num(),'jday=',jday,'xpar(1)',xfor(1,jday,iens) 
!          print *,'xfor(',iens,')',ruwbac,rsat
   
!print *,'THREAD_NUM in main',OMP_GET_THREAD_NUM()
           call flott_gwd_rando(dtime,pplay, &
                 t, u, v,prec, &
              RDISS , RUWMAX, RUWBAC,RSAT,DZ,XLAUNCH,KMIN,KMAX,CMAX,RUWSTD, &
                 zustrlo,zvstrlo, &
                 d_u_lot,d_v_lot,east_flott,west_flott)

           iter=itdeb-ibbeg(iballoon)+(iday-1)*iav+iav/2
           iballev=nballev(iter)
!          print *,iens,'west_flott:',west_flott(:,iballev)

!  Interpolation at balloon altitude:

!          print *,'iav=',iav
           do ihr=1,iav;iter=itdeb-ibbeg(iballoon)+(iday-1)*iav+ihr !  Loop on hours
           iballev=nballev(iter)
           eastpre(iter)=east_flott(ihr,iballev-1)+(east_flott(ihr,iballev)-east_flott(ihr,iballev-1)) &
                    *(zbalt(iter)-zlev(iballev-1))/(zlev(iballev)-zlev(iballev-1))
           westpre(iter)=west_flott(ihr,iballev-1)+(west_flott(ihr,iballev)-west_flott(ihr,iballev-1)) &
                    *(zbalt(iter)-zlev(iballev-1))/(zlev(iballev)-zlev(iballev-1))
           enddo
       if(isnan(eastpre(iter)))print *,'there is a Nan'
       if(isnan(westpre(iter)))print *,'there is a Nan'

!  Daily averages and mPa:

!    print *,'iav:',iav
          ypre(:,jday,iens)=0.        
          if(ilog10.ne.2)then
            do ihr=1,iav;iter=itdeb-ibbeg(iballoon)+(iday-1)*iav+ihr !  Loop on hours
            ypre(1,jday,iens)=ypre(1,jday,iens)+eastpre(iter)/float(iav)*1000.
            ypre(2,jday,iens)=ypre(2,jday,iens)-westpre(iter)/float(iav)*1000.
            enddo
          else
            do ihr=1,iav;iter=itdeb-ibbeg(iballoon)+(iday-1)*iav+ihr !  Loop on hours
            ypre(1,jday,iens)=ypre(1,jday,iens)+(eastpre(iter)-westpre(iter))/float(iav)*1000.
            ypre(2,jday,iens)=ypre(2,jday,iens)+(westpre(iter)+eastpre(iter))/float(iav)*1000.
            enddo
          endif
          if(ilog10.eq.1)ypre(:,jday,iens)=log10(ypre(:,jday,iens)+ysec)
          if(ilog10.eq.2)ypre(1,jday,iens)=log10(ypre(1,jday,iens)+ysec)
!  Synchronisation test
          ysyn(:,jday,iens)=0.;do ihr=1,iav
!         ysyn(1,jday,iens)=ysyn(1,jday,iens)+u(ihr,iballev-1)/float(iav)
          ysyn(:,jday,iens)=ysyn(:,jday,iens)+prec(ihr)/float(iav)
          enddo
!    print *,'E&W Daily:',ypre(1,jday,iens),ypre(2,jday,iens)


  enddo  !!  End loop on the ensemble
!$OMP END PARALLEL DO

!print *,'End of parallel loop:'
!      print *,'ypre:',(ypre(1,jday,iens),iens=1,nens)
!      print *,'ysyn:',(ysyn(1,jday,iens),iens=1,nens)
!      stop
     if(ltalk.and.mod(jday,100).eq.0)print *,'End of forecast loop day:',jday

!  Observations:
!    print *,'before loading balloon',iter,jday,iens
     if(ienkf.eq.0)then
     
!  Cosmetic storage of observations:
       yobs(:,jday)=0.;do ihr=1,iav;iter=itdeb-ibbeg(iballoon)+(iday-1)*iav+ihr !  Loop on hours
       yobs(1,jday)=yobs(1,jday)+eastbal(iter)/float(iav)*1000.
       yobs(2,jday)=yobs(2,jday)-westbal(iter)/float(iav)*1000.
       enddo                   

!  Proof of concept start here       
       if(lproof)then
            RDISS = theta_func(x_proof(1),theta_bound(1)); RUWMAX=theta_func(x_proof(2),theta_bound(2))
            RUWBAC= theta_func(x_proof(3),theta_bound(3));RSAT=theta_func(x_proof(4),theta_bound(4))
            DZ =theta_func(x_proof(5),theta_bound(5));  XLAUNCH=theta_func(x_proof(6),theta_bound(6))
            KMIN = theta_func(x_proof(7),theta_bound(7)); KMAX = theta_func(x_proof(8),theta_bound(8))
            CMAX = theta_func(x_proof(9),theta_bound(9))

            d_u_lot=0; d_v_lot=0; d_t_lot=0; zustrlo=0; zvstrlo=0
            east_flott=0.;  west_flott=0.
            call flott_gwd_rando(dtime,pplay, &
                 t, u, v,prec, &
                 RDISS , RUWMAX, RUWBAC,RSAT,DZ,XLAUNCH,KMIN,KMAX,CMAX,RUWSTD, &
                 zustrlo,zvstrlo, &
                 d_u_lot,d_v_lot,east_flott,west_flott)

!  Interpolation at balloon altitude:

            do ihr=1,iav;iter=itdeb-ibbeg(iballoon)+(iday-1)*iav+ihr !  Loop on hours
              iballev=nballev(iter)
              eastbal(iter)=east_flott(ihr,iballev-1)+(east_flott(ihr,iballev)-east_flott(ihr,iballev-1)) &
                   *(zbalt(iter)-zlev(iballev-1))/(zlev(iballev)-zlev(iballev-1))
              westbal(iter)=west_flott(ihr,iballev-1)+(west_flott(ihr,iballev)-west_flott(ihr,iballev-1)) &
                   *(zbalt(iter)-zlev(iballev-1))/(zlev(iballev)-zlev(iballev-1))
            enddo                  
        endif
!  End proof of concept case

        ybal(:,jday)=0.
        if(ilog10.ne.2)then
          do ihr=1,iav;iter=itdeb-ibbeg(iballoon)+(iday-1)*iav+ihr !  Loop on hours
          ybal(1,jday)=ybal(1,jday)+eastbal(iter)/float(iav)*1000.
          ybal(2,jday)=ybal(2,jday)-westbal(iter)/float(iav)*1000.
          enddo
        else
          do ihr=1,iav;iter=itdeb-ibbeg(iballoon)+(iday-1)*iav+ihr !  Loop on hours
          ybal(1,jday)=ybal(1,jday)+(eastbal(iter)-westbal(iter))/float(iav)*1000.
          ybal(2,jday)=ybal(2,jday)+(eastbal(iter)+westbal(iter))/float(iav)*1000.
          enddo
        endif

        if(ilog10.eq.1)ybal(:,jday)=log10(ybal(:,jday)+ysec)
        if(ilog10.eq.2)ybal(1,jday)=log10(ybal(1,jday)+ysec)
     endif

!     iens=iens+1 !end do ! end of loop on ensemble
!     if(iens.eq.nens+1)iter=iter+iav
!   end do  !  End loop on the ensemble

!    print *,'Target:',lproof,ybal(:,jday)

 

!------------------------------------------------
!    Analysis step, ensemble Kalman filter
!------------------------------------------------
     
     thetam(:,jday)=0.;thetav(:,jday)=0.
     xform(:,jday)=0.;yprem(:,jday)=0.;xforv(:,jday)=0.;yprev(:,jday)=0.
     thetam(:,jday)=0.;thetav(:,jday)=0.
     do iens=1,nens
     xform(:,jday)=xform(:,jday)+xfor(:,jday,iens)/float(nens)
     yprem(:,jday)=yprem(:,jday)+ypre(:,jday,iens)/float(nens)
     thetam(:,jday)=thetam(:,jday)+theta(:,jday,iens)/float(nens)
     enddo

     do iens=1,nens
     xforv(:,jday)=xforv(:,jday)+&
                  (xfor(:,jday,iens)-xform(:,jday))**2/float(nens-1)
     yprev(:,jday)=yprev(:,jday)+&
                  (ypre(:,jday,iens)-yprem(:,jday))**2/float(nens-1)
     thetav(:,jday)=thetav(:,jday)+&
                  (theta(:,jday,iens)-thetam(:,jday))**2/float(nens-1)
     enddo

     cxy(:,:,jday)=0.; do iens=1,nens;do ipar=1,npar; do iobs=1,nobs
     cxy(ipar,iobs,jday)=cxy(ipar,iobs,jday)+&
                         (xfor(ipar,jday,iens)-xform(ipar,jday))*&
                         (ypre(iobs,jday,iens)-yprem(iobs,jday))/float(nens-1)
     enddo;enddo;enddo
     cyy(:,:,jday)=0.; do iens=1,nens; do iobs=1,nobs; do jobs=1,nobs
     cyy(iobs,jobs,jday)=cyy(iobs,jobs,jday)+&
                         (ypre(iobs,jday,iens)-yprem(iobs,jday))*&
                         (ypre(jobs,jday,iens)-yprem(jobs,jday))/float(nens-1)
     enddo;enddo;enddo


!  Evaluate model errors covariance
!  Include Forecast Errors:
!
!     print *,' Old crr:',crr(:,:,jday)
      job=1;crt=0
      do iobs=1,nobs;do jobs=iobs,nobs
      crt(iobs,jobs)=crr(iobs,jobs,jday)+cyy(iobs,jobs,jday);enddo;enddo
!     print *,'avant Cholesky:',((crt(iobs,jobs),jobs=1,nobs),iobs=1,nobs)
      call schdc(crt,nobs,nobs,worky,jpivyy,job,info)
!     print *,'Apres Cholesky:',((crt(iobs,jobs),jobs=1,nobs),iobs=1,nobs)
      
      if(ldete)then
      ypre_err(:,jday,:)=0.
      else
      do iobs=1,nobs;do jobs=iobs,nobs
      crt(iobs,jobs)=crr(iobs,jobs,jday);enddo;enddo
      call schdc(crt,nobs,nobs,worky,jpivyy,job,info)
      ypre_err(:,jday,:)=0.
      do iens=1,nens;do iobs=1,nobs;xgauss=rgauss(0.,1.);do jobs=1,nobs
      ypre_err(jobs,jday,iens)=ypre_err(jobs,jday,iens)+xgauss*crt(iobs,jobs)
      enddo;enddo;enddo
      ypre_erm(:,jday)=0.;do iens=1,nens;ypre_erm(:,jday)=ypre_erm(:,jday)+&
                 ypre_err(:,jday,iens)/float(nens); enddo        
      ypre_erv(:,jday)=0.;do iens=1,nens;ypre_erv(:,jday)=ypre_erv(:,jday)+&
                 (ypre_err(:,jday,iens)-ypre_erm(:,jday))**2/float(nens-1); enddo        
      endif

!   Stabilisation 1, of the Error covariance matrics
!     crr(:,:,jday)=0.5*crr(:,:,jday)/2.;do iens=1,nens; do iobs=1,nobs; do jobs=1,nobs
!     crr(iobs,jobs,jday)=crr(iobs,jobs,jday)+0.5*&
!                        (yerr(iobs,jday,iens)-yerrm(iobs,jday))*&
!                        (yerr(jobs,jday,iens)-yerrm(jobs,jday))/float(nens-1)
!      enddo;enddo;enddo


!    print *,'yerrm:',yerrm(:,jday)
!    print *,' New crr:',crr(:,:,jday)

!    stop
!    print *,'cyy:',cyy(:,:,jday)
!  Deterministic Kalman Filter


!  Compute the Kalman gain:
     crt(:,:)=cyy(:,:,jday)+crr(:,:,jday)
!    print *,'crt:',crt
     call sgeco(crt,nobs,nobs,ipvt,rcond,zcond)
     call sgedi(crt,nobs,nobs,ipvt,fdet,workbis,11)
!    print *,'rcond:',rcond,' fdet:',fdet,'jday/ndaytot',jday,'/',ndaytot
!    print *,'Kalman step 1:',crt
     do ipar=1,npar;do iobs=1,nobs
     ckk(ipar,iobs,jday)=0.
     do jobs=1,nobs;ckk(ipar,iobs,jday)=ckk(ipar,iobs,jday) &
                   +cxy(ipar,jobs,jday)*crt(jobs,iobs)
     enddo;enddo;enddo
     tracyy=0.;do iobs=1,nobs;tracyy=tracyy+cyy(iobs,iobs,jday);enddo
     tracrr=0.;do iobs=1,nobs;tracrr=tracrr+crr(iobs,iobs,jday);enddo
     trackk=0.;do iobs=1,min(nobs,npar);trackk=trackk+ckk(iobs,iobs,jday);enddo
!    print *,'Kalman ckk:',rcond,((ckk(ipar,iobs,jday),iobs=1,nobs),ipar=1,npar)
!    print *,'Kalman crt:',rcond,((crt(iobs,jobs),iobs=1,nobs),jobs=1,nobs)
!    print *,'Kalman cxy:',rcond,((ckk(ipar,iobs,jday),iobs=1,nobs),ipar=1,npar)

! Compute the analysis:
!   print *,'Before Analysis:',ckk(:,:,jday)
!! Here are the forecast
     xana(:,jday,:)=xfor(:,jday,:)
! Here is  the analysis
     do ipar=1,npar
     do iobs=1,nobs
     xana(ipar,jday,:)=xana(ipar,jday,:)+ckk(ipar,iobs,jday)*&
                      (ybal(iobs,jday)-ypre(iobs,jday,:)+ypre_err(iobs,jday,:))
     enddo
!    xana(ipar,jday,:)=xana(ipar,jday,:)-0.01*xfor(ipar,jday,:)
     enddo

!  Mean and Std Dev:
     xanam(:,jday)=0.;xanav(:,jday)=0.
     do iens=1,nens
     xanam(:,jday)=xanam(:,jday)+xana(:,jday,iens)/float(nens)
     enddo
     do iens=1,nens
     xanav(:,jday)=xanav(:,jday)+&
                  (xana(:,jday,iens)-xanam(:,jday))**2/float(nens-1)
     enddo
     
   
      
enddo   !  END OF LOOP ON DAYS
!****************************************
!  End loop on days!
!****************************************
!      enddo   !  End of loop on balloons

!********************************************************
!  Begin the Kalman smoother
!*******************************************************

      if(lsmoo)then   !  With Kalman Smoother:

      trace=0.;do iobs=1,nobs;do iday=1,ndaytot;trace=trace+crr(iobs,iobs,iday)/float(ndaytot);enddo;enddo
         if(ltalk)print *,'crr before smoother:',trace
         if(ltalk)Print *,'Starting the Kalman Smoother:'
         do iday=1,ndaytot
         canaxx(:,:,iday)=0.;cforxx(:,:,iday)=0.
         do ipar=1,npar;do jpar=1,npar;do iens=1,nens
         canaxx(ipar,jpar,iday)=canaxx(ipar,jpar,iday)+&
                             (xana(ipar,iday,iens)-xanam(ipar,iday))*&
                             (xana(jpar,iday,iens)-xanam(jpar,iday))/&
                             float(nens-1)
         cforxx(ipar,jpar,iday)=cforxx(ipar,jpar,iday)+&
                             (xfor(ipar,iday,iens)-xform(ipar,iday))*&
                             (xfor(jpar,iday,iens)-xform(jpar,iday))/&
                             float(nens-1)
         enddo;enddo;enddo;enddo
         do iday=ndaytot-1,1,-1
         cinvxx(:,:)=cforxx(:,:,iday+1)
         call sgeco(cinvxx,npar,npar,ipvtpar,rcond,zcondpar)
         call sgedi(cinvxx,npar,npar,ipvtpar,fdet,workpar,11)
!        print *,' In Smmoother rcond and det:',rcond,fdet
         do ipar=1,npar;do jpar=1,npar
         csmoxx(ipar,jpar,iday)=0.; do kpar=1,npar
         csmoxx(ipar,jpar,iday)=csmoxx(ipar,jpar,iday)&
                               +canaxx(ipar,kpar,iday)*cinvxx(kpar,jpar)
         enddo;enddo;enddo;enddo
      
         xsmo(:,:,:)=xana(:,:,:)
         do iday=ndaytot-1,1,-1
         do ipar=1,npar;do jpar=1,npar
         xsmo(ipar,iday,:)=xsmo(ipar,iday,:)+csmoxx(ipar,jpar,iday+1)*&
                           (xsmo(jpar,iday+1,:)-xfor(jpar,iday+1,:))
         enddo;enddo
         enddo
     
     else  !  No smoother
        xsmo(:,:,:)=xana(:,:,:)
     endif !  End of Kalman Smoother

     ltestsmo=.false.
     do jday=1,ndaytot;do iens=1,nens;do ipar=1,npar
      if(isnan(xsmo(ipar,jday,iens)))ltestsmo=.true.
     enddo;enddo;enddo
     if(ltestsmo)then;xsmo=xana;print*,'  NO SMOOTHER ON Xs';endif

     do jday=1,ndaytot
     xsmom(:,jday)=0.;xsmov(:,jday)=0.
     do iens=1,nens
     xsmom(:,jday)=xsmom(:,jday)+xsmo(:,jday,iens)/float(nens)
     enddo
     do iens=1,nens
     xsmov(:,jday)=xsmov(:,jday)+&
                  (xsmo(:,jday,iens)-xsmom(:,jday))**2/float(nens-1)
     enddo
     enddo

     if(lsmoo)then
     do jday=1,ndaytot;do io=1,npar;iu=50+io-1
!     write(iu,*)jday+ienkf*ndaytot,xsmom(io,jday)-sqrt(xsmov(io,jday)),&
!     xsmom(io,jday),xsmom(io,jday)+sqrt(xsmov(io,jday)),&
!     xsmo(io,jday,nens/2)
      write(iu,*)jday+ienkf*ndaytot,(xsmo(io,jday,iens),iens=1,nens)
      write(iu+10,*)jday+ienkf*ndaytot,(xana(io,jday,iens),iens=1,nens)
      enddo;enddo
      endif

!-----------------------------------------------------------
!  Maximum likelihood estimate of the parameters statistics
!-----------------------------------------------------------
! No smoother:
     xblum(:)=xsmom(:,ndaytot);xblue(:,:)=xsmo(:,ndaytot,:)
if (ienkf.gt.0.and.lsmoo)then
     xblum(:)=xsmom(:,1);xblue(:,:)=xsmo(:,1,:)
   xblue(:,:)=0.;xblum(:)=0.
   do jday=1,ndaytot
   xblue(:,:)=xblue(:,:)+xsmo(:,jday,:)/float(ndaytot)
   xblum(:)=xblum(:)+xsmom(:,jday)/float(ndaytot)
   enddo
else
!Alternative:
   xblue(:,:)=0.;xblum(:)=0.
   do jday=1,ndaytot
   xblue(:,:)=xblue(:,:)+xsmo(:,jday,:)/float(ndaytot)
   xblum(:)=xblum(:)+xsmom(:,jday)/float(ndaytot)
   enddo
endif

if(lsmoo)then
     if(ltalk)print *,'Smoother used in the likelihood estimate:'
!--------------------------------------------------------------
! CRR needs forecast with the smoothed values of the parameters
!--------------------------------------------------------------

!------------Loop on Balloon and days------------------
     ysyn(:,:,:)=0.
     jday=0
!    do iballoon=ibalbeg,ibalend  ! Begin loop on balloon
!***************************
!  Begin loop on days
!***************************
     itdeb=ibbeg(iballoon);itfin=ibend(iballoon)
     nday=(itfin-itdeb+1)/iav

do iday=1,nday  !begin loop on days

       jday=jday+1

! Use the already read datas:
       do ihr=1,iav ; iter=itdeb-ibbeg(iballoon)+(iday-1)*iav+ihr !  Loop on hours
       rlat(ihr)=ylattmp(iter)
       prec(ihr)=prectmp(iter)
       psol(ihr)=exp(lnsptmp(iter))
       do ll=1,klev;u(ihr,ll)=vitutmp(klev+1-ll,iter);enddo
       do ll=1,klev;v(ihr,ll)=vitvtmp(klev+1-ll,iter);enddo
       do ll=1,klev;t(ihr,ll)=temptmp(klev+1-ll,iter);enddo
       enddo
! Pressure fields
       do ll=1,klev;pplay(:,ll)=ap(ll)+bp(ll)*psol(:);enddo
!  Pressure at 1/2 Levels:
       paprs(:,klev+1)=0.
       do l=2,klev; paprs(:,l)=0.5*(pplay(:,l)+pplay(:,l-1)); enddo
       paprs(:,1)=pplay(:,1)+0.5*(pplay(:,1)-pplay(:,2))
!ERA5 data loaded

!---------------------------------------------------------
!  Begin loop on the ensemble
!-----------------------------------
!     iens=1
!     do while(iens.le.nens)    !  Loop on the ensemble
!$OMP PARALLEL DO PRIVATE(KPAR,cat, &
!$OMP&       zustrlo,zvstrlo,d_u_lot,d_v_lot,d_t_lot,east_flott,west_flott, &
!$OMP&       iens,ipar,jpar,iter,ihr, &
!$OMP&       iballev,eastpre,westpre) &
!$OMP&       FIRSTPRIVATE(RDISS,RUWMAX, RUWBAC,RSAT,DZ,XLAUNCH,KMIN,KMAX,CMAX)
!$OMP&       SHARED(rlat,prec,psol,ll,l,u,v,t,pplay,paprs) 
  do iens=1,nens   
!---------------------------------------------------------
       d_u_lot=0.; d_v_lot=0.; d_t_lot=0.; zustrlo=0.; zvstrlo=0.;east_flott=0.;  west_flott=0.

!  Affecting values:

       do ipar=1,npar; theta(ipar,jday,iens)=theta_func(xsmo(ipar,jday,iens),theta_bound(jparyes(ipar)));enddo
       kpar=0 
       if(iparyes(1).eq.1)then;kpar=kpar+1;RDISS=theta(kpar,jday,iens);endif
       if(iparyes(2).eq.1)then;kpar=kpar+1;RUWMAX=theta(kpar,jday,iens);endif
       if(iparyes(3).eq.1)then;kpar=kpar+1;RUWBAC=theta(kpar,jday,iens);endif
       if(iparyes(4).eq.1)then;kpar=kpar+1;RSAT=theta(kpar,jday,iens);endif
       if(iparyes(5).eq.1)then;kpar=kpar+1;DZ=theta(kpar,jday,iens);endif
       if(iparyes(6).eq.1)then;kpar=kpar+1;XLAUNCH=theta(kpar,jday,iens);endif
       if(iparyes(7).eq.1)then;kpar=kpar+1;KMIN=theta(kpar,jday,iens);endif
       if(iparyes(8).eq.1)then;kpar=kpar+1;KMAX=theta(kpar,jday,iens);endif
       if(iparyes(9).eq.1)then;kpar=kpar+1;CMAX=theta(kpar,jday,iens);endif
       if(iparyes(10).eq.1)then;kpar=kpar+1;RUWSTD=theta(kpar,jday,iens);endif

 !        print *,'thread=',omp_get_thread_num(),'jday=',jday,'xsmo(1)',xsmo(1,jday,iens) 
 
           call flott_gwd_rando(dtime,pplay, &
                 t, u, v,prec, &
              RDISS , RUWMAX, RUWBAC,RSAT,DZ,XLAUNCH,KMIN,KMAX,CMAX,RUWSTD, &
                 zustrlo,zvstrlo, &
                 d_u_lot,d_v_lot,east_flott,west_flott)

!  Interpolation at balloon altitude:
       do ihr=1,iav;iter=itdeb-ibbeg(iballoon)+(iday-1)*iav+ihr !  Loop on hours
!         print *,'iter et itdeb',iter,itdeb
          iballev=nballev(iter)
          eastpre(iter)=east_flott(ihr,iballev-1)+(east_flott(ihr,iballev)-east_flott(ihr,iballev-1)) &
                   *(zbalt(iter)-zlev(iballev-1))/(zlev(iballev)-zlev(iballev-1))
          westpre(iter)=west_flott(ihr,iballev-1)+(west_flott(ihr,iballev)-west_flott(ihr,iballev-1)) &
                   *(zbalt(iter)-zlev(iballev-1))/(zlev(iballev)-zlev(iballev-1))
       enddo

       if(isnan(eastpre(iter)))print *,'there is a Nan'
       if(isnan(westpre(iter)))print *,'there is a Nan'

        ysmo(:,jday,iens)=0.        
        if(ilog10.ne.2)then
          do ihr=1,iav;iter=itdeb-ibbeg(iballoon)+(iday-1)*iav+ihr !  Loop on hours
          ysmo(1,jday,iens)=ysmo(1,jday,iens)+eastpre(iter)/float(iav)*1000.
          ysmo(2,jday,iens)=ysmo(2,jday,iens)-westpre(iter)/float(iav)*1000.
          enddo
        else
          do ihr=1,iav;iter=itdeb-ibbeg(iballoon)+(iday-1)*iav+ihr !  Loop on hours
          ysmo(1,jday,iens)=ysmo(1,jday,iens)+(eastpre(iter)-westpre(iter))/float(iav)*1000.
          ysmo(2,jday,iens)=ysmo(2,jday,iens)+(eastpre(iter)+westpre(iter))/float(iav)*1000.
          enddo
        endif
        if(ilog10.eq.1)ysmo(:,jday,iens)=log10(ysmo(:,jday,iens)+ysec)
        if(ilog10.eq.2)ysmo(1,jday,iens)=log10(ysmo(1,jday,iens)+ysec)
        if(isnan(ysmo(1,jday,iens)).or.isnan(ysmo(1,jday,iens)))print *,'there is a nan'
!  Synchronisation test
        ysyn(:,jday,iens)=0.;do ihr=1,iav
!       ysyn(1,jday,iens)=ysyn(1,jday,iens)+u(ihr,iballev-1)/float(iav)
!       ysyn(2,jday,iens)=ysyn(2,jday,iens)+prec(ihr)/float(iav)
        ysyn(:,jday,iens)=ysyn(:,jday,iens)+prec(ihr)/float(iav)
        enddo
!-----------------------------------------------
  enddo
!$OMP END PARALLEL DO
!       iens=iens+1
!       if(iens.eq.nens+1)iter=iter+iav
!     end do  !  End loop on the ensemble
!---------------------------------------------------
     if(ltalk.and.mod(jday,100).eq.0)print *,'End of estimation day:',jday
     
!    write(91,*)jday,ybal(1,jday),(ysyn(1,jday,iens),iens=1,nens)
!    write(92,*)jday,ybal(2,jday),(ysyn(2,jday,iens),iens=1,nens)
!    print *,'after smoother ysmo(',jday,')=',ysmo(1,jday,:)
!---------------   End loop on balloon and days ----------   
enddo          !  END OF LOOP ON DAYS
!************************
!  END OF LOOP ON DAYS
!************************
!    enddo          !  End of loop on balloons
!---------------------------------------------------------
else
     print *,'Smoother not used in the likelyhood estimate'
     ysmo(:,:,:)=ypre(:,:,:)
endif

     do ipar=1,npar;do jpar=1,npar;cbb(ipar,jpar)=0.
     do iens=1,nens
         cbb(ipar,jpar)=cbb(ipar,jpar)+ &
                  (xblue(ipar,iens)-xblum(ipar))*&
                  (xblue(jpar,iens)-xblum(jpar)) /float(nens-1)
     enddo;enddo;enddo


!  Erreur Covariance matrix
      do iobs=1,nobs;do iens=1,nens;do jday=1,ndaytot
            ysmo_err(iobs,jday,iens)=ybal(iobs,jday)-ysmo(iobs,jday,iens)
      enddo;enddo;enddo
      ysmo_erm(:,:)=0.;do iens=1,nens;ysmo_erm(:,:)=ysmo_erm(:,:)+&
      ysmo_err(:,:,iens)/float(nens); enddo        
      ysmo_erv(:,:)=0.;do iens=1,nens;ysmo_erv(:,:)=ysmo_erv(:,:)+&
                 (ysmo_err(:,:,iens)-ysmo_erm(:,:))**2/float(nens-1); enddo        
!
     if(llike)then

     do ipar=1,npar;do jpar=1,npar;cqq(ipar,jpar)=0.
     do iens=1,nens;do iday=2,ndaytot
          cqq(ipar,jpar)=cqq(ipar,jpar)+ &
                 (xsmo(ipar,iday,iens)-xsmo(ipar,iday-1,iens)&
                  -xsmom(ipar,iday)+xsmom(ipar,iday-1))*&
                 (xsmo(jpar,iday,iens)-xsmo(jpar,iday-1,iens)&
                  -xsmom(jpar,iday)+xsmom(ipar,jday-1))/float(nens-1)/float(ndaytot-1)
     enddo;enddo;enddo;enddo

      crr(:,:,:)=0.;crt=0.
       do jobs=1,nobs
       do iobs=1,nobs;do iens=1,nens;do jday=1,ndaytot
       crt(iobs,jobs)=crt(iobs,jobs)+&
!                     (ysmo_err(iobs,jday,iens)-ysmo_erm(iobs,jday))*&
!                     (ysmo_err(jobs,jday,iens)-ysmo_erm(jobs,jday))/float(nens-1)/float(ndaytot)
                      ysmo_err(iobs,jday,iens)*ysmo_err(jobs,jday,iens)/float(nens-1)/float(ndaytot)
       enddo;enddo;enddo
       enddo
      do iobs=1,nobs;do jobs=1,nobs
          crr(iobs,jobs,:)=crt(iobs,jobs)
       enddo;enddo

     else
       crt=0
       do jobs=1,nobs
       do iobs=1,nobs;do iens=1,nens;do jday=1,ndaytot
       crt(iobs,jobs)=crt(iobs,jobs)+&
                      (ypre_err(iobs,jday,iens)-ypre_erm(iobs,jday))*&
                      (ypre_err(jobs,jday,iens)-ypre_erm(jobs,jday))/float(nens-1)/float(ndaytot)
       enddo;enddo;enddo
       enddo

!  Many runs until v4 have this weird stuff that dos not help:
!      do iobs=1,nobs;crt(iobs,iobs)=crt(iobs,iobs)+0.2;enddo   !  Adding here an observational error on the Logs
! 

       trace=0.;do iobs=1,nobs;trace=trace+crt(iobs,iobs);enddo
       do iobs=1,nobs;do jobs=1,nobs
          crr(iobs,jobs,:)=crt(iobs,jobs)
       enddo;enddo
       print *,'What s up crr case of no-smooth?',crt
     call sgeco(crt,nobs,nobs,ipvt,rcond,zcond)
     call sgedi(crt,nobs,nobs,ipvt,fdet,workbis,11)
     print *,'rcond det and trace:',rcond,fdet,trace

     endif

! Print out des flux de moments

     ysmom(:,:)=0.; do iens=1,nens;ysmom(:,:)=ysmom(:,:)+ysmo(:,:,iens)/float(nens);enddo
     ysmov(:,:)=0.
     do iens=1,nens
        ysmov(:,:)=ysmov(:,:)+&
                (ysmo(:,:,iens)-ysmom(:,:))**2/float(nens-1)
     enddo


!  Open output files:

     if(lproof)then
        open(45,file='xmgr/verif_JGR24.dat',form='formatted')
    do jday=1,ndaytot
        write(45,*)jday,yobs(1,jday),-yobs(2,jday),ybal(1,jday),-ybal(2,jday),0.,0.
    enddo
        close(45)
     endif

filepar='          '
if(ienkf.lt.10.and.iballoon.lt.10)write(filepar,'(a1,i1,a1,i1,a4)'),'E',ienkf,'B',iballoon,'.dat'
if(ienkf.ge.10.and.iballoon.lt.10)write(filepar,'(a1,i2,a1,i1,a4)'),'E',ienkf,'B',iballoon,'.dat'
if(ienkf.lt.10.and.iballoon.ge.10)write(filepar,'(a1,i1,a1,i2,a4)'),'E',ienkf,'B',iballoon,'.dat'
if(ienkf.ge.10.and.iballoon.ge.10)write(filepar,'(a1,i2,a1,i2,a4)'),'E',ienkf,'B',iballoon,'.dat'
if(ltalk)print *,'filepar=',filepar

!  Open the xpars
iu=30;do ipar=1,npar;do ityp=1,3;iu=iu+1
write(xmgfiles,'(a6,a3,i1,a1,a10)')'xmgr/x',ctype(ityp),ipar,'_',filepar
open(iu,file=xmgfiles,form='formatted');enddo;enddo
! Open the tpars:
iu=50;do ipar=1,npar;do ityp=1,3;iu=iu+1
write(xmgfiles,'(a6,a3,i1,a1,a10)')'xmgr/t',ctype(ityp),ipar,'_',filepar
open(iu,file=xmgfiles,form='formatted');enddo;enddo
! Open the yvals:
iu=70
do ipar=1,nobs;do ityp=1,3,2;iu=iu+1
write(xmgfiles,'(a6,a3,i1,a1,a10)')'xmgr/y',ctype(ityp),ipar,'_',filepar
open(iu,file=xmgfiles,form='formatted');enddo;enddo
! Open the clim values
iu=80
do io=1,nobs; iu=iu+1
write(xmgfiles,'(a9,i1,a1,a10)')'xmgr/ysy_',io,'_',filepar
open(iu,file=xmgfiles,form='formatted');enddo

do jday=1,ndaytot
iday=ibbeg(iballoon)-ibbeg(ibalbeg)+jday*iav+ienkf*(ibend(ibalend)-ibbeg(ibalbeg)+1)
tday=float(iday)/float(ibend(ibalend)-ibbeg(ibalbeg)+1)
iday=ibbeg(iballoon)-1+jday*iav+ienkf*ibend(nballoon)
tday=float(iday)/float(ibend(nballoon))

iu=30;do io=1,npar;do ityp=1,3;iu=iu+1
if(ityp.eq.1)write(iu,'(6(1X,f20.12))')tday&
      ,xform(io,jday)&
      ,xform(io,jday)-2*sqrt(xforv(io,jday))&
      ,xform(io,jday)+2*sqrt(xforv(io,jday))&
      ,xfor(io,jday,nens/2),x_proof(ipar)
if(ityp.eq.2)write(iu,'(6(1X,f20.12))')tday&
      ,xanam(io,jday)&
      ,xanam(io,jday)-2*sqrt(xanav(io,jday))&
      ,xanam(io,jday)+2*sqrt(xanav(io,jday))&
      ,xana(io,jday,nens/2),x_proof(ipar)
if(ityp.eq.3)write(iu,'(6(1X,f20.12))')tday&
      ,xsmom(io,jday)&
      ,xsmom(io,jday)-2*sqrt(xsmov(io,jday))&
      ,xsmom(io,jday)+2*sqrt(xsmov(io,jday))&
      ,xsmo(io,jday,nens/2),x_proof(ipar)
enddo;enddo
iu=50;do io=1,npar;do ityp=1,3;iu=iu+1;ipar=jparyes(io)
if(ityp.eq.1)write(iu,'(6(1X,f20.12))')tday&
      ,theta_func(xform(io,jday),theta_bound(ipar))&
      ,theta_func(xform(io,jday)-2*sqrt(xforv(io,jday)),theta_bound(ipar))&
      ,theta_func(xform(io,jday)+2*sqrt(xforv(io,jday)),theta_bound(ipar))&
      ,theta_func(x_proof(ipar),theta_bound(ipar))
if(ityp.eq.2)write(iu,'(6(1X,f20.12))')tday&
      ,theta_func(xanam(io,jday),theta_bound(ipar))&
      ,theta_func(xanam(io,jday)-2*sqrt(xanav(io,jday)),theta_bound(ipar))&
      ,theta_func(xanam(io,jday)+2*sqrt(xanav(io,jday)),theta_bound(ipar))&
      ,theta_func(xana(io,jday,nens/2)+sqrt(xanav(io,jday)),theta_bound(ipar))&
      ,theta_func(x_proof(ipar),theta_bound(ipar))
if(ityp.eq.3)write(iu,'(6(1X,f20.12))')tday&
      ,theta_func(xsmom(io,jday),theta_bound(ipar))&
      ,theta_func(xsmom(io,jday)-2*sqrt(xsmov(io,jday)),theta_bound(ipar))&
      ,theta_func(xsmom(io,jday)+2*sqrt(xsmov(io,jday)),theta_bound(ipar))&
      ,theta_func(xsmo(io,jday,nens/2),theta_bound(ipar))&
      ,theta_func(x_proof(ipar),theta_bound(ipar))
enddo;enddo

  
if(ilog10.eq.0)then
  iu=70;do io=1,nobs;do ityp=1,3,2;iu=iu+1
  if(ityp.eq.1)  write(iu,'(6(1X,f20.12))')tday&
                ,-(-1)**io*yprem(io,jday)&
                ,-(-1)**io*yprem(io,jday)-2*sqrt(yprev(io,jday)+ypre_erv(io,jday))&
                ,-(-1)**io*yprem(io,jday)+2*sqrt(yprev(io,jday)+ypre_erv(io,jday))&
                ,-(-1)**io*ypre(io,jday,nens/2)&
                ,-(-1)**io*ybal(io,jday)
  if(ityp.eq.3)  write(iu,'(6(1X,f20.12))')tday&
                ,-(-1)**io*ysmom(io,jday)&
                ,-(-1)**io*ysmom(io,jday)-2*sqrt(ysmov(io,jday)+ysmo_erv(io,jday))&
                ,-(-1)**io*ysmom(io,jday)+2*sqrt(ysmov(io,jday)+ysmo_erv(io,jday))&
                ,-(-1)**io*ysmo(io,jday,nens/2)&
                ,-(-1)**io*ybal(io,jday)
  enddo;enddo
endif
if(ilog10.eq.1)then
  iu=70;do io=1,nobs;do ityp=1,3,2;iu=iu+1
  if(ityp.eq.1)  write(iu,'(6(1X,f20.12))')tday&
                ,10**(yprem(io,jday))&
                ,10**(yprem(io,jday)-2.*sqrt(yprev(io,jday)+ypre_erv(io,jday)))&
                ,10**(yprem(io,jday)+2.*sqrt(yprev(io,jday)+ypre_erv(io,jday)))&
                ,10**(ypre(io,jday,nens/2))&
                ,10**(ybal(io,jday))
  if(ityp.eq.3)  write(iu,'(6(1X,f20.12))')tday&
                ,-(-1)**io*10**(ysmom(io,jday))&
                ,-(-1)**io*10**(ysmom(io,jday)-2.*sqrt(ysmov(io,jday)+ysmo_erv(io,jday)))&
                ,-(-1)**io*10**(ysmom(io,jday)+2.*sqrt(ysmov(io,jday)+ysmo_erv(io,jday)))&
                ,-(-1)**io*10**(ysmo(io,jday,nens/2))&
                ,-(-1)**io*10**(ybal(io,jday))
  enddo;enddo
endif
if(ilog10.eq.2)then
  iu=70; io=1;do ityp=1,3,2;iu=iu+1
  if(ityp.eq.1)  write(iu,'(6(1X,f20.12))')tday,10**(yprem(io,jday))&
                ,10**(yprem(io,jday)-2.*sqrt(yprev(io,jday)+ypre_erv(io,jday)))&
                ,10**(yprem(io,jday)+2.*sqrt(yprev(io,jday)+ypre_erv(io,jday)))&
                ,10**(ypre(io,jday,nens/2)),10**(ybal(io,jday))
  if(ityp.eq.3)  write(iu,'(6(1X,f20.12))')tday,10**(ysmom(io,jday))&
                ,10**(ysmom(io,jday)-2.*sqrt(ysmov(io,jday)+ysmo_erv(io,jday)))&
                ,10**(ysmom(io,jday)+2.*sqrt(ysmov(io,jday)+ysmo_erv(io,jday)))&
                ,10**(ysmo(io,jday,nens/2)),10**(ybal(io,jday))
  enddo
  io=2
  do ityp=1,3,2;iu=iu+1
  if(ityp.eq.1)  write(iu,'(6(1X,f20.12))')tday,yprem(io,jday)&
                ,yprem(io,jday)-2.*sqrt(yprev(io,jday)+ypre_erv(io,jday))&
                ,yprem(io,jday)+2.*sqrt(yprev(io,jday)+ypre_erv(io,jday))&
                ,ypre(io,jday,nens/2),ybal(io,jday)
  if(ityp.eq.3)  write(iu,'(6(1X,f20.12))')tday,ysmom(io,jday)&
                ,ysmom(io,jday)-2.*sqrt(ysmov(io,jday)+ysmo_erv(io,jday))&
                ,ysmom(io,jday)+2.*sqrt(ysmov(io,jday)+ysmo_erv(io,jday))&
                ,ysmo(io,jday,nens/2),ybal(io,jday)
  enddo
endif

iu=80; do io=1,nobs; iu=iu+1
write(iu,'(6(1X,f20.12))')tday,yobs(1,jday),yobs(2,jday)&
               ,ysyn(io,jday,1)&
               ,ysyn(io,jday,nens/2),ysyn(io,jday,nens);enddo
enddo     


iu=30;do io=1,npar;do ityp=1,3;iu=iu+1;close(iu);enddo;enddo
iu=50;do io=1,npar;do ityp=1,3;iu=iu+1;close(iu);enddo;enddo
iu=70;do io=1,nobs;do ityp=1,3,2;iu=iu+1;close(iu);enddo;enddo

!  Store the daily files
     if(ienkf.eq.nenkf)then
     write(xmgfiles,'(a11,a10)')'xmgr/profs_',filepar
     print *,'Store the daily files in: ',xmgfiles
      open(58,file=xmgfiles); write(58,*)ndaytot,klev
      do iday=1,ndaytot; do ll=1,klev
            write(58,'(4(1X,f20.12))')pav(ll,iday),uav(ll,iday),vav(ll,iday),tav(ll,iday)
         enddo; enddo
      close(58)
      endif

!  Storage of the ensembles:

if(ienkf.eq.nenkf)then

if(ilog10.eq.1)ysmo(:,:,:)=10**ysmo(:,:,:)
if(ilog10.eq.2)ysmo(1,:,:)=10**ysmo(1,:,:)
if(ilog10.eq.1)ypre(:,:,:)=10**ypre(:,:,:)
if(ilog10.eq.2)ypre(1,:,:)=10**ypre(1,:,:)

! Momentum Fluxes:

  do iens=1,nens
  write(xmgfiles,'(a10,i3.3,a2,i2.2,a4)')'xmgr/ypr_M',iens,'_B',iballoon,'.dat'
  open(37,file=xmgfiles)
  do jday=1,ndaytot
  iday=ibbeg(iballoon)-1+jday*iav+ienkf*ibend(nballoon)
  tday=float(iday)/float(ibend(nballoon))
  write(37,'(3(1X,f20.12))'),tday,ypre(1,jday,iens),ypre(2,jday,iens)
  enddo;close(37);enddo

  do iens=1,nens
  write(xmgfiles,'(a10,i3.3,a2,i2.2,a4)')'xmgr/ysm_M',iens,'_B',iballoon,'.dat'
  open(37,file=xmgfiles)
  do jday=1,ndaytot
  iday=ibbeg(iballoon)-1+jday*iav+ienkf*ibend(nballoon)
  tday=float(iday)/float(ibend(nballoon))
  write(37,'(3(1X,f20.12))'),tday,ysmo(1,jday,iens),ysmo(2,jday,iens)
  enddo;close(37);enddo

! Parameters:

  do iens=1,nens
  write(xmgfiles,'(a10,i3.3,a2,i2.2,a4)')'xmgr/tpr_M',iens,'_B',iballoon,'.dat'
  open(37,file=xmgfiles)
  do jday=1,ndaytot
  iday=ibbeg(iballoon)-1+jday*iav+ienkf*ibend(nballoon)
  tday=float(iday)/float(ibend(nballoon))
  if(npar.eq.2)&
  write(37,'(4(1X,f20.12))'),tday,(theta_func(xfor(ipar,jday,iens),theta_bound(jparyes(ipar))),ipar=1,npar)
  if(npar.eq.3)&
  write(37,'(5(1X,f20.12))'),tday,(theta_func(xfor(ipar,jday,iens),theta_bound(jparyes(ipar))),ipar=1,npar)
  enddo;close(37);enddo

  do iens=1,nens
  write(xmgfiles,'(a10,i3.3,a2,i2.2,a4)')'xmgr/tsm_M',iens,'_B',iballoon,'.dat'
  open(37,file=xmgfiles)
  do jday=1,ndaytot
  iday=ibbeg(iballoon)-1+jday*iav+ienkf*ibend(nballoon)
  tday=float(iday)/float(ibend(nballoon))
  if(npar.eq.2)&
  write(37,'(4(1X,f20.12))'),tday,(theta_func(xsmo(ipar,jday,iens),theta_bound(jparyes(ipar))),ipar=1,npar)
  if(npar.eq.3)&
  write(37,'(5(1X,f20.12))'),tday,(theta_func(xsmo(ipar,jday,iens),theta_bound(jparyes(ipar))),ipar=1,npar)
  enddo;close(37);enddo


endif

!  End of ensemble storage

      ienkf=ienkf+1

end do   !  End loop on the sequence of DEVL-EM



     
      deallocate(nballev,zbalt)
      deallocate(theta)
      deallocate(thetam,thetav)
      deallocate(xfor)
      deallocate(xform,xforv)
      deallocate(xblue)
      deallocate(xblum,xbluv)
      deallocate(canaxx)
      deallocate(cforxx)
      deallocate(csmoxx)
      deallocate(xana)
      deallocate(xanam,xanav)
      deallocate(xsmo)
      deallocate(xsmom,xsmov)
      deallocate(ypre,ybal,yobs,ybalm)
      deallocate(ysyn)
      deallocate(yprem,yprev)
      deallocate(ysmo,ysmom,ysmov)
      deallocate(ypre_err)
      deallocate(ypre_erm,ypre_erv,crr)
      deallocate(ysmo_err)
      deallocate(ysmo_erm,ysmo_erv)
      deallocate(cxy,cyy)
      deallocate(ckk)
      deallocate(xlontmp,ylattmp)
      deallocate(zmeatmp,zstdtmp,zsigtmp)
      deallocate(zgamtmp,zthetmp,zpictmp,zvaltmp)
!  Balloon data and prediction
      deallocate(eastbal,westbal,prestmp)
      deallocate(eastpre,westpre)
      deallocate(prectmp,lnsptmp)
      deallocate(vitutmp,vitvtmp,temptmp)
      deallocate(uav,vav,tav)

222   Continue !  End loop on Balloons!

     print *,'C est fini....'

        END
        function theta_func(x,thetas)
        implicit none
        real :: theta_func,x,thetas
        theta_func=thetas*(1.+erf(x))/2.  ! ruwmax
        return
        end
