SUBROUTINE sugwd_strato(nlon, nlev, paprs, pplay)


  ! **** *SUGWD* INITIALIZE COMMON YOEGWD CONTROLLING GRAVITY WAVE DRAG

  ! PURPOSE.
  ! --------
  ! INITIALIZE YOEGWD, THE COMMON THAT CONTROLS THE
  ! GRAVITY WAVE DRAG PARAMETRIZATION.
  ! VERY IMPORTANT:
  ! ______________
  ! THIS ROUTINE SET_UP THE "TUNABLE PARAMETERS" OF THE
  ! VARIOUS SSO SCHEMES

  ! **   INTERFACE.
  ! ----------
  ! CALL *SUGWD* FROM *SUPHEC*
  ! -----        ------

  ! EXPLICIT ARGUMENTS :
  ! --------------------
  ! PAPRS,PPLAY : Pressure at semi and full model levels
  ! NLEV        : number of model levels
  ! NLON        : number of points treated in the physics

  ! IMPLICIT ARGUMENTS :
  ! --------------------
  ! COMMON YOEGWD
  ! -GFRCRIT-R:  Critical Non-dimensional mountain Height
  ! (HNC in (1),    LOTT 1999)
  ! -GKWAKE--R:  Bluff-body drag coefficient for low level wake
  ! (Cd in (2),     LOTT 1999)
  ! -GRCRIT--R:  Critical Richardson Number
  ! (Ric, End of first column p791 of LOTT 1999)
  ! -GKDRAG--R:  Gravity wave drag coefficient
  ! (G in (3),      LOTT 1999)
  ! -GKLIFT--R:  Mountain Lift coefficient
  ! (Cl in (4),     LOTT 1999)
  ! -GHMAX---R:  Not used
  ! -GRAHILO-R:  Set-up the trapped waves fraction
  ! (Beta , End of first column,  LOTT 1999)

  ! -GSIGCR--R:  Security value for blocked flow depth
  ! -NKTOPG--I:  Security value for blocked flow level
  ! -nstra----I:  An estimate to qualify the upper levels of
  ! the model where one wants to impose strees
  ! profiles
  ! -GSSECC--R:  Security min value for low-level B-V frequency
  ! -GTSEC---R:  Security min value for anisotropy and GW stress.
  ! -GVSEC---R:  Security min value for ulow


  ! METHOD.
  ! -------
  ! SEE DOCUMENTATION

  ! EXTERNALS.
  ! ----------
  ! NONE

  ! REFERENCE.
  ! ----------
  ! Lott, 1999: Alleviation of stationary biases in a GCM through...
  ! Monthly Weather Review, 127, pp 788-801.

  ! AUTHOR.
  ! -------
  ! FRANCOIS LOTT        *LMD*

  ! MODIFICATIONS.
  ! --------------
  ! ORIGINAL : 90-01-01 (MARTIN MILLER, ECMWF)
  ! LAST:  99-07-09     (FRANCOIS LOTT,LMD)
  ! ------------------------------------------------------------------
  ! OFFLINE
  ! USE dimphy
  !  USE mod_phys_lmdz_para
  !  USE mod_grid_phy_lmdz
  !  USE geometry_mod
  IMPLICIT NONE

  ! -----------------------------------------------------------------
  include "YOEGWD.h"
  ! ----------------------------------------------------------------

  ! ARGUMENTS
  INTEGER nlon, nlev
  REAL paprs(nlon, nlev+1)
  REAL pplay(nlon, nlev)

  INTEGER jk
  REAL zpr, ztop, zsigt, zpm1r
!online?
!  INTEGER :: cell,ij,nstra_tmp,nktopg_tmp
! REAL :: current_dist, dist_min,dist_min_glo

  ! *       1.    SET THE VALUES OF THE PARAMETERS
  ! --------------------------------


  ghmax = 10000.

  zpr = 100000.
  ZTOP=0.00005
  zsigt = 0.94
  ! old  ZPR=80000.
  ! old  ZSIGT=0.85


!ON line
!!ym Take the point at equator close to (0,0) coordinates.
!  dist_min=360
!  dist_min_glo=360.
!  cell=-1
!  DO ij=1,klon
!    current_dist=sqrt(longitude_deg(ij)**2+latitude_deg(ij)**2)
!    current_dist=current_dist*(1+(1e-10*ind_cell_glo(ij))/klon_glo) ! For point unicity
!    IF (dist_min>current_dist) THEN
!      dist_min=current_dist
!      cell=ij    
!    ENDIF  
!  ENDDO
  
!  !PRINT *, 'SUGWD distmin cell=', dist_min,cell
!  CALL reduce_min(dist_min,dist_min_glo)
!  CALL bcast(dist_min_glo)
!  IF (dist_min/=dist_min_glo) cell=-1
!!ym in future find the point at equator close to (0,0) coordinates.
!  PRINT *, 'SUGWD distmin dist_min_glo cell=', dist_min,dist_min_glo,cell

!  nktopg_tmp=nktopg
!  nstra_tmp=nstra
  
!  IF (cell/=-1) THEN

!    !print*,'SUGWD shape ',shape(pplay),cell+1

!    DO jk = 1, nlev
!      !zpm1r = pplay(cell+1, jk)/paprs(cell+1, 1)
!      zpm1r = pplay(cell, jk)/paprs(cell, 1)
!      IF (zpm1r>=zsigt) THEN
!        nktopg_tmp = jk
!      END IF
!      IF (zpm1r>=ztop) THEN
!        nstra_tmp = jk
!      END IF
!    END DO
!  ELSE
!    nktopg_tmp=0
!!    nstra_tmp=0
!  ENDIF
  
!  CALL reduce_sum(nktopg_tmp,nktopg)
!  CALL bcast(nktopg)
!  CALL reduce_sum(nstra_tmp,nstra)
!  CALL bcast(nstra)
! 
!  OFFLINE:
DO jk = 1, nlev
      !zpm1r = pplay(cell+1, jk)/paprs(cell+1, 1)
       zpm1r = pplay((nlon+1)/2, jk)/paprs((nlon+1)/2, 1)
       IF (zpm1r>=zsigt) THEN
         nktopg = jk
       END IF
       IF (zpm1r>=ztop) THEN
         nstra = jk
       END IF
     END DO

  
  ! inversion car dans orodrag on compte les niveaux a l'envers
  nktopg = nlev - nktopg + 1
  nstra = nlev - nstra
!  if (nstra == 0) call abort_physic("sugwd_strato", "no level in stratosphere", 1)

!  Valeurs lues dans les .def, ou attribues dans conf_phys
  !gkdrag = 0.2   
  !grahilo = 0.1
  !grcrit = 1.00
  !gfrcrit = 0.70
  !gkwake = 0.40
  !gklift = 0.25

 
  gkdrag  = 0.2
  grahilo = 0.1
  grcrit  = 1.00
  gfrcrit = 1.00
  gsigcr  = 0.80 ! Top of low level flow
  gvcrit  = 0.1
  gkwake = 0.40
  gklift = 0.25


!  PRINT *, ' DANS SUGWD NLEV=', nlev
!  PRINT *, ' DANS SUGWD nktopg=', nktopg
!  PRINT *, ' DANS SUGWD nstra=', nstra
! WRITE (UNIT=6, FMT='('' *** SSO essential constants ***'')')
! WRITE (UNIT=6, FMT='('' *** SPECIFIED IN SUGWD ***'')')
! WRITE (UNIT=6, FMT='('' Gravity wave ct '',E13.7,'' '')') gkdrag
! WRITE (UNIT=6, FMT='('' Trapped/total wave dag '',E13.7,'' '')') grahilo
! WRITE (UNIT=6, FMT='('' Critical Richardson   = '',E13.7,'' '')') grcrit
! WRITE (UNIT=6, FMT='('' Critical Froude'',e13.7)') gfrcrit
! WRITE (UNIT=6, FMT='('' Low level Wake bluff cte'',e13.7)') gkwake
! WRITE (UNIT=6, FMT='('' Low level lift  cte'',e13.7)') gklift

  ! ----------------------------------------------------------------

  ! *       2.    SET VALUES OF SECURITY PARAMETERS
  ! ---------------------------------


  gvsec = 0.10
  gssec = 0.0001

  gtsec = 0.00001

! ONLY OFF-LINE

!       3.    SOME PHYSICAL CONSTANTS
!             -----------------------

          RPI=ACOS(-1.)
!  GRAVITY
          RG=9.80665
!  EARTH ROTATION
          ROMEGA=0.7292115E-04
!  CP DRY GAS
          RCPD=0.1004709E+04
!  DRY AIR CONSTANT
          RD=0.2870597E+03
!  Latent Heat of vaporization at 0°C
          RLVTT=2.5008E+6


!WRITE(UNIT=6,FMT='('' *** Fundamental constants ***'')')
!WRITE(UNIT=6,FMT='('' *** SPECIFIED IN SUGWD ***'')')
!WRITE(UNIT=6,FMT='(''           PI = '',E13.7,'' -'')')RPI
!WRITE(UNIT=6,FMT='(''      Gravity = '',E13.7,'' m s-2'')')rg
!WRITE(UNIT=6,FMT='(''        omega = '',E13.7,'' s-1'')')romega
!WRITE(UNIT=6,FMT='(''         Cpd  = '',e13.7)') RCPD
!WRITE(UNIT=6,FMT='('' Dry air cst. = '',e13.7)') RD
!WRITE(UNIT=6,FMT='(''Lat. Heat Vap = '',e13.7)') RLVTT

  RETURN
END SUBROUTINE sugwd_strato
