#!/bin/bash
istri=1   # Jumps in latitude and longitude (stride)
IIM=1
JJM=1
STORE=1        # Storage?
IAV=24         # Number of hours to average
LOG10=1        # 1: log 10 of fluxes taken
prec=era5      #  imerg ou era5: origin of precipitation.
wavs=1hrs15min # 1hrs15min or 1day15min
#nstart=([1]=1 2566 5037 7465 9057 10975 12970 14352)
#nstop=([1]=2565 5036 7464 9056 10974 12969 14351 16197)
scenario=OPTIM  # CMIP7 values or OPTIM (Control or Optimized)
version=FIX


Ninput=../hourly_1deg_ph1_ph2
Nprog=../prog_v4
Ndivr=../divr_v4
XMdir=../xmgr_v4/One_Launch_${scenario}_${version}
mkdir -p $XMdir


cat << EOF1 > dimensions.h
       INTEGER iim,jjm,llm,ndm,nqmx
       PARAMETER (iim=${IIM},jjm=${JJM},llm=69,ndm=1,nqmx=2)
EOF1

if [ "$scenario" = "CMIP7" ]; then
cat <<EOF3 > laun_gwd_era5.nml
&flott_gwd
  RDISS = 0.5,
  RUWMAX= 0.250,
  RUWBAC= 0.000,
  SAT= 0.6,
  DZ =1000.,
  XLAUNCH=0.5,
  KMIN = 2.E-5,
  KMAX = 1.E-3,
  CMAX = 30.,
  RUWSTD=0.01
/
EOF3
fi
if [ "$scenario" = "OPTIM" ]; then
cat <<EOF3 > laun_gwd_era5.nml
&flott_gwd
  RDISS = 0.5,
  RUWMAX= 0.15,
  RUWBAC= 0.935,
  SAT= 0.3,
  DZ =100.,
  XLAUNCH=0.45,
  KMIN = 2.E-5,
  KMAX = 1.E-3,
  CMAX = 40.,
  RUWSTD=0.01
/
EOF3
fi


#Inputs: 
ln -s $Ninput data
ln -s $Ninput/sso_ph1_ph2.nc  sso_data.nc
ln -s $Ninput/ERA5_${prec}_Strateole_ph1_ph2.nc VITU.nc
ln -s $Ninput/ERA5_${prec}_Strateole_ph1_ph2.nc VITV.nc
ln -s $Ninput/ERA5_${prec}_Strateole_ph1_ph2.nc TEMP.nc
ln -s $Ninput/ERA5_${prec}_Strateole_ph1_ph2.nc LNSP.nc
ln -s $Ninput/ERA5_${prec}_Strateole_ph1_ph2.nc PREC.nc
ln -s $Ninput/STRATEOLE2_ph1_ph2_${wavs}.nc Balloon.nc
#ln -s $Ninput/STRATEOLE2_ph1_ph2_1day15min.nc Balloon.nc

ln -s $Nprog/*.h .
ln -s $Nprog/acama_gwd_rando_JGR22.f90 acama_gwd_rando.f90
ln -s $Nprog/flott_gwd_rando_COST.f90 flott_gwd_rando.f90
ln -s $Nprog/orografi_strato_JGR22.f90 orografi_strato.f90
ln -s $Nprog/laun_gwd_era5_JGR25.f90 laun_gwd_era5.f90


\rm Makefile
cp Makefile_OPT Makefile 
make

cat <<EOF5 > store
$STORE
$IAV  
$LOG10   
$prec
EOF5
./laun_gwd_era5 < store

echo 'Prediction ends start the diags'

gfortran $Ndivr/East_West_histo.f90
./a.out


xmgrace  -nxy scat_balloon.dat -par $Ndivr/scat_balloon_${prec}.par &
xmgrace  -nxy East_and_West_daily.dat -par $Ndivr/daily_${prec}.par &
xmgrace  -nxy Obs_Pred_east_and_west.dat -par $Ndivr/pdfs_${prec}.par &

cp *.dat $XMdir
mv *.f90 $Xmdir
cp laun_gwd_era5.nml $XMdir
cp one_launch.sh $XMdir


exit
