import os
import numpy as np
import matplotlib.pyplot as plt
from netCDF4 import Dataset

# Ouverture du fichier
ncdata=Dataset("phys.nc")

# Recuperation des indices de la longitude et de la latitude à tracer
# On va chercher le point le plus proche sur la grille
# En 1D, on pren d le point du 1D quelques soient les valeurs de longitude et latitude
longitude=0.
latitude=10.

# Jour à partir duquel on trace les cycles diurne
day0=2.
daystep=48

lat=np.array(ncdata.variables['lat'][:])
lon=np.array(ncdata.variables['lon'][:])
lat_i=[ilat for ilat,lati in enumerate(lat) if abs(lati-latitude) == np.min(abs(lat-latitude))][0]
lon_i=[ilon for ilon,loni in enumerate(lon) if abs(loni-longitude) == np.min(abs(lon-longitude))][0]


# Lecture des temperatures et altitude
temp=np.array(ncdata.variables['temp'][:,:,lat_i,lon_i]) # [time,z,y,x]
alt=ncdata.variables['geop'][0,:,lat_i,lon_i]/9800

# Lecture des flux
swtopdn=np.array(ncdata.variables['swtopdn'][:,lat_i,lon_i])
swtopup=np.array(ncdata.variables['swtopup'][:,lat_i,lon_i])
lwtop=np.array(ncdata.variables['lwtop'][:,lat_i,lon_i])
swtop=swtopdn-swtopup
tottop=swtop-lwtop

# wth et Altitudes au niveaux intermédiaires
wth=np.array(ncdata.variables['w_th'][:,1:,lat_i,lon_i])
altw=0.5*(alt[0:len(alt)-1]+alt[1:])

# Les 8 premiers niveaux pour la temperature et la profondeur du sol
tsoil=ncdata.variables['tsoil'][:,0:14,lat_i,lon_i] # [time,z,y,x]
if len(lat) == 1:
    depth=-ncdata.variables['zsoil'][0,0:14,lat_i,lon_i]/1000.
else :
    depth=-ncdata.variables['tsoil'][0,0:14,0,0]/1000.


# Axe des temps en jours
day=np.array([ float(i)/float(daystep) for i in range(len(temp[:,0])) ])

# Lissage en temps et anomalies diurnes
sbx = np.ones(daystep)/daystep
if np.max(day) <= 3. :
   daily_temp=[np.mean(temp,axis=0)]*len(day)
   daily_tsoil=[np.mean(tsoil,axis=0)]*len(day)
else:
   daily_temp=np.apply_along_axis(lambda m: np.convolve(m, sbx, mode='same'), axis=0, arr=temp)
   daily_tsoil=np.apply_along_axis(lambda m: np.convolve(m, sbx, mode='same'), axis=0, arr=tsoil)

anom_a=temp-daily_temp
anom_s=tsoil-daily_tsoil


# Lissage des flux
swtopup_s=np.convolve(swtopup, sbx, mode='same')
swtopdn_s=np.convolve(swtopdn, sbx, mode='same')
lwtop_s=np.convolve(lwtop, sbx, mode='same')
swtop_s=np.convolve(swtop, sbx, mode='same')
tottop_s=np.convolve(tottop, sbx, mode='same')

def t_plot() :
    it0_s=int(daystep/2)
    plt.subplot(2,1,1)
    lw_s=2.
    lw_=0.7
    if np.max(day) > 3. :
       time_=day
    else :
       time_=24.*day
       plt.xticks(np.arange(0, 3.*24, 6.0))

    plt.plot(time_,swtop,c="gold",lw=lw_,label='Ray. solaire')
    #plt.plot(time_[it0_s:],swtop_s[it0_s:],c="gold",lw=lw_s)
    plt.ylabel("Flux radiatif (W/m"+r"$^2$"+")")
    #plt.xlim([0.,np.min([10.,max(time_)])])
    plt.ylim([0.,900.])
    plt.margins(x=0.)
    plt.legend()
    plt.subplot(2,1,2)
    #plt.plot(time_[it0_s:],swtop_s[it0_s:],c="gold",lw=lw_s,label="Ray. solaire")
    #plt.plot(time_[it0_s:],lwtop_s[it0_s:],c="r",lw=lw_s,label="Ray. thermique")
    plt.plot(time_,lwtop,c="red",lw=lw_)
    plt.plot(time_,tsoil[:,0],c='green',lw=lw_,label="Temperature de surface")
    #plt.plot(time_[it0_s:],daily_tsoil[it0_s:,0],c='green',lw=lw_s)
    plt.ylabel("Flux (W/m"+r"$^2$"+") et T (K)")
    plt.xlabel("Jour depuis le début de la simulation")
    plt.ylim([100.,350.])
    #plt.xlim([0.,np.min([150.,max(time_)])])
    if np.max(day)<=3.:
       plt.xticks(np.arange(0, 3.*24, 6.0))
    plt.margins(x=0.)
    plt.legend()
    plt.savefig('fig-vol3-chp-gcm-1Db.pdf', bbox_inches='tight')
    os.system('evince fig-vol3-chp-gcm-1Db.pdf')




#-----------------------------------------------------------------------------
# Tracer des cartes t-z
#-----------------------------------------------------------------------------

def zt_plot() :
     time=(day-day0)*24
     anom_levels=[ float(i-8)/2. for i in range(17) ]
     cp=plt.contourf(time,alt,anom_a.transpose(),anom_levels,cmap='bwr',extend='both')
     cp=plt.contourf(time,depth,anom_s.transpose(),anom_levels,cmap='bwr',extend='both')
     plt.xticks(np.arange(0, 92, 6.0))
     plt.axhline(0.01,color="brown",linewidth=2.)
     
     # Tracer des vecteurs
     plt.colorbar(cp) 
     for k in range(len(altw)) :
        plt.plot(time,len(time)*[altw[k]],'+',c='k',ms=0.2)
        q=plt.quiver(time,altw[k],0*wth[:,k],wth[:,k],units='height',scale_units='height',angles='uv',scale=100,width=0.004)

        # Tracer de la legende du vent.
        # Il faut choisir une couche avec des vents non nuls
        if k == 3 :
            plt.quiverkey(q, X=0.75, Y=0.9, U=5, label='5 m/s', labelpos='E', coordinates='figure')
     
     for k in range(len(depth)) :
        plt.plot(time,len(time)*[depth[k]],'+',c='k',ms=0.2)
     
     
     plt.xlabel('heures')
     plt.ylabel('Altitude (km)')
     plt.xlim([0.,48.])
     plt.ylim([-1.,7.])
     plt.savefig('fig-vol3-chp-gcm-1Da.pdf')
     os.system('evince fig-vol3-chp-gcm-1Da.pdf')

zt_plot()
quit()
t_plot()
quit()
#test_plot() ; quit()
