#!/bin/bash

simu=mars
simu=z0
simus="z0 terre mars"
simus="terre"
simus="mars terre"


# Bordel dynzon
# l=37-l
# L'état 36 devrait être du 10 au 20 mars
# L'état 34 du 20 au 30 février
# DJF : du 26 au 34 -> 3 au 11 dans dynzon
DJFdynzon="3:11"

for simu in $simus ; do

case $simu in
   mars) dir=ghio:/data/hourdin/phyparam/MARS5
         cp=831
         factps=1 ; psilev="/lev=(-10,10,0.5)" ;;
   terre) 
         dir=ghio:/data/hourdin/phyparam/TERRE5
         #dir=TERRE0D
         cp=1004
         factps=0.01 ; psilev="/lev=(-200,-100,50)(-80,80,20)(100,200,50)" ;;
   z0)   dir=ghio:/data/hourdin/phyparam/PARAM20230114.trunk/modipsl/modeles/LMDZ/TERRE0/Z0_1mm
         cp=1004
         factps=0.01 ;;
   *) exit 1
esac
#psilev=

if [ ! -f phys_${simu}.nc ] ; then scp $dir/phys.nc phys_${simu}.nc ; fi
if [ ! -f zon_${simu}.nc ] ; then
   scp $dir/dynzon.nc zon_${simu}.nc
# ncatted -a positive,presnivs,o,c,down zon_${simu}.nc
# ncrename -v T,temp -O zon_${simu}.nc
fi

cat <<eod>| ut.jnl
use zon_${simu}
DEFINE VIEWPORT/XLIM=0.,.7/YLIM= 0,.7 V1
set v V1
sh da
reg/l=$DJFdynzon
fill/nolabel/lev=(-Inf)(-50)(-40)(-30)(-20)(-15,15,2.5)(20)(30)(40)(50)(Inf)/pal=blue_darkred u[i=@ave,l=@ave]
contour/o/nolabel/lev=(100,310,5)/y=-85.:85. temp[i=@ave,l=@ave]
quit
eod

cat <<eod>| psi.jnl
use zon_${simu}
DEFINE VIEWPORT/XLIM=0.,.7/YLIM= 0,.7 V1
set v V1
sh da
reg/l=$DJFdynzon
let trs=($cp*trsvt+trsvgz)/$cp
let trs=trsvu
fill/nolabel/lev=(-Inf)(-20,20,2)(Inf)/pal=blue_darkred trs[l=@ave]
contour/o/nolabel$psilev psi[l=@ave]
quit
eod

cat <<eod>| uv.jnl
use phys_${simu}.nc
!DEFINE VIEWPORT/XLIM=0.,.7/YLIM= 0,.7 V1
!set v V1
reg/l=31/k=19
!fill/nolabel/pal=blue_darkred/lev=(-Inf)(-14,14,2)(Inf) (ps-ps[i=@ave])*$factps
fill/nolabel/pal=blue_darkred/lev=(-Inf)(-7,7,1)(Inf) (temp-temp[i=@ave])
!contour/nolabel/o/col=1/pal=blue_darkred/lev=(100.,320.,5.) temp
VECTOR/SET/o/col=1/title=Wind/len=25 u,v
PPL axset,1,1,0,0
PPL VECTOR/over,1,1
quit
eod

for t in ut psi uv ; do
     out=fig-vol3-chp-gcm-${simu}${t}.pdf
     \rm -f tmp.pdf $out
     ferret -nojnl -batch tmp.pdf -script ${t}.jnl
     pdfcrop tmp.pdf $out 
done
done
