#!/bin/bash

simus=terre
simus="mars terre"

for simu in $simus ; do

case $simu in
   mars) dir=ghio:/data/hourdin/phyparam/MARS5
             fluxmax=250. ;;
   terre)  dir=ghio:/data/hourdin/phyparam/TERRE5
             fluxmax=400. ;;
   *) exit 1
esac



#annuel=$(( $(( $ymax * 36 )) - 35 )):$(( $ymax * 36 ))
#solstice=$(( $(( $ymax * 36 )) - 10 )):$(( $(( $ymax * 36 )) -2 ))


#if [ ! -f srf_${simu}.nc ] ; then
    rsync -av $dir/srf.nc srf_${simu}.nc
    cdo fldavg srf_${simu}.nc globe_${simu}.nc
#fi
#
#if [ ! -f phys_${simu}.nc ] ; then
    rsync -av $dir/phys.nc phys_${simu}.nc
#fi

ntime=`ncdump -h srf_$simu.nc | grep time | head -1 | sed -e 's/(/ /' | awk ' { print $6 } '`

cat <<eod> swdns.jnl
set v ll
use srf_${simu}.nc
fill/l=27/pal=blue_darkred/nolabel swtopdn
eod

cat <<eod> swdn.jnl
set v ll
use srf_${simu}.nc
fill/l=1:180/pal=blue_darkred/nolabel swtopdn[i=@ave]
eod

cat <<eod> ts.jnl
set v ll
use srf_${simu}.nc
fill/l=1:180/pal=blue_darkred/nolabel ts[i=@ave]
eod

thick=2
cat <<eod> lat.jnl
set v upper
!use srf_${simu}.nc
!reg/l=$ntime:$(( $ntime - 35 ))

use phys_${simu}.nc
reg/l=1:36
DEFINE VIEWPORT/XLIM=0.,.5/YLIM= 0,.4 V1
set v V1
plot/thick=$thick/nolabel/vlim=0.:$fluxmax/title='Solaire descendant (W/m2)' swtopdn[i=@ave,l=@ave]
plot/thick=3/o/title="Solaire net" swtopdn[i=@ave,l=@ave]-swtopup[i=@ave,l=@ave]
plot/thick=$thick/o/title="Thermique" lwtop[i=@ave,l=@ave]
plot/thick=$thick/o/title="Ts (K)" ts[i=@ave,l=@ave]
quit
eod

sed -e 's/1\:36/11/' lat.jnl > lats.jnl

for t in ts swdn swdns lat lats ; do
     ferret -nojnl -batch tmp.pdf -script ${t}.jnl
     pdfcrop tmp.pdf fig-vol3-chp-gcm-${simu}${t}.pdf
done
done
