#!/bin/bash


simu=mars

case $simu in
    mars) simdir=MARS0_20 ;;
    terre) simdir=TERRE0C_27
esac

rsync -av ghio:/data/hourdin/$simdir/ $simdir/

cd $simdir

# Simulation d'une année pour récupérer les tendances
if [ ! -f zon.nc ] ; then
    sed -i'' -e 's/period_sort=.*$/period_sort=10/' -e 's/io_tend=.*$/io_tend=1/' -e 's/io_meteo=.*$/io_meteo=2/' planete.def
    sed -i'' -e 's/nday=.*$/nday=360/' run.def
    ../run_local.sh 4 1 ../gcm.e > listing1 2>&1
    ncks -d time,25,33 phys.nc -O tmp.nc
    cdo zonavg -timavg tmp.nc zon.nc
    \rm -f phys.nc restar*
fi

# Simulation d'une simulatiopn plus courte pour lancer la simulation courte
if [ ! -f restart_param.nc ] ; then
    sed -i'' -e 's/nday=.*$/nday=320/' run.def
    ../run_local.sh 4 1 ../gcm.e > listing1 2>&1
    \rm phys.nc dynz* hist*
fi

# Simulation courte
if [ ! -d short ] ; then
     mkdir short
     \cp *def short/
     cd short
     for s in "" phy _param ; do
        ln -s ../restart${s}.nc start${s}.nc
     done
     sed -i'' -e 's/period_sort=.*$/period_sort=.04166666666666666666/' -e 's/io_tend=.*$/io_tend=0/' -e 's/io_meteo=.*$/io_meteo=2/' -e 's/io_intern.*=/io_intern=1/' planete.def
     sed -i'' -e 's/nday=.*$/nday=10/' run.def
     pwd
     echo OK
     ../../run_local.sh 4 1 ../../gcm.e
     ncks -d lon,0. phys.nc phys0.nc
     echo AK
     pwd
     echo ../../run_local.sh 4 1 ../../gcm.e
fi
