#!/bin/bash

for simu in mars terre ; do

case $simu in
   mars) dir=MARS0_4 ;;
   terre) dir=TERRE0C_16
esac

for tend in rad pbl ; do

cat <<eod> tmp.jnl
use $dir/physz.nc
set v ul
let rad=dtsw+dtlw
let pbl=dtthe+dtvdf
fill/nolabel/lev=(-Inf)(-2,2,0.2)(Inf)/pal=blue_darkred 86400*$tend
quit
eod

out=fig-vol3-chp-gcm-${simu}${tend}
ferret -batch $out.pdf -script tmp.jnl
pdfcrop $out.pdf
mv -f ${out}-crop.pdf $out.pdf


done
done
