!
! $Id: iniphysiq.F 1403 2010-07-01 09:02:53Z fairhead $
!
c
c
      SUBROUTINE iniphysiq_param(ngrid,nlayer,
     $           punjours,
     $           pdayref,ptimestep,
     $           plat,plon,parea,pcu,pcv,
     $           prad,pg,pr,pcpp,iflag_phys)
      USE dimphy
      USE mod_grid_phy_lmdz
      USE mod_phys_lmdz_para
      USE geometry_mod, ONLY: cell_area, latitude_deg, longitude_deg
!      USE inigeomphy_mod, ONLY : lonfi,latfi


      IMPLICIT NONE
c
c=======================================================================
c
c   subject:
c   --------
c
c   Initialisation for the physical parametrisations of the LMD 
c   martian atmospheric general circulation modele.
c
c   author: Frederic Hourdin 15 / 10 /93
c   -------
c
c   arguments:
c   ----------
c
c   input:
c   ------
c
c    ngrid                 Size of the horizontal grid.
c                          All internal loops are performed on that grid.
c    nlayer                Number of vertical layers.
c    pdayref               Day of reference for the simulation
c    firstcall             True at the first call
c    lastcall              True at the last call
c    pday                  Number of days counted from the North. Spring
c                          equinoxe.
c
c=======================================================================
c
c-----------------------------------------------------------------------
c   declarations:
c   -------------
 
#include "comcstphy.h"
      REAL prad,pg,pr,pcpp,punjours
 
      INTEGER ngrid,nlayer,iflag_phys
      REAL plat(ngrid),plon(ngrid),parea(klon_glo)
      REAL pcu(klon_glo),pcv(klon_glo)
      INTEGER pdayref
      INTEGER :: ibegin,iend,offset,indmin,indmax
      REAL pi
 
      REAL ptimestep
      CHARACTER (LEN=20) :: modname='iniphysiq'
      CHARACTER (LEN=80) :: abort_message

      pi=2.*asin(1.)
      print*,'INInnn ENTREE DANS INIPHYSIQ' 
      IF (nlayer.NE.klev) THEN
         PRINT*,'STOP in inifis'
         PRINT*,'Probleme de dimensions :'
         PRINT*,'nlayer     = ',nlayer
         PRINT*,'klev   = ',klev
         abort_message = ''
         CALL abort_gcm (modname,abort_message,1)
      ENDIF

      IF (ngrid.NE.klon_omp) THEN
         PRINT*,'STOP in inifis'
         PRINT*,'Probleme de dimensions :'
         PRINT*,'ngrid     = ',ngrid
         PRINT*,'klon   = ',klon_omp
         abort_message = ''
         CALL abort_gcm (modname,abort_message,1)
      ENDIF
c$OMP PARALLEL PRIVATE(ibegin,iend) 
c$OMP+         SHARED(parea,pcu,pcv,plon,plat)
      
      print*,'Dans iniphysiq '
      offset=klon_mpi_begin-1
!     cell_area(1:klon_omp)=parea(offset+klon_omp_begin:
!    &                          offset+klon_omp_end)
      !cuphy(1:klon_omp)=pcu(offset+klon_omp_begin:offset+klon_omp_end)
      !cvphy(1:klon_omp)=pcv(offset+klon_omp_begin:offset+klon_omp_end)
      indmin=offset+klon_omp_begin
      indmax=offset+klon_omp_end
!     longitude_deg(1:klon_omp)=180./pi*lonfi(indmin:indmax)
!     latitude_deg(1:klon_omp)=180./pi*latfi(indmin:indmax)
       print*,'latitude0 deg ',latitude_deg(1),latitude_deg(klon_omp)

!     call suphel
!     prad,pg,pr,pcpp
      rradius=prad
      rg=pg
      rr=pr
      rcpp=pcpp

!     return
      
      CALL iniphyparam(ngrid,nlayer,
     $           punjours,
     $           pdayref,ptimestep,
     $           prad,pg,pr,pcpp)


      print*,'OK iniphyparam ',size(plat)

c$OMP END PARALLEL

      print*,'ATTENTION !!! TRAVAILLER SUR INIPHYSIQ'
      print*,'CONTROLE DES LATITUDES, LONGITUDES, PARAMETRES ...'

      RETURN
9999  CONTINUE
      abort_message ='Cette version demande les fichier rnatur.dat
     & et surf.def'
      CALL abort_gcm (modname,abort_message,1)


      END
