PROGRAM scm
USE dimensions_mod, ONLY: iim, jjm, llm, ndm

USE dimphy
USE ioipsl_getin_p_mod, ONLY : getin_p
USE comsaison
USE comgeomfi
USE iniphysiq_mod, ONLY: iniphysiq
USE physiq_mod, ONLY: physiq
USE comvert_mod, ONLY: presnivs, ap, bp, dpres,nivsig, nivsigs, pa, &
                   preff, aps, bps, pseudoalt, scaleheight
use soil_ini_mod, only : soil_ini, nsoilmx
USE infotrac_phy, only: nqtot





      IMPLICIT NONE


      include "callkeys.h"
      include "comcstfi.h"
      include "planete.h"


!    Arguments :
!    -----------

      INTEGER ngrid,nlayer,it


      REAL plev(llm+1)
      REAL,DIMENSION(llm) :: play,temp,phi,d_t
      REAL,DIMENSION(1) :: phis=0.
      REAL :: psrf=1e5
      REAL,DIMENSION(llm) :: vitu,vitv,d_u,d_v
      REAL,DIMENSION(llm) :: ug,vg
      REAL,dimension(:,:), allocatable :: qx,d_qx,flxmass_w
      REAL,DIMENSION(1) :: d_ps=0.
      INTEGER, save :: comm_lmdz=0

!   dynamial tendencies

      INTEGER l,ierr,aslun,nlevel,iaer
!
      REAL mu0,fract
      REAL day_ini,time,longitude,latitude
      REAL ztlev(llm+1)
      REAL zplanck
      REAL stephan
      REAL ztim1,ztim2,ztim3
      REAL ls,zmax
      REAL pdtlw(llm),pdtsw(llm)
      REAL zfluxsw,zfluxlw

      REAL cst_aer
      REAL tsurf
      REAL,ALLOCATABLE :: tsoil(:)
      REAL albedo,emis
      REAL dtrad(llm),fluxrad

      DATA stephan/5.67e-08/
      DATA zmax/9./
      DATA ls,time/0.,12./

!   WARNING declin and dist_sol are prescribed instead of Ls
      REAL declin_deg,dist_sol0
      DATA declin_deg,dist_sol0/-24.8,1.4/
      REAL timestep,airefi,rday,zcufi,zcvfi
      INTEGER dayref,day_step,nday
      LOGICAL :: debut=.true.,lafin=.false.
      REAL :: sfdt,cfdt,romega,fcoriolis

!-----------------------------------------------------------------------
!    1. Initialisations :
!    --------------------


      latitude=30.
      time=0.

      pi=2.*asin(1.)
      ls=ls*pi/180.
      time=time/24.
      longitude=0.
      latitude=latitude*pi/180.
      longitude=longitude*pi/180.
      declin=declin_deg*pi/180.
      dist_sol=dist_sol0

      ngrid=1
      print*,'nlayermx ',nlayermx
      nlayermx=llm
      nlayer=nlayermx
      nlevel=nlayer+1

      !rad=3397200.
      !omeg=4.*asin(1.)/(88775.)
      !g=3.72
      !mugaz=43.49
      !rcp=.256793
      !unjours=88775.
      !r       = 8.314511*1000./mugaz
      !cpp     = r/rcp
      !PRINT*,'Cp  =  ',cpp
      !PRINT*,'R   =  ',r
      airefi=1.
      rday=0.
      zcufi=1.
      zcvfi=1.
      dayref=0

      preff=psrf
      pa=psrf/2.
!      call disvert0(pa,preff,ap,bp,dpres,presnivs,nivsigs,nivsig)
      call disvert()

      ! La lecture par appel a info_trac ne marche pas
      !call init_infotrac
      nqtot=2
      allocate(qx(llm,nqtot),d_qx(llm,nqtot),flxmass_w(llm,nqtot))
      qx=0.
      timestep=10000000.
     ! Ehouarn: iniphysiq requires arrays related to (3D) dynamics grid,
     ! e.g. for cell boundaries, which are meaningless in 1D; so pad these
     ! with '0.' when necessary
      call iniphysiq(iim,jjm,llm, &
           1,comm_lmdz, &
           rday,dayref,timestep,  &
           (/latitude,0./),(/0./), &
           (/0.,0./),(/longitude,0./),  &
           (/ (/airefi,0./),(/0.,0./) /), &
           (/zcufi,0.,0.,0./), &
           (/zcvfi,0./), &
           rad,g,r,cpp,1)
      print*,'apres iniphysiq'

      CALL iniphyparam(1,llm, &
             unjours, &
             0.,timestep, &
             rad,g,r,cpp)

      romega = 2.*pi/unjours
      fcoriolis=2.*sin(latitude)*romega
      print*,'Coriolis=',fcoriolis

      tsurf=200.
      DO l=1,nlayer
         play(l)=presnivs(l)
      ENDDO
      plev(1)=preff
      plev(nlayer+1)=0.
      DO l=1,nlayer-1
         plev(l+1)=0.5*(play(l)+play(l+1))
      ENDDO


      DO l=1,nlayer
         temp(l)=tsurf
         ug(l)=10.
         vg(l)=0.
      ENDDO
      vitu(:)=ug(:)
      vitv(:)=vg(:)

      DO l=1,nlayer
         dtrad(l)=0.
      ENDDO
      fluxrad=0.

      albedo=.24
      emis=1.
      CALL iniorbit(aphelie,periheli,year_day,peri_day,obliquit)

!  a total otempical detemph of .2 for Ps=700Pa

      ngridmax=ngrid

      call soil_ini
      print*,'scm nsoilmx ',nsoilmx
      ALLOCATE(tsoil(nsoilmx))

      call getin_p('nday',nday)
      call getin_p('day_step',day_step)
      timestep=unjours/day_step
      print*,'nday,day_step,timestep',nday,day_step,timestep



!==========================================================================
      ! Debut de la boucle en temps
!==========================================================================
     print*,'Nombre de pas de temps',nday*day_step
     DO it=1,nday*day_step

     if ( mod(it,day_step) == 0 ) write(*,'("Pas:",i8,",   Jour:",i4,"  ,",f5.1,"%")') it,it/day_step,it*100./(nday*day_step)
     !do l=1,llm
     !   print*,'l,play,temp',l,play(l),temp(l),vitu(l),vitv(l)
     !enddo

!  Extrapolation for the air temperature above the surface
      ztlev(1)=temp(1)+(plev(1)-play(1))*(temp(1)-temp(2))/(play(1)-play(2))

      DO l=2,nlevel-1
         ztlev(l)=0.5*(temp(l-1)+temp(l))
      ENDDO

      ztlev(nlevel)=temp(nlayer)


!---------------------------------------------------------------------
!  Geopotential :
!---------------------------------------------------------------------

        phi(1)=r*temp(1)*(plev(1)-play(1))/(.5*(plev(1)+play(1)))
        do l = 1, llm-1
          phi(l+1)=phi(l)+r*(temp(l)+temp(l+1))*(play(l)-play(l+1))/(play(l)+play(l+1))
        enddo
        flxmass_w=0.
        ! Traceurs mis a zeros en attendant Godot

      IF (it==1) call phyredem ("startphy.nc")
      CALL physiq (1,nlayer, &
     &            debut,lafin,timestep, &
     &            plev,play,phi,phis,play/plev(1), &
     &            vitu,vitv,temp,qx, &
     &            flxmass_w, &
     &            d_u, d_v, d_t, d_qx, d_ps)

      debut=.false.

      ! Rappel geostrophique
      sfdt = sin(0.5*fcoriolis*timestep)
      cfdt = cos(0.5*fcoriolis*timestep)
!     print *,'fcoriolis,sfdt,cfdt,timestep',fcoriolis,sfdt,cfdt,timestep
      d_u(1:llm)=d_u(1:llm)-2.*sfdt/timestep*(sfdt*(vitu(1:llm)-ug(1:llm))-cfdt*(vitv(1:llm)-vg(1:llm)))
      d_v(1:llm)=d_v(1:llm)-2.*sfdt/timestep*(cfdt*(vitu(1:llm)-ug(1:llm))+sfdt*(vitv(1:llm)-vg(1:llm)))


      temp=temp+timestep*d_t
      vitu=vitu+timestep*d_u
      vitv=vitv+timestep*d_v
      qx=qx+timestep*d_qx


      ENDDO

      END
#include "1DUTILS.h"
