module comgeomfi

   real,save,allocatable :: long(:)
   real,save,allocatable :: lati(:)
   real,save,allocatable :: area(:)
   real,save,allocatable :: sinlon(:)
   real,save,allocatable :: coslon(:)
   real,save,allocatable :: sinlat(:)
   real,save,allocatable :: coslat(:)
   real,save :: totarea
   integer,save :: ngridmax,nlayermx
!$OMP THREADPRIVATE(long,lati,area,sinlon,coslon,sinlat,coslat,totarea)
!$OMP THREADPRIVATE(ngridmax,nlayermx)
contains
  
  subroutine InitComgeomfi
  USE ioipsl_getin_p_mod, ONLY : getin_p
  USE mod_phys_lmdz_para
  USE dimphy, ONLY : klon,klev
  USE geometry_mod, ONLY : latitude_deg,longitude_deg
  implicit none

    
    print*,'Dans initcomgeomfi '
    ngridmax=klon_omp
    nlayermx=klev
    print*,'ngridmax,nlayermx',ngridmax,nlayermx
 
    allocate(long(klon_omp))
    allocate(lati(klon_omp))
    long=longitude_deg
    lati=latitude_deg
    allocate(area(klon_omp))
    allocate(sinlon(klon_omp))
    allocate(coslon(klon_omp))
    allocate(sinlat(klon_omp))
    allocate(coslat(klon_omp))

  end subroutine InitComgeomfi
  
end module comgeomfi
