subroutine ener_conserv(klon,klev,pdtphys,masse,uwnd,vwnd,temp,d_u,d_v,d_t,exner,d_t_ec)

IMPLICIT NONE
!=============================================================
! Energy conservation
! Based on the TKE equation
! The M2 and N2 terms at the origin of TKE production are
! concerted into heating in the d_t_ec term
! Option 1 is the standard
!        101 is for M2 term only
!        101 for N2 term only
!         -1 is a previours treatment for kinetic energy only
!  FH (hourdin@lmd.jussieu.fr), 2013/04/25
!=============================================================

!=============================================================
! Declarations
!=============================================================

integer, intent(in) :: klon,klev
real,intent(in) :: pdtphys
real,dimension(klon,klev), intent(in) :: masse,uwnd,vwnd,temp,d_u,d_v,d_t,exner
real,dimension(klon,klev), intent(out) :: d_t_ec

real, dimension(klon,klev) :: zu,zv
real, dimension(klon,klev+1) :: fluxu,fluxv,fluxt
real, dimension(klon,klev+1) :: dddu,dddv,dddt,d_t_ech

#include "comcstfi.h"

integer :: k


   zu(:,:)=uwnd(:,:)+0.5*d_u(:,:)*pdtphys
   zv(:,:)=vwnd(:,:)+0.5*d_v(:,:)*pdtphys

   fluxu(:,klev+1)=0.
   fluxv(:,klev+1)=0.
   fluxt(:,klev+1)=0.

   do k=klev,1,-1
      fluxu(:,k)=fluxu(:,k+1)+masse(:,k)*d_u(:,k)
      fluxv(:,k)=fluxv(:,k+1)+masse(:,k)*d_v(:,k)
      fluxt(:,k)=fluxt(:,k+1)+masse(:,k)*d_t(:,k)/exner(:,k)
   enddo

   dddu(:,1)=2*zu(:,1)*fluxu(:,1)
   dddv(:,1)=2*zv(:,1)*fluxv(:,1)
   dddt(:,1)=(exner(:,1)-1.)*fluxt(:,1)

   do k=2,klev
      dddu(:,k)=(zu(:,k)-zu(:,k-1))*fluxu(:,k)
      dddv(:,k)=(zv(:,k)-zv(:,k-1))*fluxv(:,k)
      dddt(:,k)=(exner(:,k)-exner(:,k-1))*fluxt(:,k)
   enddo
   dddu(:,klev+1)=0.
   dddv(:,klev+1)=0.
   dddt(:,klev+1)=0.

   do k=1,klev
      d_t_ech(:,k)=-(cpp*(dddt(:,k)+dddt(:,k+1)))/(2.*cpp*masse(:,k))
      !d_t_ech(:,k)=0.
      d_t_ec(:,k)=-(dddu(:,k)+dddu(:,k+1)+dddv(:,k)+dddv(:,k+1))/(2.*cpp*masse(:,k))+d_t_ech(:,k)
   enddo


!================================================================
!  Computation of integrated enthalpie and kinetic energy variation
!  FH (hourdin@lmd.jussieu.fr), 2013/04/25
!  bils_ec : energie conservation term
!  bils_ech : part of this term linked to temperature
!  bils_tke : change of TKE
!  bils_diss : dissipation of TKE (when activated)
!  bils_kinetic : change of kinetic energie of the column
!  bils_enthalp : change of enthalpie
!  bils_latent  : change of latent heat. Computed between
!          after reevaporation (at the beginning of the physics)
!          and before large scale condensation (fisrtilp)
!================================================================
!!
!!      bils_ec(:)=0.
!!      bils_ech(:)=0.
!!      bils_tke(:)=0.
!!      bils_diss(:)=0.
!!      bils_kinetic(:)=0.
!!      bils_enthalp(:)=0.
!!      bils_latent(:)=0.
!!      DO k=1,klev
!!        bils_ec(:)=bils_ec(:)-d_t_ec(:,k)*masse(:,k)
!!        bils_diss(:)=bils_diss(:)-d_t_diss(:,k)*masse(:,k)
!!        bils_kinetic(:)=bils_kinetic(:)+masse(:,k)* &
!!     &           (pun(:,k)*pun(:,k)+pvn(:,k)*pvn(:,k) &
!!     &            -puo(:,k)*puo(:,k)-pvo(:,k)*pvo(:,k))
!!        bils_enthalp(:)= &
!!     &  bils_enthalp(:)+masse(:,k)*(ptn(:,k)-pto(:,k)+d_t_ec(:,k)-d_t_eva(:,k)-d_t_lsc(:,k))
!!!    &  bils_enthalp(:)+masse(:,k)*(ptn(:,k)-pto(:,k)+d_t_ec(:,k))
!!        bils_latent(:)=bils_latent(:)+masse(:,k)* &
!!!    &             (pqn(:,k)-pqo(:,k))
!!     &             (pqn(:,k)-pqo(:,k)-d_q_eva(:,k)-d_q_lsc(:,k))
!!      ENDDO
!!      bils_ec(:)=rcpd*bils_ec(:)/pdtphys
!!      bils_diss(:)=rcpd*bils_diss(:)/pdtphys
!!      bils_kinetic(:)= 0.5*bils_kinetic(:)/pdtphys
!!      bils_enthalp(:)=rcpd*bils_enthalp(:)/pdtphys
!!      bils_latent(:)=rlvtt*bils_latent(:)/pdtphys
!!!jyg<
!!      IF (iflag_pbl > 1) THEN
!!        DO k=1,klev
!!          bils_tke(:)=bils_tke(:)+0.5*(dtke(:,k)+dtke(:,k+1))*masse(:,k)
!!        ENDDO
!!        bils_tke(:)=bils_tke(:)/pdtphys
!!      ENDIF  ! (iflag_pbl > 1)
!!!>jyg
!!
!!IF (iflag_ener_conserv>=1) THEN
!!      bils_ech(:)=0.
!!      DO k=1,klev
!!        bils_ech(:)=bils_ech(:)-d_t_ech(:,k)*masse(:,k)
!!      ENDDO
!!      bils_ech(:)=rcpd*bils_ech(:)/pdtphys
!!ENDIF

RETURN

END
