      subroutine my_25(imax,kmax,dt,gp,z,zi,u,v,teta,cd,q2,long,km,kh)

!**********************************************************************
!****** FERMETURE MELLOR-YAMADA DE NIVEAU 2.5 (QUASI-EQUILIBRE) *******
!* q2 au interfaces entre mailles.
!**********************************************************************

     USE vdif_ini, ONLY : karman,a1,a2,b1,b2,c1,e1,e2
     USE vdif_ini, ONLY : khmin,kmmin,kqmin,q2min,q2lmin,ghmax,ghmin

     IMPLICIT NONE

!************* DECLARATIONS *******************************************


      integer, intent(in) :: imax,kmax
      real, intent(in) :: dt,gp
      real, dimension(imax,kmax), intent(in) :: teta, u, v, z
      real, dimension(imax,kmax+1), intent(out) :: zi
      real, dimension(imax), intent(in) :: cd
      real, dimension(imax,kmax+1), intent(inout) :: q2
      real, dimension(imax,kmax+1), intent(out) :: long,km, kh

      real :: longc



      real, dimension(imax,kmax) :: unsdz, kq,a,b,c,f
      real, dimension(imax,kmax+1) :: unsdzi,m2,n2,ri,alph
      real :: ksdz2inf,ksdz2sup

      real :: acd, adz, adzi, akh, akm, akq, al, al0, am
      real :: am2, aq2, ateta, au, az, azi, bet, beta, dest, du, dv
      real :: gh, prod, q2c, sh, sm, sq, us, vt, vt1, vt2

      integer :: i,k


      print*,'WARNING : PAS DE IMPLICIT NONE DANS my_25'

!**********************************************************************


!************* INCREMENTS VERTICAUX ***********************************

      do i=1,imax
       zi(i,kmax+1)=zi(i,kmax)+2.0*(z(i,kmax)-zi(i,kmax))
      enddo

      do k=1,kmax
       do i=1,imax
        unsdz(i,k)=1.0/(zi(i,k+1)-zi(i,k))
       enddo
      enddo

      do k=2,kmax
       do i=1,imax
        unsdzi(i,k)=1.0/(z(i,k)-z(i,k-1))
       enddo
      enddo

      do i=1,imax
       unsdzi(i,1)=0.5/(z(i,1)-zi(i,1))
       unsdzi(i,kmax+1)=0.5/(zi(i,kmax+1)-z(i,kmax))
      enddo

!**********************************************************************


!************* DIFFUSIVITES KH, KM et KQ ******************************
! Ci-dessous, une premiere estimation des diffusivites turbulentes km *
! et kh est effectuee pour utilisation dans les taux de production    *
! et de destruction de q2 et q2l. On calcule aussi kq.                *

      m2(:,1)=0.
      m2(:,kmax+1)=0.
      n2(:,1)=0.
      n2(:,kmax+1)=0.
      do k=2,kmax
       do i=1,imax
        beta=2.0/(teta(i,k)+teta(i,k-1))
        n2(i,k)=beta*gp*unsdzi(i,k)*(teta(i,k)-teta(i,k-1))
        n2(i,k)=amax1(0.0,n2(i,k))
        du=unsdzi(i,k)*(u(i,k)-u(i,k-1))
        dv=unsdzi(i,k)*(v(i,k)-v(i,k-1))
        m2(i,k)=du*du+dv*dv
        ri(i,k)=n2(i,k)/(m2(i,k)+1.0e-10)
        ri(i,k)=amax1(-0.1,min(4.0,ri(i,k)))
       enddo
      enddo

      do k=2,kmax
       do i=1,imax
        vt=karman*(zi(i,k)-zi(i,1))
        long(i,k)=vt/(1.0+vt/160.0)
        if(n2(i,k).gt.0.0) then
         long(i,k)=min(0.53*sqrt(q2(i,k))/sqrt(n2(i,k)),long(i,k))
        endif
        gh=amax1(ghmin,min(ghmax,-long(i,k)*long(i,k)*n2(i,k)/q2(i,k)))
        sm=a1*(1.0-3.0*c1-6.0*a1/b1-3.0*a2*gh*((b2-3.0*a2)*(1.0-6.0*a1/b1)-3.0*c1*(b2+6.0*a1)))/((1.0-3.0*a2*gh*(6.0*a1+b2))*(1.0-9.0*a1*a2*gh))
        km(i,k)=amax1(kmmin,long(i,k)*sqrt(q2(i,k))*sm)
        sh=a2*(1.0-6.0*a1/b1)/(1.0-3.0*a2*gh*(6.0*a1+b2))
        kh(i,k)=amax1(khmin,long(i,k)*sqrt(q2(i,k))*sh)
       enddo
      enddo

      do i=1,imax
       us=sqrt(cd(i)*(u(i,1)*u(i,1)+v(i,1)*v(i,1)))
       vt1=(b1**0.666667)*us*us
       vt2=(b1**0.6666667)*karman*karman*m2(i,2)*(zi(i,2)-zi(i,1))*(zi(i,2)-zi(i,1))
       q2(i,1)=amax1(q2min,vt1)
       long(i,1)=0.0
       long(i,kmax+1)=long(i,kmax)
       sq=0.2
       kq(i,1)=amax1(kqmin,karman*(z(i,1)-zi(i,1))*us*sq)
      enddo

      do k=2,kmax
       do i=1,imax
        longc=0.5*(long(i,k)+long(i,k+1))
        q2c=0.5*(q2(i,k)+q2(i,k+1))
        sq=0.2
        kq(i,k)=amax1(kqmin,longc*sqrt(q2c)*sq)
       enddo
      enddo

!**********************************************************************


!************* CALCUL DE Q2 *******************************************

      do k=2,kmax
       do i=1,imax
        prod=2.0*(km(i,k)*m2(i,k)+amax1(0.0,-kh(i,k)*n2(i,k)))
        dest=2.0*(amax1(0.0,kh(i,k)*n2(i,k))+q2(i,k)*sqrt(q2(i,k))/(b1*long(i,k)))
        if(k.lt.kmax) then
         ksdz2sup=unsdzi(i,k)*unsdz(i,k)*kq(i,k)
        else
         ksdz2sup=0.0
        endif
        ksdz2inf=unsdzi(i,k)*unsdz(i,k-1)*kq(i,k-1)
        b(i,k)=-ksdz2inf*dt
        a(i,k)=1.0+dt*(dest/q2(i,k)+ksdz2inf+ksdz2sup)
        c(i,k)=-ksdz2sup*dt
        f(i,k)=q2(i,k)+dt*prod
       enddo
      enddo

      do i=1,imax
       f(i,2)=f(i,2)+dt*unsdzi(i,2)*unsdz(i,1)*kq(i,1)*q2(i,1)
      enddo
      
      do i=1,imax
       alph(i,2)=a(i,2)
      enddo

      do k=3,kmax
       do i=1,imax
        bet=b(i,k)/alph(i,k-1)
        alph(i,k)=a(i,k)-bet*c(i,k-1)
        f(i,k)=f(i,k)-bet*f(i,k-1)
       enddo
      enddo

      
      do i=1,imax
       q2(i,kmax)=amax1(q2min,f(i,kmax)/alph(i,kmax))
       q2(i,kmax+1)=q2(i,kmax)
      enddo

      do k=kmax-1,2,-1
       do i=1,imax
        q2(i,k)=amax1(q2min,(f(i,k)-c(i,k)*q2(i,k+1))/alph(i,k))
       enddo
      enddo

      do i=1,imax
       q2(i,2)=amax1(q2(i,2),q2(i,1))
      enddo

!**********************************************************************


!************* EVALUATION FINALE DE KH ET KM **************************

      do k=2,kmax
       do i=1,imax
        if(n2(i,k).gt.0.0) then
         long(i,k)=min(0.53*sqrt(q2(i,k))/sqrt(n2(i,k)),long(i,k))
        endif
        gh=amax1(ghmin,  min(ghmax,-long(i,k)*long(i,k)*n2(i,k)/q2(i,k)))
        sm=a1*(1.0-3.0*c1-6.0*a1/b1-3.0*a2*gh*((b2-3.0*a2)*(1.0-6.0*a1/b1)-3.0*c1*(b2+6.0*a1)))/((1.0-3.0*a2*gh*(6.0*a1+b2))*(1.0-9.0*a1*a2*gh))
        km(i,k)=amax1(kmmin,long(i,k)*sqrt(q2(i,k))*sm)
        sh=a2*(1.0-6.0*a1/b1)/(1.0-3.0*a2*gh*(6.0*a1+b2))
        kh(i,k)=amax1(khmin,long(i,k)*sqrt(q2(i,k))*sh)
       enddo
      enddo

      do i=1,imax
       km(i,1)=kmmin
       km(i,kmax+1)=km(i,kmax)
       kh(i,1)=khmin
       kh(i,kmax+1)=kh(i,kmax)
      enddo
 
!**********************************************************************

       am=1.0/float(imax)
       do k=kmax,1,-1
        au=0.0
        ateta=0.0
        az=0.0
        adz=0.0
        akq=0.0
        acd=0.0
        do i=1,imax
         au=au+am*sqrt(u(i,k)*u(i,k)+v(i,k)*v(i,k))
         ateta=ateta+am*teta(i,k)
         az=az+am*z(i,k)
         adz=adz+am*(1.0/unsdz(i,k))
         akq=akq+am*kq(i,k)
         acd=acd+am*cd(i)
        enddo
!        write(*,2000) k,az,adz,au,ateta,akq,acd*1000.0
 2000   format(2x,i3,2x,6(f9.2,2x))
       enddo
       
       write(*,*)
       write(*,*)

       do k=kmax+1,1,-1
        azi=0.0
        adzi=0.0
        aq2=0.0
        al=0.0
        akm=0.0
        akh=0.0
        am2=0.0
        al0=0.0
        do i=1,imax
         azi=azi+am*zi(i,k)
         adzi=adzi+am*(1.0/unsdzi(i,k))
         aq2=aq2+am*q2(i,k)
         al=al+am*long(i,k)
         akm=akm+am*km(i,k)
         akh=akh+am*kh(i,k)
         am2=am2+am*m2(i,k)
!         al0=al0+am*long0d(i)
        enddo
!        write(*,2001) k,azi,aq2,al,akm,akh,am2*1.0e5
 2001   format(2x,i3,6(2x,f9.3))
       enddo
!      endif

      return
      end
