 SUBROUTINE phyparam(ngrid,nlayer,nq,         &
&            firstcall,lastcall,              &
&            ptimestep,                       &
&            pplev,pplay,pphi,pphis,presnivs, &
&            pu,pv,pt,pq,                     &
&            pw,                              &
&            pdu,pdv,pdt,pdq,pdpsrf)


use comsaison
use mod_grid_phy_lmdz, only: klon_glo,nbp_lon,nbp_lat

use dimphy
use comgeomfi
use thermals_mod, only : thermal_plume,thermal_dq
use logic_mod, only : read_start
use iostart, only : open_startphy,close_startphy,get_field
use iostart, only : get_var
use iostart, only : open_restartphy, close_restartphy
use iostart, only : enddef_restartphy, put_field, put_var
use temps_mod, only : day_ini,annee_ref,day_ref
use temps_mod, only : jD_ref,jH_ref,start_time, calend
use soil_ini_mod, only : nsoilmx, soil_ini
use mod_phys_lmdz_para, only: klon_omp, is_mpi_root,klon_mpi_begin,scatter
use mod_phys_lmdz_omp_data, only :  is_omp_root
use netcdf, only : NF90_NOWRITE,NF90_OPEN,NF90_NOERR,NF90_INQ_VARID
use netcdf, only : NF90_CLOSE, NF90_GET_VAR
use regular_lonlat_mod, only: lon_reg, lat_reg
USE ioipsl_getin_p_mod, ONLY : getin_p
use vdif_ini, only : vdif_ini_




implicit none

!=======================================================================
!
!   subject:
!   --------
!
!   Organisation of the physical parametrisations of the LMD 
!   20 parameters GCM for planetary atmospheres.
!   It includes:
!   raditive transfer (long and shortwave) for CO2 and dust.
!   vertical turbulent mixing
!   convective adjsutment
!
!   author: Frederic Hourdin 15 / 10 /93
!   -------
!
!   arguments:
!   ----------
!
!   input:
!   ------
!
!    ngrid                 Size of the horizontal grid.
!                          All internal loops are performed on that grid.
!    nlayer                Number of vertical layers.
!    nq                    Number of advected fields
!    firstcall             True at the first call
!    lastcall              True at the last call
!                          equinoxe.
!    ptimestep             timestep (s)
!    pplay(ngrid,nlayer+1) Pressure at the middle of the layers (Pa)
!    pplev(ngrid,nlayer+1) intermediate pressure levels (pa)
!    pphi(ngrid,nlayer)    Geopotential at the middle of the layers (m2s-2)
!    pu(ngrid,nlayer)      u component of the wind (ms-1)
!    pv(ngrid,nlayer)      v component of the wind (ms-1)
!    pt(ngrid,nlayer)      Temperature (K)
!    pq(ngrid,nlayer,nq)   Advected fields
!    pudyn(ngrid,nlayer)    
!    pvdyn(ngrid,nlayer)      Dynamical temporal derivative for the
!    ptdyn(ngrid,nlayer)      corresponding variables
!    pqdyn(ngrid,nlayer,nq)
!    pw(ngrid,?)           vertical velocity
!
!   output:
!   -------
!
!    pdu(ngrid,nlayermx)        \
!    pdv(ngrid,nlayermx)         \  Temporal derivative of the corresponding
!    pdt(ngrid,nlayermx)         /  variables due to physical processes.
!    pdq(ngrid,nlayermx)      /
!    pdpsrf(ngrid)        /
!
!=======================================================================
!
!-----------------------------------------------------------------------
!
!    0.  Declarations :
!    ------------------

      !include "dimensions.h"
      !include "description.h"
      include "callkeys.h"
      include "comcstfi.h"
      include "planete.h"
      include "surface.h"

!    Arguments :
!    -----------

!    inputs:
!    -------
      integer :: ngrid,nlayer,nq

      real :: ptimestep,zdtime
      real, dimension(ngrid,nlayer+1) , intent(in)    :: pplev
      real, dimension(ngrid,nlayer)   , intent(in)    :: pplay,pphi,pu,pv,pt
      real, dimension(ngrid,nlayer)   , intent(out)   :: pdu,pdv
      real, dimension(ngrid,nlayer,nq), intent(inout) :: pq
      real, dimension(ngrid)          , intent(in)    :: pphis
!   dynamial tendencies
      real, dimension(ngrid,nlayer)    :: pdtdyn,pdudyn,pdvdyn,pw
      real, dimension(ngrid,nlayer,nq) :: pdqdyn

!     outputs:
!     --------

!   physical tendencies
      real, dimension(ngrid,nlayer)    :: pdt
      real, dimension(ngrid,nlayer,nq) :: pdq
      real, dimension(ngrid)           :: pdpsrf
      logical :: firstcall,lastcall,found

!    Local variables :
!    -----------------

      integer i,j,l,ig,ierr,aslun,nlevel,igout,it1,it2,isoil,iq,ipass
!
      real,dimension(ngrid) :: mu0,fract
      real :: zday,z1,z2
      real, dimension(ngrid,nlayer)   :: zh,zzlay
      real, dimension(ngrid,nlayer+1) :: zzlev
      real, dimension(ngrid,nlayer)   :: zdvfr,zdufr,zdhfr,zha,zdhdifv
      real, dimension(ngrid)          :: zdtsrf,zdtsrfr,zflubid,zpmer
      real, dimension(ngrid)          :: zplanck,zsrfsw,zsrflw,ztopupsw,ztopdnsw,ztoplw
      real, dimension(ngrid,nlayer)   :: zpopsk,masse
      real, dimension(ngrid,nlayer)   :: zdum1,zdum2,zdum3
      real, dimension(ngrid,nlayer)   :: zdtlw,zdtsw
      real,dimension(ngrid,nlayer)    :: e_th,d_th,d_t_ec
      real,dimension(ngrid,nlayer+1)  :: f_th,w_th,a_th
      real :: ztim1,ztim2,ztim3,zls,zinsol
      real, dimension(ngrid,nlayer,nq) :: zdqth

      character*2 str2
      character*8 namev
      character*3 nomq

      real, dimension(nq) :: factq,tauq



!   Local saved variables:
!   ----------------------

      real, save :: zday_last
!$OMP THREADPRIVATE( zday_last)

      REAL zps_av

      real,dimension(:,:),allocatable,save :: tsoil,tmp3d,dtrad,q2,u_seri,v_seri,t_seri
      real,dimension(:),allocatable,save   :: z_soil,tsurf,rnatur,capcal,fluxgrd
      real,dimension(:),allocatable,save   :: fluxrad,albedo,emissiv,z0m,z0h,inertie
      real,dimension(:),allocatable,save   :: zcdv,zcdh

      real,dimension(ngrid,nlayer+1) ::  kz_v,kz_h,richardson

      real,save :: solarcst=1370., tsoil_ini=250.
      real,save :: stephan=5.67e-08
      integer,parameter :: tab_cntrl_len=100
      REAL,save :: tab_cntrl(tab_cntrl_len)


!   Time
      integer,save :: rjourvrai
      REAL,save :: gmtime_in_seconds=0.


!$OMP THREADPRIVATE(tsurf,tsoil,rnatur)
!$OMP THREADPRIVATE(u_seri,v_seri,t_seri)
!$OMP THREADPRIVATE( tmp3d)
!$OMP THREADPRIVATE( z_soil)
!$OMP THREADPRIVATE( capcal,fluxgrd,dtrad,fluxrad)
!$OMP THREADPRIVATE( q2)
!$OMP THREADPRIVATE( albedo,emissiv,solarcst,z0m,z0h,inertie)
!$OMP THREADPRIVATE( zcdv,zcdh)
!$OMP THREADPRIVATE( stephan)
!$OMP THREADPRIVATE( tab_cntrl)
!$OMP THREADPRIVATE(rjourvrai,gmtime_in_seconds)

      real,save,dimension(:,:), allocatable :: temp_prev_timestep
!$OMP THREADPRIVATE(temp_prev_timestep)

      EXTERNAL vdif,convadj
      EXTERNAL orbite,mucorr
      EXTERNAL ismin,ismax


      integer        longcles
      parameter    ( longcles = 20 )
      REAL clesphy0( longcles      )
      REAL presnivs(nlayer)
      integer :: nid_relief,varid
      real, dimension(:,:), allocatable :: relief
      real, dimension(:), allocatable :: rnatur_glo

    INTEGER :: iim,iip1,jjm,jjp1,ip1jm,ip1jmp1,llm

! Some definition for grid size
    ip1jm=(nbp_lon+1)*(nbp_lat-1)
    ip1jmp1=(nbp_lon+1)*nbp_lat
    iim=nbp_lon
    iip1=nbp_lon+1
    jjp1=nbp_lat
    jjm=jjp1-1
    ip1jm=(nbp_lon+1)*(nbp_lat-1)
    ip1jmp1=(nbp_lon+1)*nbp_lat
    llm=klev


      igout=ngrid/2+1
      IF (lverbose) then
          PRINT*,'OK DANS PHYPARAM'
          PRINT*,'Tlay Play Plev'
          DO l=1,nlayer
             WRITE(*,'(3f15.5,2e15.2)') pt(igout,l),pplay(igout,l),pplev(igout,l)
          ENDDO
      ENDIF

!-----------------------------------------------------------------------
!    1. Initialisations :
!    --------------------

      nlevel=nlayer+1

      ! Definition de 5 traceurs idéalisés (potentiellement):
      ! Mais le nombre total de traceurs est controle par tracer.def
      ! Pour l'instant ne tourne qu'avec 2 traceurs
      ! car nqtot est imposé dans physiq_mod.F90
      ! if (.NOT.nq==2) STOP 'Il faut 4 traceurs'
      if ( nq >= 1 ) tauq(1)=1800.
      if ( nq >= 2 ) tauq(2)=10800.
      if ( nq >= 3 ) tauq(3)=86400.
      if ( nq >= 4 ) tauq(4)=864000.
      if ( nq >=1 )  factq(1:min(4,nq))= (1.-exp(-ptimestep/tauq(1:min(4,nq))))/ptimestep
      !print*,'FACTQ ',factq

      if (lverbose) then
         print*,'nq ',nq
         print*,'latitude0',ngrid,lati(1),lati(ngrid:ngrid)
         print*,'nlayer',nlayer
         print*,'size pdq ',ngrid*nlayer*4,ngrid*nlayer*nq,size(pdq),size(lati),size(pq),size(factq)
      endif

      pdq=0.
      do iq=1,min(4,nq)
          do l=1,nlayer
              pdq(1:ngrid,l,iq)=(1.+sin(lati(1:ngrid))-pq(1:ngrid,l,iq))*factq(iq)
          enddo
      enddo
      if ( nq >= 5 ) then
         do l=1,nlayer
            pdq(:,l,5)=1.+sin(lati(:))/ptimestep
         enddo
      endif

!--------------------------------------------------------------------------
      IF(firstcall) THEN
!--------------------------------------------------------------------------

         call vdif_ini_(cpp,r,g,rcp)
         call soil_ini
         allocate(temp_prev_timestep(ngrid,nlayer))
         print*,'WARNING : zps_av impose a 1e5 pour le rayonnement'
         PRINT*,'FIRSTCALL  ',read_start
         allocate(tsurf(ngrid))
         allocate (tsoil(ngrid,nsoilmx))
         allocate (z_soil(nsoilmx))
         allocate (rnatur(ngrid))
         allocate(capcal(ngrid),fluxgrd(ngrid))
         allocate(dtrad(ngrid,nlayer),fluxrad(ngrid))
         allocate(tmp3d(ngrid,nlayer))
         allocate(u_seri(ngrid,nlayer))
         allocate(v_seri(ngrid,nlayer))
         allocate(t_seri(ngrid,nlayer))
         allocate(q2(ngrid,nlayer+1))
         allocate(albedo(ngrid),emissiv(ngrid))
         allocate(z0m(ngrid),z0h(ngrid),inertie(ngrid))
         allocate(zcdv(ngrid),zcdh(ngrid))
         if (iflag_dyn == 0) then
             u_seri(:,:)=pu(:,:)
             v_seri(:,:)=pv(:,:)
             t_seri(:,:)=pt(:,:)
         endif
         temp_prev_timestep(:,:)=t_seri(:,:)
         zcdv=0. ; zcdh=0.
         IF (read_start) THEN
            CALL open_startphy('start_param.nc')
            CALL get_field("tsurf",tsurf)
            DO isoil=1,nsoilmx
               namev(1:5)='tsoil'
               write(namev(6:8),'(i3.3)') isoil
               CALL get_field(namev, tsoil(:,isoil))
               print*,'get_field',namev,tsoil(klon/2+1,isoil)
            ENDDO
            CALL get_var("controle", tab_cntrl)
            rjourvrai=NINT(tab_cntrl(1))
            CALL get_field("rnatur", rnatur)
            CALL get_field("capcal", capcal)
            CALL get_field("fluxgrd", fluxgrd)
            CALL get_field("dtrad", dtrad)
            CALL get_field("fluxrad", fluxrad)
            CALL get_field("q2", q2)
            CALL get_field("albedo", albedo)
            CALL get_field("emissiv", emissiv)
            CALL get_field("z0m", z0m)
            CALL get_field("z0h", z0h)
            CALL get_field("inertie", inertie)
            print*,"Apres get_field, rnatur", rnatur(klon/2+1)
            print*,"Apres get_field, capcal", capcal(klon/2+1)
            print*,"Apres get_field, fluxgrd", fluxgrd(klon/2+1)
            print*,"Apres get_field, dtrad", dtrad(klon/2+1,klev/2)
            print*,"Apres get_field, fluxrad", fluxrad(klon/2+1)
            print*,"Apres get_field, dtrad", dtrad(klon/2+1,klev/2)
            print*,"Apres get_field, q2", q2(klon/2+1,klev/2)
            print*,"Apres get_field, albedo", albedo(klon/2+1)
            print*,"Apres get_field, emissiv", emissiv(klon/2+1)
            print*,"Apres get_field, z0m", z0m(klon/2+1)
            print*,"Apres get_field, inertie", inertie(klon/2+1)
            CALL close_startphy

         ELSE

            ! Lecture d'un champ global 2D.
!!! !$OMP MASTER
            allocate(relief(size(lon_reg),size(lat_reg)))
            allocate(rnatur_glo(klon_glo))
            if (is_mpi_root .AND. is_omp_root) THEN
                ierr = NF90_OPEN ('relief_in_phys.nc', NF90_NOWRITE,nid_relief)
                if (ierr.EQ.NF90_NOERR) THEN
                    ierr=NF90_INQ_VARID(nid_relief,'RELIEF',varid)
                    if (ierr==NF90_NOERR) THEN
                         ierr=NF90_GET_VAR(nid_relief,varid,relief)
                    else
                         CALL abort_physic ('iniphyparam','variable RELIEF pas la',1)
                    endif
                endif
                ierr = NF90_CLOSE (nid_relief)
                rnatur_glo(1)=min(int(relief(1,1))/10,1)
                do j=2,jjm
                    do i=1,iim
                        rnatur_glo(1+(j-2)*size(lon_reg)+i)=min(int(relief(i,j))/10,1)
                    enddo
                enddo
                rnatur_glo(klon_glo)=min(int(relief(1,jjm+1))/10,1)
                !print*,'XXX relief',minval(relief),maxval(relief)
                !print*,'XXX rnatur_glo',minval(rnatur_glo),maxval(rnatur_glo)
                !print*,'XXX klon_glo=',klon_glo
            endif
            call Scatter(rnatur_glo,rnatur)
            !rnatur=rnatur_glo

!!! !$OMP END MASTER
!$OMP BARRIER
            rjourvrai=0
            q2=1.e-10
            CALL getin_p('tsoil_ini',tsoil_ini)
            tsurf=tsoil_ini
            tsoil=tsoil_ini
         ENDIF

         !print*,'PROC ',is_mpi_root,is_omp_root
         !stop 'Moment'
         emissiv(:)=(1.-rnatur(:))*emi_mer+rnatur(:)*emi_ter
         inertie(:)=(1.-rnatur(:))*I_mer+rnatur(:)*I_ter
         albedo(:)=(1.-rnatur(:))*alb_mer+rnatur(:)*alb_ter
         z0m(:)=(1.-rnatur(:))*z0m_mer+rnatur(:)*z0m_ter
         z0h(:)=0.1*z0m(:)

         if (lverbose) THEN
            print*,tsoil(ngrid/2+1,nsoilmx/2+2)
            print*,'TS ',tsurf(igout),tsoil(igout,5)
         ENDIF
         CALL iniorbit(aphelie,periheli,year_day,peri_day,obliquit)
         if (.not.callrad) fluxrad(1:ngrid)=0.
!     print*,'OK PHYPARAM 1 '
         IF(callsoil) THEN
      print*,'SIZEB ',size(z_soil)
            CALL soil(ngrid,nsoilmx,firstcall,inertie,ptimestep,tsurf,tsoil,capcal,fluxgrd,z_soil)
         ELSE
            PRINT*,'WARNING!!! Thermal conduction in the soil turned off'
            DO ig=1,ngrid
               capcal(ig)=1.e5
               fluxgrd(ig)=0.
            ENDDO
         ENDIF
!        CALL inifrict(ptimestep)
         call iophys_ini(period_sort*unjours)
         e_th=0.
         f_th=0.
         zday_last=rjourvrai+NINT(gmtime_in_seconds-ptimestep)/unjours

!--------------------------------------------------------------------------
      ENDIF ! fisrtcall
!--------------------------------------------------------------------------



      gmtime_in_seconds=gmtime_in_seconds+ptimestep
      IF (gmtime_in_seconds>=unjours) THEN
         gmtime_in_seconds=gmtime_in_seconds-unjours
         rjourvrai=rjourvrai+1
      ENDIF
      zday=rjourvrai+NINT(gmtime_in_seconds)/unjours

      IF (lverbose) THEN
         print*,'rjourvrai=',rjourvrai,zday
         print*,'tsurf ',tsurf(klon/2+1),firstcall
      ENDIF

      if (lverbose) PRINT*,'FIRSTCALL AP '
      IF (ngrid.NE.ngridmax) THEN
         PRINT*,'STOP in inifis'
         PRINT*,'Probleme de dimenesions :'
         PRINT*,'ngrid     = ',ngrid
         PRINT*,'ngridmax   = ',ngridmax
         STOP
      ENDIF

      DO l=1,nlayer
         DO ig=1,ngrid
            pdu(ig,l)=0.
            pdv(ig,l)=0.
            pdt(ig,l)=0.
         ENDDO
      ENDDO

      if (iflag_dyn == 1) then
         do l=1,nlayer
            do ig=1,ngrid
               u_seri(ig,l)=pu(ig,l)
               v_seri(ig,l)=pv(ig,l)
               t_seri(ig,l)=pt(ig,l)
            enddo
         enddo
      endif

      DO ig=1,ngrid
         pdpsrf(ig)=0.
         zflubid(ig)=0.
         zdtsrf(ig)=0.
      ENDDO

!-----------------------------------------------------------------------
!   calcul du geopotentiel aux niveaux intercouches
!   ponderation des altitudes au niveau des couches en dp/p
!-----------------------------------------------------------------------

      DO l=1,nlayer
         DO ig=1,ngrid
            zzlay(ig,l)=pphi(ig,l)/g
         ENDDO
      ENDDO
      DO ig=1,ngrid
         zzlev(ig,1)=0.
      ENDDO
      DO l=2,nlayer
         DO ig=1,ngrid
            z1=(pplay(ig,l-1)+pplev(ig,l))/(pplay(ig,l-1)-pplev(ig,l))
            z2=(pplev(ig,l)+pplay(ig,l))/(pplev(ig,l)-pplay(ig,l))
            zzlev(ig,l)=(z1*zzlay(ig,l-1)+z2*zzlay(ig,l))/(z1+z2)
         ENDDO
      ENDDO

!-----------------------------------------------------------------------
!   Transformation de la temperature en temperature potentielle
      DO l=1,nlayer
         DO ig=1,ngrid
            zpopsk(ig,l)=(pplay(ig,l)/pplev(ig,1))**rcp
            masse(ig,l)=(pplev(ig,l)-pplev(ig,l+1))/g
         ENDDO
      ENDDO
      DO l=1,nlayer
         DO ig=1,ngrid
            zh(ig,l)=t_seri(ig,l)/zpopsk(ig,l)
         ENDDO
      ENDDO

!-----------------------------------------------------------------------
!    2. Calcul of the radiative tendencies :
!    ---------------------------------------

      ! print*,'callrad0' ; STOP
      IF(callrad) THEN
!     print*,'callrad'

!   WARNING !!! on calcule le ray a chaque appel

            CALL solarlong(zday,zls)
            CALL orbite(zls,dist_sol,declin)
            if (lverbose) print*,'iflag_diurnal=',iflag_diurnal
            if (iflag_diurnal==1) then

                if ( 1.eq.1 ) then
                        ztim1=SIN(declin)
                        ztim2=COS(declin)*COS(2.*pi*(zday-.5))
                        ztim3=-COS(declin)*SIN(2.*pi*(zday-.5))
!                    call dump2d(iim,jjm-1,lati(2),'LATI  0   ')
!                    call dump2d(iim,jjm-1,long(2),'LONG  0   ')
!                    call dump2d(iim,jjm-1,sinlon(2),'sinlon0   ')
!                    call dump2d(iim,jjm-1,coslon(2),'coslon0   ')
!                    call dump2d(iim,jjm-1,sinlat(2),'sinlat   ')
!                    call dump2d(iim,jjm-1,coslat(2),'coslat   ')
!                  print*,'OK diurnal 0',lverbose
                   CALL solang(ngrid,sinlon,coslon,sinlat,coslat,ztim1,ztim2,ztim3,mu0,fract)
                else
                   zdtime=ptimestep*float(iradia)
                   CALL zenang(zls,gmtime_in_seconds/unjours,zdtime,lati,long,mu0,fract)
                   if (lverbose) print*,'ZENANG '
                endif

                if (lverbose) THEN
                   PRINT*,'day, declin, sinlon,coslon,sinlat,coslat',zday, declin,sinlon(igout),coslon(igout),sinlat(igout),coslat(igout)
                endif
            else if (iflag_diurnal==0) then
                if (lverbose) print*,'declin,ngrid,rad',declin,ngrid,rad
!               call dump2d(iim,jjm-1,lati(2),'LATI      ')
                CALL mucorr(ngrid,declin,lati,mu0,fract,10000.,rad)
            else
                fract(:)=0.5
                !mu0=0.5*(1+cos(lati(:))*cos(lati(:)))
                mu0=0.5*(1+cos(lati(:)))
            endif
!           print*,'orbite:mu0,fract',mu0,fract

!           call dump2d(iim,jjm-1,fract(2),'FRACT A   ')
!           call dump2d(iim,jjm-1,mu0(2),'MU0 A     ')


!    2.2 Calcul of the radiative tendencies and fluxes:
!    --------------------------------------------------

!  2.1.2 levels

            zinsol=solarcst/(dist_sol*dist_sol)
            if (lverbose) then
               print*,iim,jjm,llm,ngrid,nlayer,ngridmax,nlayer
               print*,'iim,jjm,llm,ngrid,nlayer,ngridmax,nlayer'
!           call dump2d(iim,jjm-1,albedo(2),'ALBEDO    ')
!           call dump2d(iim,jjm-1,mu0(2),'MU0       ')
               call dump2d(iim,jjm-1,fract(2),'FRACT     ')
!           call dump2d(iim,jjm-1,lati(2),'LATI      ')
            endif
            zps_av=1.e5
            if (firstcall) then
               print*,'WARNING ps_rad impose'
            endif
            CALL sw(ngrid,nlayer,iflag_diurnal,coefvis,albedo, &
     &              pplev,zps_av,                        &
     &              mu0,fract,zinsol,                    &
     &              ztopdnsw,ztopupsw,zsrfsw,zdtsw,      &
     &              lverbose)
!           call dump2d(iim,jjm-1,zsrfsw(2),'SWS 1     ')
!           stop

            IF (lverbose) then
                PRINT*,'AVANT LW'
                PRINT*,'Tlay Play Plev dT/dt SW dT/dt LW (K/day)'
                DO l=1,nlayer
                   WRITE(*,'(3f15.5,2e15.2)') t_seri(igout,l),pplay(igout,l),pplev(igout,l)
                ENDDO
            ENDIF

            CALL lw(ngrid,nlayer,coefir,emissiv,  &
     &             pplev,zps_av,tsurf,t_seri,         &
     &             ztoplw,zsrflw,zdtlw,           &
     &             lverbose) 


!    2.4 total flux and tendencies:
!    ------------------------------

!    2.4.1 fluxes

            DO ig=1,ngrid
               fluxrad(ig)=emissiv(ig)*zsrflw(ig)+zsrfsw(ig)*(1.-albedo(ig))
               zplanck(ig)=tsurf(ig)*tsurf(ig)
               zplanck(ig)=emissiv(ig)*stephan*zplanck(ig)*zplanck(ig)
               fluxrad(ig)=fluxrad(ig)-zplanck(ig)
            ENDDO

!    2.4.2 temperature tendencies

            DO l=1,nlayer
               DO ig=1,ngrid
                  dtrad(ig,l)=zdtsw(ig,l)+zdtlw(ig,l)
               ENDDO
            ENDDO

!        ENDIF

!    2.5 Transformation of the radiative tendencies:
!    -----------------------------------------------

         DO l=1,nlayer
            DO ig=1,ngrid
               pdt(ig,l)=pdt(ig,l)+dtrad(ig,l)
            ENDDO
         ENDDO

         IF(lverbose) THEN
            PRINT*,'Diagnotique for the radaition'
            PRINT*,'albedo, emissiv, mu0,fract,Frad,Planck'
            PRINT*,albedo(igout),emissiv(igout),mu0(igout),fract(igout),fluxrad(igout),zplanck(igout)
            PRINT*,'Tlay Play Plev dT/dt SW dT/dt LW (K/day)'
            PRINT*,'unjours',unjours
            DO l=1,nlayer
               WRITE(*,'(3f15.5,2e15.2)') t_seri(igout,l),pplay(igout,l),pplev(igout,l),zdtsw(igout,l),zdtlw(igout,l)
            ENDDO
         ENDIF


      ENDIF

!-----------------------------------------------------------------------
!    3. Vertical diffusion (turbulent mixing):
!    -----------------------------------------
!
      IF(calldifv) THEN

         DO ig=1,ngrid
            zflubid(ig)=fluxrad(ig)+fluxgrd(ig)
         ENDDO

         CALL zerophys(ngrid*nlayer,zdum1)
         CALL zerophys(ngrid*nlayer,zdum2)
         do l=1,nlayer
            do ig=1,ngrid
               zdum3(ig,l)=pdt(ig,l)/zpopsk(ig,l)
            enddo
         enddo

         CALL vdif(ngrid,nlayer,                               &
     &        ptimestep,capcal,z0m,z0h,                        &
     &        pplay,pplev,zzlay,zzlev,                         &
     &        u_seri,v_seri,zh,tsurf,emissiv,                          &
     &        zdum1,zdum2,zdum3,zflubid,                       &
     &        zdufr,zdvfr,zdhfr,zdtsrfr,q2,kz_v,kz_h,      &
     &        richardson,zcdv,zcdh,                             &
     &        lverbose)

         DO l=1,nlayer
            DO ig=1,ngrid
               pdv(ig,l)=pdv(ig,l)+zdvfr(ig,l)
               pdu(ig,l)=pdu(ig,l)+zdufr(ig,l)
               pdt(ig,l)=pdt(ig,l)+zdhfr(ig,l)*zpopsk(ig,l)
            ENDDO
         ENDDO
         zdhdifv=zdhfr

         DO ig=1,ngrid
            zdtsrf(ig)=zdtsrf(ig)+zdtsrfr(ig)
         ENDDO

      ELSE
         zdvfr=0.
         zdufr=0.
         zdhfr=0.
         zdhdifv=0.
         kz_v=0. ; kz_h=0. ; q2=0.
         DO ig=1,ngrid
            zdtsrf(ig)=zdtsrf(ig)+(fluxgrd(ig)+fluxrad(ig))/capcal(ig)
         ENDDO
      ENDIF
      if (lverbose) print*,'callradA'
!
!-----------------------------------------------------------------------
!   4. Dry convective adjustment:
!   -----------------------------

      IF(calladj) THEN

         DO l=1,nlayer
            DO ig=1,ngrid
               zdum1(ig,l)=pdt(ig,l)/zpopsk(ig,l)
            ENDDO
         ENDDO
         zdufr(:,:)=0.
         zdvfr(:,:)=0.
         zdhfr(:,:)=0.
         CALL convadj(ngrid,nlayer,ptimestep,  &
     &                pplay,pplev,zpopsk,      &
     &                u_seri,v_seri,zh,                &
     &                pdu,pdv,zdum1,           &
     &                zdufr,zdvfr,zdhfr)

         DO l=1,nlayer
            DO ig=1,ngrid
               pdu(ig,l)=pdu(ig,l)+zdufr(ig,l)
               pdv(ig,l)=pdv(ig,l)+zdvfr(ig,l)
               pdt(ig,l)=pdt(ig,l)+zdhfr(ig,l)*zpopsk(ig,l)
            ENDDO
         ENDDO

      ENDIF

!-----------------------------------------------------------------------
!   4.1 Themal plume model
!   ----------------------

      zdufr(:,:)=0.
      zdvfr(:,:)=0.
      zdhfr(:,:)=0.
      f_th(:,:)=0.
      e_th(:,:)=0.
      d_th(:,:)=0.
      w_th(:,:)=0.

      IF(iflag_thermals>0) THEN

         DO l=1,nlayer
            DO ig=1,ngrid
               zdum1(ig,l)=pdt(ig,l)/zpopsk(ig,l)
            ENDDO
         ENDDO
         if ( iflag_thermals == 1 ) then
            CALL thermal_plume(ngrid,nlayer,ptimestep,   &
     &               pplay,pplev,zzlay,zzlev,zpopsk,     &
     &               zh+ptimestep*pdt/zpopsk,            &
     &               f_th,e_th,d_th,w_th,lverbose)

            if (lverbose) print*,'ptimestep ',ptimestep
            CALL thermal_dq(ngrid,nlayer,ptimestep,f_th,e_th,   &
     &           masse,zh+ptimestep*pdt/zpopsk,zdhfr,zha,lverbose)
          else
            !pq=0.
            CALL thermcell_2002(ngrid, nlayer, ptimestep,          &
     &           iflag_thermals, pplay,                            &
     &           pplev, pphi, u_seri+ptimestep*pdu, v_seri+ptimestep*pdv,  &
     &           t_seri+ptimestep*pdt, pq,                             &
     &           zdufr, zdvfr, zdhfr, zdqth, f_th, e_th,             &
     &           a_th, w_th, 2., 40., 0, 1800.)
          endif

          DO l=1,nlayer
             DO ig=1,ngrid
                pdu(ig,l)=pdu(ig,l)+zdufr(ig,l)
                pdv(ig,l)=pdv(ig,l)+zdvfr(ig,l)
                pdt(ig,l)=pdt(ig,l)+zdhfr(ig,l)*zpopsk(ig,l)
             ENDDO
          ENDDO

      ENDIF

      if ( iflag_conserv > 0 ) then
          CALL ener_conserv(ngrid,nlayer,ptimestep,masse,u_seri,v_seri,t_seri,    &
     &        pdu,pdv,(zdhfr+zdhdifv)*zpopsk,zpopsk,d_t_ec)
          pdt=pdt+d_t_ec
      else
          d_t_ec=0.
      endif

! subroutine ener_conserv(klon,klev,pdtphys,masse,uwnd,vwnd,temp,d_u,d_v,d_t,exner,d_t_ec)

!-----------------------------------------------------------------------
!   On incremente les tendances physiques de la temperature du sol:
!   ---------------------------------------------------------------

      DO ig=1,ngrid
         tsurf(ig)=tsurf(ig)+ptimestep*zdtsrf(ig) 
      ENDDO
      DO l=1,nlayer
         DO ig=1,ngrid
            u_seri(ig,l)=u_seri(ig,l)+pdu(ig,l)*ptimestep
            v_seri(ig,l)=v_seri(ig,l)+pdv(ig,l)*ptimestep
            t_seri(ig,l)=t_seri(ig,l)+pdt(ig,l)*ptimestep
         ENDDO
      ENDDO

      !WRITE(55,'(2e15.5)') zday,tsurf(ngrid/2+1)

!-----------------------------------------------------------------------
!   soil temperatures:
!   --------------------


      IF (callsoil) THEN
         CALL soil(ngrid,nsoilmx,.false.,inertie,              &
     &          ptimestep,tsurf,tsoil,capcal,fluxgrd,z_soil)
         IF(lverbose) THEN
            print*,'AAA lverbose=',lverbose
            PRINT*,'Surface Heat capacity,conduction Flux, Ts,dTs, dt'
            PRINT*,capcal(igout),fluxgrd(igout),tsurf(igout),zdtsrf(igout),ptimestep
         ENDIF
      ENDIF
!     print*,'ATTENTION Ts imposee'
!     tsoil=300.
!     tsurf=300.

!-----------------------------------------------------------------------
!   sorties:
!   --------

!           call dump2d(iim,jjm-1,zsrfsw(2),'SWS 2     ')
      !if (lverbose) print*,'zday, zday_last ',zday,zday_last,period_sort,abs(zday-zday_last-period_sort),ptimestep/unjours/10.
      if (lverbose)                                           &
     & print*,'zday, zday_last ',zday,zday_last,period_sort,  &
     & unjours,ptimestep,                                     &
     & abs(zday-zday_last-period_sort),ptimestep/unjours/10.

! Controle de la frequence de sorties
      if(abs(zday-zday_last-period_sort)<=ptimestep/unjours/10. &
     &       .OR. period_sort==0. ) then

         if(lverbose) print*,'zday, zday_last SORTIE ',zday,zday_last
         zday_last=zday
         !  Ecriture/extension de la coordonnee temps
  
         !print*,'valeur de r'
         !print*,'valeur ',r
         !print*,'valeur ',pphi(1,1)
         !print*,'valeur ',pplev(1,1)
           do ig=1,ngridmax
              zpmer(ig)=pplev(ig,1)*exp(pphi(ig,1)/(r*285.))
           enddo
  
         if ( io_meteo >= 0 ) then

            if ( io_meteo == 1 ) then
               l=1
            else
               l=llm
            endif

            call iophys_ecrit('u',l,'Vent zonal moy','m/s',u_seri)
            call iophys_ecrit('v',l,'Vent meridien moy','m/s',v_seri)
            call iophys_ecrit('temp',l,'Temperature','K',t_seri)
            call iophys_ecrit('theta',l,'Temperature pot.','K',zh)
            call iophys_ecrit('geop',l,'Geopotential','m2/s2',pphi)
            call iophys_ecrit('plev',l,'plev','Pa',pplev(:,1:nlayer))

            call iophys_ecrit('ts',1,'Surface temper','K',tsurf)
            call iophys_ecrit('Inertie',1,'I','sI',inertie)
            call iophys_ecrit('zsrf',1,'z','m',pphis/g)
            call iophys_ecrit('ps',1,'Surface pressure','Pa',pplev)
            call iophys_ecrit('slp',1,'Sea level pressure','Pa',zpmer)
            call iophys_ecrit('swtopup',1,'SW top up','Pa',ztopupsw)
            call iophys_ecrit('swtopdn',1,'SW top dn','Pa',ztopdnsw)
            call iophys_ecrit('lwtop',1,'LW top','Pa',ztoplw)
            call iophys_ecrit('swsrfdn',1,'SW surf','Pa',zsrfsw)
            call iophys_ecrit('lwsrfdn',1,'LW surf','Pa',zsrflw)
            call iophys_ecrit('fluxgrd',1,'grd heat flx','W/M2',fluxgrd)
            call iophys_ecrit('cdh',1,'Drag coef','',zcdh)
            call iophys_ecrit('cdv',1,'Drag coef','',zcdv)
            call iophys_ecrit('fluxrad',1,'net surf rad','W/M2',fluxrad)
         endif

     
         if ( io_tend > 0 ) then
            call iophys_ecrit('du',llm,'du',' ',pdu)
            call iophys_ecrit('dv',llm,'du',' ',pdv)
            call iophys_ecrit('dt',llm,'dt',' ',pdt)
            call iophys_ecrit('dtec',llm,'dtec',' ',d_t_ec)
            call iophys_ecrit('dtthe',llm,'dt_the',' ',zdhfr*zpopsk)
            call iophys_ecrit('dtvdf',llm,'dt_vdf',' ',zdhdifv*zpopsk)
            call iophys_ecrit('dtsw',llm,'dtsw',' ',zdtsw)
            call iophys_ecrit('dtlw',llm,'dtlw',' ',zdtlw)
            call iophys_ecrit('dtdyn',llm,'dtdyn',' ',(pt-temp_prev_timestep)/ptimestep)
         endif

         if ( io_soil > 0 ) then
            !--------------------------------------------------------------
            ! Bidouilles pour sortir les variables de sol alors
            ! que la grille verticale est differentes
            !--------------------------------------------------------------
            tmp3d=0.
            tmp3d(:,1:min(llm,nsoilmx))=tsoil(:,1:min(llm,nsoilmx))
            IF (sin(lati(1))> 0.9999.and.ngrid>1) THEN
               ! on stoke les niveaux verticaux au pole N
               tmp3d(1,1:min(llm,nsoilmx))=z_soil(1:min(llm,nsoilmx))
            ENDIF
            call iophys_ecrit('tsoil',llm,'tsoil',' ',tmp3d)
            if ( ngrid == 1 ) then
               tmp3d=0.
               tmp3d(1,1:min(llm,nsoilmx))=z_soil(1:min(llm,nsoilmx))
               call iophys_ecrit('zsoil',llm,'zsoil',' ',tmp3d)
            endif
            !--------------------------------------------------------------
         endif
     

         if ( io_intern > 0 ) then

              do iq=1,nq
                 nomq="tr."
                 write(nomq(3:3),'(i1.1)') iq
                 call iophys_ecrit(nomq,llm,nomq,' ',pq(:,:,iq))
              enddo

              call iophys_ecrit('f_th',llm,'f thermals','',f_th)
              call iophys_ecrit('e_th',llm,'e thermals','',e_th)
              call iophys_ecrit('d_th',llm,'d thermals','',d_th)
              call iophys_ecrit('w_th',llm,'W thermals','m/s',w_th)
              call iophys_ecrit('kz_v',llm,'Kz','m2/s2',kz_v)
!              call iophys_ecrit('ri',llm,'ri','',richardson)
  
              call iophys_ecrit('coslon',1,'coslon',' ',coslon)
              call iophys_ecrit('sinlon',1,'sinlon',' ',sinlon)
              call iophys_ecrit('coslat',1,'coslat',' ',coslat)
              call iophys_ecrit('sinlat',1,'sinlat',' ',sinlat)
              call iophys_ecrit('mu0',1,'mu0',' ',mu0)
              call iophys_ecrit('alb',1,'alb',' ',albedo)
              call iophys_ecrit('fract',1,'fract',' ',fract)

         endif

      endif

      ! Temperature after adding physical tendency
      ! stored for next time step to estimate the contribution
      ! from dynamics
      temp_prev_timestep(:,:)=pt(:,:)+ptimestep*pdt(:,:)

!-----------------------------------------------------------------------
      IF(lastcall) THEN
         call iotd_fin
         PRINT*,'Ecriture du fichier de reinitialiastion de la physique'
         print*,'FIN0'
         CALL open_restartphy('restart_param.nc')
                  print*,'FIN1'
         DO ipass=1,2   ! pass=1 netcdf definition ; pass=2 netcdf write
            CALL put_field(ipass, "tsurf", "tsurf", tsurf)
            DO isoil=1,nsoilmx
               namev(1:5)='tsoil'
               write(namev(6:8),'(i3.3)') isoil
               CALL put_field(ipass, namev, namev, tsoil(:,isoil))
            ENDDO
            tab_cntrl(1)=zday
            CALL put_var(ipass, "controle", "Param controle", tab_cntrl)
            CALL put_field(ipass, "rnatur", "rnatur", rnatur)
            CALL put_field(ipass, "capcal", "capcal", capcal)
            CALL put_field(ipass, "fluxgrd", "fluxgrd", fluxgrd)
            CALL put_field(ipass, "dtrad", "dtrad", dtrad)
            CALL put_field(ipass, "fluxrad", "fluxrad", fluxrad)
            CALL put_field(ipass, "q2", "q2", q2)
            CALL put_field(ipass, "albedo", "albedo", albedo)
            CALL put_field(ipass, "emissiv", "emissiv", emissiv)
            CALL put_field(ipass, "z0m", "z0m", z0m)
            CALL put_field(ipass, "z0h", "z0h", z0h)
            CALL put_field(ipass, "inertie", "inertie", inertie)
            IF (ipass==1) CALL enddef_restartphy
            IF (ipass==2) CALL close_restartphy
         ENDDO

      ENDIF




      if (lverbose) print*,'callradB'

      RETURN
      END
