      SUBROUTINE sw(ngrid,nlayer,iflag_diurn,
     s              coefvis,albedo,
     s              plevel,ps_rad,pmu,pfract,psolarf0,
     s              ftopdnvis,ftopupvis,fsrfvis,dtsw,
     s              lwrite)
      IMPLICIT NONE
c=======================================================================
c
c   Rayonnement solaire en atmosphere non diffusante avec un 
c   coefficient d'absoprption gris.
c
c=======================================================================
c
c   declarations:
c   -------------
c
#include "comcstfi.h"
c
c   arguments:
c   ----------
c
      INTEGER ngrid,nlayer,iflag_diurn
      REAL albedo(ngrid),coefvis
      REAL pmu(ngrid),pfract(ngrid)
      REAL plevel(ngrid,nlayer+1),ps_rad
      REAL psolarf0
      REAL fsrfvis(ngrid),dtsw(ngrid,nlayer)
      REAL ftopupvis(ngrid)
      REAL ftopdnvis(ngrid)
      LOGICAL lwrite
c
c   variables locales:
c   ------------------
c

      REAL zalb(ngrid),zmu(ngrid),zfract(ngrid)
      REAL zplev(ngrid,nlayer+1)
      REAL zflux(ngrid),zdtsw(ngrid,nlayer)

      INTEGER ig,l,nlevel,reindex(ngrid),ncount,igout
      REAL ztrdir(ngrid,nlayer+1),ztrref(ngrid,nlayer+1)
      REAL zfsrfref(ngrid)
      REAL z1(ngrid)
      REAL zu(ngrid,nlayer+1)
      REAL tau0

      LOGICAL firstcall
      SAVE firstcall
      DATA firstcall/.true./
!$OMP THREADPRIVATE(firstcall)

c-----------------------------------------------------------------------
c   1. initialisations:
c   -------------------

      !lwrite=.true.
 
      nlevel=nlayer+1

c-----------------------------------------------------------------------
c   Definitions des tableaux locaux pour les points ensoleilles:
c   ------------------------------------------------------------

      !Initialisation à 0 ajoutées pour le mode debug. Sans trop de vérifications ...
      zfract=0.
      zmu=0.
      zalb=0.
      zmu=0.
      ztrdir=0.
      zfsrfref=0.
      ztrref=0.
      !Initialisation à 0 ajoutées pour le mode debug. Sans trop de vérifications ...


      IF (iflag_diurn==1) THEN
         ncount=0
         DO ig=1,ngrid
            reindex(ig)=0
         ENDDO
         DO ig=1,ngrid
            IF(pfract(ig).GT.1.e-6) THEN
               ncount=ncount+1
               reindex(ncount)=ig
            ENDIF
         ENDDO
         !print*,'avant gather ncount',ncount,'ngrid',ngrid
         CALL monGATHER(ngrid,ncount,zfract,pfract,reindex)
         !print*,'apres gather ncount',ncount,'ngrid',ngrid
         CALL monGATHER(ngrid,ncount,zmu,pmu,reindex)
         CALL monGATHER(ngrid,ncount,zalb,albedo,reindex)
         DO l=1,nlevel
            CALL monGATHER(ngrid,ncount,zplev(1,l),plevel(1,l),reindex)
         ENDDO
      ELSE
         ncount=ngrid
         zfract(:)=pfract(:)
         zmu(:)=pmu(:)
         zalb(:)=albedo(:)
         zplev(:,:)=plevel(:,:)
      ENDIF

c-----------------------------------------------------------------------
c   calcul des profondeurs optiques integres depuis p=0:
c   ----------------------------------------------------

      tau0=-.5*log(coefvis)

c calcul de la partie homogene de l'opacite
      tau0=tau0/ps_rad
      DO l=1,nlayer+1
         DO ig=1,ncount
            zu(ig,l)=tau0*zplev(ig,l)
         ENDDO
      ENDDO

c-----------------------------------------------------------------------
c   2. calcul de la transmission depuis le sommet de l'atmosphere:
c   -----------------------------------------------------------

      DO l=1,nlevel
         DO ig=1,ncount
            ztrdir(ig,l)=exp(-zu(ig,l)/zmu(ig))
         ENDDO
      ENDDO
      DO ig=1,ncount
         if (ztrdir(ig,nlevel).NE.1.) THEN
                 print*,'ztrdir(ig,nlevel)=',ztrdir(ig,nlevel)
                 stop 'BLA'
         ENDIF
      ENDDO

      igout=ncount/2+1
c      print*,'igout=',igout
      IF (lwrite) THEN
         PRINT*
         PRINT*,'Diagnostique des transmission dans le spectre solaire'
         PRINT*,'zfract, zmu, zalb'
         PRINT*,zfract(igout), zmu(igout), zalb(igout)
         PRINT*,'Pression, quantite d abs, transmission'
         DO l=1,nlayer+1
            PRINT*,zplev(igout,l),zu(igout,l),ztrdir(igout,l)
         ENDDO
      ENDIF

c-----------------------------------------------------------------------
c   3. taux de chauffage, ray. solaire direct:
c   ------------------------------------------

      DO l=1,nlayer
         DO ig=1,ncount
            zdtsw(ig,l)=g*psolarf0*zfract(ig)*zmu(ig)*
     s                     (ztrdir(ig,l+1)-ztrdir(ig,l))/
     s                     (cpp*(zplev(ig,l)-zplev(ig,l+1)))
         ENDDO
      ENDDO

      if ( 1 == 0 ) then
         print*,'sw pfract OK0 ',pfract(1:ngrid)
         print*,'sw zfract OK0 ',zfract(1:ncount)
         print*,'sw zmu OK0 ',zmu(1:ncount)
         print*,'sw ztrdir 1 OK0 ',ztrdir(1:ncount,1)
         print*,'sw ztrdir 2 OK0 ',ztrdir(1:ncount,2)
         print*,'sw zplev 1 OK0 ',zplev(1:ncount,1)
         print*,'sw zplev 2 OK0 ',zplev(1:ncount,2)
         print*,'sw zdtsw OK0 ',zdtsw(1:ncount,1)
         CALL abort_physic("OK0","Et merde",1)
      endif
      IF (lwrite) THEN
         PRINT*
         PRINT*,'Diagnostique des taux de chauffage solaires:'
         PRINT*,' 1 taux de chauffage lie au ray. solaire  direct'
         DO l=1,nlayer
            PRINT*,zdtsw(igout,l)
         ENDDO
      ENDIF


c-----------------------------------------------------------------------
c   4. calcul du flux solaire arrivant sur le sol:
c   ----------------------------------------------

      DO ig=1,ncount
         z1(ig)=zfract(ig)*zmu(ig)*psolarf0*ztrdir(ig,1)
         zflux(ig)=(1.-zalb(ig))*z1(ig)
         zfsrfref(ig)=    zalb(ig)*z1(ig)
      ENDDO
      IF (lwrite) THEN
         PRINT*
         PRINT*,'Diagnostique des taux de chauffage solaires:'
         PRINT*,' 2 flux solaire net incident sur le sol'
         PRINT*,zflux(igout)
      ENDIF


c-----------------------------------------------------------------------
c   5.calcul des traansmissions depuis le sol, cas diffus:
c   ------------------------------------------------------

      DO l=1,nlevel
         DO ig=1,ncount
            ztrref(ig,l)=exp(-(zu(ig,1)-zu(ig,l))*1.66)
         ENDDO
      ENDDO

      IF (lwrite) THEN
         PRINT*
         PRINT*,'Diagnostique des taux de chauffage solaires'
         PRINT*,' 3 transmission avec les sol'
         PRINT*,'niveau     transmission'
         DO l=1,nlevel
            PRINT*,l,ztrref(igout,l)
         ENDDO
      ENDIF

c-----------------------------------------------------------------------
c   6.ajout a l'echauffement de la contribution du ray. sol. reflechit: 
c   -------------------------------------------------------------------

      DO l=1,nlayer
         DO ig=1,ncount
            zdtsw(ig,l)=zdtsw(ig,l)+
     s      g*zfsrfref(ig)*(ztrref(ig,l+1)-ztrref(ig,l))/
     s      (cpp*(zplev(ig,l+1)-zplev(ig,l)))
         ENDDO
      ENDDO
c      l=1
c         print*,'DTSW ref ',l,86400*
c     s      g*zfsrfref(igout)*(ztrref(igout,l+1)-ztrref(igout,l))/
c     s      (cpp*(zplev(igout,l+1)-zplev(igout,l))),zfsrfref(igout),
c     s      z1(igout),zfract(igout),zmu(igout)

         !print*,'sw zdtsw OK1 ',zdtsw(1:ncount,1)
c-----------------------------------------------------------------------
c   10. sorites eventuelles:
c   ------------------------

      IF (lwrite) THEN
         PRINT*
         PRINT*,'Diagnostique des taux de chauffage solaires:'
         PRINT*,' 3 taux de chauffage total'
         DO l=1,nlayer
            PRINT*,zdtsw(igout,l)
         ENDDO
      ENDIF

      IF (iflag_diurn==1) THEN
         CALL zerophys(ngrid,fsrfvis)
         CALL zerophys(ngrid,ftopupvis)
         CALL zerophys(ngrid,ftopdnvis)
         CALL monscatter(ngrid,ncount,fsrfvis,reindex,z1)
         CALL monscatter(ngrid,ncount,ftopdnvis,reindex
     s   ,zfract*zmu*psolarf0)
         CALL monscatter(ngrid,ncount,ftopupvis,reindex
     s   ,zfsrfref(:)*ztrref(:,nlevel))
         CALL zerophys(ngrid*nlayer,dtsw)
         DO l=1,nlayer
            CALL monscatter(ngrid,ncount,dtsw(1,l),reindex,zdtsw(1,l))
         ENDDO
         !print*,'sw zdtsw ',zdtsw(1:ncount,1)
         !print*,'sw dtsw ',dtsw(:,1)
      ELSE
         fsrfvis(:)=z1(:)
         dtsw(:,:)=zdtsw(:,:)
         ftopdnvis(:)=zfract(:)*zmu(:)*psolarf0
         ftopupvis(:)=zfsrfref(:)*ztrref(:,nlevel)
      ENDIF
c        call dump2d(iim,jjm-1,zflux(2),'ZFLUX      ')
c        call dump2d(iim,jjm-1,fsrfvis(2),'FSRVIS     ')
c        call dump2d(iim,jjm-1,ztrdir(2,1),'ztrdir     ')
c        call dump2d(iim,jjm-1,pmu(2),'pmu        ')
c        call dump2d(iim,jjm-1,pfract(2),'pfract     ')
c        call dump2d(iim,jjm-1,albedo(2),'albedo     ')
c        call dump2d(iim,jjm-1,ztrdir(2,1),'ztrdir     ')


      RETURN
      END
