MODULE thermals_mod
IMPLICIT NONE

CONTAINS

SUBROUTINE thermal_plume(ngrid,nlay,ptimestep, &
                     pplay,pplev,pzlay,pzlev,popsk, &
                     ph, &
                     f_th,e_th,d_th,w_th,lwrite)
      IMPLICIT NONE


!=======================================================================
!
!   Diffusion verticale
!   Shema implicite
!   On commence par rajouter au variables x la tendance physique
!   et on resoult en fait:
!      x(t+1) =  x(t) + dt * (dx/dt)phys(t)  +  dt * (dx/dt)difv(t+1)
!
!   arguments:
!   ----------
!
!   entree:
!   -------
!
!
!=======================================================================

!-----------------------------------------------------------------------
!   declarations:
!   -------------

   include "comcstfi.h"
!  des include de la geometrie dynamique pour sorties graphiques
! #include "paramet.h"
! #include "comvert.h"
! #include "comgeom.h"
!   include "description.h"
!
!   arguments:
!   ----------

      INTEGER ngrid,nlay
      REAL ptimestep
      REAL,DIMENSION(ngrid,nlay):: pplay,pzlay,popsk
      REAL,DIMENSION(ngrid,nlay+1) :: pplev,pzlev
      REAL, DIMENSION(ngrid,nlay) :: ph
      REAL, DIMENSION(ngrid,nlay+1) :: f_th(ngrid,nlay+1),w_th(ngrid,nlay+1)
      REAL, DIMENSION(ngrid,nlay)   :: e_th(ngrid,nlay+1),d_th(ngrid,nlay+1)
      LOGICAL lwrite
!
!   local:
!   ------

      INTEGER ilev,ig,ilay,nlev
      INTEGER unit,ierr,it1,it2
      REAL,DIMENSION(ngrid,nlay) :: zh, zha,buoy
      REAL,DIMENSION(ngrid,nlay+1) :: w2
      LOGICAL,DIMENSION(ngrid) :: active
      LOGICAL :: allinactive
      REAL :: emoinsd,rho

      REAL, SAVE :: eps=0.,a_th=0.1,w2min=0.00000001
!$OMP THREADPRIVATE(eps,a_th,w2min)

!-----------------------------------------------------------------------
!   A partir de l'equation de continuité du panache 
!   d f / d z  = e* - d*
!   traduite en volumes finis :
!   d_z f = e - d
!   on prend l'netrainement et le detrainement sous la forme :
!   e =  max (d_z f,0) + eps
!   d = -min (d_z f,0) + eps
!
!   Conservation de la quantité de mouvement
!   d_z ( f w ) = e * 0 + d * w + rho * a * B
!   avec la flotabilité
!   B= g ( th_a - th ) / th
!   On suppose  rho * a = cste ~ rho_s * A
!   d_z ( rho_s * A * w^2 ) = d w + rho_s A B
!   Avec d=0
!   d_z ( w^2 ) = B
!   f= rho_s A w
!   On peut aussi prendre sans doute
!   f= rho A w
!
!   d_z ( f ha ) = e h - d ha 
!-----------------------------------------------------------------------
!   initialisations:
!   ----------------

      nlev=nlay+1

!   computation of rho*dz and dt*rho/dz=dt*rho**2 g/dp:
!   with rho=p/RT=p/ (R Theta) (p/ps)**kappa
!   ---------------------------------

      IF(lwrite) THEN
         ig=ngrid/2+1
         PRINT*,'Pression (mbar) ,altitude (km),theta, rho dz'
         DO ilay=1,nlay
            WRITE(*,*) .01*pplay(ig,ilay),.001*pzlay(ig,ilay),ph(ig,ilay)
         ENDDO
         PRINT*,'Pression (mbar) ,altitude (km),zb'
         DO ilev=1,nlay
            WRITE(*,*) .01*pplev(ig,ilev),.001*pzlev(ig,ilev)
         ENDDO
      ENDIF

!-----------------------------------------------------------------------
!   2. ajout des tendances physiques:
!   ------------------------------

      DO ilay=1,nlay
         DO ig=1,ngrid
            zh(ig,ilay)=ph(ig,ilay)
         ENDDO
      ENDDO

      f_th(:,1:nlay+1)=0.
      w_th(:,1:nlay+1)=0.
      e_th(:,1:nlay)=0.
      d_th(:,1:nlay)=0.
      buoy(:,1:nlay)=-0.0001

      ! Flotabilité de la première couche
      ! A partir de la différence entre temperature intrepollée
      ! a la surface et premiere couche
      ! = gradient entre couche 1 et 2 * demi epaisseur premiere couche

      zha(1:ngrid,1)=zh(1:ngrid,1)+(zh(1:ngrid,1)-zh(1:ngrid,2)) &
       *(pplev(1:ngrid,1)-pplay(1:ngrid,1))/(pplay(1:ngrid,1)-pplay(1:ngrid,2))
      active(1:ngrid)=.true.
      w2(1:ngrid,1:nlay+1)=0.
      zha(1:ngrid,2:nlay)=0.

      allinactive=.false.
      DO ilay=1,nlay-2
        if (.NOt. allinactive) then
         allinactive=.true.
         DO ig=1,ngrid
            if (active(ig)) then
               buoy(ig,ilay)=g*(zha(ig,ilay)-zh(ig,ilay))/zh(ig,ilay)
               !print*,'buoy il ',ilay,zha(ig,ilay),zh(ig,ilay),buoy(1,ilay)
               w2(ig,ilay+1)=w2(ig,ilay)+buoy(ig,ilay)*(pzlev(ig,ilay+1)-pzlev(ig,ilay))
               if (w2(ig,ilay+1)>w2min) then
                   if (ilay>=nlay-2) stop 'Les thermiques montent trop haut'
                   allinactive=.false.
                   rho=pplev(ig,ilay+1)/(r*zh(ig,ilay+1)*0.5*(popsk(ig,ilay+1)+popsk(ig,ilay+2)))
                   !print*,ilay,'rho',rho,'w2',w2(ig,ilay+1),'dT ',zha(ig,ilay)-zh(ig,ilay)
                   w_th(ig,ilay+1)=sqrt(w2(ig,ilay+1))
                   f_th(ig,ilay+1)=rho*a_th*w_th(ig,ilay+1)
                   emoinsd=f_th(ig,ilay+1)-f_th(ig,ilay)
                   if (emoinsd>0.) then
                       e_th(ig,ilay)=emoinsd
                   else
                       d_th(ig,ilay)=-emoinsd
                   endif
                   zha(ig,ilay+1)=(zha(ig,ilay)*f_th(ig,ilay) &
                   +e_th(ig,ilay)*zh(ig,ilay))/(d_th(ig,ilay)+f_th(ig,ilay+1))
                   !print*,'buoy zha ... ',ilay+1,zha(ig,ilay+1)
               else
                   ! derniere couche active
                   active(ig)=.false.
                   d_th(ig,ilay)=f_th(ig,ilay)
               endif
            endif  
         ENDDO
        endif
      ENDDO

!-----------------------------------------------------------------------
!   calcul final des tendances de la diffusion verticale:
!   -----------------------------------------------------

     !  call iophys_ecrit('buoy',nlay,'flotabilite','',buoy)

      IF(lwrite) THEN
         PRINT*
         PRINT*,'Diagnostique de la diffusion verticale'
         PRINT*,'h avant et apres diffusion verticale'
         DO 3110 ilay=1,nlay
            PRINT*,ph(ngrid/2+1,ilev),zh(ngrid/2+1,ilev)
3110     CONTINUE
      ENDIF


      RETURN
      END

!=======================================================================
      subroutine thermal_dq(ngrid,nlay,ptimestep,fm,entr,  &
     &           masse,q,dq,qa,lwrite)
      implicit none
!=======================================================================
!
!   Calcul du transport verticale dans la couche limite en presence
!   de "thermiques" explicitement representes
!   calcul du dq/dt une fois qu'on connait les ascendances
!
! Modif 2013/01/04 (FH hourdin@lmd.jussieu.fr)
!  Introduction of an implicit computation of vertical advection in
!  the environment of thermal plumes in thermal_dq
!
!=======================================================================

      integer ngrid,nlay

      real ptimestep
      real masse(ngrid,nlay),fm(ngrid,nlay+1)
      real entr(ngrid,nlay)
      real q(ngrid,nlay)
      real dq(ngrid,nlay)
      logical lwrite                           ! niveau pour les print

      real qa(ngrid,nlay),detr(ngrid,nlay),wqd(ngrid,nlay+1)

      real zzm

      integer ig,k
      real cfl

      real qold(ngrid,nlay),fqa(ngrid,nlay+1)
      integer niter,iter
      CHARACTER (LEN=20) :: modname='thermal_dq'
      CHARACTER (LEN=80) :: abort_message


      !print*,'DANS thermal_dq ',entr(1,1)
! Calcul du critere CFL pour l'advection dans la subsidence
      cfl = 0.
      do k=1,nlay
         do ig=1,ngrid
            zzm=masse(ig,k)/ptimestep
            cfl=max(cfl,fm(ig,k)/zzm)
            if (entr(ig,k).gt.zzm) then
               print*,'entr*dt>m,1',k,entr(ig,k)*ptimestep,masse(ig,k)
               abort_message = 'entr dt > m, thermal_dq 1st'
               CALL abort_physic (modname,abort_message,1)
            endif
         enddo
      enddo

      qold=q


      if (lwrite) print*,'Q2 THERMCEL_DQ 0'

!   calcul du detrainement
      do k=1,nlay
         do ig=1,ngrid
            detr(ig,k)=fm(ig,k)-fm(ig,k+1)+entr(ig,k)
!           print*,'Q2 DQ ',detr(ig,k),fm(ig,k),entr(ig,k)
!test
            if (detr(ig,k).lt.0.) then
               entr(ig,k)=entr(ig,k)-detr(ig,k)
               detr(ig,k)=0.
!               print*,'detr2<0!!!','ig=',ig,'k=',k,'f=',fm(ig,k),
!     s         'f+1=',fm(ig,k+1),'e=',entr(ig,k),'d=',detr(ig,k)
            endif
            if (fm(ig,k+1).lt.0.) then
!               print*,'fm2<0!!!'
            endif
            if (entr(ig,k).lt.0.) then
!               print*,'entr2<0!!!'
            endif
         enddo
      enddo

! Computation of tracer concentrations in the ascending plume
      do ig=1,ngrid
         qa(ig,1)=q(ig,1)
      enddo

      do k=2,nlay
         do ig=1,ngrid
            if ((fm(ig,k+1)+detr(ig,k))*ptimestep.gt.  &
     &         1.e-5*masse(ig,k)) then
         qa(ig,k)=(fm(ig,k)*qa(ig,k-1)+entr(ig,k)*q(ig,k))  &
     &         /(fm(ig,k+1)+detr(ig,k))
            else
               qa(ig,k)=q(ig,k)
            endif
            if (qa(ig,k).lt.0.) then
!               print*,'qa<0!!!'
            endif
            if (q(ig,k).lt.0.) then
!               print*,'q<0!!!'
            endif
         enddo
      enddo

! Plume vertical flux
      do k=2,nlay-1
         fqa(:,k)=fm(:,k)*qa(:,k-1)
      enddo
      fqa(:,1)=0. ; fqa(:,nlay)=0.


! Trace species evolution
      do k=nlay-1,1,-1
         q(:,k)=(q(:,k)+ptimestep/masse(:,k)*(fqa(:,k)-fqa(:,k+1)+fm(:,k+1)*q(:,k+1))) &
      &               /(1.+fm(:,k)*ptimestep/masse(:,k))
      enddo

! Tendencies
      do k=1,nlay
         do ig=1,ngrid
            dq(ig,k)=(q(ig,k)-qold(ig,k))/ptimestep
            q(ig,k)=qold(ig,k)
         enddo
      enddo

return
end


END MODULE thermals_mod
