SUBROUTINE thermcell_2002(ngrid, nlay, ptimestep, iflag_thermals, pplay, &
    pplev, pphi, pu, pv, pt, po, pduadj, pdvadj, pdtadj, pdoadj, fm0, entr0, &
    fraca, wa_moy, r_aspect, l_mix, w2di, tho)

  USE dimphy
!  USE write_field_phy
  IMPLICIT NONE


  ! =======================================================================

  ! Calcul du transport verticale dans la couche limite en presence
  ! de "thermiques" explicitement representes

  ! Rcriture  partir d'un listing papier  Habas, le 14/02/00

  ! le thermique est suppos homogne et dissip par mlange avec
  ! son environnement. la longueur l_mix contrle l'efficacit du
  ! mlange

  ! Le calcul du transport des diffrentes espces se fait en prenant
  ! en compte:
  ! 1. un flux de masse montant
  ! 2. un flux de masse descendant
  ! 3. un entrainement
  ! 4. un detrainement

! -----------------------------------------------------------------------
!  iflag_thermals =   1 [0-3]  [0-3] 0
!                     - flagdq dvdq  ibuoy
!                     1   3      3   0
!
!  flagdq = 0 -> dqthermcell
!           1 -> dqthermcell2
!        >= 2 -> thermcell_dq 2 -> dqimpl=-1
!                             3 -> dqimpl=1
!
!  dvdq = 0 -> dqthermcell
!         1 -> dvthermcell2
!         2 -> thermcell_dv2
!         3 -> thermcell_dq
!
!  ibuoy = 0 -> pas de correction (fbuoy=1)
!        = [1-9] -> fbuoy=ibuoy/10.
!
! -----------------------------------------------------------------------
  ! =======================================================================

  ! -----------------------------------------------------------------------
  ! declarations:
  ! -------------

  INCLUDE "comcstfi.h"

  ! arguments:
  ! ----------

  INTEGER ngrid, nlay, w2di, iflag_thermals
  REAL tho
  REAL ptimestep, l_mix, r_aspect
  REAL pt(ngrid, nlay), pdtadj(ngrid, nlay)
  REAL pu(ngrid, nlay), pduadj(ngrid, nlay)
  REAL pv(ngrid, nlay), pdvadj(ngrid, nlay)
  REAL po(ngrid, nlay), pdoadj(ngrid, nlay)
  REAL pplay(ngrid, nlay), pplev(ngrid, nlay+1)
  REAL pphi(ngrid, nlay)
  REAL fraca(ngrid, nlay+1), zw2(ngrid, nlay+1)

  INTEGER, SAVE :: idetr = 3, lev_out = 1
  !$OMP THREADPRIVATE(idetr,lev_out)

  ! local:
  ! ------

  INTEGER, SAVE :: dvdq = 0, flagdq = 0, dqimpl = 1
  REAL, SAVE :: fbuoy
  LOGICAL, SAVE :: debut = .TRUE.
  !$OMP THREADPRIVATE(dvdq,flagdq,debut,dqimpl,fbuoy)

  INTEGER ig, k, l, lmax(klon, klev+1), lmaxa(klon), lmix(klon),ibuoy
  REAL zmax(klon), zw, zz, ztva(klon, klev), zzz,zdz,zl0,zentr

  REAL zlev(klon, klev+1), zlay(klon, klev)
  REAL zh(klon, klev), zdhadj(klon, klev)
  REAL ztv(klon, klev)
  REAL zu(klon, klev), zv(klon, klev), zo(klon, klev)
  REAL wh(klon, klev+1)
  REAL wu(klon, klev+1), wv(klon, klev+1), wo(klon, klev+1)
  REAL zla(klon, klev+1)
  REAL zwa(klon, klev+1)
  REAL zld(klon, klev+1)
  REAL zwd(klon, klev+1)
  REAL zsortie(klon, klev)
  REAL zva(klon, klev)
  REAL zua(klon, klev)
  REAL zoa(klon, klev)

  REAL zha(klon, klev)
  REAL wa_moy(klon, klev+1)
  REAL fracc(klon, klev+1)
  REAL zf, zf2
  REAL thetath2(klon, klev), wth2(klon, klev)
  ! common/comtherm/thetath2,wth2

  REAL count_time

  LOGICAL sorties
  REAL rho(klon, klev), rhobarz(klon, klev+1), masse(klon, klev)
  REAL zpspsk(klon, klev)

  REAL wmax(klon, klev), wmaxa(klon)

  REAL wa(klon, klev, klev+1)
  REAL wd(klon, klev+1)
  REAL larg_part(klon, klev, klev+1)
  REAL fracd(klon, klev+1)
  REAL xxx(klon, klev+1)
  REAL larg_cons(klon, klev+1)
  REAL larg_detr(klon, klev+1)
  REAL fm0(klon, klev+1), entr0(klon, klev), detr(klon, klev)
  REAL pu_therm(klon, klev), pv_therm(klon, klev)
  REAL fm(klon, klev+1), entr(klon, klev)
  REAL fmc(klon, klev+1)

  CHARACTER (LEN=2) :: str2
  CHARACTER (LEN=10) :: str10

  CHARACTER (LEN=20) :: modname = 'thermcell2002'
  CHARACTER (LEN=80) :: abort_message

  LOGICAL vtest(klon), down

  EXTERNAL scopy

  INTEGER ncorrec, ll
  SAVE ncorrec
  DATA ncorrec/0/
  !$OMP THREADPRIVATE(ncorrec)


  REAL,SAVE :: rg,rd,rkappa
  !$OMP THREADPRIVATE(rg,rd,rkappa)


  ! -----------------------------------------------------------------------
  ! initialisation:
  ! ---------------

  IF (debut) THEN
       rg=g
       rd=r
       rkappa=rcp
       flagdq = (iflag_thermals-1000)/100
       dvdq = (iflag_thermals-(1000+flagdq*100))/10
       IF (flagdq==2) dqimpl = -1
       IF (flagdq==3) dqimpl = 1
       ibuoy = iflag_thermals-(1000+flagdq*100+dvdq*10)
       if ( ibuoy == 0 ) then
           fbuoy=0.
       else
           fbuoy=ibuoy/10.
       endif
       debut = .FALSE.
       PRINT *, 'THERMAL PLUME flags :', iflag_thermals, flagdq, dvdq, dqimpl
  END IF

  sorties = .TRUE.
  IF (ngrid/=klon) THEN
    PRINT *
    PRINT *, 'STOP dans convadj'
    PRINT *, 'ngrid    =', ngrid
    PRINT *, 'klon  =', klon
  END IF

  ! -----------------------------------------------------------------------
  ! incrementation eventuelle de tendances precedentes:
  ! ---------------------------------------------------

  ! print*,'0 OK convect8'

  DO l = 1, nlay
    DO ig = 1, ngrid
      zpspsk(ig, l) = (pplay(ig,l)/pplev(ig,1))**rkappa
      zh(ig, l) = pt(ig, l)/zpspsk(ig, l)
      zu(ig, l) = pu(ig, l)
      zv(ig, l) = pv(ig, l)
      zo(ig, l) = po(ig, l)
      ztv(ig, l) = zh(ig, l)*(1.+0.61*zo(ig,l))
      fracd(ig,l)=0.
      zwa(ig,l)=0.
    END DO
  END DO

  ! print*,'1 OK convect8'
  ! --------------------


  ! + + + + + + + + + + +


  ! wa, fraca, wd, fracd --------------------   zlev(2), rhobarz
  ! wh,wt,wo ...

  ! + + + + + + + + + + +  zh,zu,zv,zo,rho


  ! --------------------   zlev(1)
  ! \\\\\\\\\\\\\\\\\\\\



  ! -----------------------------------------------------------------------
  ! Calcul des altitudes des couches
  ! -----------------------------------------------------------------------

  DO l = 2, nlay
    DO ig = 1, ngrid
      zlev(ig, l) = 0.5*(pphi(ig,l)+pphi(ig,l-1))/rg
    END DO
  END DO
  DO ig = 1, ngrid
    zlev(ig, 1) = 0.
    zlev(ig, nlay+1) = (2.*pphi(ig,klev)-pphi(ig,klev-1))/rg
  END DO
  DO l = 1, nlay
    DO ig = 1, ngrid
      zlay(ig, l) = pphi(ig, l)/rg
    END DO
  END DO

  ! print*,'2 OK convect8'
  ! -----------------------------------------------------------------------
  ! Calcul des densites
  ! -----------------------------------------------------------------------

  DO l = 1, nlay
    DO ig = 1, ngrid
      rho(ig, l) = pplay(ig, l)/(zpspsk(ig,l)*rd*zh(ig,l))
    END DO
  END DO

  DO l = 2, nlay
    DO ig = 1, ngrid
      rhobarz(ig, l) = 0.5*(rho(ig,l)+rho(ig,l-1))
    END DO
  END DO

  DO k = 1, nlay
    DO l = 1, nlay + 1
      DO ig = 1, ngrid
        wa(ig, k, l) = 0.
      END DO
    END DO
  END DO

  ! print*,'3 OK convect8'
  ! ------------------------------------------------------------------
  ! Calcul de w2, quarre de w a partir de la cape
  ! a partir de w2, on calcule wa, vitesse de l'ascendance

  ! ATTENTION: Dans cette version, pour cause d'economie de memoire,
  ! w2 est stoke dans wa

  ! ATTENTION: dans convect8, on n'utilise le calcule des wa
  ! independants par couches que pour calculer l'entrainement
  ! a la base et la hauteur max de l'ascendance.

  ! Indicages:
  ! l'ascendance provenant du niveau k traverse l'interface l avec
  ! une vitesse wa(k,l).

  ! --------------------

  ! + + + + + + + + + +

  ! wa(k,l)   ----       --------------------    l
  ! /\
  ! /||\       + + + + + + + + + +
  ! ||
  ! ||        --------------------
  ! ||
  ! ||        + + + + + + + + + +
  ! ||
  ! ||        --------------------
  ! ||__
  ! |___      + + + + + + + + + +     k

  ! --------------------



  ! ------------------------------------------------------------------


  DO k = 1, nlay - 1
    DO ig = 1, ngrid
      wa(ig, k, k) = 0.
      wa(ig, k, k+1) = fbuoy * 2.*rg*(ztv(ig,k)-ztv(ig,k+1))/ztv(ig, k+1)* &
        (zlev(ig,k+1)-zlev(ig,k))
    END DO
    DO l = k + 1, nlay - 1
      DO ig = 1, ngrid
        wa(ig, k, l+1) = wa(ig, k, l) +fbuoy *  2.*rg*(ztv(ig,k)-ztv(ig,l))/ztv(ig, l &
          )*(zlev(ig,l+1)-zlev(ig,l))
      END DO
    END DO
    DO ig = 1, ngrid
      wa(ig, k, nlay+1) = 0.
    END DO
  END DO

  ! print*,'4 OK convect8'
  ! Calcul de la couche correspondant a la hauteur du thermique
  DO k = 1, nlay - 1
    DO ig = 1, ngrid
      lmax(ig, k) = k
    END DO
    DO l = nlay, k + 1, -1
      DO ig = 1, ngrid
        IF (wa(ig,k,l)<=1.E-10) lmax(ig, k) = l - 1
      END DO
    END DO
  END DO

  ! print*,'5 OK convect8'
  ! Calcule du w max du thermique
  DO k = 1, nlay
    DO ig = 1, ngrid
      wmax(ig, k) = 0.
    END DO
  END DO

  DO k = 1, nlay - 1
    DO l = k, nlay
      DO ig = 1, ngrid
        IF (l<=lmax(ig,k)) THEN
          wa(ig, k, l) = sqrt(wa(ig,k,l))
          wmax(ig, k) = max(wmax(ig,k), wa(ig,k,l))
        ELSE
          wa(ig, k, l) = 0.
        END IF
      END DO
    END DO
  END DO

  DO k = 1, nlay - 1
    DO ig = 1, ngrid
      pu_therm(ig, k) = sqrt(wmax(ig,k))
      pv_therm(ig, k) = sqrt(wmax(ig,k))
    END DO
  END DO

  ! print*,'6 OK convect8'
  ! Longueur caracteristique correspondant a la hauteur des thermiques.
  DO ig = 1, ngrid
    zmax(ig) = 500.
  END DO
  ! print*,'LMAX LMAX LMAX '
  DO k = 1, nlay - 1
    DO ig = 1, ngrid
      zmax(ig) = max(zmax(ig), zlev(ig,lmax(ig,k))-zlev(ig,k))
    END DO
    ! print*,k,lmax(1,k)
  END DO
  ! print*,'ZMAX ZMAX ZMAX ',zmax
  ! call dump2d(iim,jjm-1,zmax(2:ngrid-1),'ZMAX      ')

  ! print*,'OKl336'
  ! Calcul de l'entrainement.
  ! Le rapport d'aspect relie la largeur de l'ascendance a l'epaisseur
  ! de la couche d'alimentation en partant du principe que la vitesse
  ! maximum dans l'ascendance est la vitesse d'entrainement horizontale.
  DO k = 1, nlay
    DO ig = 1, ngrid

      zzz=0.5*(zlev(ig,k+1)-zlev(ig,k))
      zdz=zlev(ig,k+1)-zlev(ig,k)
      zl0=30
     !zentr=rho(ig, k)*wmax(ig, k)*zdz/(zmax(ig)*r_aspect)
      ! Avec un facteur correctiif pour que le dtrainement tende
      ! vers zro  la surface. Hauteur caractristique 30m
      zentr=rho(ig, k)*wmax(ig, k)*zdz/(zmax(ig)*r_aspect)*zzz/(zl0+zzz)
      IF (w2di==2) THEN
        entr(ig, k) = entr(ig, k) + ptimestep*(zentr-entr(ig,k))/tho
      ELSE
        entr(ig, k) = zentr
      END IF
      ztva(ig, k) = ztv(ig, k)
    END DO
  END DO


  ! print*,'7 OK convect8'
  DO k = 1, klev + 1
    DO ig = 1, ngrid
      zw2(ig, k) = 0.
      fmc(ig, k) = 0.
      larg_cons(ig, k) = 0.
      larg_detr(ig, k) = 0.
      wa_moy(ig, k) = 0.
    END DO
  END DO

  ! print*,'8 OK convect8'
  DO ig = 1, ngrid
    lmaxa(ig) = 1
    lmix(ig) = 1
    wmaxa(ig) = 0.
  END DO


  ! print*,'OKl372'
  DO l = 1, nlay - 2
    DO ig = 1, ngrid
      ! if (zw2(ig,l).lt.1.e-10.and.ztv(ig,l).gt.ztv(ig,l+1)) then
      ! print*,'COUCOU ',l,zw2(ig,l),ztv(ig,l),ztv(ig,l+1)
      IF (zw2(ig,l)<1.E-10 .AND. ztv(ig,l)>ztv(ig,l+1) .AND. &
          entr(ig,l)>1.E-10) THEN
        ! print*,'COUCOU cas 1'
        ! Initialisation de l'ascendance
        ! lmix(ig)=1
        ztva(ig, l) = ztv(ig, l)
        fmc(ig, l) = 0.
        fmc(ig, l+1) = entr(ig, l)
        zw2(ig, l) = 0.
        ! if (.not.ztv(ig,l+1).gt.150.) then
        ! print*,'ig,l+1,ztv(ig,l+1)'
        ! print*, ig,l+1,ztv(ig,l+1)
        ! endif
        zw2(ig, l+1) = 2.*rg*(ztv(ig,l)-ztv(ig,l+1))/ztv(ig, l+1)* &
          (zlev(ig,l+1)-zlev(ig,l))
        larg_detr(ig, l) = 0.
      ELSE IF (zw2(ig,l)>=1.E-10 .AND. fmc(ig,l)+entr(ig,l)>1.E-10) THEN
        ! Incrementation...
        fmc(ig, l+1) = fmc(ig, l) + entr(ig, l)
        ! if (.not.fmc(ig,l+1).gt.1.e-15) then
        ! print*,'ig,l+1,fmc(ig,l+1)'
        ! print*, ig,l+1,fmc(ig,l+1)
        ! print*,'Fmc ',(fmc(ig,ll),ll=1,klev+1)
        ! print*,'W2 ',(zw2(ig,ll),ll=1,klev+1)
        ! print*,'Tv ',(ztv(ig,ll),ll=1,klev)
        ! print*,'Entr ',(entr(ig,ll),ll=1,klev)
        ! endif
        ztva(ig, l) = (fmc(ig,l)*ztva(ig,l-1)+entr(ig,l)*ztv(ig,l))/ &
          fmc(ig, l+1)
        ! mise a jour de la vitesse ascendante (l'air entraine de la couche
        ! consideree commence avec une vitesse nulle).
        zw2(ig, l+1) = zw2(ig, l)*(fmc(ig,l)/fmc(ig,l+1))**2 + &
          2.*rg*(ztva(ig,l)-ztv(ig,l))/ztv(ig, l)*(zlev(ig,l+1)-zlev(ig,l))
      END IF
      IF (zw2(ig,l+1)<0.) THEN
        zw2(ig, l+1) = 0.
        lmaxa(ig) = l
      ELSE
        wa_moy(ig, l+1) = sqrt(zw2(ig,l+1))
      END IF
      IF (wa_moy(ig,l+1)>wmaxa(ig)) THEN
        ! lmix est le niveau de la couche ou w (wa_moy) est maximum
        lmix(ig) = l + 1
        wmaxa(ig) = wa_moy(ig, l+1)
      END IF
      ! print*,'COUCOU cas 2 LMIX=',lmix(ig),wa_moy(ig,l+1),wmaxa(ig)
    END DO
  END DO

  ! print*,'9 OK convect8'
  ! print*,'WA1 ',wa_moy

  ! determination de l'indice du debut de la mixed layer ou w decroit

  ! calcul de la largeur de chaque ascendance dans le cas conservatif.
  ! dans ce cas simple, on suppose que la largeur de l'ascendance provenant
  ! d'une couche est gale  la hauteur de la couche alimentante.
  ! La vitesse maximale dans l'ascendance est aussi prise comme estimation
  ! de la vitesse d'entrainement horizontal dans la couche alimentante.

  ! print*,'OKl439'
  DO l = 2, nlay
    DO ig = 1, ngrid
      IF (l<=lmaxa(ig)) THEN
        zw = max(wa_moy(ig,l), 1.E-10)
        larg_cons(ig, l) = zmax(ig)*r_aspect*fmc(ig, l)/(rhobarz(ig,l)*zw)
      END IF
    END DO
  END DO

  DO l = 2, nlay
    DO ig = 1, ngrid
      IF (l<=lmaxa(ig)) THEN
        ! if (idetr.eq.0) then
        ! cette option est finalement en dur.
        larg_detr(ig, l) = sqrt(l_mix*zlev(ig,l))
        ! else if (idetr.eq.1) then
        ! larg_detr(ig,l)=larg_cons(ig,l)
        ! s            *sqrt(l_mix*zlev(ig,l))/larg_cons(ig,lmix(ig))
        ! else if (idetr.eq.2) then
        ! larg_detr(ig,l)=sqrt(l_mix*zlev(ig,l))
        ! s            *sqrt(wa_moy(ig,l))
        ! else if (idetr.eq.4) then
        ! larg_detr(ig,l)=sqrt(l_mix*zlev(ig,l))
        ! s            *wa_moy(ig,l)
        ! endif
      END IF
    END DO
  END DO

  ! print*,'10 OK convect8'
  ! print*,'WA2 ',wa_moy
  ! calcul de la fraction de la maille concerne par l'ascendance en tenant
  ! compte de l'epluchage du thermique.

  fraca=0.
  fracc=0.
  fracd=0.
  wd=0.
  DO l = 2, nlay
    DO ig = 1, ngrid
      IF (larg_cons(ig,l)>1.) THEN
        ! print*,ig,l,lmix(ig),lmaxa(ig),larg_cons(ig,l),'  KKK'
        fraca(ig, l) = (larg_cons(ig,l)-larg_detr(ig,l))/(r_aspect*zmax(ig))
        IF (l>lmix(ig)) THEN
          xxx(ig, l) = (lmaxa(ig)+1.-l)/(lmaxa(ig)+1.-lmix(ig))
          IF (idetr==0) THEN
            fraca(ig, l) = fraca(ig, lmix(ig))
          ELSE IF (idetr==1) THEN
            fraca(ig, l) = fraca(ig, lmix(ig))*xxx(ig, l)
          ELSE IF (idetr==2) THEN
            fraca(ig, l) = fraca(ig, lmix(ig))*(1.-(1.-xxx(ig,l))**2)
          ELSE
            fraca(ig, l) = fraca(ig, lmix(ig))*xxx(ig, l)**2
          END IF
        END IF
        ! print*,ig,l,lmix(ig),lmaxa(ig),xxx(ig,l),'LLLLLLL'
        fraca(ig, l) = max(fraca(ig,l), 0.)
        fraca(ig, l) = min(fraca(ig,l), 0.5)
        fracd(ig, l) = 1. - fraca(ig, l)
        fracc(ig, l) = larg_cons(ig, l)/(r_aspect*zmax(ig))
      ELSE
        ! wa_moy(ig,l)=0.
        fraca(ig, l) = 0.
        fracc(ig, l) = 0.
        fracd(ig, l) = 1.
      END IF
    END DO
  END DO

  ! print*,'11 OK convect8'
  ! print*,'Ea3 ',wa_moy
  ! ------------------------------------------------------------------
  ! Calcul de fracd, wd
  ! somme wa - wd = 0
  ! ------------------------------------------------------------------


  DO ig = 1, ngrid
    fm(ig, 1) = 0.
    fm(ig, nlay+1) = 0.
  END DO

  DO l = 2, nlay
    DO ig = 1, ngrid
      fm(ig, l) = fraca(ig, l)*wa_moy(ig, l)*rhobarz(ig, l)
    END DO
    DO ig = 1, ngrid
      IF (fracd(ig,l)<0.1) THEN
        abort_message = 'fracd trop petit'
        CALL abort_physic(modname, abort_message, 1)
      ELSE
        ! vitesse descendante "diagnostique"
        wd(ig, l) = fm(ig, l)/(fracd(ig,l)*rhobarz(ig,l))
      END IF
    END DO
  END DO

  DO l = 1, nlay
    DO ig = 1, ngrid
      ! masse(ig,l)=rho(ig,l)*(zlev(ig,l+1)-zlev(ig,l))
      masse(ig, l) = (pplev(ig,l)-pplev(ig,l+1))/rg
    END DO
  END DO

  ! print*,'12 OK convect8'
  ! print*,'WA4 ',wa_moy
  ! c------------------------------------------------------------------
  ! calcul du transport vertical
  ! ------------------------------------------------------------------

  GO TO 4444
  ! print*,'XXXXXXXXXXXXXXX ptimestep= ',ptimestep
  DO l = 2, nlay - 1
    DO ig = 1, ngrid
      IF (fm(ig,l+1)*ptimestep>masse(ig,l) .AND. fm(ig,l+1)*ptimestep>masse( &
          ig,l+1)) THEN
        ! print*,'WARN!!! FM>M ig=',ig,' l=',l,'  FM='
        ! s         ,fm(ig,l+1)*ptimestep
        ! s         ,'   M=',masse(ig,l),masse(ig,l+1)
      END IF
    END DO
  END DO

  DO l = 1, nlay
    DO ig = 1, ngrid
      IF (entr(ig,l)*ptimestep>masse(ig,l)) THEN
        ! print*,'WARN!!! E>M ig=',ig,' l=',l,'  E=='
        ! s         ,entr(ig,l)*ptimestep
        ! s         ,'   M=',masse(ig,l)
      END IF
    END DO
  END DO

  DO l = 1, nlay
    DO ig = 1, ngrid
      IF (.NOT. fm(ig,l)>=0. .OR. .NOT. fm(ig,l)<=10.) THEN
        ! print*,'WARN!!! fm exagere ig=',ig,'   l=',l
        ! s         ,'   FM=',fm(ig,l)
      END IF
      IF (.NOT. masse(ig,l)>=1.E-10 .OR. .NOT. masse(ig,l)<=1.E4) THEN
        ! print*,'WARN!!! masse exagere ig=',ig,'   l=',l
        ! s         ,'   M=',masse(ig,l)
        ! print*,'rho(ig,l),pplay(ig,l),zpspsk(ig,l),RD,zh(ig,l)',
        ! s                 rho(ig,l),pplay(ig,l),zpspsk(ig,l),RD,zh(ig,l)
        ! print*,'zlev(ig,l+1),zlev(ig,l)'
        ! s                ,zlev(ig,l+1),zlev(ig,l)
        ! print*,'pphi(ig,l-1),pphi(ig,l),pphi(ig,l+1)'
        ! s                ,pphi(ig,l-1),pphi(ig,l),pphi(ig,l+1)
      END IF
      IF (.NOT. entr(ig,l)>=0. .OR. .NOT. entr(ig,l)<=10.) THEN
        ! print*,'WARN!!! entr exagere ig=',ig,'   l=',l
        ! s         ,'   E=',entr(ig,l)
      END IF
    END DO
  END DO

4444 CONTINUE
  ! print*,'OK 444 '

  IF (w2di==1) THEN
    fm0 = fm0 + ptimestep*(fm-fm0)/tho
    entr0 = entr0 + ptimestep*(entr-entr0)/tho
  ELSE
    fm0 = fm
    entr0 = entr
  END IF
  IF (flagdq==0) THEN
    CALL dqthermcell(ngrid, nlay, ptimestep, fm0, entr0, masse, zh, zdhadj, &
      zha)
    CALL dqthermcell(ngrid, nlay, ptimestep, fm0, entr0, masse, zo, pdoadj, &
      zoa)
!   PRINT *, 'THERMALS OPT 1'
  ELSE IF (flagdq==1) THEN
    CALL dqthermcell2(ngrid, nlay, ptimestep, fm0, entr0, masse, fraca, zh, &
      zdhadj, zha)
    CALL dqthermcell2(ngrid, nlay, ptimestep, fm0, entr0, masse, fraca, zo, &
      pdoadj, zoa)
!   PRINT *, 'THERMALS OPT 2'
  ELSE
    CALL thermcell_dq(ngrid, nlay, dqimpl, ptimestep, fm0, entr0, masse, zh, &
      zdhadj, zha, lev_out)
    CALL thermcell_dq(ngrid, nlay, dqimpl, ptimestep, fm0, entr0, masse, zo, &
      pdoadj, zoa, lev_out)
!   PRINT *, 'THERMALS OPT 3', dqimpl
  END IF


! PRINT *, 'TH VENT ', dvdq
  IF (dvdq==0) THEN
    ! print*,'TH VENT OK ',dvdq
    CALL dqthermcell(ngrid, nlay, ptimestep, fm0, entr0, masse, zu, pduadj, &
      zua)
    CALL dqthermcell(ngrid, nlay, ptimestep, fm0, entr0, masse, zv, pdvadj, &
      zva)
  ELSE IF (dvdq==1) THEN
    CALL dvthermcell2(ngrid, nlay, ptimestep, fm0, entr0, masse, fraca, zmax, &
      zu, zv, pduadj, pdvadj, zua, zva)
  ELSE IF (dvdq==2) THEN
    CALL thermcell_dv2(ngrid, nlay, ptimestep, fm0, entr0, masse, fraca, &
      zmax, zu, zv, pduadj, pdvadj, zua, zva, lev_out)
  ELSE IF (dvdq==3) THEN
    CALL thermcell_dq(ngrid, nlay, dqimpl, ptimestep, fm0, entr0, masse, zu, &
      pduadj, zua, lev_out)
    CALL thermcell_dq(ngrid, nlay, dqimpl, ptimestep, fm0, entr0, masse, zv, &
      pdvadj, zva, lev_out)
  END IF

  ! CALL writefield_phy('duadj',pduadj,klev)

  DO l = 1, nlay
    DO ig = 1, ngrid
      zf = 0.5*(fracc(ig,l)+fracc(ig,l+1))
      zf2 = zf/(1.-zf)
      thetath2(ig, l) = zf2*(zha(ig,l)-zh(ig,l))**2
      wth2(ig, l) = zf2*(0.5*(wa_moy(ig,l)+wa_moy(ig,l+1)))**2
    END DO
  END DO


  ! print*,'13 OK convect8'
  ! print*,'WA5 ',wa_moy
  DO l = 1, nlay
    DO ig = 1, ngrid
      pdtadj(ig, l) = zdhadj(ig, l)*zpspsk(ig, l)
    END DO
  END DO


  ! do l=1,nlay
  ! do ig=1,ngrid
  ! if(abs(pdtadj(ig,l))*86400..gt.500.) then
  ! print*,'WARN!!! ig=',ig,'  l=',l
  ! s         ,'   pdtadj=',pdtadj(ig,l)
  ! endif
  ! if(abs(pdoadj(ig,l))*86400..gt.1.) then
  ! print*,'WARN!!! ig=',ig,'  l=',l
  ! s         ,'   pdoadj=',pdoadj(ig,l)
  ! endif
  ! enddo
  ! enddo

  ! print*,'14 OK convect8'
  ! ------------------------------------------------------------------
  ! Calculs pour les sorties
  ! ------------------------------------------------------------------

  IF (sorties) THEN
    DO l = 1, nlay
      DO ig = 1, ngrid
        zla(ig, l) = (1.-fracd(ig,l))*zmax(ig)
        zld(ig, l) = fracd(ig, l)*zmax(ig)
        IF (1.-fracd(ig,l)>1.E-10) zwa(ig, l) = wd(ig, l)*fracd(ig, l)/ &
          (1.-fracd(ig,l))
      END DO
    END DO

    DO l = 1, nlay
      DO ig = 1, ngrid
        detr(ig, l) = fm(ig, l) + entr(ig, l) - fm(ig, l+1)
        IF (detr(ig,l)<0.) THEN
          entr(ig, l) = entr(ig, l) - detr(ig, l)
          detr(ig, l) = 0.
          ! print*,'WARNING !!! detrainement negatif ',ig,l
        END IF
      END DO
    END DO
  END IF

  ! print*,'15 OK convect8'


  ! if(wa_moy(1,4).gt.1.e-10) stop

  ! print*,'19 OK convect8'
  RETURN
END SUBROUTINE thermcell_2002
SUBROUTINE dqthermcell(ngrid, nlay, ptimestep, fm, entr, masse, q, dq, qa)
  USE dimphy
  IMPLICIT NONE

  ! =======================================================================

  ! Calcul du transport verticale dans la couche limite en presence
  ! de "thermiques" explicitement representes
  ! calcul du dq/dt une fois qu'on connait les ascendances

  ! =======================================================================

  INTEGER ngrid, nlay

  REAL ptimestep
  REAL masse(ngrid, nlay), fm(ngrid, nlay+1)
  REAL entr(ngrid, nlay)
  REAL q(ngrid, nlay)
  REAL dq(ngrid, nlay)

  REAL qa(klon, klev), detr(klon, klev), wqd(klon, klev+1)

  INTEGER ig, k

  ! calcul du detrainement

  DO k = 1, nlay
    DO ig = 1, ngrid
      detr(ig, k) = fm(ig, k) - fm(ig, k+1) + entr(ig, k)
      ! test
      IF (detr(ig,k)<0.) THEN
        entr(ig, k) = entr(ig, k) - detr(ig, k)
        detr(ig, k) = 0.
        ! print*,'detr2<0!!!','ig=',ig,'k=',k,'f=',fm(ig,k),
        ! s         'f+1=',fm(ig,k+1),'e=',entr(ig,k),'d=',detr(ig,k)
      END IF
      IF (fm(ig,k+1)<0.) THEN
        ! print*,'fm2<0!!!'
      END IF
      IF (entr(ig,k)<0.) THEN
        ! print*,'entr2<0!!!'
      END IF
    END DO
  END DO

  ! calcul de la valeur dans les ascendances
  DO ig = 1, ngrid
    qa(ig, 1) = q(ig, 1)
  END DO

  DO k = 2, nlay
    DO ig = 1, ngrid
      IF ((fm(ig,k+1)+detr(ig,k))*ptimestep>1.E-5*masse(ig,k)) THEN
        qa(ig, k) = (fm(ig,k)*qa(ig,k-1)+entr(ig,k)*q(ig,k))/ &
          (fm(ig,k+1)+detr(ig,k))
      ELSE
        qa(ig, k) = q(ig, k)
      END IF
      IF (qa(ig,k)<0.) THEN
        ! print*,'qa<0!!!'
      END IF
      IF (q(ig,k)<0.) THEN
        ! print*,'q<0!!!'
      END IF
    END DO
  END DO

  DO k = 2, nlay
    DO ig = 1, ngrid
      ! wqd(ig,k)=fm(ig,k)*0.5*(q(ig,k-1)+q(ig,k))
      wqd(ig, k) = fm(ig, k)*q(ig, k)
      IF (wqd(ig,k)<0.) THEN
        ! print*,'wqd<0!!!'
      END IF
    END DO
  END DO
  DO ig = 1, ngrid
    wqd(ig, 1) = 0.
    wqd(ig, nlay+1) = 0.
  END DO

  DO k = 1, nlay
    DO ig = 1, ngrid
      dq(ig, k) = (detr(ig,k)*qa(ig,k)-entr(ig,k)*q(ig,k)-wqd(ig,k)+wqd(ig,k+ &
        1))/masse(ig, k)
      ! if (dq(ig,k).lt.0.) then
      ! print*,'dq<0!!!'
      ! endif
    END DO
  END DO

  RETURN
END SUBROUTINE dqthermcell
SUBROUTINE dvthermcell(ngrid, nlay, ptimestep, fm, entr, masse, fraca, larga, &
    u, v, du, dv, ua, va)
  USE dimphy
  IMPLICIT NONE

  ! =======================================================================

  ! Calcul du transport verticale dans la couche limite en presence
  ! de "thermiques" explicitement representes
  ! calcul du dq/dt une fois qu'on connait les ascendances

  ! =======================================================================

  INTEGER ngrid, nlay

  REAL ptimestep
  REAL masse(ngrid, nlay), fm(ngrid, nlay+1)
  REAL fraca(ngrid, nlay+1)
  REAL larga(ngrid)
  REAL entr(ngrid, nlay)
  REAL u(ngrid, nlay)
  REAL ua(ngrid, nlay)
  REAL du(ngrid, nlay)
  REAL v(ngrid, nlay)
  REAL va(ngrid, nlay)
  REAL dv(ngrid, nlay)

  REAL qa(klon, klev), detr(klon, klev)
  REAL wvd(klon, klev+1), wud(klon, klev+1)
  REAL gamma0, gamma1(klon, klev+1)
  REAL dua, dva
  INTEGER iter

  INTEGER ig, k

  ! calcul du detrainement

  DO k = 1, nlay
    DO ig = 1, ngrid
      detr(ig, k) = fm(ig, k) - fm(ig, k+1) + entr(ig, k)
    END DO
  END DO

  ! calcul de la valeur dans les ascendances
  DO ig = 1, ngrid
    ua(ig, 1) = u(ig, 1)
    va(ig, 1) = v(ig, 1)
  END DO

  DO k = 2, nlay
    DO ig = 1, ngrid
      IF ((fm(ig,k+1)+detr(ig,k))*ptimestep>1.E-5*masse(ig,k)) THEN
        ! On itre sur la valeur du coeff de freinage.
        ! gamma0=rho(ig,k)*(zlev(ig,k+1)-zlev(ig,k))
        gamma0 = masse(ig, k)*sqrt(0.5*(fraca(ig,k+1)+fraca(ig, &
          k)))*0.5/larga(ig)
        ! gamma0=0.
        ! la premire fois on multiplie le coefficient de freinage
        ! par le module du vent dans la couche en dessous.
        dua = ua(ig, k-1) - u(ig, k-1)
        dva = va(ig, k-1) - v(ig, k-1)
        DO iter = 1, 5
          gamma1(ig, k) = gamma0*sqrt(dua**2+dva**2)
          ua(ig, k) = (fm(ig,k)*ua(ig,k-1)+(entr(ig,k)+gamma1(ig, &
            k))*u(ig,k))/(fm(ig,k+1)+detr(ig,k)+gamma1(ig,k))
          va(ig, k) = (fm(ig,k)*va(ig,k-1)+(entr(ig,k)+gamma1(ig, &
            k))*v(ig,k))/(fm(ig,k+1)+detr(ig,k)+gamma1(ig,k))
          ! print*,k,ua(ig,k),va(ig,k),u(ig,k),v(ig,k),dua,dva
          dua = ua(ig, k) - u(ig, k)
          dva = va(ig, k) - v(ig, k)
        END DO
      ELSE
        ua(ig, k) = u(ig, k)
        va(ig, k) = v(ig, k)
        gamma1(ig, k) = 0.
      END IF
    END DO
  END DO

  DO k = 2, nlay
    DO ig = 1, ngrid
      wud(ig, k) = fm(ig, k)*u(ig, k)
      wvd(ig, k) = fm(ig, k)*v(ig, k)
    END DO
  END DO
  DO ig = 1, ngrid
    wud(ig, 1) = 0.
    wud(ig, nlay+1) = 0.
    wvd(ig, 1) = 0.
    wvd(ig, nlay+1) = 0.
  END DO

  DO k = 1, nlay
    DO ig = 1, ngrid
      du(ig, k) = ((detr(ig,k)+gamma1(ig,k))*ua(ig,k)-(entr(ig,k)+gamma1(ig, &
        k))*u(ig,k)-wud(ig,k)+wud(ig,k+1))/masse(ig, k)
      dv(ig, k) = ((detr(ig,k)+gamma1(ig,k))*va(ig,k)-(entr(ig,k)+gamma1(ig, &
        k))*v(ig,k)-wvd(ig,k)+wvd(ig,k+1))/masse(ig, k)
    END DO
  END DO

  RETURN
END SUBROUTINE dvthermcell
SUBROUTINE dqthermcell2(ngrid, nlay, ptimestep, fm, entr, masse, frac, q, dq, &
    qa)
  USE dimphy
  IMPLICIT NONE

  ! =======================================================================

  ! Calcul du transport verticale dans la couche limite en presence
  ! de "thermiques" explicitement representes
  ! calcul du dq/dt une fois qu'on connait les ascendances

  ! =======================================================================

  INTEGER ngrid, nlay

  REAL ptimestep
  REAL masse(ngrid, nlay), fm(ngrid, nlay+1)
  REAL entr(ngrid, nlay), frac(ngrid, nlay)
  REAL q(ngrid, nlay)
  REAL dq(ngrid, nlay)

  REAL qa(klon, klev), detr(klon, klev), wqd(klon, klev+1)
  REAL qe(klon, klev), zf, zf2

  INTEGER ig, k

  ! calcul du detrainement

  DO k = 1, nlay
    DO ig = 1, ngrid
      detr(ig, k) = fm(ig, k) - fm(ig, k+1) + entr(ig, k)
    END DO
  END DO

  ! calcul de la valeur dans les ascendances
  DO ig = 1, ngrid
    qa(ig, 1) = q(ig, 1)
    qe(ig, 1) = q(ig, 1)
  END DO

  DO k = 2, nlay
    DO ig = 1, ngrid
      IF ((fm(ig,k+1)+detr(ig,k))*ptimestep>1.E-5*masse(ig,k)) THEN
        zf = 0.5*(frac(ig,k)+frac(ig,k+1))
        zf2 = 1./(1.-zf)
        qa(ig, k) = (fm(ig,k)*qa(ig,k-1)+zf2*entr(ig,k)*q(ig,k))/ &
          (fm(ig,k+1)+detr(ig,k)+entr(ig,k)*zf*zf2)
        qe(ig, k) = (q(ig,k)-zf*qa(ig,k))*zf2
      ELSE
        qa(ig, k) = q(ig, k)
        qe(ig, k) = q(ig, k)
      END IF
    END DO
  END DO

  DO k = 2, nlay
    DO ig = 1, ngrid
      ! wqd(ig,k)=fm(ig,k)*0.5*(q(ig,k-1)+q(ig,k))
      wqd(ig, k) = fm(ig, k)*qe(ig, k)
    END DO
  END DO
  DO ig = 1, ngrid
    wqd(ig, 1) = 0.
    wqd(ig, nlay+1) = 0.
  END DO

  DO k = 1, nlay
    DO ig = 1, ngrid
      dq(ig, k) = (detr(ig,k)*qa(ig,k)-entr(ig,k)*qe(ig,k)-wqd(ig,k)+wqd(ig,k &
        +1))/masse(ig, k)
    END DO
  END DO

  RETURN
END SUBROUTINE dqthermcell2
SUBROUTINE dvthermcell2(ngrid, nlay, ptimestep, fm, entr, masse, fraca, &
    larga, u, v, du, dv, ua, va)
  USE dimphy
  IMPLICIT NONE

  ! =======================================================================

  ! Calcul du transport verticale dans la couche limite en presence
  ! de "thermiques" explicitement representes
  ! calcul du dq/dt une fois qu'on connait les ascendances

  ! =======================================================================

  INTEGER ngrid, nlay

  REAL ptimestep
  REAL masse(ngrid, nlay), fm(ngrid, nlay+1)
  REAL fraca(ngrid, nlay+1)
  REAL larga(ngrid)
  REAL entr(ngrid, nlay)
  REAL u(ngrid, nlay)
  REAL ua(ngrid, nlay)
  REAL du(ngrid, nlay)
  REAL v(ngrid, nlay)
  REAL va(ngrid, nlay)
  REAL dv(ngrid, nlay)

  REAL qa(klon, klev), detr(klon, klev), zf, zf2
  REAL wvd(klon, klev+1), wud(klon, klev+1)
  REAL gamma0, gamma1(klon, klev+1)
  REAL ue(klon, klev), ve(klon, klev)
  REAL dua, dva
  INTEGER iter

  INTEGER ig, k

  ! calcul du detrainement

  DO k = 1, nlay
    DO ig = 1, ngrid
      detr(ig, k) = fm(ig, k) - fm(ig, k+1) + entr(ig, k)
    END DO
  END DO

  ! calcul de la valeur dans les ascendances
  DO ig = 1, ngrid
    ua(ig, 1) = u(ig, 1)
    va(ig, 1) = v(ig, 1)
    ue(ig, 1) = u(ig, 1)
    ve(ig, 1) = v(ig, 1)
    gamma1(ig,1)=0.
  END DO

  DO k = 2, nlay
    DO ig = 1, ngrid
      IF ((fm(ig,k+1)+detr(ig,k))*ptimestep>1.E-5*masse(ig,k)) THEN
        ! On itre sur la valeur du coeff de freinage.
        ! gamma0=rho(ig,k)*(zlev(ig,k+1)-zlev(ig,k))
        gamma0 = masse(ig, k)*sqrt(0.5*(fraca(ig,k+1)+fraca(ig, &
          k)))*0.5/larga(ig)*1.
        ! s         *0.5
        ! gamma0=0.
        zf = 0.5*(fraca(ig,k)+fraca(ig,k+1))
        zf = 0.
        zf2 = 1./(1.-zf)
        ! la premire fois on multiplie le coefficient de freinage
        ! par le module du vent dans la couche en dessous.
        dua = ua(ig, k-1) - u(ig, k-1)
        dva = va(ig, k-1) - v(ig, k-1)
        DO iter = 1, 5
          ! On choisit une relaxation lineaire.
          gamma1(ig, k) = gamma0
          ! On choisit une relaxation quadratique.
          gamma1(ig, k) = gamma0*sqrt(dua**2+dva**2)
          ua(ig, k) = (fm(ig,k)*ua(ig,k-1)+(zf2*entr(ig,k)+gamma1(ig, &
            k))*u(ig,k))/(fm(ig,k+1)+detr(ig,k)+entr(ig,k)*zf*zf2+gamma1(ig,k) &
            )
          va(ig, k) = (fm(ig,k)*va(ig,k-1)+(zf2*entr(ig,k)+gamma1(ig, &
            k))*v(ig,k))/(fm(ig,k+1)+detr(ig,k)+entr(ig,k)*zf*zf2+gamma1(ig,k) &
            )
          ! print*,k,ua(ig,k),va(ig,k),u(ig,k),v(ig,k),dua,dva
          dua = ua(ig, k) - u(ig, k)
          dva = va(ig, k) - v(ig, k)
          ue(ig, k) = (u(ig,k)-zf*ua(ig,k))*zf2
          ve(ig, k) = (v(ig,k)-zf*va(ig,k))*zf2
        END DO
      ELSE
        ua(ig, k) = u(ig, k)
        va(ig, k) = v(ig, k)
        ue(ig, k) = u(ig, k)
        ve(ig, k) = v(ig, k)
        gamma1(ig, k) = 0.
      END IF
    END DO
  END DO

  DO k = 2, nlay
    DO ig = 1, ngrid
      wud(ig, k) = fm(ig, k)*ue(ig, k)
      wvd(ig, k) = fm(ig, k)*ve(ig, k)
    END DO
  END DO
  DO ig = 1, ngrid
    wud(ig, 1) = 0.
    wud(ig, nlay+1) = 0.
    wvd(ig, 1) = 0.
    wvd(ig, nlay+1) = 0.
  END DO

  DO k = 1, nlay
    DO ig = 1, ngrid
      du(ig, k) = ((detr(ig,k)+gamma1(ig,k))*ua(ig,k)-(entr(ig,k)+gamma1(ig, &
        k))*ue(ig,k)-wud(ig,k)+wud(ig,k+1))/masse(ig, k)
      dv(ig, k) = ((detr(ig,k)+gamma1(ig,k))*va(ig,k)-(entr(ig,k)+gamma1(ig, &
        k))*ve(ig,k)-wvd(ig,k)+wvd(ig,k+1))/masse(ig, k)
    END DO
  END DO

  RETURN
END SUBROUTINE dvthermcell2

