      SUBROUTINE vdif_cd( ngrid,pz0m,pz0h,pg,pz,pu,pv,pts,ph,pcdv,pcdh)
!=======================================================================
!
!   Subject: computation of the surface drag coefficient using the
!   -------  approch developed by Loui for ECMWF.
!
!   Author: Frederic Hourdin  15 /10 /93
!   -------
!
!   Arguments:
!   ----------
!
!   inputs:
!   ------
!     ngrid            size of the horizontal grid
!     pg               gravity (m s -2)
!     pz(ngrid)        height of the first atmospheric layer
!     pu(ngrid)        u component of the wind in that layer
!     pv(ngrid)        v component of the wind in that layer
!     pts(ngrid)       surfacte temperature
!     ph(ngrid)        potential temperature T*(p/ps)^kappa
!
!   outputs:
!   --------
!     pcdv(ngrid)      Cd for the wind
!     pcdh(ngrid)      Cd for potential temperature
!
!=======================================================================
!
!-----------------------------------------------------------------------
!   Declarations:
!   -------------

      USE vdif_ini, ONLY : karman,b,c,d,c2b,c3bc,c3b,umin2
      IMPLICIT NONE

!     INCLUDE 'dimensions.h'
!   Arguments:
!   ----------
      integer, intent(in) :: ngrid
      real, dimension(ngrid), intent(in) :: pz0m,pz0h,pz
      real, intent(in) :: pg
      real, dimension(ngrid), intent(in) :: pu,pv
      real, dimension(ngrid), intent(in) :: pts,ph
      real, dimension(ngrid), intent(out) :: pcdv,pcdh

!   Local:
!   ------

      integer :: ig
      real :: zu2,z1,zri,zcd0m,zcd0h,zz


!-----------------------------------------------------------------------
!   couche de surface:
!   ------------------


!!!!! WARNING, verifier la formule originale de Louis!
      !call dump2d(iim,jjm-1,pz0m(2),'CD z0     ')
      DO ig=1,ngrid
         zu2=pu(ig)*pu(ig)+pv(ig)*pv(ig)+umin2
         zri=pg*pz(ig)*(ph(ig)-pts(ig))/(ph(ig)*zu2)
         zcd0m=karman/log(1.+pz(ig)/pz0m(ig))
         zcd0h=karman/log(1.+pz(ig)/pz0h(ig))
         zcd0h=zcd0m*zcd0h
         zcd0m=zcd0m*zcd0m
         zcd0h=zcd0h*sqrt(zu2)
         zcd0m=zcd0m*sqrt(zu2)
         IF (1==0) THEN
            ! On prend des Cdrag neutres
            IF(zri.LT.0.) THEN
               z1=b*zri/(1.+c3bc*zcd0m*sqrt(-z1*zri))
               pcdv(ig)=zcd0m*(1.-2.*z1)
               pcdh(ig)=zcd0h*(1.-3.*z1)
            ELSE
               zz=sqrt(1.+d*zri)
               pcdv(ig)=zcd0m/(1.+c2b*zri/zz)
               pcdh(ig)=zcd0h/(1.+c3b*zri*zz)
            ENDIF
         ELSE
            pcdv(ig)=zcd0m
            pcdh(ig)=zcd0h
         ENDIF
      ENDDO

!-----------------------------------------------------------------------

      RETURN
      END
