module vdif_ini

real, save :: cpp, r, g,rcp
!$OMP THREADPRIVATE(cpp,r,g,rcp)
real, save :: b=5.,c=5.,d=5.,umin2=1.e-12
!$OMP THREADPRIVATE(b,c,d,umin2)
real, save :: c2b,c3bc,c3b
!$OMP THREADPRIVATE(c2b,c3bc,c3b)
real, save :: lmixmin=100. ,emin_turb=1.e-4
!$OMP THREADPRIVATE(lmixmin,emin_turb)
real, save :: karman=0.4
!$OMP THREADPRIVATE(karman)
real, save :: a1=0.92, a2=0.74, b1=16.6, b2=10.1, c1=0.08,e1=1.8, e2=1.33
!$OMP THREADPRIVATE(a1,a2,b1,b2,c1,e1,e2)
real, save :: khmin=1.0e-5, kmmin=1.0e-5, kqmin=1.0e-5,q2min=0.001, q2lmin=0.001
real, save :: ghmax=0.023, ghmin=-0.28
!$OMP THREADPRIVATE(khmin,kmmin,kqmin,q2min,q2lmin,ghmax,ghmin)


contains
subroutine vdif_ini_(cpp_in,r_in,g_in,rcp_in)

     real, intent(in) :: cpp_in,r_in,g_in,rcp_in

     cpp=cpp_in
     r=r_in
     g=g_in
     rcp=rcp_in

     c2b=2.*b
     c3bc=3.*b*c
     c3b=3.*b
     return
end subroutine vdif_ini_
end module vdif_ini
