      SUBROUTINE vdif_k(ngrid,nlay,ptimestep,pg,pzlev,pzlay,pz0,pu,pv,ph,pcdv,kz_v,kz_h,richardson)

      USE vdif_ini, ONLY : lmixmin,emin_turb,karman
      IMPLICIT NONE

      integer, intent(in) :: ngrid,nlay

      real, intent(in) :: ptimestep
      real, dimension (ngrid,nlay), intent(in) ::  pzlay,pu,pv,ph
      real, dimension(ngrid,nlay+1), intent(in) ::  pzlev
      REAL, dimension(ngrid,nlay+1), intent(out)::  kz_v,kz_h,richardson
      REAL, dimension(ngrid),intent(in) :: pz0,pcdv
      REAL, intent(in) :: pg

      integer :: ig,il
      real :: zdu,zdv,zdvodz2,zdz,z1,lmix,zri

      DO ig=1,ngrid
         kz_v(ig,1)=0.
         kz_h(ig,1)=0.
         richardson(ig,1)=0.
         kz_v(ig,nlay+1)=0.
         kz_h(ig,nlay+1)=0.
         richardson(ig,nlay+1)=0.
      ENDDO
      DO il=2,nlay
         DO ig=1,ngrid
            z1=pzlev(ig,il)+pz0(ig)
            lmix=karman*z1/(1.+karman*z1/lmixmin)
!           lmix=lmixmin
! WARNING test lmix=lmixmin
            zdu=pu(ig,il)-pu(ig,il-1)
            zdv=pv(ig,il)-pv(ig,il-1)
            zdz=pzlay(ig,il)-pzlay(ig,il-1)
            zdvodz2=(zdu*zdu+zdv*zdv)/(zdz*zdz)
            IF(zdvodz2.LT.1.e-12) THEN
                kz_v(ig,il)=lmix*sqrt(emin_turb)
            ELSE
               richardson(ig,il)=2.*pg*(ph(ig,il)-ph(ig,il-1))/ (zdz* (ph(ig,il)+ph(ig,il-1)) *zdvodz2  )
               zri=richardson(ig,il)
               zri=0.
               kz_v(ig,il)=lmix*sqrt(MAX(lmix*lmix*zdvodz2*(1-zri*.4),emin_turb))
            ENDIF
            kz_h(ig,il)=kz_v(ig,il)
!           IF(ig.EQ.ngrid/2+1) PRINT*,il,lmix,kz_v(ig,il),
!    s      zdu,zdv,zdz,zdvodz2,ph(ig,il)+ph(ig,il-1),
!    s      lmix*lmix*zdvodz2*(1-zri/.4),emin_turb,zri,ph(ig,il)-ph(ig,il-1),
!    s      ph(ig,il),ph(ig,il-1)
         ENDDO
      ENDDO

      RETURN
      END
