import os
import numpy as np
import matplotlib.pyplot as plt
from netCDF4 import Dataset

longitude=0.
latitude=10.
# Jour à partir duquel on trace les cycles diurne
day0=2.
nday=3000
daystep=24
timemax=72.
it0=(nday-3)*daystep-1
itmax=np.int(timemax*daystep/24.)
time=[ (it+1) * 24/daystep  for it in range(itmax) ]
xticks=[ 6 * it for it in range(np.int(timemax/6.+1)) ]
print(xticks)


prop_cycle = plt.rcParams['axes.prop_cycle']
colors = prop_cycle.by_key()['color']

# Ouverture du fichier
def tracerun(file,color,label) :
    ncdata=Dataset(file)
    plt.subplot(1,2,1)
    lat=np.array(ncdata.variables['lat'][:])
    lon=np.array(ncdata.variables['lon'][:])
    lat_i=[ilat for ilat,lati in enumerate(lat) if abs(lati-latitude) == np.min(abs(lat-latitude))][0]
    lon_i=[ilon for ilon,loni in enumerate(lon) if abs(loni-longitude) == np.min(abs(lon-longitude))][0]
    # Lecture des temperatures et altitude
    temp=np.array(ncdata.variables['temp'][it0:it0+itmax,:,lat_i,lon_i]-273.15) # [time,z,y,x]
    tsoil=np.array(ncdata.variables['tsoil'][it0:it0+itmax,0:9,lat_i,lon_i]-273.15) # [time,z,y,x]
    alt=np.array(ncdata.variables['geop'][it0:it0+itmax,:,lat_i,lon_i]/9800)
    if len(lat) == 1:
        depth=-ncdata.variables['zsoil'][0,0:9,lat_i,lon_i]/1000.
    else :
        depth=-ncdata.variables['tsoil'][0,0:9,0,0]/1000.
    print(np.mean(tsoil,axis=0))
    plt.plot(np.mean(temp,axis=0),np.mean(alt,axis=0),lw=2,color=color,label=label)
    plt.plot(np.mean(tsoil,axis=0),depth,lw=2,color=color)


tracerun("phys0.nc",colors[0],"Contrôle")
tracerun("phys5.nc",colors[1],"Abs solaire accrue")
tracerun("phys6.nc",colors[2],"Abs thermique accrue")
plt.axhline(0.,color="brown",linewidth=2.)
plt.ylabel('Prof. (m)|                       Altitude (km)                             ')
plt.xlabel('Température (°C)')
plt.ylim([-5.,30.])
plt.xlim([-100.,70.])
#plt.xlim([0.,timemax])
plt.margins(x=0.)
plt.legend()
pdffile='fig-vol3-chp-gcm-EqRad.pdf'
plt.savefig('tmp.pdf')
os.system('pdfcrop tmp.pdf ; \mv -f tmp-crop.pdf '+pdffile+' ; evince '+pdffile)
