import os
import numpy as np
import matplotlib.pyplot as plt
from netCDF4 import Dataset

longitude=0.
latitude=10.
# Jour à partir duquel on trace les cycles diurne
day0=2.
nday=3000
daystep=24
timemax=48.
it0=(nday-5)*daystep-1
itmax=np.int(timemax*daystep/24.)+1
time=[ it * 24/daystep  for it in range(itmax) ]
xticks=[ 6. * it for it in range(np.int(timemax/6.+1)) ]
print(xticks)
print([xticks[0],time[0]])


prop_cycle = plt.rcParams['axes.prop_cycle']
colors = prop_cycle.by_key()['color']

# Ouverture du fichier
def tracerun(file,color,label) :
    ncdata=Dataset(file)
    lat=np.array(ncdata.variables['lat'][:])
    lon=np.array(ncdata.variables['lon'][:])
    lat_i=[ilat for ilat,lati in enumerate(lat) if abs(lati-latitude) == np.min(abs(lat-latitude))][0]
    lon_i=[ilon for ilon,loni in enumerate(lon) if abs(loni-longitude) == np.min(abs(lon-longitude))][0]
    # Lecture des temperatures et altitude
    temp=np.array(ncdata.variables['temp'][:,:,lat_i,lon_i]-273.15) # [time,z,y,x]
    tsoil=np.array(ncdata.variables['tsoil'][:,0:14,lat_i,lon_i]-273.15) # [time,z,y,x]
    plt.plot(time,tsoil[it0:it0+itmax,0],'-',linewidth=2,color=color,label=label)
    plt.plot(time,temp[it0:it0+itmax,0],'--',linewidth=1,color=color)

def tracerlw(file,color,label) :
    ncdata=Dataset(file)
    lat=np.array(ncdata.variables['lat'][:])
    lon=np.array(ncdata.variables['lon'][:])
    lat_i=[ilat for ilat,lati in enumerate(lat) if abs(lati-latitude) == np.min(abs(lat-latitude))][0]
    lon_i=[ilon for ilon,loni in enumerate(lon) if abs(loni-longitude) == np.min(abs(lon-longitude))][0]
    # Lecture des temperatures et altitude
    lw=np.array(ncdata.variables['lwtop'][:,lat_i,lon_i]) # [time,z,y,x]
    plt.plot(time,lw[it0:it0+itmax],'-',linewidth=2,color=color)

def tracesolaire() :
    ncdata=Dataset("phys0.nc")
    lat=np.array(ncdata.variables['lat'][:])
    lon=np.array(ncdata.variables['lon'][:])
    lat_i=[ilat for ilat,lati in enumerate(lat) if abs(lati-latitude) == np.min(abs(lat-latitude))][0]
    lon_i=[ilon for ilon,loni in enumerate(lon) if abs(loni-longitude) == np.min(abs(lon-longitude))][0]
    # Lecture des temperatures et altitude
    sw=np.array(ncdata.variables['swtopdn'][:,lat_i,lon_i]) # [time,z,y,x]
    plt.subplot(4,2,4)
    plt.ylim([0.,1000.])
    plt.xlim([0.,timemax])
    #print(sw[it0:it0+itmax])
    plt.plot(time,sw[it0:it0+itmax],'-',linewidth=2,color="gold",label="Solaire")



tracesolaire()
tracerlw("phys1.nc",colors[1],"I=500")
tracerlw("phys0.nc",colors[0],"I=2000")
tracerlw("phys2.nc",colors[2],"I=20000")
plt.xticks(xticks)
plt.ylabel('Flux (W/m'+r'$^2$'+')')
plt.subplot(2,2,4)
plt.ylim([0.,80.])
plt.xlim([0.,timemax])
tracerun("phys1.nc",colors[1],"I=500")
tracerun("phys0.nc",colors[0],"I=2000")
tracerun("phys2.nc",colors[2],"I=20000")
plt.xticks(xticks)
plt.ylabel("Temperature (°C)")
plt.xlabel("Heure locale")
plt.margins(0.)
plt.legend(loc='upper left',bbox_to_anchor=(0.55, 1.3, 0.5, 0.5))
plt.savefig('tmp.pdf')
pdffile="fig-vol3-chp-gcm-evol.pdf"
os.system('pdfcrop tmp.pdf ; \mv -f tmp-crop.pdf '+pdffile+' ; evince '+pdffile)
