#!/bin/bash

cat >| gcm.def <<eod
day_step=96
iphysiq=1
eod


for cas in `seq 0 6` ; do

   inertie=2000
   calldifv=n
   thermals=0
   coefvis=.75
   coefir=.2
   period_sort=.04166666666666666666

   case $cas in
      0) echo cas de control ;;
      1) inertie=500 ;;
      2) inertie=20000 ;;
      3) calldifv=y ;;
      4) calldifv=y ; thermals=1 ;;
      5) coefvis=0.6 ;;
      6) coefir=0.1 ;;
      *) echo cas $cas non prevu ; exit 1
   esac
   if [ $thermals = 1 ] ; then iflag_thermals=1335 ; else iflag_thermals=0 ; fi
   if [ $calldifv = y ] ; then iflag_conserv=1 ; else iflag_conserv=0 ; fi

   if [ ! -f planete_sed ] ; then cp planete.def planete_sed ; fi
   sed -e 's/obliquit=.*$/obliquit=0./' \
       -e 's/I_mer=.*$/I_mer='$inertie'/'  \
       -e 's/calldifv=.*$/calldifv='$calldifv'/' \
       -e 's/iflag_thermals=.*$/iflag_thermals='$iflag_thermals'/' \
       -e 's/iflag_conserv=.*$/iflag_conserv='$iflag_conserv'/' \
       -e 's/coefvis=.*$/coefvis='$coefvis'/' \
       -e 's/coefir=.*$/coefir='$coefir'/' \
       -e 's/period_sort=.*$/period_sort='$period_sort'/' \
       planete_sed > planete.def
   
   \cp -f planete.def planete.$cas
   sed -i'' -e 's/nday=.*$/nday=3000/' run.def

   if [ ! -f phys$cas.nc ] ; then
       echo '----------------------------------------------------'
       echo 'Running scm.e for cas $cas log in listing' $cas
       echo '----------------------------------------------------'
       time ./scm.e > listing$cas 2>&1
       if [ $cas == 4 ]  ; then
           cp phys.nc phys4.nc
       else
           ncks -v zsoil,temp,tsoil,theta,geop,w_th,swtopdn,swtopup,lwtop phys.nc -O phys$cas.nc
       fi
   fi
   
   echo 'Running ferret'
   for var in temp theta ; do
      cat > tmp.jnl <<_______________________________________________________eod
      use phys$cas
      let var=$var
      let Zkm=geop/9.8
      plot/vs/vlim=0:1000/line=7/hlim=280:320/l=2392 var,Zkm
      plot/vs/o/l=2394/line=8 var,Zkm
      plot/vs/o/l=2396/line=9 var,Zkm
      plot/vs/o/l=2398/line=10 var,Zkm
      quit
_______________________________________________________eod

      ferret -nojnl -batch $var$cas.pdf -script tmp.jnl
   done

done
