#!/bin/bash


ntasks=$1
nthreads=1

imputation=`whoami | cut -c 2-4`

cat <<eod>| tmp
#!/bin/bash
#
#SBATCH --job-name=TEST         # nom du job
#SBATCH -A ${imputation}@cpu
# Nombre de processus MPI :
#SBATCH --ntasks=$ntasks
# number of MPI processes per node :
#SBATCH --ntasks-per-node=5
# nombre de threads OpenMP
#SBATCH --cpus-per-task=$nthreads
# de Slurm "multithread" fait bien reference a l'hyperthreading.
#SBATCH --hint=nomultithread       # 1 thread par coeur physique (pas d'hyperthreading)
#SBATCH --time=03:00:00
#SBATCH --output=outTEST%j     # Nom du fichier de sortie
#SBATCH --error=outTEST%j      # Nom du fichier d'erreur (ici commun avec la sortie)
#


set -ex



# number of OpenMP threads:
export OMP_NUM_THREADS=$nthreads
# private memory for each thread
export OMP_STACKSIZE=800M
# Binding
export OMP_PLACES=cores

simul=TEST
ulimit -s unlimited

. lmdz_env.sh

time \$run $ntasks ./gcm.e > listing

eod

sbatch tmp
