#!/bin/bash

nday=3

\rm -rf BIS
./clean.sh
./compile.sh

nday2=$(( 2 * $nday ))
ndayp1=$(( $nday + 1 ))

run="gcm.e"
run="run_local.sh 2 2 gcm.e"


sed -i'' -e 's/nday=.*.$/nday='$nday'/' run.def
$run | grep rjourv >| out
mkdir BIS
for suf in "" phy _param ; do
   cp restart$suf.nc BIS/start$suf.nc 
done
cp *def run_local.sh BIS/
sed -i'' -e 's/read_start=.*.$/read_start=y/'  BIS/gcm.def
cd BIS

ln -s ../gcm.e .
$run | grep rjourvr >| out
cd ..
sed -i'' -e 's/nday=.*.$/nday='$nday2'/' run.def
$run | grep rjourv >| out2

cat <<eod>| tmp.jnl
use phys
use BIS/phys
fill ts[i=@ave]- ts[d=1,i=@ave,l=@shft:-$ndayp1]
list ts[i=@ave]- ts[d=1,i=@ave,l=@shft:-$ndayp1]
eod


# Rayonnement + diffusion OK avc 
