#!/bin/bash
set -eu  # error on command failure, and on unset variables


local_d=`pwd`

set +e ; conda deactivate ; set -e

# LMDZ and install_lmdz version to be downloaded
install_svn_version=0
version="-v 20200127.trunk -unstable" ; install_svn_version=5244 # Original sources from the second M2 sessions where the exercise was proposed
version="-v 20241018.trunk" ; install_svn_version=5244
version="-v 20250209.trunk -unstable" ; install_svn_version=5528

# Some defaults
install_d=$local_d
cas_ref=arm_cu
day_step=1080
physdef=6A
clean=0

# Directories management :
# ------------------------
# save_pub="-save_pub -save_pub_dir DIR" given ton install_lmdz.sh
#     Allows saving files donwloaded from lmdz web site
#     Alternative save_pub=""
# netcdf=DIR, -netcdf $netcdf passed to install_lmdz.sh
#     Alternative netcdf=0

LMDZname=LMDZ$( echo $version | sed -e 's/-v//' -e 's/ //g' -e 's/.trunk//' -e 's/unstable//' -e 's/\-//g' )
save_pub_dir="" ; for d in $HOME $local_d ; do if [ -d $d/LMDZ/pub ] ; then save_pub_dir=$d/LMDZ/pub ; fi ; done
save_pub=$( if [ "$save_pub_dir" = "" ] ; then save_pub="" ; else save_pub="-save_pub -save_pub_dir $save_pub_dir" ; fi  )
netcdf=$save_pub_dir/netcdf # Alternative : netcdf=0 to install with native netcdf

#-------------------------------------------------------------------------
function run_cmd_with_log { # Runing a command with log file
#-------------------------------------------------------------------------
echo Runing $*
local logf=$PWD/$( basename $logfile )
echo Log in $logf
$* > $logf 2>&1
echo '      ----        '
if [ $? = 0 ] ; then
   echo Command $1 completed
else
   echo Something went wrong with command $1
   echo Look in log file $logf
   echo and ask for help
   exit 1
fi
echo '      ----        '
}

cat <<eod
-------------------------------------------------------------------------
   -- LMDZ with empty physics for training on model development --
-------------------------------------------------------------------------

on $local_d/$LMDZname
Case arm_cu will be run automatically on 
    $local_d/$LMDZname/1D/EXEC/${physdef}L79
with the standard version of LMDZ and on
    $local_d/$LMDZname/1D/EXEC/${physdef}L79lmdworkdt$day_step
with a modified version with minimal physics (only K diffusion with fixed parameters).
Some files will be saved on save_pub_dir=$save_pub_dir
    $save_pub_dir

eod
#-------------------------------------------------------------------------
echo 1. INSTALLATION if not already done
#-------------------------------------------------------------------------

if [ ! -d $install_d/$LMDZname -o $clean = 1 ] ; then
   cd $install_d
   if [ ! -f install_lmdz.sh ] ; then
      if [ $install_svn_version = 0 ] ; then
          wget http://lmdz.lmd.jussieu.fr/pub/install_lmdz.sh -O install_lmdz.sh
      else
          \rm -rf script_install
          svn co -r $install_svn_version http://svn.lmd.jussieu.fr/LMDZ/BOL/script_install
          \cp -f script_install/install_lmdz.sh .
          \rm -rf script_install
      fi
   fi

   chmod +x ./install_lmdz.sh
   logfile=$PWD/install_lmdz$$.log
   run_cmd_with_log ./install_lmdz.sh $version -bench 0 -name $LMDZname -netcdf $netcdf -rad oldrad $save_pub

fi

echo -------------------------------------------------------------------------
echo 2. Installation du 1D et premiere simulation
echo -------------------------------------------------------------------------

if [ ! -d $install_d/$LMDZname/1D ] ; then
    cd $install_d/$LMDZname
    if [ -f $save_pub_dir/1D/1D.tar.gz ] ; then
        tar xf $save_pub_dir/1D/1D.tar.gz
    else
        wget http://lmdz.lmd.jussieu.fr/pub/1D/1D.tar.gz
        tar xf 1D.tar.gz
        if [ -d $save_pub_dir ] ; then mkdir -p $save_pub_dir/1D ; mv 1D.tar.gz $save_pub_dir/1D/1D.tar.gz ; fi
    fi
    cd 1D
    sed -i'' -e 's/^listedef=.*$/listedef='$physdef'/' -e 's/^listecas=.*$/listecas='${cas_ref}'/' run.sh
    echo Reference 1D simulation run on $PWD/EXEC/${physdef}L79/${cas_ref}
    logfile=RunOrig.log
    run_cmd_with_log ./run.sh
    cd -
fi

echo -------------------------------------------------------------------------
echo 3. Ajout des sources specifiques
echo -------------------------------------------------------------------------

libf=$install_d/$LMDZname/modipsl/modeles/LMDZ/libf
if [ ! -d $libf/phylmdwork ] ; then
    cd $libf
    cp -r phylmd phylmdwork
    cp -r $local_d/src phylmdwork/work
    cd phylmdwork
    ln -sf work/* .
fi


cd $install_d/$LMDZname/1D
echo pwd $PWD
cp run.sh run.orig
sed -i'' -e '/^phys=/a\
phys=lmdwork' run.sh
out_d=$PWD/EXEC/${physdef}L79lmdworkdt${day_step}/${cas_ref}

echo Runing a first simulation with the dev physics
echo outputs in
echo $out_d
logfile=RunNew.log

run_cmd_with_log ./run.sh -day_step $day_step > outRunNew 2>&1

if [ -f $out_d/phys.nc ] ; then
   echo File $out_d/phys.nc contains outputs of the ref simulation
else
   echo File $out_d/phys.nc does not exist
fi
