SUBROUTINE diffkz(klev,nq,rho,rhodz,kz,theta,vitu,vitv,qx,taux,tauy,fsens,flat,d_theta,d_u,d_v,d_qx)
use yomcst_mod_h
IMPLICIT NONE

!--------------------------------------------------------------------------
! Computes vertical diffusion for potential temperature, theta, wind (vitu
! and vitv), and tracer (qx) assuming that kz is the diffusion coefficient
!--------------------------------------------------------------------------

!==========================================================================
! 0/ Declarations
!==========================================================================

! arguments
INTEGER,INTENT(IN)  :: klev,nq
REAL, DIMENSION(klev),INTENT(IN)  :: rho, rhodz, theta, vitu, vitv
REAL, DIMENSION(klev,nq),INTENT(IN)  :: qx
REAL, DIMENSION(klev+1),INTENT(IN)  :: kz
REAL, DIMENSION(klev),INTENT(OUT)  :: d_theta,d_u,d_v
REAL, DIMENSION(klev,nq),INTENT(OUT)  :: d_qx
REAL :: taux, tauy, fsens, flat

! local
INTEGER k
REAL, DIMENSION(klev+1) :: fluxt,fluxu,fluxv
REAL, DIMENSION(klev+1,nq) :: fluxq

!==========================================================================
! 1/ Flux computation
!==========================================================================


do k=2,klev
   fluxt(k)=2.*kz(k)*rho(k)*rho(k)*(theta(k-1)-theta(k))/(rhodz(k)+rhodz(k-1))
   fluxq(k,:)=2.*kz(k)*rho(k)*rho(k)*(qx(k-1,:)-qx(k,:))/(rhodz(k)+rhodz(k-1))
   fluxu(k)=2.*kz(k)*rho(k)*rho(k)*(vitu(k-1)-vitu(k))/(rhodz(k)+rhodz(k-1))
   fluxv(k)=2.*kz(k)*rho(k)*rho(k)*(vitv(k-1)-vitv(k))/(rhodz(k)+rhodz(k-1))
enddo


!==========================================================================
! 2/ surface fluxes
!==========================================================================

fluxt(1)=-fsens/rcpd
fluxq(1,1)=-flat/rlvtt
fluxq(1,2:nq)=0.
fluxu(1)=taux
fluxv(1)=tauy

fluxt(klev+1)=0.
fluxq(klev+1,:)=0.
fluxu(klev+1)=0.
fluxv(klev+1)=0.
print*,'PHY1DNUM OK4'

!==========================================================================
! 3/ tendencies computation
!==========================================================================

do k=1,klev
   d_theta(k)=(fluxt(k)-fluxt(k+1))/rhodz(k)
   d_qx(k,:)=(fluxq(k,:)-fluxq(k+1,:))/rhodz(k)
   d_u(k)=(fluxu(k)-fluxu(k+1))/rhodz(k)
   d_v(k)=(fluxv(k)-fluxv(k+1))/rhodz(k)
enddo

RETURN
END SUBROUTINE diffkz
