SUBROUTINE iniphyparam(ngrid,nlayer,punjours,pdayref,ptimestep,prad,pg,pr,pcpp)

use IOIPSL
use dimphy
USE mod_grid_phy_lmdz
use comgeomfi
use comsaison
USE geometry_mod, ONLY : longitude,latitude,cell_area
USE ioipsl_getin_p_mod, ONLY : getin_p

USE mod_phys_lmdz_para, ONLY: klon_omp
!USE mod_phys_lmdz_para, ONLY: klon_omp, is_mpi_root,klon_mpi_begin
!USE mod_phys_lmdz_omp_data, ONLY :  is_omp_root
!USE netcdf, only : NF90_NOWRITE,NF90_OPEN,NF90_NOERR,NF90_INQ_VARID
!USE netcdf, only : NF90_CLOSE, NF90_GET_VAR
!USE regular_lonlat_mod, ONLY: lon_reg, lat_reg

implicit none

!=======================================================================
!
!   subject:
!   --------
!
!   Initialisation for the physical parametrisations of the LMD 
!   martian atmospheric general circulation modele.
!
!   author: Frederic Hourdin 15 / 10 /93
!   -------
!
!   arguments:
!   ----------
!
!   input:
!   ------
!
!    ngrid                 Size of the horizontal grid.
!                          All internal loops are performed on that grid.
!    nlayer                Number of vertical layers.
!    pdayref               Day of reference for the simulation
!    firstcall             True at the first call
!    lastcall              True at the last call
!    pday                  Number of days counted from the North. Spring
!                          equinoxe.
!
!=======================================================================
!
!-----------------------------------------------------------------------
!   declarations:
!   -------------

 
      include "planete.h"
      include "comcstfi.h"
      include "callkeys.h"
      include "surface.h"
! #include "iniprint.h"


      REAL prad,pg,pr,pcpp,punjours
 
      INTEGER ngrid,nlayer
      REAL pdayref
 
      REAL ptimestep
      INTEGER ig,ierr

      INTEGER lunout
 
      EXTERNAL inifrict,iniorbit,orbite


      lunout=6
      print*,'INIPHYPARAM'
      if (ngrid == 1 ) then
              klon_omp=1
              klon=1
              klev=nlayer
      endif
      CALL InitComgeomfi


      IF (klon.NE.klon_omp) THEN
         PRINT*,'STOP in iniphyparam'
         PRINT*,'Probleme de dimenesions :'
         PRINT*,'klon     = ',klon
         PRINT*,'klon_omp   = ',klon_omp
         STOP
      ENDIF

      IF (nlayer.NE.nlayermx) THEN
         PRINT*,'STOP in iniphyparam'
         PRINT*,'Probleme de dimenesions :'
         PRINT*,'nlayer     = ',nlayer
         PRINT*,'nlayermx   = ',nlayermx
         STOP
      ENDIF

      IF (ngrid.NE.klon_glo) THEN
         PRINT*,'STOP in iniphyparam'
         PRINT*,'Probleme de dimenesions :'
         PRINT*,'ngrid     = ',ngrid
         PRINT*,'ngridmax   = ',klon_glo
!        STOP
      ENDIF

      print*,'Avant les getpar '
      unjours=86400.
      rad=6400.
      g=9.8
      cpp=1004.
      mugaz=28.
      year_day=360.
      periheli=150.
      aphelie=150.
      peri_day=0.
      obliquit=0.
      z0m_ter=.1
      z0m_mer=.1
      I_ter=3000.
      I_mer=3000.
      alb_ter=.112
      alb_mer=.112
      emi_ter=1.
      emi_mer=1.
      emin_turb=1.e-16
      lmixmin=100.
      coefvis=.99
      coefir=.08
      callrad=.true.
      calldifv=.true.
      calladj=.false.
      iflag_conserv=1
      iflag_thermals=0
      iflag_dyn=1
      callcond=.true.
      callsoil=.true.
      season=.false.
      iflag_diurnal=1
      lverbose=.false.
      period_sort=1.
      io_meteo=1
      io_tend=0
      io_soil=0
      io_intern=0


      CALL getin_p('daysec',unjours)
      CALL getin_p('radius',rad)
      CALL getin_p('g',g)
      CALL getin_p('cpp',cpp)
      CALL getin_p('molmass',mugaz)
      CALL getin_p('year_day',year_day)
      CALL getin_p('periheli',periheli)
      CALL getin_p('aphelie',aphelie)
      CALL getin_p('peri_day',peri_day)
      CALL getin_p('obliquit',obliquit)
      CALL getin_p('z0m_ter',z0m_ter)
      CALL getin_p('z0m_mer',z0m_mer)
      CALL getin_p('I_ter',I_ter)
      CALL getin_p('I_mer',I_mer)
      CALL getin_p('alb_ter',alb_ter)
      CALL getin_p('alb_mer',alb_mer)
      CALL getin_p('emi_ter',emi_ter)
      CALL getin_p('emi_mer',emi_mer)
      CALL getin_p('emin_turb',emin_turb)
      CALL getin_p('lmixmin',lmixmin)
      CALL getin_p('coefvis',coefvis)
      CALL getin_p('coefir',coefir)
      CALL getin_p('callrad',callrad)
      CALL getin_p('calldifv',calldifv)
      CALL getin_p('calladj',calladj)
      CALL getin_p('iflag_conserv',iflag_conserv)
      CALL getin_p('iflag_thermals',iflag_thermals)
      CALL getin_p('iflag_dyn',iflag_dyn)
      CALL getin_p('callcond',callcond)
      CALL getin_p('callsoil',callsoil)
      CALL getin_p('season',season)
      CALL getin_p('iflag_diurnal',iflag_diurnal)
      CALL getin_p('lverbose',lverbose)
      CALL getin_p('period_sort',period_sort)
      CALL getin_p('io_meteo',io_meteo)
      CALL getin_p('io_tend',io_tend)
      CALL getin_p('io_soil',io_soil)
      CALL getin_p('io_intern',io_intern)


      write(lunout,*) 'unjours=',unjours
      write(lunout,*) 'rad=',rad
      write(lunout,*) 'g=',g
      write(lunout,*) 'cpp=',cpp
      write(lunout,*) 'mugaz=',mugaz
      write(lunout,*) 'year_day=',year_day
      write(lunout,*) 'periheli=',periheli
      write(lunout,*) 'aphelie=',aphelie
      write(lunout,*) 'peri_day=',peri_day
      write(lunout,*) 'obliquit=',obliquit
      write(lunout,*) 'z0m_mer=',z0m_mer
      write(lunout,*) 'z0m_ter=',z0m_ter
      write(lunout,*) 'I_mer=',I_mer
      write(lunout,*) 'I_ter=',I_ter
      write(lunout,*) 'alb_ter=',alb_ter
      write(lunout,*) 'alb_mer=',alb_mer
      write(lunout,*) 'emi_mer=',emi_mer
      write(lunout,*) 'emi_mer=',emi_mer
      write(lunout,*) 'emin_turb=',emin_turb
      write(lunout,*) 'lmixmin=',lmixmin
      write(lunout,*) 'coefvis=',coefvis
      write(lunout,*) 'coefir=',coefir
      write(lunout,*) 'callrad=',callrad
      write(lunout,*) 'calldifv=',calldifv
      write(lunout,*) 'calladj=',calladj
      write(lunout,*) 'iflag_conserv=',iflag_conserv
      write(lunout,*) 'iflag_thermals=',iflag_thermals
      write(lunout,*) 'iflag_dyn=',iflag_dyn
      write(lunout,*) 'callcond=',callcond
      write(lunout,*) 'callsoil=',callsoil
      write(lunout,*) 'season=',season
      write(lunout,*) 'iflag_diurnal=',iflag_diurnal
      write(lunout,*) 'lverbose=',lverbose
      write(lunout,*) 'period_sort=',period_sort
      write(lunout,*) 'io_meteo=',io_meteo
      write(lunout,*) 'io_tend=',io_tend
      write(lunout,*) 'io_intern=',io_intern
      write(lunout,*) 'io_soil=',io_soil

      print*,'Activation de la physique:'
      print*,' Rayonnement ',callrad
      print*,' Diffusion verticale turbulente ', calldifv
      print*,' Ajustement convectif ',calladj
      print*,' Thermiques ',iflag_thermals
      print*,' Sol ',callsoil
      print*,' Cycle diurne ',iflag_diurnal

!   choice of the frequency of the computation of radiations
      IF(iflag_diurnal==1) THEN
         iradia=NINT(punjours/(20.*ptimestep))
      ELSE
         iradia=NINT(punjours/(4.*ptimestep))
      ENDIF
      iradia=1
      PRINT*,'unjours',punjours
      PRINT*,'The radiative transfer is computed each '
      PRINT*,   iradia,' physical time-step or each '
      PRINT*,   iradia*ptimestep,' seconds'
!-----------------------------------------------------------------------


      !print*,'cell_area=',cell_area
      !print*,'longitude=',longitude,klon_omp
      long(1:klon_omp)=longitude(1:klon_omp)
      lati(1:klon_omp)=latitude(1:klon_omp)
      area(1:klon_omp)=cell_area(1:klon_omp)
      !print*,'ngrid=',ngrid
      totarea=sum(cell_area,ngrid)
      !print*,'OK17 AAA'

      sinlat(:)=sin(lati(:))
      coslat(:)=cos(lati(:))
      sinlon(:)=sin(long(:))
      coslon(:)=cos(long(:))

      pi=2.*asin(1.)
      prad=rad
      pg=g
      r=8.134/(mugaz*0.001)
      print*,'R=',r
      pr=r
      pcpp=cpp
      rcp=r/cpp
      dtphys=ptimestep
      punjours=unjours

      RETURN
9999  STOP 'Cette version demande les fichier rnatur.dat et surf.def'
      END


