      subroutine vdif_dq(ngrid,nlay,nq,                                       &
     &                ptimestep,pcapcal,pz0m,pz0h,                         &
     &                pplay,pplev,pzlay,pzlev,                             &
     &                pu,pv,ph,ptsrf,pq,pemis,                             &
     &                pdufi,pdvfi,pdhfi,pfluxsrf,                          &
     &                pdudif,pdvdif,pdhdif,pdtsrf,pdqdif,q2,kz_v,kz_h,     &
     &                richardson,pcdv,pcdh,                                &
     &                lwrite)
!     INCLUDE 'dimensions.h'

!=======================================================================
!
!   Diffusion verticale
!   Shema implicite
!   On commence par rajouter au variables x la tendance physique
!   et on resoult en fait:
!      x(t+1) =  x(t) + dt * (dx/dt)phys(t)  +  dt * (dx/dt)difv(t+1)
!
!   arguments:
!   ----------
!
!   entree:
!   -------
!
!
!=======================================================================

!-----------------------------------------------------------------------
!   declarations:
!   -------------

!     include "comcstfi.h"
!  des include de la geometrie dynamique pour sorties graphiques
! #include "paramet.h"
! #include "comvert.h"
! #include "comgeom.h"
!     include "description.h"
!
!   arguments:
!   ----------

      use vdif_ini, only : cpp,r,g,rcp

      IMPLICIT NONE
      integer, intent(in) :: ngrid,nlay,nq
      real, intent(IN) :: ptimestep
      real, dimension(ngrid,nlay), intent(in) :: pplay,pzlay
      real, dimension(ngrid,nlay+1), intent(in) :: pplev,pzlev
      real, dimension(ngrid,nlay), intent(in) :: pu,pv,ph
      real, dimension(ngrid,nlay,nq), intent(in) :: pq
      real, dimension(ngrid), intent(in) :: ptsrf,pemis
      real, dimension(ngrid,nlay), intent(out) :: pdufi,pdvfi,pdhfi
      real, dimension(ngrid), intent(out) :: pfluxsrf
      real, dimension(ngrid,nlay), intent(out) :: pdudif,pdvdif,pdhdif
      real, dimension(ngrid,nlay,nq), intent(out) :: pdqdif
      real, dimension(ngrid), intent(out) :: pdtsrf,pcapcal,pz0m,pz0h
      real, dimension(ngrid), intent(out) :: pcdv,pcdh
      REAL, dimension(ngrid,nlay+1), intent(inout) :: q2
      REAL, dimension(ngrid,nlay+1), intent(out) :: kz_v,kz_h,richardson

      LOGICAL lwrite
!
!   local:
!   ------

      INTEGER ilev,ig,ilay,nlev,iq
      REAL z4st,zdplanck(ngrid)
      REAL zu(ngrid,nlay),zv(ngrid,nlay)
      REAL zh(ngrid,nlay)
      REAL ztsrf2(ngrid)
      REAL z1(ngrid),z2(ngrid)
      REAL za(ngrid,nlay),zb(ngrid,nlay)
      REAL zb0(ngrid,nlay)
      REAL zc(ngrid,nlay),zd(ngrid,nlay)
      REAL lmix(ngrid,nlay+1)
      REAL zq(ngrid,nlay)
      REAL zcst1

      EXTERNAL coefdifv
!
!-----------------------------------------------------------------------
!   initialisations:
!   ----------------

      nlev=nlay+1

!   computation of rho*dz and dt*rho/dz=dt*rho**2 g/dp:
!   with rho=p/RT=p/ (R Theta) (p/ps)**kappa
!   ---------------------------------

      DO ilay=1,nlay
         DO ig=1,ngrid
            za(ig,ilay)=(pplev(ig,ilay)-pplev(ig,ilay+1))/g
         ENDDO
      ENDDO

      zcst1=4.*g*ptimestep/(r*r)
      DO ilev=2,nlev-1
         DO ig=1,ngrid
            ! zb0 = 1/2  p/T
            zb0(ig,ilev)=pplev(ig,ilev)*(pplev(ig,1)/pplev(ig,ilev))**rcp /(ph(ig,ilev-1)+ph(ig,ilev))
            ! zb0 = zb0^2 * 4 g dt / R^2 / dp = g rho^2 dt / dp = rho dt  / dz
            zb0(ig,ilev)=zcst1*zb0(ig,ilev)*zb0(ig,ilev)/(pplay(ig,ilev-1)-pplay(ig,ilev))
         ENDDO
      ENDDO
      DO ig=1,ngrid
         zb0(ig,1)=ptimestep*pplev(ig,1)/(r*ptsrf(ig))
      ENDDO
      IF(lwrite) THEN
         ig=ngrid/2+1
         PRINT*,'Pression (mbar) ,altitude (km),u,v,theta, rho dz'
         DO ilay=1,nlay
            WRITE(*,*) .01*pplay(ig,ilay),.001*pzlay(ig,ilay),pu(ig,ilay),pv(ig,ilay),ph(ig,ilay),za(ig,ilay)
         ENDDO
         PRINT*,'Pression (mbar) ,altitude (km),zb'
         DO ilev=1,nlay
            WRITE(*,*) .01*pplev(ig,ilev),.001*pzlev(ig,ilev),zb0(ig,ilev)
         ENDDO
      ENDIF

!-----------------------------------------------------------------------
!   2. ajout des tendances physiques:
!   ------------------------------

      DO ilev=1,nlay
         DO ig=1,ngrid
            zu(ig,ilev)=pu(ig,ilev)+pdufi(ig,ilev)*ptimestep
            zv(ig,ilev)=pv(ig,ilev)+pdvfi(ig,ilev)*ptimestep
            zh(ig,ilev)=ph(ig,ilev)+pdhfi(ig,ilev)*ptimestep
         ENDDO
      ENDDO

!-----------------------------------------------------------------------
!   3. calcul de  cd :
!   ----------------
!
      CALL vdif_cd( ngrid,pz0m,pz0h,g,pzlay,pu,pv,ptsrf,ph,pcdv,pcdh)
      if (1==1) then

         CALL vdif_k(ngrid,nlay,ptimestep,g,pzlev,pzlay,pz0m,pu,pv,ph,pcdv,kz_v,kz_h,richardson)

          ! Ci dessous formule de Kz ne dépendant que de z. callé sur le précédent
          !kz_v=0.5*pzlay*exp(-pzlay/200.)
          !kz_h=kz_v
      else
      ! EN CHANTIER : VERIFIER L'INTERFACE
         call my_25(ngrid,nlay,ptimestep,g,pzlay,pzlev,pu,pv,ph,pcdv,q2,lmix,kz_v,kz_h)
      endif


      IF(lwrite) THEN
         PRINT*
         PRINT*,'Diagnostique diffusion verticale'
         PRINT*,'coefficients Cd pour v et h'
         PRINT*,pcdv(ngrid/2+1),pcdh(ngrid/2+1)
         PRINT*,'coefficients K pour v et h'
         DO ilev=1,nlay
            PRINT*,kz_v(ngrid/2+1,ilev),kz_h(ngrid/2+1,ilev)
         ENDDO
      ENDIF

!-----------------------------------------------------------------------
!   integration verticale pour u:
!   -----------------------------
!
      DO ilay=2,nlay
         DO ig=1,ngrid
            zb(ig,ilay)=kz_v(ig,ilay)*zb0(ig,ilay)
        ENDDO
      ENDDO
      !CALL multipl((nlay-1)*ngrid,kz_v(1,2),zb0(1,2),zb(1,2))
      !CALL multipl(ngrid,pcdv,zb0,zb)
      DO ig=1,ngrid
         zb(ig,1)=pcdv(ig)*zb0(ig,1)
         z1(ig)=1./(za(ig,nlay)+zb(ig,nlay))
         zc(ig,nlay)=za(ig,nlay)*zu(ig,nlay)*z1(ig)
         zd(ig,nlay)=zb(ig,nlay)*z1(ig)
      ENDDO

      DO ilay=nlay-1,1,-1
         DO ig=1,ngrid
            z1(ig)=1./(za(ig,ilay)+zb(ig,ilay)+zb(ig,ilay+1)*(1.-zd(ig,ilay+1)))
            zc(ig,ilay)=(za(ig,ilay)*zu(ig,ilay)+zb(ig,ilay+1)*zc(ig,ilay+1))*z1(ig)
            zd(ig,ilay)=zb(ig,ilay)*z1(ig)
         ENDDO
      ENDDO

      DO ig=1,ngrid
         zu(ig,1)=zc(ig,1)
      ENDDO
      DO ilay=2,nlay
         DO ig=1,ngrid
            zu(ig,ilay)=zc(ig,ilay)+zd(ig,ilay)*zu(ig,ilay-1)
         ENDDO
      ENDDO

!-----------------------------------------------------------------------
!   integration verticale pour v:
!   -----------------------------
!
      DO ig=1,ngrid
         z1(ig)=1./(za(ig,nlay)+zb(ig,nlay))
         zc(ig,nlay)=za(ig,nlay)*zv(ig,nlay)*z1(ig)
         zd(ig,nlay)=zb(ig,nlay)*z1(ig)
      ENDDO

      DO ilay=nlay-1,1,-1
         DO ig=1,ngrid
            z1(ig)=1./(za(ig,ilay)+zb(ig,ilay)+zb(ig,ilay+1)*(1.-zd(ig,ilay+1)))
            zc(ig,ilay)=(za(ig,ilay)*zv(ig,ilay)+zb(ig,ilay+1)*zc(ig,ilay+1))*z1(ig)
            zd(ig,ilay)=zb(ig,ilay)*z1(ig)
         ENDDO
      ENDDO

      DO ig=1,ngrid
         zv(ig,1)=zc(ig,1)
      ENDDO
      DO ilay=2,nlay
         DO ig=1,ngrid
            zv(ig,ilay)=zc(ig,ilay)+zd(ig,ilay)*zv(ig,ilay-1)
         ENDDO
      ENDDO

      DO ilay=2,nlay
         DO ig=1,ngrid
            zb(ig,ilay)=kz_h(ig,ilay)*zb0(ig,ilay)
        ENDDO
      ENDDO
      !CALL multipl((nlay-1)*ngrid,kz_h(1,2),zb0(1,2),zb(1,2))
      !CALL multipl(ngrid,pcdh,zb0,zb)
      DO ig=1,ngrid
         zb(ig,1)=pcdh(ig)*zb0(ig,1)
         z1(ig)=1./(za(ig,nlay)+zb(ig,nlay))
         zc(ig,nlay)=za(ig,nlay)*zh(ig,nlay)*z1(ig)
         zd(ig,nlay)=zb(ig,nlay)*z1(ig)
      ENDDO

      DO ilay=nlay-1,1,-1
         DO ig=1,ngrid
            z1(ig)=1./(za(ig,ilay)+zb(ig,ilay)+zb(ig,ilay+1)*(1.-zd(ig,ilay+1)))
            zc(ig,ilay)=(za(ig,ilay)*zh(ig,ilay)+zb(ig,ilay+1)*zc(ig,ilay+1))*z1(ig)
            zd(ig,ilay)=zb(ig,ilay)*z1(ig)
         ENDDO
      ENDDO

!-----------------------------------------------------------------------
!   rajout eventuel de planck dans le shema implicite:
!   --------------------------------------------------

      z4st=4.*5.67e-8*ptimestep
!     z4st=0.
      DO ig=1,ngrid
         zdplanck(ig)=z4st*pemis(ig)*ptsrf(ig)*ptsrf(ig)*ptsrf(ig)
      ENDDO

!-----------------------------------------------------------------------
!   calcul le l'evolution de la temperature du sol:
!   -----------------------------------------------

      DO ig=1,ngrid
         z1(ig)=pcapcal(ig)*ptsrf(ig)+cpp*zb(ig,1)*zc(ig,1)+zdplanck(ig)*ptsrf(ig)+ pfluxsrf(ig)*ptimestep
         z2(ig)= pcapcal(ig)+cpp*zb(ig,1)*(1.-zd(ig,1))+zdplanck(ig)
         ztsrf2(ig)=z1(ig)/z2(ig)
         zh(ig,1)=zc(ig,1)+zd(ig,1)*ztsrf2(ig)
         pdtsrf(ig)=(ztsrf2(ig)-ptsrf(ig))/ptimestep
      ENDDO

!-----------------------------------------------------------------------
!   integration verticale finale:
!   -----------------------------

      DO ilay=2,nlay
         DO ig=1,ngrid
            zh(ig,ilay)=zc(ig,ilay)+zd(ig,ilay)*zh(ig,ilay-1)
         ENDDO
      ENDDO

!-----------------------------------------------------------------------
!  integration verticale pour q:
!  -----------------------------
!
!  Schema :
!   $ q_k - q_k* =  \dt * ( \Fq{k} - \Fq{k+1} ) / ( rho dz ) $
!  avec
!   $ \Fq{k} = \rho\Kz{k} ( q_{k-1} - q_{k} ) / dz $ 
!
!  On pose $ q_k = C_k + D_k q_{k-1} $
!     b0 = rho dt  / dz
!     B=\b0\Kz
!     a = dp/g = rho dz
!     a_n ( q_n - q_n* ) = B_{n} ( q_{n-1} - q_{n} )  
!     a_k ( q_k - q_k* ) = B_{k} ( q_{k-1} - q_{k} ) - B_{k+1} ( q_{k} - q_{k+1} )
!     a_1 ( q_1 - q_1* ) = Fs                        - B_{2}   ( q_{1} - q_{2} )
!
!     On remplace $q_{k+1}$ par $C_k + D_k q_{k-1}$ et on factorise $q_{k}$:
!     den_k = a_k + B_{k} + B_{k+1} ( 1 - D_{k+1} )
!     C_k = ( a_k q_k* + B_{k+1} C_{k+1} ) / den_k
!     D_k = B_{k} / den_k
!
!     Cas flux nul en surface (B_1=0) :
!     B_1=0 ; q_0=0
!     den_1 = a_1 + B_1 + B_2 ( 1 - D_2 )
!     q_1 = C_1 = ( a_1 q_1 + B_2 C_2 ) / den_1
!  
!
   DO iq=1,nq
      zq(:,:)=pq(:,:,iq)
      DO ilay=2,nlay
         DO ig=1,ngrid
            zb(ig,ilay)=kz_h(ig,ilay)*zb0(ig,ilay)
        ENDDO
      ENDDO
      DO ig=1,ngrid
         ! zb(ig,1)=pcdv(ig)*zb0(ig,1)   : pour le vent
         zb(ig,1)=0.
         z1(ig)=1./(za(ig,nlay)+zb(ig,nlay))
         zc(ig,nlay)=za(ig,nlay)*zq(ig,nlay)*z1(ig)
         zd(ig,nlay)=zb(ig,nlay)*z1(ig)
      ENDDO

      DO ilay=nlay-1,1,-1
         DO ig=1,ngrid
            z1(ig)=1./(za(ig,ilay)+zb(ig,ilay)+zb(ig,ilay+1)*(1.-zd(ig,ilay+1)))
            zc(ig,ilay)=(za(ig,ilay)*zq(ig,ilay)+zb(ig,ilay+1)*zc(ig,ilay+1))*z1(ig)
            zd(ig,ilay)=zb(ig,ilay)*z1(ig)
         ENDDO
      ENDDO

      DO ig=1,ngrid
         zq(ig,1)=zc(ig,1)
      ENDDO

      DO ilay=2,nlay
         DO ig=1,ngrid
            zq(ig,ilay)=zc(ig,ilay)+zd(ig,ilay)*zq(ig,ilay-1)
         ENDDO
      ENDDO

      DO ilay=1,nlay
         DO ig=1,ngrid
            pdqdif(ig,ilay,iq)=(zq(ig,ilay)-pq(ig,ilay,iq))/ptimestep
         ENDDO
      ENDDO

   ENDDO

!-----------------------------------------------------------------------
!   calcul final des tendances de la diffusion verticale:
!   -----------------------------------------------------

      DO ilev = 1, nlay
         DO ig=1,ngrid
            pdudif(ig,ilev)=(    zu(ig,ilev)-(pu(ig,ilev)+pdufi(ig,ilev)*ptimestep)    )/ptimestep
            pdvdif(ig,ilev)=(    zv(ig,ilev)-(pv(ig,ilev)+pdvfi(ig,ilev)*ptimestep)    )/ptimestep
            pdhdif(ig,ilev)=(    zh(ig,ilev)-(ph(ig,ilev)+pdhfi(ig,ilev)*ptimestep)    )/ptimestep
         ENDDO
      ENDDO

      IF(lwrite) THEN
         PRINT*
         PRINT*,'Diagnostique de la diffusion verticale'
         PRINT*,'h avant et apres diffusion verticale'
         PRINT*,ptsrf(ngrid/2+1),ztsrf2(ngrid/2+1)
         DO  ilev=1,nlay
            PRINT*,ph(ngrid/2+1,ilev),zh(ngrid/2+1,ilev)
         ENDDO
      ENDIF


!-----------------------------------------------------------------------

      RETURN
      END
