program adv2d
implicit none

!    ###################################################
!    #define/undef IONC will call routines for netcdf outputs
#undef IONC
!    ###################################################

!========================================================================
! DECLARATIONS
!========================================================================

integer,parameter :: imax=300,kmax=100
integer :: i,k
real :: xmin,xmax,umin,umax,deltat,deltax,deltaz,temps,zmax,x0
real, dimension(imax)      :: xxx          ! x en m
real, dimension(kmax)      :: zzz          ! z en m
real, dimension(imax,kmax) :: vitu,vitw    ! vent
real, dimension(imax,kmax) :: qinitial     ! concentration initiale
real, dimension(imax,kmax) :: qexact       ! solution exaxte (advection 1D)
real pi
real alphax

character*5 file

integer it
integer :: nt=3001

!========================================================================
! INITIALISATIONS
!========================================================================

!------------------------------------------------------------------------
! Initialize constants
!------------------------------------------------------------------------

! pause
xmax=3000.
zmax=1000.
umin=2.
umax=10.
x0=xmax/5.


pi=2.*asin(1.)

!------------------------------------------------------------------------
! Initialize grid
!------------------------------------------------------------------------
deltax=xmax/float(imax)
deltaz=zmax/float(kmax)

do i=1,imax
   xxx(i)=i*deltax
enddo

do k=1,kmax
   zzz(k)=(k-0.5)*deltaz
enddo

!------------------------------------------------------------------------
! Initialize tracer
!------------------------------------------------------------------------
do i=1,imax
   qinitial(i,:)=exp( -(25.*(xxx(i)-x0)/xmax)**2 )
enddo

!------------------------------------------------------------------------
! Initialize outputs
!------------------------------------------------------------------------
#ifdef IONC
call iotd_ini('coucou.nc   ',imax,1,kmax,xxx,0.,zzz)
#endif


!------------------------------------------------------------------------
! alphax(z) = delta t / U(z)
!------------------------------------------------------------------------

deltat=0.2*deltax/umax
do k=1,kmax
   vitu(:,k)=umin+(umax-umin)*zzz(k)/zmax
enddo
vitw(:,:)=0.

qexact(:,:)=qinitial(:,:)


!=========================================================================
do it=1,nt ! TIME LOOP
!=========================================================================

! To be used during tutorial
! vitu_pert(i,k)=vitu(k)*(1.+apert_u*sin(3.2*k/float(kmax)-temps/20.))
! www=wmax*(0.4*sin(33.*pi*xxx(i)/xmax-temps/50.)+sin(10.*pi*xxx(i)/xmax-temps/66.))

!=========================================================================
! OUTPUTS
!=========================================================================


#ifdef IONC
       print*,'ECRITURES it'
       call iotd_ecrit('qexact',kmax,'qexact','kg/kg',qexact)
       call iotd_ecrit('U',kmax,'vitu','m/s',vitu)
       call iotd_ecrit('W',kmax,'vitu','m/s',vitw)
#else

    if (mod(it,100)==1) then
       file="e...."
       write(file(2:5),'(i4.4)') it
       open (10,file=file,form='formatted')
       do k=1,kmax
       do i=1,imax
          write(10,*) xxx(i),zzz(k),qexact(i,k)
       enddo
!      write(10,*)
       enddo
       close(10)
    endif

#endif

    

    print*,'Pas de temps it=',it
    temps=it*deltat

!-------------------------------------------------------------------------
! Exact computation of advection in x with a wind field that depends
! on z only
!-------------------------------------------------------------------------

    do k=1,kmax
       do i=1,imax
          qexact(i,k)=exp( -(25.*(xxx(i)-xmax/5.-vitu(i,k)*temps)/xmax)**2 )
       enddo
    enddo

!=========================================================================
enddo ! END OF TIME LOOP
!=========================================================================

#ifdef IONC
call iotd_fin
#endif


end
