#!/bin/bash
# set -vx

##########################################################################
# About Netcdf IO library
##########################################################################
netcdf=netcdf/netcdf-4.0.1
lib=$netcdf/lib
include=$netcdf/include

# Reinstalling if not present
if [ ! -f $lib/libnetcdff.a ] ; then ./setup.sh ; fi
if [ ! -f $lib/libnetcdff.a ] ; then echo "Pb install netcdf" ; exit ; fi

##########################################################################
# Optimisation for gfortran
##########################################################################
optim="-O3"
debug_opt="-g3 -Wall -fbounds-check -ffpe-trap=invalid,zero,overflow -O0 -fstack-protector-all -fbacktrace -finit-real=nan"

##########################################################################
# Script interface
##########################################################################
if  [ $# = 0 ] ; then ./compile.x -help ; exit ; fi
while (($# > 0)) ; do
        case $1 in
          -debug) optim="$debug_opt" ; shift ;;
          -help) echo Usage: $0 "[-debug] prog [or prog.F90] ; prog.F90 should exist "
                 exit ; shift ;;
          *) main=`basename $1 .F90` ; if [ ! -f $main.F90 ] 
             then echo "$main.F90 does not exist"
             ./compile.x -help ; exit ; fi ; shift ;;
        esac
done

###############################################################
# Finally compiling with the iotd interface to Netcdf Library
###############################################################
gfortran -I$netcdf/include $optim $main.F90 iotd_ini.F90 iotd_ecrit.F90 iotd_fin.F90 -Wl,-rpath=/usr/lib:$lib -L$lib -lnetcdf -lnetcdff -o $main.e
