#!/bin/bash

for loc in France1 ; do
sim=$loc/IPSL-CM6A-LR/historical-EXT/r1i1p1f1/
sim=$loc/IPSL-CM6A-LR/ssp585/r1i1p1f1/
sim=$loc/IPSL-CM6A-LR/ssp126/r1i1p1f1/
out=NC/$sim

mkdir -p $out
cd $out
rsync -av ciclad:/data/hourdin/CMIPNature/$out/ ./
#

if [ ! -f meteo_day.csv ] ; then
ferret <<eod
use snc
let date_strings = TAX_DATESTRING(t[g=snc],t[g=snc],"full")
list/file=meteo_day.csv/nohead/format=(a,f7.2)/clobber/order=T date_strings,snc
quit
eod
fi

if [ ! -f meteo_3hr.csv ] ; then
ferret <<eod
use tslsi
use tas
use huss
use ps
use pr
use rsds
use rsus
use rlds
use hfss
use hfls
reg/l=1:467512
let date_strings = TAX_DATESTRING(t[g=hfls],t[g=hfls],"full")
list/file=meteo_3hr.csv/nohead/format=(a,f7.2,f7.2,f8.2,i7,i4,f8.2,f8.2,f8.2,f8.2,f8.2)/clobber/order=T date_strings,tslsi[d=1],tas[d=2],1000*huss[d=3],ps[d=4],86400*pr[d=5],rsds[d=6],rsus[d=7],rlds[d=8],hfss[d=9],hfls[d=10]
list "MOY TS 100 ANS :",tslsi[d=1,l=1:292200@ave]
quit
eod
fi


\rm meteo.csv ; touch meteo.csv
for date in `cut -c-11 meteo_day.csv` ; do
   snc=`grep $date meteo_day.csv | awk ' { print $3 } '`
   grep $date meteo_3hr.csv | sed -e 's/$/ '$snc'/' >> meteo.csv
done

done
