SUBROUTINE diffkz_implicit(klev, nqtot, rho, rhodz, kz, qx, theta, vitu, vitv,  &
                           flat, fsens, taux, tauy,                         &
                           d_theta, d_u, d_v, d_qx, pdtphys)

use yomcst_mod_h
IMPLICIT NONE

!=========================================================
! Arguments
!=========================================================
INTEGER, INTENT(IN) :: klev, nqtot
REAL, INTENT(IN) :: pdtphys
REAL, DIMENSION(klev), INTENT(IN) :: rho, rhodz
REAL, DIMENSION(klev), INTENT(IN) :: theta, vitu, vitv
REAL, DIMENSION(klev,nqtot), INTENT(IN) :: qx
REAL, DIMENSION(klev+1), INTENT(IN) :: kz

REAL, INTENT(IN) :: flat        ! latent heat flux (W/m2)
REAL, INTENT(IN) :: fsens       ! sensible heat flux (W/m2)
REAL, INTENT(IN) :: taux, tauy  ! surface stress (N/m2)

REAL, DIMENSION(klev), INTENT(OUT) :: d_theta, d_u, d_v
REAL, DIMENSION(klev,nqtot), INTENT(OUT) :: d_qx

!=========================================================
! Local variables
!=========================================================
INTEGER :: iq
REAL :: surface_flux
REAL, PARAMETER :: cp = 1004.0
REAL, PARAMETER :: Lv = 2.5e6


print *, 'pdtphysun', pdtphys
print *, 'pdtphysdeux', pdtphys
print *, 'pdtphystrois', pdtphys
print *, 'pdtphysquatre', pdtphys
print *, 'pdtphyscinq', pdtphys
print *, 'pdtphyssix', pdtphys

!=========================================================
! === THETA diffusion ===
!=========================================================
surface_flux = -fsens/rcpd !fsens / (rho(1)*cp)
! fluxt(1)=-fsens/rcpd
CALL solve_diffusion(theta, d_theta, surface_flux)

!=========================================================
! === U wind diffusion ===
!=========================================================
surface_flux = taux ! taux/ rho(1)
! fluxu(1)=taux
CALL solve_diffusion(vitu, d_u, surface_flux)

!=========================================================
! === V wind diffusion ===
!=========================================================
surface_flux = tauy ! tauy/ rho(1)
! fluxv(1)=tauy
CALL solve_diffusion(vitv, d_v, surface_flux)

!=========================================================
! === Tracer diffusion ===
!=========================================================
! fluxq(1,1)=-flat/rlvtt
! fluxq(1,2:nq)=0.
DO iq = 1, nqtot
    surface_flux = -flat/rlvtt !-flat / (rho(1)*Lv)
    CALL solve_diffusion(qx(:,iq), d_qx(:,iq), surface_flux)
END DO

RETURN

!#######################################################################
CONTAINS
!#######################################################################

SUBROUTINE solve_diffusion(var, dvar, surf_flux)


REAL, DIMENSION(klev), INTENT(IN)  :: var
REAL, DIMENSION(klev), INTENT(OUT) :: dvar
REAL, INTENT(IN) :: surf_flux

REAL, DIMENSION(klev) :: a, b, c, d
REAL, DIMENSION(klev) :: Acoef, Bcoef
REAL, DIMENSION(klev) :: var_new
REAL :: denomk
INTEGER :: k


!---------------------------------------------------------
! Right-hand side
!---------------------------------------------------------
DO k = 1, klev
    d(k) = var(k)
END DO

!---------------------------------------------------------
! Tridiagonal coefficients (interior levels)
!---------------------------------------------------------
DO k = 2, klev-1
    a(k) = - pdtphys * 2.0 * kz(k) * rho(k)**2 / &
           ((rhodz(k)+rhodz(k-1)) * rhodz(k))

    c(k) = - pdtphys * 2.0 * kz(k+1) * rho(k+1)**2 / &
           ((rhodz(k+1)+rhodz(k)) * rhodz(k))

    b(k) = 1.0 - a(k) - c(k)
END DO

!---------------------------------------------------------
! Top boundary (zero flux)
!---------------------------------------------------------
a(klev) = - pdtphys * 2.0 * kz(klev) * rho(klev)**2 / &
           ((rhodz(klev)+rhodz(klev-1)) * rhodz(klev))

c(klev) = 0.0
b(klev) = 1.0 - a(klev)

!---------------------------------------------------------
! Surface boundary (imposed flux)
!---------------------------------------------------------
a(1) = 0.0
c(1) = - pdtphys * 2.0 * kz(2) * rho(2)**2 / &
       ((rhodz(2)+rhodz(1)) * rhodz(1))

b(1) = 1.0 - c(1)

d(1) = d(1) + pdtphys * surf_flux / rhodz(1)

!---------------------------------------------------------
! Thomas algorithm (back substitution form)
!---------------------------------------------------------
Acoef(klev) = 1.0
Bcoef(klev) = 0.0

DO k = klev-1, 1, -1
    denomk = b(k) + c(k) * Acoef(k+1)
    Acoef(k) = -a(k) / denomk
    Bcoef(k) = (d(k) - c(k)*Bcoef(k+1)) / denomk
END DO

!---------------------------------------------------------
! Forward substitution
!---------------------------------------------------------
var_new(1) = Bcoef(1)
DO k = 2, klev
    var_new(k) = Acoef(k)*var_new(k-1) + Bcoef(k)
END DO

!---------------------------------------------------------
! Tendencies
!---------------------------------------------------------
DO k = 1, klev
    dvar(k) = (var_new(k) - var(k)) / (pdtphys)
END DO

END SUBROUTINE solve_diffusion

END SUBROUTINE diffkz_implicit
