SUBROUTINE panache_thermique(klev,rho,theta,theta_th,d_theta_th,w_th,dz)

    IMPLICIT NONE

    integer, intent(in) :: klev  ! Nombre de niveau
    real, dimension(klev), intent(in) :: rho,theta,dz
    real, dimension(klev), intent(inout):: d_theta_th,w_th,theta_th

    !Local
    integer :: k  ! Indice de boucle
    integer :: k_stop
    real :: var_int
    real, dimension(klev) :: f,e,d  ! Tableau pour stocker les valeurs de w_th_k
    real, parameter :: g=9.81  
    real, parameter :: alpha=0.1  


    !Initialisation
    theta_th(:)=theta(:)
    e(:)=0.
    d(:)=0.
    f(:)=0.
    w_th(:)=0.
    k_stop=0.
    
    if (theta(1)>theta(2)) then
        !Initialisation
        theta_th(2) = theta(1)
        w_th(2)=sqrt(g*dz(1)*rho(1)/(rho(2)*alpha)*(theta(1)-(theta(1)+theta(2))/2)/theta(1))
        f(2)=rho(2)*alpha*w_th(2)
        e(2)=f(2)
        d(2)=0
        ! Calcul des valeurs de w_th et theta_th
        do k = 2, klev-1
            var_int=rho(k)/rho(k+1)*w_th(k)**2 + g*dz(k)*rho(k)/(rho(k+1)*alpha)*(theta_th(k)-theta(k))/theta(k)
            if (var_int>0.) then
                w_th(k+1) = sqrt(var_int)   ! premi??re estimation de w_th avec d=0
            else
                w_th(k+1)=0.
                f(k+1)=0.
                theta_th(k+1)=theta(k+1)
                k_stop=k+1
                exit
            end if
            f(k+1) = rho(k+1)*alpha*w_th(k+1)
            d(k)=max(0.0,f(k)-f(k+1))
            e(k)=max(0.0,f(k+1)-f(k))     

            var_int=rho(k)/rho(k+1)*w_th(k)**2 - d(k)*w_th(k)/(rho(k+1)*alpha) + g*dz(k)*rho(k)/(rho(k+1)*alpha)*(theta_th(k)-theta(k))/theta(k)
            if (var_int>0.) then        
                w_th(k+1) = sqrt(var_int)   ! deuxi??me estimation de w_th avec d!=0
            else
                w_th(k+1)=0.
                f(k+1)=0.
                theta_th(k+1)=theta(k+1)
                k_stop=k+1
                exit
            end if

            f(k+1) = rho(k+1)*alpha*w_th(k+1)
            d(k)=max(0.0,f(k)-f(k+1))
            e(k)=max(0.0,f(k+1)-f(k))
            theta_th(k+1)=(e(k)*theta(k)-d(k)*theta_th(k))/f(k+1) + theta_th(k)*f(k)/f(k+1)
        
        end do
    end if

    !Valeur de d_theta_th ?? la premi??re couche
    d_theta_th(1)=d_theta_th(1) + (f(2)*(theta(2)-theta_th(1)))/(rho(1)*dz(1))

    !Valeur de d_theta_th ?? partir de la 2??me couche
    do k=2,klev-1
        d_theta_th(k)=d_theta_th(k) + (f(k+1)*(theta(k+1)-theta_th(k))+f(k)*(theta_th(k-1)-theta(k)))/(rho(k)*dz(k))
    end do

    !Valeur de d_theta_th ?? la derni??re couche
    d_theta_th(klev)=d_theta_th(klev) + (f(klev)*(theta_th(klev-1)-theta(klev)))/(rho(klev)*dz(klev))


    ! Affichage des r??sultats
    print *, "La plume s'est arr??t??e au niveau = ", k_stop

end SUBROUTINE panache_thermique
