! $Id: physiq.F 1565 2011-08-31 12:53:29Z jghattas $

      SUBROUTINE phys_param_dev_rad (nlon,nlev, &
     &            debut,lafin,pdtphys, &
     &            paprs,pplay,pphi,pphis,presnivs,clesphy0, &
     &            vitu,vitv,temp,qx, &
     &            flxmass_w, &
     &            d_u, d_v, d_t, d_qx, d_ps )

      USE dimphy
      USE infotrac
      USE geometry_mod, ONLY: cell_area, latitude_deg, longitude_deg
      USE phys_cal_mod, only: year_len, mth_len, days_elapsed, jh_1jan, &
         year_cur, mth_cur,jD_cur,jH_cur, jD_ref
      USE ioipsl , ONLY : getin
      use yomcst_mod_h
      USE flux_arp_mod_h

      IMPLICIT NONE
!======================================================================
! Objet: Moniteur general de la physique du modele
!======================================================================
!
!  Arguments:
!
! nlon----input-I-nombre de points horizontaux
! nlev----input-I-nombre de couches verticales, doit etre egale a klev
! debut---input-L-variable logique indiquant le premier passage
! lafin---input-L-variable logique indiquant le dernier passage
! jD_cur       -R-jour courant a l'appel de la physique (jour julien)
! jH_cur       -R-heure courante a l'appel de la physique (jour julien)
! pdtphys-input-R-pas d'integration pour la physique (seconde)
! paprs---input-R-pression pour chaque inter-couche (en Pa)
! pplay---input-R-pression pour le mileu de chaque couche (en Pa)
! pphi----input-R-geopotentiel de chaque couche (g z) (reference sol)
! pphis---input-R-geopotentiel du sol
! presnivs-input_R_pressions approximat. des milieux couches ( en PA)
! vitu-------input-R-vitesse dans la direction X (de O a E) en m/s
! vitv-------input-R-vitesse Y (de S a N) en m/s
! temp-------input-R-temperature (K)
! qx------input-R-humidite specifique (kg/kg) et d'autres traceurs
! d_t_dyn-input-R-tendance dynamique pour "t" (K/s)
! d_q_dyn-input-R-tendance dynamique pour "q" (kg/kg/s)
! flxmass_w -input-R- flux de masse verticale
! d_u-----output-R-tendance physique de "u" (m/s/s)
! d_v-----output-R-tendance physique de "v" (m/s/s)
! d_t-----output-R-tendance physique de "t" (K/s)
! d_qx----output-R-tendance physique de "qx" (kg/kg/s)
! d_ps----output-R-tendance physique de la pression au sol
!======================================================================


!============================================================================
! 0/ Declarations
!============================================================================

! include


      INTEGER ivap          ! indice de traceurs pour vapeur d'eau
      PARAMETER (ivap=1)
      INTEGER iliq          ! indice de traceurs pour eau liquide
      PARAMETER (iliq=2)

! Variables argument:
      INTEGER nlon
      INTEGER nlev

      REAL pdtphys
      LOGICAL debut, lafin
      REAL paprs(klev+1)
      REAL pplay(klev)
      REAL pphi(klev)
      REAL pphis
      REAL presnivs(klev)
      REAL znivsig(klev)

      REAL vitu(klev)
      REAL vitv(klev)
      REAL temp(klev),theta(klev)
      REAL qx(klev,nqtot)
      REAL flxmass_w(klev)
      REAL omega(klev) ! vitesse verticale en Pa/s
      REAL d_u(klev)
      REAL d_v(klev)
      REAL d_t(klev)
      REAL d_qx(klev,nqtot)
      REAL d_ps
      REAL da(klev),phi(klev,klev),mp(klev)
      INTEGER nbteta
      PARAMETER(nbteta=3)

      REAL, DIMENSION(klev) :: zaltitude,rho,rhodz,ovap,qsat,dz,modv,d_theta
      REAL, DIMENSION(klev+1) :: kz,ri
      REAL fq_sat,fcoriolis

      REAL, DIMENSION(klev) :: d_t_dyn,d_q_dyn,d_u_dyn,d_v_dyn
      REAL, SAVE, ALLOCATABLE :: t_pre(:),q_pre(:),u_pre(:),v_pre(:)

      REAL, SAVE :: flux_sensible=-10000, flux_latent=-10000
      INTEGER, SAVE :: flag_init=0, flag_forcing=0,flag_tscalc=0

      INTEGER        longcles
      PARAMETER    ( longcles = 20 )

      REAL temp_newton(klev)
      INTEGER k,l,j,kinv,ktop
      logical, SAVE :: first=.true.

      REAL taux, tauy

      REAL clesphy0( longcles      )
      
! Constante argument : 

      REAL, PARAMETER :: sigma = 5.67e-8
      REAL, PARAMETER :: kIR   = 1.e-10    ! paramètre ajustable
      REAL, PARAMETER :: eps_s =  1.0       ! Corps Noir
      REAL :: up = 0. 
      REAL :: dT_Rad(klev)
      REAL :: dp
      REAL :: Fvis = 340.
      REAL :: alpha = 10.
      REAL, SAVE :: Tsurf=300.,flux_srf,sensible
      REAL,save :: Tsurf_pre, dt_Ts
      
! Fluxes Argument : 

      REAL :: Fup(klev+1)
      REAL :: Fdown(klev+1)
      REAL :: Fnet(klev+1)
      REAL :: tau(klev+1,klev+1)! Fonction de Planck

!=====================================================================
! 1/ Some initialisations
!=====================================================================

if ( nlon /= 1 ) then
    stop 'physiq1dnum est fait pour tourner en 1D'
endif

fcoriolis=2.e-7
print*,'CORIOLIS ',fcoriolis
print*,'ENTREE DANS PHYSIQ'

if (first) then
     print*,'FIRST '
     allocate (t_pre(klev),q_pre(klev),u_pre(klev),v_pre(klev))
     d_u_dyn=0. ; d_v_dyn=0. ; d_t_dyn=0. ; d_q_dyn=0.
     call iophys_ini('phys.nc    ')
     first=.false.

! Lecture de parametres de controle des simulations
     call getin('flux_sensible',flux_sensible)
     call getin('flux_latent',flux_latent)
     call getin('flag_init',flag_init)
     call getin('flag_forcing',flag_forcing)
     call getin('flag_tscalc',flag_tscalc)
     if (flag_init==1) then
     ! On met l'eau et les traceurs à zero au debut
        qx=-d_qx/pdtphys
        qx=0.
     else if (flag_init==2) then
     ! On met l'eau et les traceurs à zero au debut
        qx=-d_qx/pdtphys
        qx=0.
     ! On prend une temperature potentielle uniforme theta=300K
        do k=1,klev
           temp(k)=300.*(paprs(k)/paprs(1))**(rd/rcpd)
        enddo
        Tsurf = temp(1)
	
     endif
     print*,'END FIRST'
else

! Si flag_forcing>0, on elimine le forçage du cas 1D pour le redéfinir
! en direct.
     if (flag_forcing>0) then ! on reprend les valeurs du pas precedent
        vitu(:)=u_pre(:)
        vitv(:)=v_pre(:)
        temp(:)=t_pre(:)
        qx(:,1)=q_pre(:)
        Tsurf = Tsurf_pre
     endif
     d_u_dyn(:)=(vitu(:)-u_pre(:))/pdtphys
     d_v_dyn(:)=(vitv(:)-v_pre(:))/pdtphys
     d_t_dyn(:)=(temp(:)-t_pre(:))/pdtphys
     d_q_dyn(:)=(qx(:,1)-q_pre(:))/pdtphys
endif
print*,'OK0'

d_u=0.
d_v=0.
d_t=0.
d_qx=0.
d_ps=0.
dt_Ts = 0.

!=====================================================================
! SUJET 5/ Transfert Radiatif 
!=====================================================================

! Calcul de tau entre chaque couche 

DO k = 1, klev+1
  DO l = 1, klev+1

     up = 0.5 * ABS(paprs(k)**2 - paprs(l)**2) ! Ecriture de up dans l'équation 34.
     tau(k,l) = EXP(- kIR * up)

  END DO
END DO

! Initialisation des flux 
Fup(:) = 0.
Fdown(:) = 0.

! Calcul des flux montant et descendant

DO k = 1, klev+1


   Fdown(k) = 0.
   Fup(k) = eps_s * PLANCK(Tsurf) * tau(1,k)      ! Calcul du flux issu de la surface et réduit par les couches du dessous avec température de surface constante en test

	! Calcul du flux Montant : Contribution des couches en-dessous de la couche k
   
   DO l=1,k-1

   Fup(k) = Fup (k) + PLANCK(temp(l)) * (tau(l+1,k) -  tau(l,k)) ! Somme de toute les contribution des couches du dessous

   ENDDO

	! Calcul du flux descendant : Contribution des couches au-dessus de la couche k
   DO j = k, klev

   Fdown(k) = Fdown(k) + PLANCK(temp(j)) * (tau(k,j) - tau(k,j+1)) ! Somme de la contribution de toute les couches du dessus

   ENDDO
ENDDO

! Calcul du flux net

DO k =1, klev+1
   Fnet(k) = Fup(k) - Fdown(k)
ENDDO

! Calcul du réchauffement radiatif 

DO k = 1,klev
   
   dp = paprs(k) - paprs(k+1)
   dT_Rad(k) = (rg/rcpd) * ( Fnet(k) - Fnet(k+1))/dp
   
ENDDO

sensible=-alpha*(Tsurf - temp(1))
Flux_srf = sensible - sigma * Tsurf**4 + Fdown(1) + Fvis
if ( flag_tscalc == 1 ) then
   Tsurf = Tsurf + Flux_srf*pdtphys/1e5
endif

!print*, 'Tsurf' , Tsurf

!=====================================================================
! 2/ Some usefull cocmputations
!=====================================================================
! Variables at mid-layer
!----------------------------------------------------

fcoriolis=2.*sin(rpi/4.)*2*rpi/86400.
do k=1,klev
   ! Variables définies au centre des couches
   zaltitude(k)=pphi(k)/RG
   ovap(k)=qx(k,1)
   rho(k)=pplay(k)/(rd*temp(k))
   qsat(k)=fq_sat(temp(k),pplay(k)/100.)
   theta(k)=temp(k)*(paprs(1)/pplay(k))**(rd/rcpd)
   rhodz(k)=(paprs(k)-paprs(k+1))/rg
   dz(k)=rhodz(k)/rho(k) ! Distance entre les deux interfaces adjacentes
   modv(k)=vitu(k)*vitu(k)+vitv(k)*vitv(k)
enddo
print*,'OK 1'

!=====================================================================
! 3/ Vertical turbulent diffusion
!=====================================================================

! Calcul du coefficient de diffusion turbulente
do k=1,klev
   kz(k)=2.*(1.-tanh(2.*(k-klev*5./6.)))/2.
enddo

! Surface fluxes, sensible and latent heat
if ( flag_tscalc == 0 ) then
   if ( flux_latent > -9999. ) flat=-flux_latent
   if ( flux_sensible > -9999. ) fsens=-flux_sensible
else
   flat=0.
   fsens=sensible
endif
print*,'fsens=',fsens
print*,'flat=',flat

! Vertical diffusion computation
taux=-vitu(1)/100.
tauy=-vitv(1)/100.

CALL diffkz(klev,nqtot,rho,rhodz,kz,theta,vitu,vitv,qx, &
   &         taux,tauy,fsens,flat,d_theta,d_u,d_v,d_qx)

! Changing potential temperature tendency to natural
d_t(:)=d_theta(:)*temp(:)/theta(:)
! Ajout du réchauffement radiatif des couches dans la température
d_t(:) = d_t(:) + dT_Rad(:)

!============================================================================
! 9/ Writing outputs
!============================================================================
 
print*, 'Flux montant', Fup(1)
print*, 'Flux descendant', Fdown(1)

print*, 'Température de surface', temp(1)
print*,'PHY1DNUM OK5'
 call iophys_ecrit('kz',nlev,'Kz','m2/s',kz)

 !call iophys_ecrit('tau',nlev,'transmitivity',tau(1:klev,1))
 call iophys_ecrit('kinv',1,'Kinv',' ',float(kinv))
print*,'PHY1DNUM OKavant dz'
 call iophys_ecrit('dz',nlev,'dz','m',dz)
print*,'PHY1DNUM OKdz'
!print*,'u',vitu
 call iophys_ecrit('u',nlev,'Vent zonal moy','m/s',vitu)
 call iophys_ecrit('dtrad',nlev,'Tendance radiative','K/s',dT_Rad(1:nlev))
 call iophys_ecrit('Flux_srf',1,'Flux en surface Ts','W/m2',Flux_srf)
 call iophys_ecrit('fdn',nlev,'Flux radiatif descendant','W/m2',Fdown(1:nlev))
 call iophys_ecrit('fup',nlev,'Flux radiatif montant','W/m2',Fup)
print*,'PHY1DNUM OKu'
 call iophys_ecrit('v',nlev,'Vent meridien moy','m/s',vitv)
 call iophys_ecrit('temp',nlev,'Temperature','K',temp)
 call iophys_ecrit('ovap',nlev,'humidite specifique ','g/kg',ovap)
 call iophys_ecrit('rh',nlev,'humidite relative ','g/kg',ovap/qsat)
 call iophys_ecrit('qsat',nlev,'humidite a saturation ','g/kg',qsat)
 call iophys_ecrit('theta',nlev,'Temperature pot','K',theta)
 call iophys_ecrit('geop',nlev,'Geopotential','m2/s2',pphi)
 call iophys_ecrit('rhodz',nlev,'layer mass = rho * dz ','kg/m2',rhodz)
 call iophys_ecrit('ps',1,'Surface pressure','Pa',paprs)
 call iophys_ecrit('sens',1,'Surface sensible flux','W/m2',fsens)
 call iophys_ecrit('flat',1,'Surface latent flux','W/m2',flat)
 call iophys_ecrit('tsrf',1,'Surface temperature','K',Tsurf)


! Écriture des tendances 
 call iophys_ecrit('d_u',nlev,'Tendance u','m/s/s',d_u)
 call iophys_ecrit('d_v',nlev,'Tendance v','m/s/s',d_v)
 call iophys_ecrit('d_t',nlev,'Tendance t','K/s',d_t)
 call iophys_ecrit('d_qx',nlev,'Tendance vap','kg/kg/s',d_qx)

 call iophys_ecrit('d_u_dyn',nlev,'d_u_dyn','m/s',d_u_dyn)
 call iophys_ecrit('d_v_dyn',nlev,'d_v_dyn','m/s',d_v_dyn)
 call iophys_ecrit('d_t_dyn',nlev,'d_t_dyn','m/s',d_t_dyn)
 call iophys_ecrit('d_q_dyn',nlev,'d_q_dyn','m/s',d_q_dyn)

      print*,'COUCOU B PHYDEV'
u_pre(:)=vitu(:)+d_u(:)*pdtphys
v_pre(:)=vitv(:)+d_v(:)*pdtphys
t_pre(:)=temp(:)+d_t(:)*pdtphys
q_pre(:)=qx(:,1)+d_qx(:,1)*pdtphys
!Tsurf_pre = Tsurf * dt_Ts * pdtphys

      return
      
! Fonction de Planck   
CONTAINS
REAL FUNCTION planck(T)

    REAL, INTENT(IN) :: T
    planck = sigma * T**4
    
END FUNCTION planck
      
      end
      
      
      


