subroutine radiation(klev,paprs,kIR,eps_s,rg,rcpd,tau,tsurf,temp,Fup,Fdown,dT_Rad)

implicit none
integer, intent(in) :: klev

real,intent(in) :: kIR,eps_s,rg,rcpd,tsurf
real,intent(in), dimension(klev) :: temp
real,intent(in), dimension(klev+1) :: paprs
real,intent(out), dimension(klev+1) :: Fup,Fdown
real,intent(out), dimension(klev+1,klev+1) :: tau
real,intent(out), dimension(klev) :: dT_Rad

REAL, PARAMETER :: sigma = 5.67e-8

real, dimension(klev+1) :: Fnet
integer :: k,l,j
real :: up,dp

!=====================================================================
! SUJET 5/ Transfert Radiatif 
!=====================================================================

! Calcul de tau entre chaque couche 
print*,'radiation mini projet'

DO k = 1, klev+1
  DO l = 1, klev+1

     up = 0.5 * ABS(paprs(k)**2 - paprs(l)**2) ! Ecriture de up dans l'équation 34.
     tau(k,l) = EXP(- kIR * up)

  END DO
END DO

! Initialisation des flux 
Fup(:) = 0.
Fdown(:) = 0.

! Calcul des flux montant et descendant

DO k = 1, klev+1


   Fdown(k) = 0.
   Fup(k) = eps_s * planck(Tsurf) * tau(1,k)      ! Calcul du flux issu de la surface et réduit par les couches du dessous avec température de surface constante en test

	! Calcul du flux Montant : Contribution des couches en-dessous de la couche k
   
   DO l=1,k-1

   Fup(k) = Fup (k) + planck(temp(l)) * (tau(l+1,k) -  tau(l,k)) ! Somme de toute les contribution des couches du dessous

   ENDDO

	! Calcul du flux descendant : Contribution des couches au-dessus de la couche k
   DO j = k, klev

   Fdown(k) = Fdown(k) + planck(temp(j)) * (tau(k,j) - tau(k,j+1)) ! Somme de la contribution de toute les couches du dessus

   ENDDO
ENDDO

! Calcul du flux net

DO k =1, klev+1
   Fnet(k) = Fup(k) - Fdown(k)
ENDDO

! Calcul du réchauffement radiatif 

DO k = 1,klev
   
   dp = paprs(k) - paprs(k+1)
   dT_Rad(k) = (rg/rcpd) * ( Fnet(k) - Fnet(k+1))/dp
   
ENDDO

return

! Fonction de Planck   
CONTAINS
REAL FUNCTION planck(T)

    REAL, INTENT(IN) :: T
    planck = sigma * T**4
    
END FUNCTION planck

end subroutine radiation
