      FUNCTION HEAVYSIDE(x, Delta, Hprime)

C    Copyright (C) 1996, Centre National de la Recherche Scientifique
C real x        in     argument of the Heavyside
C real Delta    in     width of the step
C real Hprime   out    smoothed derivative
C
C***************************************************************
C*                                                             *
C* HEAVYSIDE  function at x/Delta and d./dx.                   *
C*   Compute a smoothed Heaviside function                     *
C* written by  : Anne MATHIEU, 14/05/96, 18.03.23              *
C***************************************************************
      integer ientry
      real Rx,H,x,Hprime,Delta,Div

      ientry = 0
      goto 1000

      ENTRY  HEAVYDELTA(x, Delta, Hprime)
      ientry = 1

1000  continue

      if (Delta.eq.0.0) Delta=1.

      Rx = exp( -abs(x*10./Delta) )
      H = 1./(1. + Rx)
      Div = min(1.E10,abs(10.*H*H/Delta))

      Hprime = sign(Rx*Div,Delta)

      if (x*10./Delta .gt. 0.0) then
        Heavyside = H
      else
        Heavyside = 1. - H
      endif

      if (ientry.eq.1) Heavydelta = Hprime

      return
      end
