      SUBROUTINE MXREGI(abuf,k2,iflag,Zprint,TOL)
      parameter(lp=0)
      parameter(np=12,mp=26)
      parameter(maxstep=100 000)
      parameter(n=np)
      dimension abuf(n,n),abuf1(n,n),abuf2(n,n),umx(n,n)
      dimension abuf3(n,n),abuf4(n,n),iPiv(n)
      logical Zprint
c initialisations
      call mxuty(umx,n)
9000  format('->',A8,10(e15.7))
9001  format('->',A20,I4,10(e15.7))
c ------------------------------------------------
c   regularisation par Log A = 2^k Log [A^(1/2^k)]
c ------------------------------------------------
      k2=0
      yk2=1.
      DO WHILE (yk2.gt.0.5 .and. k2.le.20)
        k2=k2+1
c              print*,'>sqrt() k2,abuf  ',k2,abuf
c entree : abuf, sorties : A^1/2 -> abuf2; A^-1/2 -> abuf1
c --------------------------------------------------------
c Denman-Beavers algo pour calculer A^1/2
c  Y(0)=A; Z(0)=I
        call ucopy(abuf,abuf2,n*n)
        call mxuty(abuf1,n)
        k=0
        pkp=1.
        do while (pkp.gt.TOL .and. k.le.20)
            k=k+1
c              print*,'loop k,abufYk ',k,abuf2
c              print*,'loop k,abufZk ',k,abuf1
c   Y(k+1)=[Y(k)+Z(k)^-1]/2.
c Zk ^-1 -> abuf3
          call ucopy(abuf1,abuf3,n*n)
          call mxuty(umx,n)
          call sgesv(n,n,abuf3,n,iPiv,umx,n,info)
          call ucopy(umx,abuf3,n*n)
          if (info.ne.0) print*,'*** SGESV(Zk abuf3,umx) error: ',
     +                   info,' at k',k
c      + Yk ]/2. -> Y(k+1)<-> abuf4
          call vadd(abuf2,abuf3,abuf3,n*n)
          call vscale(abuf3,0.5,abuf4,n*n)
c   Z(k+1)=[Z(k)+Y(k)^-1]/2.
c Yk ^-1 -> abuf3
          call ucopy(abuf2,abuf3,n*n)
          call mxuty(umx,n)
          call sgesv(n,n,abuf3,n,iPiv,umx,n,info)
          call ucopy(umx,abuf3,n*n)
          if (info.ne.0) print*,'*** SGESV(Yk abuf3,umx) error: ',
     +                   info,' at k',k
c      + Zk ]/2. -> Y(k+1)<-> abuf3
          call vadd(abuf1,abuf3,abuf1,n*n)
          call vscale(abuf1,0.5,abuf1,n*n)
c
          call ucopy(abuf4,abuf2,n*n)
c
c critere d'arret sur YkZk=I
c       Log A = 2 Log Yk - Log YkZk
          call mxmpy(abuf1,abuf2,abuf3,n,n,n)
          call mxuty(umx,n)
          call vsub(abuf3,umx,abuf3,n*n)
          pkp=vmaxa(abuf3,n*n)
        enddo
        if (k.ge.20) Zprint=.true.
c **** verifs fin sqrt
        if (Zprint) then
          print*,' verif abuf1*abuf2-I'
          print 9000,'0buf3 ',abuf3
          call mxmpy(abuf2,abuf2,abuf3,n,n,n)
          print*,' verif abuf = abuf2^2 apres k=',k,pkp
          print 9000,'Abuf3 ',abuf3
        endif
        call ucopy(abuf2,abuf,n*n)
c critere d'arret sur Yk = I+[eps]
        call mxuty(umx,n)
        call vsub(abuf2,umx,abuf3,n*n)
        yk2=vmaxa(abuf3,n*n)
      ENDDO
      if (k2.ge.20) then
        print*,' *** Pb convergence dans MXREGI',k2,yk2,k,pkp
        Zprint=.true.
      endif
c*** verification A = abuf**2K2
      if (Zprint) then
        call mxmpy(abuf,abuf,abuf3,n,n,n)
        do k=1,k2-1
          call mxmpy(abuf3,abuf3,abuf1,n,n,n)
          call ucopy(abuf1,abuf3,n*n)
        enddo
        print*,'*** Sortie DB verif A=abuf**2k2 k2=',k2
        print 9000,'vbuf3 ',abuf3
        print 9001,'A^(1/2^k2), k2, abuf',k2,abuf
      endif
      return
      END
