      program principal
      parameter (maxtime=5000,maxtau=201)
      common/ PAWC/ HLIMIK (200 000)
      character*40 FICPOW, POWINT,CHADIR 
      dimension time(maxtime),gain(maxtau,maxtime),tau(maxtau)

      data  IOUPOW / 50 / FICPOW,POWINT / 'bookgain.dat','alain' /

c ----------- lecture tau_Borel.data --------
c ...........  et passage a Tau = dt/2 ......
      open (10,file='tau_Borel.data',status='OLD')
      j=0
      do i=1,maxtau
        read(10,1000,end=100)tau(i)
        tau(i)=0.5*tau(i)
        j=j+1
      enddo
100   continue
      ntau=j
      close (10)
1000  format(201(1x,e12.5))
c ----------- lecture time dans gains.data --------
      open (10,file='gains.data',status='OLD')
      j=0
      do i=1,maxtime
        read(10,1000,end=200)time(i)
        j=j+1
      enddo
200   continue
      ntime=j
      close (10)
      taumin=min(tau(1),tau(ntau))
      taumax=max(tau(1),tau(ntau))
c=========================================================      
c=============  macro pour PAW / VIZU ====================      
c=========================================================      
      open (10, file='borel.kumac',status='unknown')
      write(10,"(A)") '/ZEBRA/RZ/FILE 50 bookgain.dat 1024 !'
      write(10,"(A)") '/ZEBRA/RZ/CDIR  //lun50/01-01 !'
      write(10,"(A)") 'set ncol 32'
      write(10,"(A)") 'palette 1'
      write(10,"(A)") "title 'Lorenz 63 PBL model'"
      write(10,"(A)") 'angle 90 0'
      write(10,"(A,I3,A,I3,A)")     'hi/plot 100(1:',ntau,',1:',ntime,')
     s surf2zA'
c      write(10,"(A)") "atit  'Tau Borel variable' 'time' ! 0 !"
      write(10,"(A,4F5.0,2E10.2,A)") '/GRAPH/PRIM/AXIS ',
     s        0.1*float(ntau/10),float(ntau),
     s      -float(ntime/45),-float(ntime/45),taumin,taumax,' 510'
c     s      -float(ntime/45),-float(ntime/45),taumin,taumax,' 510 G'
      write(10,"(A,6F7.0,A)")'/GRAPH/PRIM/AXIS ',-float(ntau/80),
     s   -float(ntau/80),float(ntime/60),float(ntime),time(1),
     s   time(ntime),' 510 -'
      write(10,"(A,2F7.0,A)") '/GRAPH/PRIM/TEXT ',0.75*float(ntau),
     s   -float(ntime/20)," 'Tau (Borel variable)' 0.2 0. L"
      write(10,"(A,2F7.0,A)") '/GRAPH/PRIM/TEXT ',-float(ntau/40),
     s   0.9*float(ntime)," 'Time along trajectory' 0.2 90. R"
      close(10)

c=========================================================      
c=========================================================      
c=========================================================      
      print*,' -- DEBUT BOREL, ntau=',ntau,' ntime=',ntime
chbook ===================================================
         CALL  HLIMIT (200 000)
      print*,' -- HROPEN'
         call  HROPEN (IOUPOW,POWINT,FICPOW,'U',1024,ISTATU)
         if (ISTATU.ne.0) then
          print *, ' --- HROPEN ISTATU =',ISTATU,' ---'
          print 3000 ,FICPOW
3000  format ('  --- HROPEN nouveau fichier ',A /,1X,61(1H*))
          call  HROPEN (IOUPOW,POWINT,FICPOW,'N',1024,ISTATU)
         endif

2000     format (A15)
         write (CHADIR,2000) 'Borel g sweep'
c  histogramme de gain(i,j)
         CALL HBOOK2(100,CHADIR,ntau,1.,float(ntau+1),
     s                                ntime,0.,float(ntime),0.)
         write (CHADIR,2000) 'Borel eff-gain'
c histogramme de 1/(1-gain(i,j))
         CALL HBOOK2(110,CHADIR,ntau,1.,float(ntau+1),
     s                                ntime,0.,float(ntime),0.)
c      print*,' -- HBOOK'
         open(10,file='gains.data',status='OLD')
chbook =======================================================
c   calcul format (impose 3 digits pour ntau)
         write (CHADIR,2200) ntau+1
2200  format('(',I3,'(1xe12.5))')
      print*,CHADIR
      do i=1,ntime
         read(10,CHADIR)time(i),(gain(j,i),j=1,ntau)
      enddo
      do i=ntime-9,ntime
         print CHADIR,time(i),(gain(j,i),j=ntau-9,ntau)
      enddo
      do i=1,ntime
        do j=1,ntau
          CALL HFILL( 100, float(j)+0.5, float(i)-0.5,
     s                                   3.*tanh(gain(j,i)/3.) )
          CALL HFILL( 110, float(j)+0.5, float(i)-0.5,
     s                            3.*tanh(1./(1.-gain(j,i))/3.))
        enddo
      enddo

      IMM=1
      IAA=1
      write (CHADIR,1088) IMM,IAA
1088  format (I2.2,'-',I2.2)
      print *,'--- Hbook saving in RZ directory :  ',CHADIR

      call  HMDIR (CHADIR,'S')
      call  HROUT (0,icycle,' ')
      call  HCDIR ('\\',' ')
      call  HREND  (POWINT)
      CLOSE(ioupow)
c fin book     =================================

c      CALL HTITLE(CHADIR)
c      CALL HISTDO
c      CALL  HRESET (0,' ')
c      print*,' *** hbook reset mois',imm,iaa
c ==========================================
c
       end
