      PROGRAM SUBMOD
C-------------------------------------------------------------
C      Ce programme lit la fonction Ftsh sur le fichier id.dat, y
C    soustrait les modes prealablement identifies (lesquels figurent
C    sur le fichier modes.id) et ecrit le resultat sur le fichier
C    id_upd.dat.
C
C  ATTENTION : les abscisses sont en 'Log(tau)' sur id.dat et sur id_upd.dat.
C              on les transforme en 'Ln(tau)' pour les calculs.
C
      DIMENSION FTSH(1000), Y(1000)
C
      OPEN (12,FILE='id.dat',status= 'old')
      OPEN (13,FILE='modes.id',status = 'unknown')
      OPEN (14,FILE='id_upd.dat',status= 'unknown')
C
C     .Lecture de la fonction ftsh
C
      READ (12,*) M
      READ (12,*) (Y(I),FTSH(I),I=1,M)
C     .to natural logarithm coordinate
      coef = LOG(10.)
      DO I=1,M
        Y(I) = Y(I)*coef
      ENDDO
C
C     . Soustraction des modes deja identifies
      READ(13,*) NMODES
      DO IMODES = 1,NMODES
C        MULTMOD vaut 1 pour un pole simple et 2 pour deux poles.
C        Multmod <0 => mode non pris en compte.
        READ(13,*) MULTMOD
C
        IF (ABS(MULTMOD) .EQ. 1) THEN
          READ(13,*) SRHO
          READ(13,*) SA
          IF (MULTMOD .GT. 0) THEN
            DO I = 1,M
              G1 = 1./(1.+EXP(Y(I)-SRHO))
              FTSH(I) = FTSH(I) - SA*G1
            ENDDO
          ENDIF
        ELSE IF (ABS(MULTMOD) .EQ. 2) THEN
          READ(13,*) SRHO
          READ(13,*) SXI
          READ(13,*) SA
          READ(13,*) SB
          IF (MULTMOD .GT. 0) THEN
            DO I=1,M
              DEN = 2*(COSH(Y(I)-SRHO)+SXI)
              H1 = 1. /DEN
              H2 = EXP(-(Y(I)-SRHO))/DEN
              FTSH(I) = FTSH(I) - SA*H1 - SB*H2
            ENDDO
          ENDIF
        ELSE
            PRINT *,' ERROR; POLE MULTIPLICITY .NE. 1 OR 2 : ',MULTMOD
            STOP
        ENDIF
      ENDDO
C
C     .back to decimal logarithm coordinate
      coef = LOG(10.)
      DO I=1,M
        Y(I) = Y(I)/coef
      ENDDO
C
C
      WRITE (14,*) M, '   Nombre de points'
      DO I = 1,M
        WRITE (14,*) Y(I),FTSH(I)
      ENDDO
C 
      END
