      SUBROUTINE snewt(ntrial,sol,n,tolx,tolf,DD,ff,ifin,info)
C solve a linear system with a newton method
C    Copyright (C) 1999 Universite Paul Sabatier, Toulouse
C    Copyright (C) 2003, 2004,
C         Centre National de la Recherche Scientifique
C--------------------------------------------------------
C  ecrit par : Stephane Blanco en 1999 (D_loop)
C--------------------------------------------------------
C modifie fin 2003 par : Al1
C modifie fin 2004 par : Al1, passage a LAPACK
C--------------------------------------------------------
      parameter(np=12,mp=26)
      parameter(maxstep=100 000)
      parameter(lp=0)
      integer mp,np,lp,maxstep
C advance newton. In order to solve fun(x) = 0, advance with dx solution of
C fun' dx = fun
C ntrial   (in)       number of trial
C sol      (in/out)   estimate of the equation solution
C n        (in)       n^2 size of dd and n size of ff and sol (unused)
C tolx     (in)       tolerance on result
C tolf     (in)       tolerance on advance
C What we actually want is to solve r(x) = x, therefore we need to
C recompute fun(x) = r(x) - x with the following values:
C dd       (in)       derivative of r, evaluated at ff
C ff       (in)       r(sol), sol being the previous estimate
C In our case r is f(eta,ff)
C ifin     (out)      a tolerance is attained
C info     (out)      lapack information
       INTEGER n,ntrial,ifin,info
C       REAL tolf,tolx,
       DIMENSION sol(mp)
C    USES SGESV LAPACK and,usrfun
       INTEGER i,k,indx(mp)
C       REAL errf,errx,
        DIMENSION fjac(mp,mp),fvec(mp),p(mp)
        DIMENSION DD(mp,mp),ff(mp)
       INTEGER iPiv(mp)
       ifin=0
       do 14  k=1,ntrial
        call usrfun(sol,mp,mp,fvec,fjac,DD,ff)
        errf=0.
        do 11 i=1,mp
          errf=errf+abs(fvec(i))
11      continue
        if(errf.le.tolf) then
          ifin=1
        endif
C  P will be over-written by SGESV
        do 12 i=1,mp
          p(i)=fvec(i)
12      continue
C Resolution systeme lineaire [fjac] |x> = |p>
        call SGESV(n,1,fjac,mp,iPiv,p,mp,info)
        if (info.ne.0) print*,'*** SGESV error: ',info,' trial # ',k
        errx=0.
        do 13 i=1,mp
          errx=errx+abs(p(i))
          sol(i)=sol(i)+p(i)
13      continue
        if(errx.le.tolx) then
          ifin=1
        endif
14     continue
      return
      END
