C skdisri.f
C Time discretization of  the ricatti equation of variance covariance
C update. The equation is
C dP/dt = F*P + P*F^T + W*Q*W^T
C the results are the matrix dA dC of the time discretisation:
C dP + dA*dP + dP*dA^T = dC

C    Copyright (C) 2004, Patrice Dumas
C
C    This program is free software; you can redistribute it and/or
C    modify it under the terms of the GNU General Public License as
C    published by the Free Software Foundation; either version 2 of
C    the License, or (at your option) any later version.
C
C    This program is distributed in the hope that it will be useful,
C    but WITHOUT ANY WARRANTY; without even the implied warranty of
C    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C    GNU General Public License for more details.
C
C    You should have received a copy of the GNU General Public License
C    along with this program; if not, write to the Free Software
C    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
C    MA 02111-1307 USA

      SUBROUTINE skdisri(aspha,mereta,coveta,covfor,dcoric,
     $daric,n,nerr,np,nerrp,dtime)

C
C aspha             state advance matrix = F
C mereta            matrix multiplying noise to add it to the state = W
C coveta            variance-covariance matrix of the noise = Q
C covfor            variance-covariance of the state (the forecast) = P
C dcoric            matrix in the discretized Ricatti equation
C daric             matrix in the discretized Ricatti equation
C n                 dimension of the state
C nerr              dimension of the error vecteur
C np                storage dimension of the state
C nerrp             storage dimension of the error vecteur
C dtime             time step length
C
      integer n,nerr,np,nerrp
      real dtime
      real aspha(np,np),mereta(np,nerrp),coveta(nerrp,nerrp)
      real covfor(np,np),dcoric(np,np),daric(np,np)

      character*32 title


C Compute dcoric = dtime (F*P + P*F^T + W*Q*W^T)
C use temporarily daric to hold F^T, F*P and W*Q*W^T
      call transmat (aspha,daric,n,np,n,np)
      call matmlt (covfor,daric,dcoric,n,np,n,np,n,np)
      call matmlt (aspha,covfor,daric,n,np,n,np,n,np)
      call matadd (daric,dcoric,dcoric,n,np,n,np)
      call matsq (mereta,coveta,daric,n,np,nerr,nerrp)
      call matadd (daric,dcoric,dcoric,n,np,n,np)
      call scamat (dtime,dcoric,dcoric,n,np,n,np)

C Compute daric = -F dtime/2
      call scamat ((-dtime)/2,aspha,daric,n,np,n,np)

C      title = 'daric'
C      call printmat (title,daric,n,np,n,np)
C      title = 'dcoric'
C      call printmat (title,dcoric,n,np,n,np)

      return
      end
