      PROGRAM IDLSQ
C==============================================================================
C          EXEMPLE D'IDENTIFICATION DES MODES DANS LA TRANSFORMEE DE BOREL
C==============================================================================
C
C But :
C ---
C             Identification d'un mode
C
C Methode :
C -------
C         Ajustement d'une sigmoide (transformee de Borel d'un amortissement) sur la
C      fonction consideree.
C         La minimisation sa fait par la methode de Householder.
C Exemple traite :
C --------------
C       Coefficient de couplage [Debit -> Pl] dans l'evaporateur de la pompe.
C
C Principe :
C --------
C-La fonction sur laquelle ont veut identifier les modes est designee par ftsh.
C  La fonction ftsh est donnee par un echantillonage :
C                  ftsh_i = ftsh(y_i)  ;  1 =< i =< m
C  (le fichier id.dat contient (tau_i, ftsh_i); il suffit de prendre y_i=Ln(tau_i) )
C-Le mode va etre recherche sur un segment [y1,y2]. Les valeurs de y1 et y2 sont lues
C  dans le fichier input.id .
C-On va chercher le parametres rho du mode amorti, le poids a de la sigmoide, et le
C  terme constant c pour lesquels le Chi2 :
C       Chi2 = Sum_for_y1<y_i<y2 [  (ftsh_i - a*G1(y_i) - c)**2  ]
C  est minimal.
C  Avec :
C       G1(y) = 1. / [1. + exp(y-rho)]       
C   (G1 est une sigmoide inflechie a rho)
C    La fonction concrete correspondante est a*exp(-k*t), avec k=exp(rho)
C
C
      IMPLICIT REAL*8 (A-H,O-Z)
C
      PARAMETER (MD=400)
      PARAMETER (ND=100)
      PARAMETER ( NDP1 = ND+1, ND2 = 2*NDP1, NDM1 = ND-1, NDM2 = ND-2
     *          ,MND = MD*NDP1)
C
      DIMENSION A(MND),B(MD),IPIV(NDP1),AUX(ND2),FTSH(MD)
     *         ,Y(MD),X(NDM1),SIG(MD),V(MD),FITPAR(NDP1)
     *         ,FPAR(NDP1),DIAGN(NDP1),DFPAR(ND)
      DIMENSION AA(MND),BB(MD)
      REAL*4 FPAROUT(ND),VOUT(MD)
      EQUIVALENCE (TA,FPAR(1)),(TC,FPAR(2))
      EQUIVALENCE (TRHO,FPAR(3))
C
C 0. INITIALISATION
C -----------------
C
      IER = 0
      OPEN (11,FILE='input.id1',status = 'unknown')
      OPEN (12,FILE='id.dat',status= 'old')
      OPEN (13,FILE='modes.id',status = 'unknown')
C
      READ (11,*) N
C     . N = nombre de parametres ajustes
      IF (N .GT. ND-1) THEN
         PRINT *, 'N SHOULD BE AT MOST ',NDM1,'; N=',N
         STOP
      ENDIF
      READ (11,*) NITMAX
C     . Y1 et Y2 = bornes inferieure et superieure de l'intervalle de fit
      READ (11,*) Y1
      READ (11,*) Y2
C     . IFLAG : flag d'initialisation ( 0 : pas de fichier d'init.;
C                                       1 : fichier d'init.; 2 : restart)
      READ (11,*) IFLAG
C     . Lecture eventuelle des valeurs initiales
      IF (IFLAG .EQ. 1) THEN
        OPEN (14,FILE='fstappr.id1',status = 'unknown')
        READ (14,*) TRHO
        CLOSE (14)
      ENDIF
      IF (IFLAG .EQ. 2) THEN
        OPEN (14,FILE='resu.id1',status = 'unknown')
        READ (14,*) TRHO
        READ (14,*) TA
        CLOSE (14)
      ENDIF
C
      READ (12,*) M
      READ (12,*) (Y(I),FTSH(I),I=1,M)
C     .to natural logarithm coordinate
      coef = LOG(10.)
      DO I=1,M
        Y(I) = Y(I)*coef
      ENDDO
C
C     . Soustraction des modes deja identifies
      READ(13,*) NMODES
      DO IMODES = 1,NMODES
C        MULTMOD vaut 1 pour un pole simple et 2 pour deux poles.
C        Multmod <0 => mode non pris en compte.
        READ(13,*) MULTMOD
C
        IF (ABS(MULTMOD) .EQ. 1) THEN
          READ(13,*) SRHO
          READ(13,*) SA
          IF (MULTMOD .GT. 0) THEN
            DO I = 1,M
              G1 = 1./(1.+EXP(Y(I)-SRHO))
              FTSH(I) = FTSH(I) - SA*G1
            ENDDO
          ENDIF
        ELSE IF (ABS(MULTMOD) .EQ. 2) THEN
          READ(13,*) SRHO
          READ(13,*) SXI
          READ(13,*) SA
          READ(13,*) SB
          IF (MULTMOD .GT. 0) THEN
            DO I=1,M
              DEN = 2*(COSH(Y(I)-SRHO)+SXI)
              H1 = 1. /DEN
              H2 = EXP(-(Y(I)-SRHO))/DEN
              FTSH(I) = FTSH(I) - SA*H1 - SB*H2
            ENDDO
          ENDIF
        ELSE
            PRINT *,' ERROR; POLE MULTIPLICITY .NE. 1 OR 2 : ',MULTMOD
            STOP
        ENDIF
      ENDDO
C
C     . Iindices inferieur et superieur
      I1=1
      I2=M
      DO I=1,M
        IF (Y(I) .LT. Y1) I1 = I+1
        IF (Y(I) .LE. Y2) I2 = I
      ENDDO
C
C     . MM = Nbre de donnees fittees
      MM = I2 - I1 + 1
C
      PRINT 1010, (I,Y(I),FTSH(I),I = I1,I2)
1010  FORMAT (2(I4,2E13.5))
C
      CLOSE (11)
      CLOSE (12)
      CLOSE (13)
C
      NM1 = N-1
      NM2 = N-2
      NP1 = N+1
C
C 1. SET SIG
C ---------------
C
      DO I = I1,I2
        SIG(I) = 1.
      ENDDO
C
C 2.5 WRITE HEADER
C
      OPEN (12,FILE ='header.id',status = 'unknown')
      write (12,1002) M,N,Y1,Y2
1002  FORMAT (I5,I5,10(1X,F10.5))
      CLOSE (12)
C
C 4.  INITIALIZE PARAMETERS 
C -------------------------
C             (Attention : on suppose, pour le moment, que les sigmoides decroissent)
C
      TC = MIN(FTSH(I1),FTSH(I2))
      IF (IFLAG .EQ. 0) THEN
        TA = FTSH(I1) - FTSH(I2)
        TRHO = (Y1+Y2)/2.
      ENDIF
C
      PRINT *, 'Initial parameters : TA, TC, TRHO'
      PRINT 1000, TA, TC, TRHO
C
C ......................................................................
C
C 4.5 CHI2 MINIMIZATION LOOP
C --------------------------
      CHI2PREV = 0.
      DO NITER = 1,NITMAX
C          NFPAR = nombre de parametres ajustes.
        NFPAR = N
C     .  Par_1 = ta; Par(2) = tc; Par(3) = trho
C
C 5. FILL B
C ---------
C
      CHI2INIT = 0.
      DO I= I1,I2
            G1 = 1./(1.+EXP(Y(I)-TRHO))
           B(I) = (FTSH(I) - TA*G1 - TC)/SIG(I)
           CHI2INIT = CHI2INIT + B(I)*B(I)
      ENDDO
C
C 5.5 FILL 'A' MATRIX
C ----------------
C      
C       B_i =  (ftsh_i - a*G1(y_i) - c)/sig_i
C  Avec :
C       G1(y) = 1. / [1. + exp(y-rho)]       
C
C       A_i_j = D(B_i)/D(par_j)
C       Par_1 = ta; Par(2) = tc; Par(3) = trho
C
C     Attention : les indices sont permutes dans le code.
C   I = numero du point d'echantillonage (position Y(I))
C   J = numero du parametre fpar ajuste 
C   A (1D) represente un tableau AA (2D) a N colonnes et MM lignes;
C   le terme AA(J,I-I1+1) est en A( (I-I1)*N + J )
C
      DO I = I1,I2
        IP = (I-I1)*NFPAR
          G1 = 1./(1.+EXP(Y(I)-TRHO))
          DG1DRHO = EXP(Y(I)-TRHO)*G1*G1
C
C 5.51 DERIVATIVE RELATIVE TO 'TA'
C ..............................
        A(IP+1) = -G1/SIG(I)
C
C 5.53 DERIVATIVE RELATIVE TO 'TC'
C ..............................
        IF (NFPAR .GE. 2) THEN
          A(IP+2) = -1./SIG(I)
        ENDIF
C
C 5.54 DERIVATIVE RELATIVE TO 'TRHO'
C ..............................
        IF (NFPAR .GE. 3) THEN
          A(IP+3) = - TA*DG1DRHO / SIG(I)
        ENDIF
C
      ENDDO
C
C  COPIES DE A ET DE B DANS AA ET BB (POUR DIAGNOSTIC)
C
      DO I = I1,I2
        BB(I) = B(I)
        IP = (I-I1)*NFPAR        
        DO J = 1,NFPAR
          AA(IP+J) = A(IP+J)
        ENDDO
      ENDDO
C
C  Pour le moment : pas de normalisation
      DO J = 1,NFPAR
        DIAGN(J) = 1.
      ENDDO
C
      PRINT *, 'DIAGN'
      PRINT *, (DIAGN(J),J=1,NFPAR)
C
C 5.6 NORMALIZE 'A'
C -----------------
C
      DO J= 1,NFPAR
        DIAGN(J) = SQRT(DIAGN(J))
      ENDDO
      DO I= I1,I2
        IP = (I-I1)*NFPAR
        DO J = 1,NFPAR
          A(IP+J) = A(IP+J)/DIAGN(J)
        ENDDO
      ENDDO     
C
C 6. FIT
C ------
C
      PRINT *,' MATRICE A'
      DO I = I1,I2
        IP = (I-I1)*NFPAR
        PRINT *,I,(A(IP+J),J=1,NFPAR)
      ENDDO
C
      PRINT *,'B ',(B(I),I=I1,I2)
C      
      CALL OLLSQ(A,B(I1),FITPAR,MM,NFPAR,1,1,IPIV,AUX,IER)
      PRINT *, 'IER',IER
C
C 6.1 VERIFICATION DE LA MINIMISATION LINEAIRE
C --------------------------------------------
C
      CHI2L = 0.
      DO I = I1,I2
        V(I) = BB(I)
        IP = (I-I1)*NFPAR
        DO J = 1,NFPAR
          V(I) = V(I) - AA(IP+J)*FITPAR(J)/DIAGN(J)
        ENDDO
        CHI2L = CHI2L + V(I)*V(I)
      ENDDO      
C
C 6.5 UPDATE PARAMETERS WHILE STAYING WITHIN BOUNDARIES
C -----------------------------------------------------
      DO J = 1,NFPAR
        DFPAR(J) = - FITPAR(J)/DIAGN(J)
      ENDDO
      RATIO = 1.
      IF (TRHO+DFPAR(3) .GT. Y2) RATIO = (Y2-TRHO)/DFPAR(3)
      IF (TRHO+DFPAR(3) .LT. Y1) RATIO = (Y1-TRHO)/DFPAR(3)
      DO J = 1,NFPAR
        DFPAR(J) = DFPAR(J)*RATIO
      ENDDO
      DO J = 1,NFPAR
        FPAR(J) = FPAR(J) +DFPAR(J)
      ENDDO
C
C 7. CHI2
C -------
      NCUTSTEP = 0
70    CONTINUE
      CHI2 = 0.
      DO I = I1,I2
          G1 = 1./(1.+EXP(Y(I)-TRHO))
           V(I) = (FTSH(I) - TA*G1 - TC)/SIG(I)
C         
         CHI2 = CHI2 + V(I)*V(I)
      ENDDO
      PRINT *, 'DFPAR'
      PRINT 1000, (DFPAR(J),J=1,N)
      PRINT *, 'FPAR '
      PRINT 1000, (FPAR(I),I=1,N)
      PRINT *,'CHI2, CHI2INIT, CHI2L '
      PRINT 1000 , CHI2, CHI2INIT, CHI2L 
      PRINT *, 'V'
      PRINT 1000 , (V(I),I=I1,I2)
1000  FORMAT (10D13.5)
C
C 7.2 CUTSTEPS WHEN NECESSARY
C_____________________________
      IF ( CHI2 .GT. CHI2PREV .AND. NCUTSTEP .LT. 5
     $     .AND. NITER .GE. 2) THEN
         NCUTSTEP = NCUTSTEP + 1
         DO I= 1,N
            FPAR(I) = FPAR(I) - DFPAR(I)*2./3.
            DFPAR(I) = DFPAR(I)/3.
         ENDDO
         PRINT *, 'CUTSTEP'
         GO TO 70
      ELSE
         CHI2PREV = CHI2
      ENDIF
C
C 7.3 MATRICE DE COVARIANCE
C_________________________
      DO I= 1,NFPAR
        IP = (I-1)*NFPAR
        DO J= 1,NFPAR
          A(IP+J)=A(IP+J)/(DIAGN(I)*DIAGN(J))
        ENDDO
      ENDDO
C
      PRINT *, 'COVARIANCE'
      DO I= 1,NFPAR
        IP = (I-1)*NFPAR
        PRINT 1000, (A(IP+J),J=1,NFPAR)
      ENDDO

C
C 7.5 END OF CHI2 MINIMIZATION LOOP
C ---------------------------------
      ENDDO
C
C ......................................................................
C
C 8. FINAL FPAR AND V
C ------------
      DO I=1,N
        FPAROUT(I) = FPAR(I) 
      ENDDO
      DO I = I1,I2
        VOUT(I) = V(I)
      ENDDO
C ---------
C
      OPEN (10,FILE ='fpar.id1',status = 'unknown')
      OPEN (11,FILE ='covar.id1',status = 'unknown')
      OPEN (12,FILE ='residu.id1',status = 'unknown')
      OPEN (14,FILE='resu.id1',status = 'unknown')
c
      WRITE (10,1001) (FPAROUT(I),I=1,N)
1001  format (5x,'$',e13.6/,(5x,'$,',e13.6))
C
      DO I= 1,NFPAR
        IP = (I-1)*NFPAR
        WRITE (11,*) (A(IP+J),J=1,NFPAR)
      ENDDO
C
      WRITE (12,1003) (VOUT(I),I=I1,I2)
1003  FORMAT (5E13.5)
C
      WRITE (14,*) TRHO, '    rho'
      WRITE (14,*) TA, '    amplitude sigmoide'
C
      CLOSE (10)
      CLOSE (11)
      CLOSE (12)
      CLOSE (14)
C
      END
      SUBROUTINE OLLSQ(A,B,X,M,N,LAR,ICOR,IPIV,AUX,IER)
C
      IMPLICIT REAL*8 (A-H,O-Z)
C
      DIMENSION A(N,1),B(LAR,1),X(LAR,1),IPIV(1),AUX(1)                        
C
C    . ICOR = 1 => CALCUL DE LA MATRICE DE COVARIANCE
C
CCC      DATA EPS/1.E-07/
      DATA EPS/1.D-14/
1     L=LAR
      IF(M-N)30,7000,7000                                                      
7000  PIV=0.                                                                   
      DO 4 K=1,N                                                               
      IPIV(K)=K                                                                
      H=0.                                                                     
      DO 2 I=1,M                                                               
      H=H+A(K,I)*A(K,I)                                                        
2     CONTINUE                                                                 
      AUX(K)=H                                                                 
      IF(H-PIV)4,4,7001                                                        
7001  PIV=H                                                                    
      KPIV=K                                                                   
4     CONTINUE                                                                 
      IF(PIV)31,31,7002                                                        
7002  SIG=SQRT(PIV)                                                            
      TOL=SIG*EPS                                                              
      DO 210K=1,N                                                              
      IF(KPIV-K)8,8,7003                                                       
7003  H=AUX(K)                                                                 
      AUX(K)=AUX(KPIV)                                                         
      AUX(KPIV)=H                                                              
      DO 7 I=K,M                                                               
      H=A(K,I)                                                                 
      A(K,I)=A(KPIV,I)                                                         
      A(KPIV,I)=H                                                              
7     CONTINUE                                                                 
8     IF(K-1)11,11,7004                                                        
7004  SIG=0.                                                                   
      DO 10 I=K,M                                                              
      SIG=SIG+A(K,I)*A(K,I)                                                    
10    CONTINUE                                                                 
      SIG=SQRT(SIG)                                                            
      IF(SIG-TOL)32,32,11                                                      
11    SIG=SIGN(SIG,A(K,K))                                                     
      IPIV(KPIV)=IPIV(K)                                                       
      IPIV(K)=KPIV                                                             
      BETA=A(K,K)+SIG                                                          
      A(K,K)=BETA                                                              
      BETA=1./(SIG*BETA)                                                       
      AUX(N+K)=-SIG                                                            
      IF(K-N)7005,19,19                                                        
7005  KP1=K+1                                                                  
      KPIV=K+1                                                                 
      PIV=0.                                                                   
      DO 18 J=KP1,N                                                            
      H=0.                                                                     
      DO 15 I=K,M                                                              
      H=H+A(K,I)*A(J,I)                                                        
15    CONTINUE                                                                 
      H=BETA*H                                                                 
      DO 16 I=K,M                                                              
      A(J,I)=A(J,I)-A(K,I)*H                                                   
16    CONTINUE                                                                 
      AUX(J)=AUX(J)-A(J,K)*A(J,K)                                              
      IF(AUX(J)-PIV)18,18,7006                                                 
7006  PIV=AUX(J)                                                               
      KPIV=J                                                                   
18    CONTINUE                                                                 
19    IF(L.EQ.0)GO TO 210                                                      
      DO 21 J=1,L                                                              
      H=0.                                                                     
      DO 20 I=K,M                                                              
      H=H+A(K,I)*B(J,I)                                                        
20    CONTINUE                                                                 
      H=BETA*H                                                                 
      DO 21 I=K,M                                                              
      B(J,I)=B(J,I)-A(K,I)*H                                                   
21    CONTINUE                                                                 
210   CONTINUE                                                                 
      GO TO 240                                                                
      ENTRY OLLSQ1(A,B,X,M,N,LAR,ICOR,IPIV,AUX,IER)                                 
211   L=LAR
      IF(L.EQ.0)GO TO 240                                                      
      DO 230 K=1,N                                                             
      BETA=1./(A(K,K)*AUX(N+K))                                                
      DO 221 J=1,L                                                             
      H=0.                                                                     
      DO 220 I=K,M                                                             
      H=H+A(K,I)*B(J,I)                                                        
220   CONTINUE                                                                 
      H=BETA*H                                                                 
      DO 221 I=K,M                                                             
      B(J,I)=B(J,I)+A(K,I)*H                                                   
221   CONTINUE                                                                 
230   CONTINUE                                                                 
240   CONTINUE                                                                 
      IF(L.EQ.0)GO TO 100                                                      
      PIV=1./AUX(N+N)                                                          
      DO 22 K=1,L                                                              
      X(K,N)=PIV*B(K,N)                                                        
22    CONTINUE                                                                 
      IF(N-1)26,26,7008                                                        
7008  NM1=N-1                                                                  
      DO 25 I=NM1,1,-1                                                         
      IP=IPIV(I)                                                               
      PIV=1./AUX(N+I)                                                          
      DO 25 LL=1,L                                                             
      H=B(LL,I)                                                                
      IP1=I+1                                                                  
      DO 24 IL=IP1,N                                                           
      H=H-A(IL,I)*X(LL,IL)                                                     
24    CONTINUE                                                                 
      X(LL,I)=X(LL,IP)                                                         
      X(LL,IP)=PIV*H                                                           
25    CONTINUE                                                                 
26    IF(ICOR .EQ. 0)GO TO 226                                                   
100   A(N,N)=(1./AUX(N+N))**2                                                  
      IF(N.LT.2)GO TO 225                                                      
      DO 101 K=2,N                                                             
      KP=IPIV(K)                                                               
      IF(KP.LE.K)GO TO 101                                                     
      K1=K-1                                                                   
      DO 102 I=1,K1                                                            
      H=A(K,I)                                                                 
      A(K,I)=A(KP,I)                                                           
102   A(KP,I)=H                                                                
101   CONTINUE                                                                 
      DO110 J=N,2,-1                                                           
      J1=J-1                                                                   
      DO 115 I=J1,1,-1                                                         
      I1=I+1                                                                   
      S=0.                                                                     
      DO 116 K=I1,N                                                            
      KK=MAX0(K,J)                                                             
      JJ=MIN0(K,J)                                                             
116   S=S-A(K,I)*A(JJ,KK)                                                      
115   A(I,J)=S/AUX(N+I)                                                        
      S=1./AUX(N+J1)                                                           
      A(J1,J1)=S                                                               
      DO111 K=J,N                                                              
111   S=S-A(K,J1)*A(J1,K)                                                      
110   A(J1,J1)=A(J1,J1)*S                                                      
      DO120 J=2,N                                                              
      J1=J-1                                                                   
      DO 120 I=1,J1                                                            
120   A(J,I)=A(I,J)                                                            
      DO 130 J=N,1,-1                                                          
      JP=IPIV(J)                                                               
      IF(JP.LE.J)GO TO 130                                                     
      DO 131 I=1,N                                                             
      H=A(J,I)                                                                 
      A(J,I)=A(JP,I)                                                           
131   A(JP,I)=H                                                                
130   CONTINUE                                                                 
      DO 140 J=N,1,-1                                                          
      JP=IPIV(J)                                                               
      IF(JP.LE.J)GO TO 140                                                     
      DO 141 I=1,N                                                             
      H=A(I,J)                                                                 
      A(I,J)=A(I,JP)                                                           
141   A(I,JP)=H                                                                
140   CONTINUE                                                                 
225   IF(L.EQ.0)RETURN                                                         
226   NP1=N+1                                                                  
      DO 29 J=1,L                                                              
      H=0.                                                                     
      IF(M-N)29,29,7007                                                        
7007  DO 28 I=NP1,M                                                            
      H=H+B(J,I)*B(J,I)                                                        
28    CONTINUE                                                                 
29    AUX(J)=H                                                                 
      IER=0                                                                    
      RETURN                                                                   
30    IER=-2                                                                   
      RETURN                                                                   
31    IER=-1                                                                   
      RETURN                                                                   
32    IER=K-1                                                                  
      RETURN                                                                   
      END                                                                      
