#!/bin/bash

SIM=CTRL
th=""
physiq_def=physiq.def

n=1

#=========================================================================
while (($# > 0))
  do
  case $1 in
      "-h")
          echo "Usage : ./lance.sh [-s NOMSIM] [-p PhysiqTRUC.def] -t [iflag_thermals]" ;
          echo "Pour retrouver le papier original de 2002 :" ;
          echo "./lance.sh -s H202 -t 1000 " ; exit;;
      "-p") physiq_def="$2" ; shift ; shift ;;
      "-s") SIM="$2" ; shift ; shift ;;
      "-t") th="$2" ; shift ; shift ;;
      "-n") n="$2" ; shift ; shift ;;
      *) ./lance.sh -h ; exit ;;
  esac
done
if [ ! -f $physiq_def ] ; then
    echo "$physiq_def absent"
    ./lance.sh -h ; exit
fi
#=========================================================================

if [ -d $SIM ] ; then
   \rm -rf $SIM
fi

# ./compile.x

cass=(   00SC 00WC 03SC 05SC 05WC 15B  24B  24F  24SC )
timestep=( 500 1000 500 500 500 500 500 500 500 )
timestep=( 100 1000   50 50 100  50 50 50 50 )
# On passe de 1000 a 960 pour avoir un nombre de pas de temps entier / jour
timestep=( 100 960   50 50 100  50 50 50 50 )
# On passe à 480 pour rendre le H2002 stable
timestep=( 100 480   50 50 100  50 50 50 50 )

duree=( 6300 24000 6000 5000 9100 5000 5000 5000 5000 ) 


for icas in 0 1 2 3 4 5 6 7 8 ; do


CAS=${cass[$icas]}

daystep=`echo ${timestep[$icas]} 86400. | awk ' { print int( $2 / ($1 + 0.) ) } '`
ts=`echo $daystep 86400. | awk ' { print  $2 / $1  } '`
nts=`echo $ts ${duree[$icas]} | awk ' { print '$n' * int( $2 / ($1 + 0.) ) + 1 } '`
echo Nombre de pas de temps : $nts , daystep = $daystep, dt= $ts

flux=`echo $CAS | sed -e 's/[A-Z]//g'`
flux=0.$flux


zi=`grep $CAS description | awk ' { print $9 } '`
mkdir -p $SIM/$CAS
\cp *def $SIM/$CAS/


sed -e 's/wtsurf.*.$/wtsurf='$flux'/' lmdz1d.def >| $SIM/$CAS/lmdz1d.def
sed -e 's/day_step.*.$/day_step='$daystep'/' gcm1d.def >| $SIM/$CAS/gcm1d.def
# Pour eviter que nbapp_rad ne divise pas le pas de temps
sed -e 's/nbapp_rad.*.$/nbapp_rad='$daystep'/' config.def >| $SIM/$CAS/config.def

sed -e 's/nday.*.$/nday=-'$nts'/' run.def >| $SIM/$CAS/run.def
# On force eventuellement a changer la version du modele du thermique
# On n'active pas la thermo de la glace car les traceurs sont importants
# pour ce cas, et donc il faudrait décaler les lectures en fonc
if [ "$th" = "" ] ; then
   sed -e 's/iflag_ice_thermo.*.$/iflag_ice_thermo=0/' $physiq_def >| $SIM/$CAS/physiq.def
else
   sed -e 's/iflag_thermals=.*.$/iflag_thermals='$th'/' -e 's/iflag_ice_thermo.*.$/iflag_ice_thermo=0/' $physiq_def >| $SIM/$CAS/physiq.def
fi
sed -i -e 's/nbapp_cv=.*.$/nbapp_cv='$daystep'/' $SIM/$CAS/physiq.def

echo ${daystep[$icas]}
echo diff $SIM/$CAS/gcm.def gcm.def
diff $SIM/$CAS/gcm.def gcm.def

cat $SIM/$CAS/lmdz1d.def

cp DONNEES/LES$CAS/*001 $SIM/$CAS
cd $SIM/$CAS
nz=`head -1 prof.inp.001 | awk '  { print $1 } '`
echo $nz 1 4 >| trac.inp.001
awk ' { q=0 ; if ( $1 < '$zi' ) q=1 ;  print $1 , 0 , 0 , 3 + 9.5*q , 1-q } ' prof.inp.001 | sed -e '1d' >> trac.inp.001
../../lmdz1d.e >| listing
cd ../../
done
./extr_surf.x $SIM
./extractions.x $SIM
./tracera.x $SIM 
# \rm -f $SIM/*/hist*
