#!/bin/bash

listecas=" 24B 00WC 05WC 00SC 03SC  05SC  24SC  24F 15B "


# nombres de couches pour les post-traitments
zmax=85000.

SIM=$1

if [ ! -d $SIM ] ; then
echo $SIM n existe pas
exit
fi
cd $SIM


####################################################################
#  DEBUT DE LA BOUCLE SUR LES CAS
####################################################################

div=1

for cas in $listecas ; do

descr=`grep $cas ../description`
echo $descr
wt0=`echo $descr | awk ' { print $2 } '`
Ug=`echo $descr | awk ' { print $3 } '`
Vg=`echo $descr | awk ' { print $4 } '`
t0=`echo $descr | awk ' { print $5 } '`
t1=`echo $descr | awk ' { print $6 } '`
dt=`echo $div $descr | awk ' { print $8 / $1 } '`
echo ECHO $div $descr $dt
ustar=`echo $descr | awk ' { print $8 } '`
dtstock=`echo $descr | awk ' { print $7 } '`

# dtstock est le pas de temps du fichier histoire utilise
dt=`ncdump -v time_counter $cas/histhf.nc | grep time_co | tail -1 | awk ' { print $4 - $3 } '`
dtstock=50
dtstock=$dt

npasday=`echo $dt | awk ' { print 86400 / $1 } '`
npas=`echo $dt | awk ' { print '$t1' / $1 } '`

npasday=`echo $dt | awk ' { print 86400 / '$dtstock' } '`
npas=`echo $dt | awk ' { print '$t1' / '$dtstock' } '`

echo $cas $npas $t1
cd $cas

ln -s  ../../DONNEES/LES$cas/t0.a data
nsor=`echo $npasday | awk ' { print $1 / '$div' } '`
pas0=`echo $dtstock | awk ' { print '$t0' / $1 + 1 } '`
echo $cas $wt0 $Ug $t0 $t1 $dt $npasday $pas0 $npas

#   Choix entre une moyenne temporelle ou la valeur medaine comme
#   valeur finale.

if [ 1 == 0 ] ; then
pas1=`echo $pas0 $npas | awk ' { print ( $1 + $2 ) / 2. } '`
pas2=$pas1
else
pas1=$pas0
pas2=`echo $npas | awk ' { print $1 / '$div' } '`
fi
pas1=`echo $dtstock | awk ' { print int( '$t0' / $1 ) +1 } '`
pas2=`echo $dtstock | awk ' { print int( '$t1' / $1  ) } '`
echo $pas1 $pas2


echo $cas PAS1 $pas1 PAS2 $pas2


###########################
# Extraction des champs 1D.
###########################
../../extractnc.x vitv $pas1 $pas2 $zmax vm
# ../../extractnc.x $npasday'*(wtajs+wtvdf)' $pas1 $pas2 $zmax  wtm
../../extractnc.x '1000*dtvdf' $pas1 $pas2 $zmax dtvdf
../../extractnc.x '1000*dtthe' $pas1 $pas2 $zmax dtthe
../../extractnc.x mass $pas1 $pas2 $zmax mass
../../extractnc.x 'temp' $pas1 $pas2 $zmax temp
../../extractnc.x 'pres' $pas1 $pas2 $zmax pres
paste temp pres | awk ' { print 289 * $1 / $3 , $2 } ' >| unsrho
../../extractnc.x theta $pas1 $pas2 $zmax tm
../../extractnc.x theta 1 1 $zmax t0m
mv tmp.jnl tmpemp.jnl
../../extractnc.x B $pas1 $pas2 $zmax bm
../../extractnc.x C $pas1 $pas2 $zmax cm
../../extractnc.x vitu $pas1 $pas2 $zmax um
echo ../../extractnc.x vitu $pas1 $pas2 $zmax um
for f in t0 u0 v0 b0 c0 ; do
\cp ../../DONNEES/LES$cas/$f $f
done

########################################################################
# Transformation des tendances de temperature en flux : un cauchemard
########################################################################
# Multiplication puis division par 1000 pour une question de precision
paste mass dtthe | awk ' BEGIN{ f=0 ; z=0 ; zm=0 ; print 0 , 0 } { f=f-$1*$3 ; print f, $2 } ' >| the
paste mass dtvdf | awk ' BEGIN{ f=0 ; z=0 ; zm=0 ; print 0 , 0 } { f=f-$1*$3 ; print f, $2 } ' >| toto
f0=`tail -1 toto | awk ' { print $1 } '`
awk ' { print $1 - '$f0' , $2 } ' toto  >| vdf
paste the vdf | awk ' { print $1 + $3 , $2 } ' >| tot
for f in the vdf tot ; do
  # horrible bidouille pour decaler les niveaux verticaux ...
  paste $f unsrho | awk ' BEGIN { zm=0 } { print 0.001*f , 0.5*(zm+$2) ; zm=$2 ; f=$1*$3 } ' | sed -e '1d' | awk ' BEGIN { a=0 } { print $1 , a*$2 ; a=1 } ' >| wt$f
done
awk ' { print 0 , $2 } ' wttot >| wtnul




data=../../DONNEES/LES$cas
for i in um vm tm bm cm wtm u0 v0 b0 c0 ; do
   ln -s $data/$i ${i}_LES
done

\rm -f vent.epsi temp.epsi flux.epsi
xmgrace="xmgrace -legend load"
print="-hardcopy -hdevice EPS -printfile "
$xmgrace -view 0.35 0.15 1.15 0.85 $print vent.eps um vm um_LES vm_LES u0_LES v0_LES
xmgrace="xmgrace "
$xmgrace -view 0.15 0.15 0.55 0.85 $print temp.eps t0m tm tm_LES t0_LES
$xmgrace -view 0.15 0.15 0.35 0.85 $print B.eps bm bm_LES b0_LES
$xmgrace -view 0.15 0.15 0.35 0.85 $print C.eps cm cm_LES c0_LES
$xmgrace -view 0.15 0.15 0.55 0.85 $print flux.eps wttot wtm_LES wtvdf wtthe

for i in vent temp B C flux ; do
ps2epsi $i.ps
done

pwd
cd ..

echo $cas
echo $listecas

done

