#!/bin/bash
##################################################################
# 0 or 1 or 2 argument :
#   - 1st = suffix of the physics used (eg: foo --> use phy1dfoo, model name = lmdz1d_foo.e)
#   - 2nd = suffix of the model name (eg : 42 --> model = lmdz1d_foo_42.e)
#      (A dot is equivalent to the absence of a suffix).
# Examples :
#   compile.x norad --> physiq = phy1dnorad, model = lmdz1d_norad.e
#   compile.x norad 42 --> physiq = phy1dnorad, model = lmdz1d_norad_42.e
#   compile.x --> physiq = phy1d, model = lmdz1d.e
#   compile.x . 42 --> physiq = phy1d, model = lmdz1d_42.e
##################################################################
#
opt_comp=""
opt_comp="-debug"
llm=59

#
if [ -n "$1" -a "$1" != \. ]
then
 physiq="$1"
 physname="_$1"
else
 physiq=""
 physname=""
fi
if [ -n "$2" -a "$2" != \. ]
then
 exec="_$2"
else
 exec=""
fi

suffix=${physname}${exec}_L$llm
#
#
ici=`pwd`
#

##########################################################
# Recherche de l'emplacement de LMDZ
##########################################################
if [ -d ../../modipsl/modeles/LMDZ5 ] ; then
   lmdz5='../../modipsl/modeles/LMDZ5'
elif [ -d ../modipsl/modeles/LMDZ5 ] ; then
   lmdz5='../modipsl/modeles/LMDZ5'
elif [ -d ../../modipsl/modeles/LMDZ4 ] ; then
   lmdz5='../../modipsl/modeles/LMDZ4'
elif [ -d ../modipsl/modeles/LMDZ4 ] ; then
   lmdz5='../modipsl/modeles/LMDZ4'
else
   echo Probleme : je ne trouve pas LMDZ
   exit
fi

##########################################################
# Recherche de l'emplacement de LMDZ
# Utile pour la retrocompatibilite avec l'epoque ou 
# phy1d etait dans un repertoire separe
##########################################################
cd $lmdz5/libf
if [ -d phy1d$physiq ] ; then
   physique=1d${physiq}
elif [ -d phy$physiq ] ; then
   physique=$physiq
elif [ -d phylmd ] ; then
   physique=lmd
fi




#
##########################################################
echo "compilation sur: "$lmdz5
##########################################################
#
#
cd $ici ; cd $lmdz5
#

rm -f lmdz1d.e
./makelmdz ${opt_comp} -d $llm -p ${physique} lmdz1d

if [ ! -f lmdz1d.e ] ; then
   echo La compilation a echoue
   exit
fi

mv -f lmdz1d.e lmdz1d${suffix}.e
cd $ici
ln -sf  ${lmdz5}/lmdz1d${suffix}.e lmdz1d${suffix}.e
ln -sf lmdz1d${suffix}.e lmdz1d.e
