#!/bin/bash

###########################################################################
# Ce script recupere des .def de simulations mis a disposition sur une 
# page dods (typiquement les simulations de reglage 3D du modele) pour les
# tester sur le cas toga.
###########################################################################

orig=http://dodsp.idris.fr/rces855/IGCM_OUT/LMDZOR

for sim in NPv2F.0 NPv2F.1 NPv2F.2 NPv2F.3 NPv2F.4 NPv2F.5 NPv2F.6 NPv2F.7 NPv2F.8 NPv2F.9 NPv2F.10 NPv2F.11 NPv2F.12  ; do

mkdir -p $sim
cd $sim

for file in run.def lmdz1d.def gcm.def config.def ; do
cp ../$file  .
done

for file in physiq.def conv_param.data ep_param.data wake_param.data ; do
echo wget $orig/$sim/ATM/Debug/${sim}_19820301_19820330_$file
wget $orig/$sim/ATM/Debug/${sim}_19820301_19820330_$file
cp ${sim}_19820301_19820330_$file $file
done
ls

ln -s ../d_toga .
ln -s ../lmdz1d.e .
ln -s ../diags .

echo EXECUTION $sim
../xqt.x

# Faire un peu de menage ...
tail -1000 lmdz1d.lis > fin.lis
tail -1000 lmdz.out > fin.out
\rm lmdz1d.lis lmdz.out

../diags.x $sim

cd ..

done
